// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chimesdkmessaging.serde

import aws.sdk.kotlin.services.chimesdkmessaging.model.BatchCreateChannelMembershipRequest
import aws.sdk.kotlin.services.chimesdkmessaging.model.ChannelMembershipType
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class BatchCreateChannelMembershipOperationSerializer: HttpSerialize<BatchCreateChannelMembershipRequest> {
    override suspend fun serialize(context: ExecutionContext, input: BatchCreateChannelMembershipRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.channelArn) { "channelArn is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("channels"))
                add(PercentEncoding.SmithyLabel.encode("${input.channelArn}"))
                add(PercentEncoding.Path.encode("memberships"))
            }
            parameters.decodedParameters {
                add("operation", "batch-create")
            }
        }

        builder.headers {
            if (input.chimeBearer?.isNotEmpty() == true) append("x-amz-chime-bearer", input.chimeBearer)
        }

        val payload = serializeBatchCreateChannelMembershipOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeBatchCreateChannelMembershipOperationBody(context: ExecutionContext, input: BatchCreateChannelMembershipRequest): ByteArray {
    val serializer = JsonSerializer()
    val MEMBERARNS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("MemberArns"))
    val SUBCHANNELID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SubChannelId"))
    val TYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Type"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(MEMBERARNS_DESCRIPTOR)
        field(SUBCHANNELID_DESCRIPTOR)
        field(TYPE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.memberArns != null) {
            listField(MEMBERARNS_DESCRIPTOR) {
                for (el0 in input.memberArns) {
                    serializeString(el0)
                }
            }
        }
        input.subChannelId?.let { field(SUBCHANNELID_DESCRIPTOR, it) }
        input.type?.let { field(TYPE_DESCRIPTOR, it.value) }
    }
    return serializer.toByteArray()
}
