// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chimesdkmessaging.model



public class SendChannelMessageRequest private constructor(builder: Builder) {
    /**
     * The ARN of the channel.
     */
    public val channelArn: kotlin.String? = builder.channelArn
    /**
     * The ARN of the `AppInstanceUser` or `AppInstanceBot` that makes the API call.
     */
    public val chimeBearer: kotlin.String? = builder.chimeBearer
    /**
     * The `Idempotency` token for each client request.
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * The content of the channel message.
     */
    public val content: kotlin.String? = builder.content
    /**
     * The content type of the channel message.
     */
    public val contentType: kotlin.String? = builder.contentType
    /**
     * The attributes for the message, used for message filtering along with a `FilterRule` defined in the `PushNotificationPreferences`.
     */
    public val messageAttributes: Map<String, MessageAttributeValue>? = builder.messageAttributes
    /**
     * The optional metadata for each message.
     */
    public val metadata: kotlin.String? = builder.metadata
    /**
     * Boolean that controls whether the message is persisted on the back end. Required.
     */
    public val persistence: aws.sdk.kotlin.services.chimesdkmessaging.model.ChannelMessagePersistenceType? = builder.persistence
    /**
     * The push notification configuration of the message.
     */
    public val pushNotification: aws.sdk.kotlin.services.chimesdkmessaging.model.PushNotificationConfiguration? = builder.pushNotification
    /**
     * The ID of the SubChannel in the request.
     */
    public val subChannelId: kotlin.String? = builder.subChannelId
    /**
     * The target of a message. Must be a member of the channel, such as another user, a bot, or the sender. Only the target and the sender can view targeted messages. Only users who can see targeted messages can take actions on them. However, administrators can delete targeted messages that they can’t see.
     */
    public val target: List<Target>? = builder.target
    /**
     * The type of message, `STANDARD` or `CONTROL`.
     *
     * `STANDARD` messages can be up to 4KB in size and contain metadata. Metadata is arbitrary, and you can use it in a variety of ways, such as containing a link to an attachment.
     *
     * `CONTROL` messages are limited to 30 bytes and do not contain metadata.
     */
    public val type: aws.sdk.kotlin.services.chimesdkmessaging.model.ChannelMessageType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.chimesdkmessaging.model.SendChannelMessageRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SendChannelMessageRequest(")
        append("channelArn=$channelArn,")
        append("chimeBearer=$chimeBearer,")
        append("clientRequestToken=*** Sensitive Data Redacted ***,")
        append("content=*** Sensitive Data Redacted ***,")
        append("contentType=*** Sensitive Data Redacted ***,")
        append("messageAttributes=$messageAttributes,")
        append("metadata=*** Sensitive Data Redacted ***,")
        append("persistence=$persistence,")
        append("pushNotification=$pushNotification,")
        append("subChannelId=$subChannelId,")
        append("target=$target,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = channelArn?.hashCode() ?: 0
        result = 31 * result + (chimeBearer?.hashCode() ?: 0)
        result = 31 * result + (clientRequestToken?.hashCode() ?: 0)
        result = 31 * result + (content?.hashCode() ?: 0)
        result = 31 * result + (contentType?.hashCode() ?: 0)
        result = 31 * result + (messageAttributes?.hashCode() ?: 0)
        result = 31 * result + (metadata?.hashCode() ?: 0)
        result = 31 * result + (persistence?.hashCode() ?: 0)
        result = 31 * result + (pushNotification?.hashCode() ?: 0)
        result = 31 * result + (subChannelId?.hashCode() ?: 0)
        result = 31 * result + (target?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SendChannelMessageRequest

        if (channelArn != other.channelArn) return false
        if (chimeBearer != other.chimeBearer) return false
        if (clientRequestToken != other.clientRequestToken) return false
        if (content != other.content) return false
        if (contentType != other.contentType) return false
        if (messageAttributes != other.messageAttributes) return false
        if (metadata != other.metadata) return false
        if (persistence != other.persistence) return false
        if (pushNotification != other.pushNotification) return false
        if (subChannelId != other.subChannelId) return false
        if (target != other.target) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.chimesdkmessaging.model.SendChannelMessageRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ARN of the channel.
         */
        public var channelArn: kotlin.String? = null
        /**
         * The ARN of the `AppInstanceUser` or `AppInstanceBot` that makes the API call.
         */
        public var chimeBearer: kotlin.String? = null
        /**
         * The `Idempotency` token for each client request.
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * The content of the channel message.
         */
        public var content: kotlin.String? = null
        /**
         * The content type of the channel message.
         */
        public var contentType: kotlin.String? = null
        /**
         * The attributes for the message, used for message filtering along with a `FilterRule` defined in the `PushNotificationPreferences`.
         */
        public var messageAttributes: Map<String, MessageAttributeValue>? = null
        /**
         * The optional metadata for each message.
         */
        public var metadata: kotlin.String? = null
        /**
         * Boolean that controls whether the message is persisted on the back end. Required.
         */
        public var persistence: aws.sdk.kotlin.services.chimesdkmessaging.model.ChannelMessagePersistenceType? = null
        /**
         * The push notification configuration of the message.
         */
        public var pushNotification: aws.sdk.kotlin.services.chimesdkmessaging.model.PushNotificationConfiguration? = null
        /**
         * The ID of the SubChannel in the request.
         */
        public var subChannelId: kotlin.String? = null
        /**
         * The target of a message. Must be a member of the channel, such as another user, a bot, or the sender. Only the target and the sender can view targeted messages. Only users who can see targeted messages can take actions on them. However, administrators can delete targeted messages that they can’t see.
         */
        public var target: List<Target>? = null
        /**
         * The type of message, `STANDARD` or `CONTROL`.
         *
         * `STANDARD` messages can be up to 4KB in size and contain metadata. Metadata is arbitrary, and you can use it in a variety of ways, such as containing a link to an attachment.
         *
         * `CONTROL` messages are limited to 30 bytes and do not contain metadata.
         */
        public var type: aws.sdk.kotlin.services.chimesdkmessaging.model.ChannelMessageType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.chimesdkmessaging.model.SendChannelMessageRequest) : this() {
            this.channelArn = x.channelArn
            this.chimeBearer = x.chimeBearer
            this.clientRequestToken = x.clientRequestToken
            this.content = x.content
            this.contentType = x.contentType
            this.messageAttributes = x.messageAttributes
            this.metadata = x.metadata
            this.persistence = x.persistence
            this.pushNotification = x.pushNotification
            this.subChannelId = x.subChannelId
            this.target = x.target
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.chimesdkmessaging.model.SendChannelMessageRequest = SendChannelMessageRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.chimesdkmessaging.model.PushNotificationConfiguration] inside the given [block]
         */
        public fun pushNotification(block: aws.sdk.kotlin.services.chimesdkmessaging.model.PushNotificationConfiguration.Builder.() -> kotlin.Unit) {
            this.pushNotification = aws.sdk.kotlin.services.chimesdkmessaging.model.PushNotificationConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
