// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chimesdkmessaging.model



/**
 * A `Field` of the channel that you want to search.
 */
public class SearchField private constructor(builder: Builder) {
    /**
     * An `enum` value that indicates the key to search the channel on. `MEMBERS` allows you to search channels based on memberships. You can use it with the `EQUALS` operator to get channels whose memberships are equal to the specified values, and with the `INCLUDES` operator to get channels whose memberships include the specified values.
     */
    public val key: aws.sdk.kotlin.services.chimesdkmessaging.model.SearchFieldKey = requireNotNull(builder.key) { "A non-null value must be provided for key" }
    /**
     * The operator used to compare field values, currently `EQUALS` or `INCLUDES`. Use the `EQUALS` operator to find channels whose memberships equal the specified values. Use the `INCLUDES` operator to find channels whose memberships include the specified values.
     */
    public val operator: aws.sdk.kotlin.services.chimesdkmessaging.model.SearchFieldOperator = requireNotNull(builder.operator) { "A non-null value must be provided for operator" }
    /**
     * The values that you want to search for, a list of strings. The values must be `AppInstanceUserArns` specified as a list of strings.
     *
     * This operation isn't supported for `AppInstanceUsers` with large number of memberships.
     */
    public val values: List<String> = requireNotNull(builder.values) { "A non-null value must be provided for values" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.chimesdkmessaging.model.SearchField = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SearchField(")
        append("key=$key,")
        append("operator=$operator,")
        append("values=$values")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = key.hashCode()
        result = 31 * result + (operator.hashCode())
        result = 31 * result + (values.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SearchField

        if (key != other.key) return false
        if (operator != other.operator) return false
        if (values != other.values) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.chimesdkmessaging.model.SearchField = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An `enum` value that indicates the key to search the channel on. `MEMBERS` allows you to search channels based on memberships. You can use it with the `EQUALS` operator to get channels whose memberships are equal to the specified values, and with the `INCLUDES` operator to get channels whose memberships include the specified values.
         */
        public var key: aws.sdk.kotlin.services.chimesdkmessaging.model.SearchFieldKey? = null
        /**
         * The operator used to compare field values, currently `EQUALS` or `INCLUDES`. Use the `EQUALS` operator to find channels whose memberships equal the specified values. Use the `INCLUDES` operator to find channels whose memberships include the specified values.
         */
        public var operator: aws.sdk.kotlin.services.chimesdkmessaging.model.SearchFieldOperator? = null
        /**
         * The values that you want to search for, a list of strings. The values must be `AppInstanceUserArns` specified as a list of strings.
         *
         * This operation isn't supported for `AppInstanceUsers` with large number of memberships.
         */
        public var values: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.chimesdkmessaging.model.SearchField) : this() {
            this.key = x.key
            this.operator = x.operator
            this.values = x.values
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.chimesdkmessaging.model.SearchField = SearchField(this)

        internal fun correctErrors(): Builder {
            if (key == null) key = SearchFieldKey.SdkUnknown("no value provided")
            if (operator == null) operator = SearchFieldOperator.SdkUnknown("no value provided")
            if (values == null) values = emptyList()
            return this
        }
    }
}
