// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chimesdkmeetings.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A meeting created using the Amazon Chime SDK.
 */
public class Meeting private constructor(builder: Builder) {
    /**
     * The external meeting ID.
     *
     * Pattern: `[-_&@+=,(){}\[\]\/«».:|'"#a-zA-Z0-9À-ÿ\s]*`
     *
     * Values that begin with `aws:` are reserved. You can't configure a value that uses this prefix. Case insensitive.
     */
    public val externalMeetingId: kotlin.String? = builder.externalMeetingId
    /**
     * The media placement for the meeting.
     */
    public val mediaPlacement: aws.sdk.kotlin.services.chimesdkmeetings.model.MediaPlacement? = builder.mediaPlacement
    /**
     * The Region in which you create the meeting. Available values: `af-south-1`, `ap-northeast-1`, `ap-northeast-2`, `ap-south-1`, `ap-southeast-1`, `ap-southeast-2`, `ca-central-1`, `eu-central-1`, `eu-north-1`, `eu-south-1`, `eu-west-1`, `eu-west-2`, `eu-west-3`, `sa-east-1`, `us-east-1`, `us-east-2`, `us-west-1`, `us-west-2`.
     *
     * Available values in Amazon Web Services GovCloud (US) Regions: `us-gov-east-1`, `us-gov-west-1`.
     */
    public val mediaRegion: kotlin.String? = builder.mediaRegion
    /**
     * The ARN of the meeting.
     */
    public val meetingArn: kotlin.String? = builder.meetingArn
    /**
     * The features available to a meeting, such as echo reduction.
     */
    public val meetingFeatures: aws.sdk.kotlin.services.chimesdkmeetings.model.MeetingFeaturesConfiguration? = builder.meetingFeatures
    /**
     * Reserved.
     */
    public val meetingHostId: kotlin.String? = builder.meetingHostId
    /**
     * The Amazon Chime SDK meeting ID.
     */
    public val meetingId: kotlin.String? = builder.meetingId
    /**
     * When specified, replicates the media from the primary meeting to this meeting.
     */
    public val primaryMeetingId: kotlin.String? = builder.primaryMeetingId
    /**
     * Array of strings.
     */
    public val tenantIds: List<String>? = builder.tenantIds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.chimesdkmeetings.model.Meeting = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Meeting(")
        append("externalMeetingId=*** Sensitive Data Redacted ***,")
        append("mediaPlacement=$mediaPlacement,")
        append("mediaRegion=$mediaRegion,")
        append("meetingArn=$meetingArn,")
        append("meetingFeatures=$meetingFeatures,")
        append("meetingHostId=*** Sensitive Data Redacted ***,")
        append("meetingId=$meetingId,")
        append("primaryMeetingId=$primaryMeetingId,")
        append("tenantIds=$tenantIds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = externalMeetingId?.hashCode() ?: 0
        result = 31 * result + (mediaPlacement?.hashCode() ?: 0)
        result = 31 * result + (mediaRegion?.hashCode() ?: 0)
        result = 31 * result + (meetingArn?.hashCode() ?: 0)
        result = 31 * result + (meetingFeatures?.hashCode() ?: 0)
        result = 31 * result + (meetingHostId?.hashCode() ?: 0)
        result = 31 * result + (meetingId?.hashCode() ?: 0)
        result = 31 * result + (primaryMeetingId?.hashCode() ?: 0)
        result = 31 * result + (tenantIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Meeting

        if (externalMeetingId != other.externalMeetingId) return false
        if (mediaPlacement != other.mediaPlacement) return false
        if (mediaRegion != other.mediaRegion) return false
        if (meetingArn != other.meetingArn) return false
        if (meetingFeatures != other.meetingFeatures) return false
        if (meetingHostId != other.meetingHostId) return false
        if (meetingId != other.meetingId) return false
        if (primaryMeetingId != other.primaryMeetingId) return false
        if (tenantIds != other.tenantIds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.chimesdkmeetings.model.Meeting = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The external meeting ID.
         *
         * Pattern: `[-_&@+=,(){}\[\]\/«».:|'"#a-zA-Z0-9À-ÿ\s]*`
         *
         * Values that begin with `aws:` are reserved. You can't configure a value that uses this prefix. Case insensitive.
         */
        public var externalMeetingId: kotlin.String? = null
        /**
         * The media placement for the meeting.
         */
        public var mediaPlacement: aws.sdk.kotlin.services.chimesdkmeetings.model.MediaPlacement? = null
        /**
         * The Region in which you create the meeting. Available values: `af-south-1`, `ap-northeast-1`, `ap-northeast-2`, `ap-south-1`, `ap-southeast-1`, `ap-southeast-2`, `ca-central-1`, `eu-central-1`, `eu-north-1`, `eu-south-1`, `eu-west-1`, `eu-west-2`, `eu-west-3`, `sa-east-1`, `us-east-1`, `us-east-2`, `us-west-1`, `us-west-2`.
         *
         * Available values in Amazon Web Services GovCloud (US) Regions: `us-gov-east-1`, `us-gov-west-1`.
         */
        public var mediaRegion: kotlin.String? = null
        /**
         * The ARN of the meeting.
         */
        public var meetingArn: kotlin.String? = null
        /**
         * The features available to a meeting, such as echo reduction.
         */
        public var meetingFeatures: aws.sdk.kotlin.services.chimesdkmeetings.model.MeetingFeaturesConfiguration? = null
        /**
         * Reserved.
         */
        public var meetingHostId: kotlin.String? = null
        /**
         * The Amazon Chime SDK meeting ID.
         */
        public var meetingId: kotlin.String? = null
        /**
         * When specified, replicates the media from the primary meeting to this meeting.
         */
        public var primaryMeetingId: kotlin.String? = null
        /**
         * Array of strings.
         */
        public var tenantIds: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.chimesdkmeetings.model.Meeting) : this() {
            this.externalMeetingId = x.externalMeetingId
            this.mediaPlacement = x.mediaPlacement
            this.mediaRegion = x.mediaRegion
            this.meetingArn = x.meetingArn
            this.meetingFeatures = x.meetingFeatures
            this.meetingHostId = x.meetingHostId
            this.meetingId = x.meetingId
            this.primaryMeetingId = x.primaryMeetingId
            this.tenantIds = x.tenantIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.chimesdkmeetings.model.Meeting = Meeting(this)

        /**
         * construct an [aws.sdk.kotlin.services.chimesdkmeetings.model.MediaPlacement] inside the given [block]
         */
        public fun mediaPlacement(block: aws.sdk.kotlin.services.chimesdkmeetings.model.MediaPlacement.Builder.() -> kotlin.Unit) {
            this.mediaPlacement = aws.sdk.kotlin.services.chimesdkmeetings.model.MediaPlacement.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.chimesdkmeetings.model.MeetingFeaturesConfiguration] inside the given [block]
         */
        public fun meetingFeatures(block: aws.sdk.kotlin.services.chimesdkmeetings.model.MeetingFeaturesConfiguration.Builder.() -> kotlin.Unit) {
            this.meetingFeatures = aws.sdk.kotlin.services.chimesdkmeetings.model.MeetingFeaturesConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
