// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chimesdkmeetings.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Settings specific for Amazon Transcribe as the live transcription engine.
 *
 * If you specify an invalid combination of parameters, a `TranscriptFailed` event will be sent with the contents of the `BadRequestException` generated by Amazon Transcribe. For more information on each parameter and which combinations are valid, refer to the [StartStreamTranscription](https://docs.aws.amazon.com/transcribe/latest/APIReference/API_streaming_StartStreamTranscription.html) API in the *Amazon Transcribe Developer Guide*.
 */
public class EngineTranscribeSettings private constructor(builder: Builder) {
    /**
     * Labels all personally identifiable information (PII) identified in your transcript. If you don't include `PiiEntityTypes`, all PII is identified.
     *
     * You can’t set `ContentIdentificationType` and `ContentRedactionType`.
     */
    public val contentIdentificationType: aws.sdk.kotlin.services.chimesdkmeetings.model.TranscribeContentIdentificationType? = builder.contentIdentificationType
    /**
     * Content redaction is performed at the segment level. If you don't include `PiiEntityTypes`, all PII is redacted.
     *
     * You can’t set `ContentRedactionType` and `ContentIdentificationType`.
     */
    public val contentRedactionType: aws.sdk.kotlin.services.chimesdkmeetings.model.TranscribeContentRedactionType? = builder.contentRedactionType
    /**
     * Enables partial result stabilization for your transcription. Partial result stabilization can reduce latency in your output, but may impact accuracy.
     */
    public val enablePartialResultsStabilization: kotlin.Boolean = builder.enablePartialResultsStabilization
    /**
     * Enables automatic language identification for your transcription.
     *
     * If you include `IdentifyLanguage`, you can optionally use `LanguageOptions` to include a list of language codes that you think may be present in your audio stream. Including language options can improve transcription accuracy.
     *
     * You can also use `PreferredLanguage` to include a preferred language. Doing so can help Amazon Transcribe identify the language faster.
     *
     * You must include either `LanguageCode` or `IdentifyLanguage`.
     *
     * Language identification can't be combined with custom language models or redaction.
     */
    public val identifyLanguage: kotlin.Boolean = builder.identifyLanguage
    /**
     * Specify the language code that represents the language spoken.
     *
     * If you're unsure of the language spoken in your audio, consider using `IdentifyLanguage` to enable automatic language identification.
     */
    public val languageCode: aws.sdk.kotlin.services.chimesdkmeetings.model.TranscribeLanguageCode? = builder.languageCode
    /**
     * Specify the name of the custom language model that you want to use when processing your transcription. Note that language model names are case sensitive.
     *
     * The language of the specified language model must match the language code. If the languages don't match, the custom language model isn't applied. There are no errors or warnings associated with a language mismatch.
     *
     * If you use Amazon Transcribe in multiple Regions, the custom language model must be available in Amazon Transcribe in each Region.
     */
    public val languageModelName: kotlin.String? = builder.languageModelName
    /**
     * Specify two or more language codes that represent the languages you think may be present in your media; including more than five is not recommended. If you're unsure what languages are present, do not include this parameter.
     *
     * Including language options can improve the accuracy of language identification.
     *
     * If you include `LanguageOptions`, you must also include `IdentifyLanguage`.
     *
     * You can only include one language dialect per language. For example, you cannot include `en-US` and `en-AU`.
     */
    public val languageOptions: kotlin.String? = builder.languageOptions
    /**
     * Specify the level of stability to use when you enable partial results stabilization (`EnablePartialResultsStabilization`).
     *
     * Low stability provides the highest accuracy. High stability transcribes faster, but with slightly lower accuracy.
     */
    public val partialResultsStability: aws.sdk.kotlin.services.chimesdkmeetings.model.TranscribePartialResultsStability? = builder.partialResultsStability
    /**
     * Specify which types of personally identifiable information (PII) you want to redact in your transcript. You can include as many types as you'd like, or you can select `ALL`.
     *
     * Values must be comma-separated and can include: `ADDRESS`, `BANK_ACCOUNT_NUMBER`, `BANK_ROUTING`, `CREDIT_DEBIT_CVV`, `CREDIT_DEBIT_EXPIRY``CREDIT_DEBIT_NUMBER`, `EMAIL`,`NAME`, `PHONE`, `PIN`, `SSN`, or `ALL`.
     *
     * Note that if you include `PiiEntityTypes`, you must also include `ContentIdentificationType` or `ContentRedactionType`.
     *
     * If you include `ContentRedactionType` or `ContentIdentificationType`, but do not include PiiEntityTypes, all PII is redacted or identified.
     */
    public val piiEntityTypes: kotlin.String? = builder.piiEntityTypes
    /**
     * Specify a preferred language from the subset of languages codes you specified in `LanguageOptions`.
     *
     * You can only use this parameter if you include `IdentifyLanguage` and `LanguageOptions`.
     */
    public val preferredLanguage: aws.sdk.kotlin.services.chimesdkmeetings.model.TranscribeLanguageCode? = builder.preferredLanguage
    /**
     * The Amazon Web Services Region in which to use Amazon Transcribe.
     *
     * If you don't specify a Region, then the [MediaRegion](https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_meeting-chime_CreateMeeting.html) of the meeting is used. However, if Amazon Transcribe is not available in the `MediaRegion`, then a `TranscriptFailed` event is sent.
     *
     * Use `auto` to use Amazon Transcribe in a Region near the meeting’s `MediaRegion`. For more information, refer to [Choosing a transcription Region](https://docs.aws.amazon.com/chime-sdk/latest/dg/transcription-options.html#choose-region) in the *Amazon Chime SDK Developer Guide*.
     */
    public val region: aws.sdk.kotlin.services.chimesdkmeetings.model.TranscribeRegion? = builder.region
    /**
     * Specify how you want your vocabulary filter applied to your transcript.
     *
     * To replace words with `***`, choose `mask`.
     *
     * To delete words, choose `remove`.
     *
     * To flag words without changing them, choose `tag`.
     */
    public val vocabularyFilterMethod: aws.sdk.kotlin.services.chimesdkmeetings.model.TranscribeVocabularyFilterMethod? = builder.vocabularyFilterMethod
    /**
     * Specify the name of the custom vocabulary filter that you want to use when processing your transcription. Note that vocabulary filter names are case sensitive.
     *
     * If you use Amazon Transcribe in multiple Regions, the vocabulary filter must be available in Amazon Transcribe in each Region.
     *
     * If you include `IdentifyLanguage` and want to use one or more vocabulary filters with your transcription, use the `VocabularyFilterNames` parameter instead.
     */
    public val vocabularyFilterName: kotlin.String? = builder.vocabularyFilterName
    /**
     * Specify the names of the custom vocabulary filters that you want to use when processing your transcription. Note that vocabulary filter names are case sensitive.
     *
     * If you use Amazon Transcribe in multiple Regions, the vocabulary filter must be available in Amazon Transcribe in each Region.
     *
     *  If you're *not* including `IdentifyLanguage` and want to use a custom vocabulary filter with your transcription, use the `VocabularyFilterName` parameter instead.
     */
    public val vocabularyFilterNames: kotlin.String? = builder.vocabularyFilterNames
    /**
     * Specify the name of the custom vocabulary that you want to use when processing your transcription. Note that vocabulary names are case sensitive.
     *
     * If you use Amazon Transcribe multiple Regions, the vocabulary must be available in Amazon Transcribe in each Region.
     *
     * If you include `IdentifyLanguage` and want to use one or more custom vocabularies with your transcription, use the `VocabularyNames` parameter instead.
     */
    public val vocabularyName: kotlin.String? = builder.vocabularyName
    /**
     * Specify the names of the custom vocabularies that you want to use when processing your transcription. Note that vocabulary names are case sensitive.
     *
     * If you use Amazon Transcribe in multiple Regions, the vocabulary must be available in Amazon Transcribe in each Region.
     *
     * If you don't include `IdentifyLanguage` and want to use a custom vocabulary with your transcription, use the `VocabularyName` parameter instead.
     */
    public val vocabularyNames: kotlin.String? = builder.vocabularyNames

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.chimesdkmeetings.model.EngineTranscribeSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EngineTranscribeSettings(")
        append("contentIdentificationType=$contentIdentificationType,")
        append("contentRedactionType=$contentRedactionType,")
        append("enablePartialResultsStabilization=$enablePartialResultsStabilization,")
        append("identifyLanguage=$identifyLanguage,")
        append("languageCode=$languageCode,")
        append("languageModelName=$languageModelName,")
        append("languageOptions=$languageOptions,")
        append("partialResultsStability=$partialResultsStability,")
        append("piiEntityTypes=$piiEntityTypes,")
        append("preferredLanguage=$preferredLanguage,")
        append("region=$region,")
        append("vocabularyFilterMethod=$vocabularyFilterMethod,")
        append("vocabularyFilterName=$vocabularyFilterName,")
        append("vocabularyFilterNames=$vocabularyFilterNames,")
        append("vocabularyName=$vocabularyName,")
        append("vocabularyNames=$vocabularyNames")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = contentIdentificationType?.hashCode() ?: 0
        result = 31 * result + (contentRedactionType?.hashCode() ?: 0)
        result = 31 * result + (enablePartialResultsStabilization.hashCode())
        result = 31 * result + (identifyLanguage.hashCode())
        result = 31 * result + (languageCode?.hashCode() ?: 0)
        result = 31 * result + (languageModelName?.hashCode() ?: 0)
        result = 31 * result + (languageOptions?.hashCode() ?: 0)
        result = 31 * result + (partialResultsStability?.hashCode() ?: 0)
        result = 31 * result + (piiEntityTypes?.hashCode() ?: 0)
        result = 31 * result + (preferredLanguage?.hashCode() ?: 0)
        result = 31 * result + (region?.hashCode() ?: 0)
        result = 31 * result + (vocabularyFilterMethod?.hashCode() ?: 0)
        result = 31 * result + (vocabularyFilterName?.hashCode() ?: 0)
        result = 31 * result + (vocabularyFilterNames?.hashCode() ?: 0)
        result = 31 * result + (vocabularyName?.hashCode() ?: 0)
        result = 31 * result + (vocabularyNames?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EngineTranscribeSettings

        if (contentIdentificationType != other.contentIdentificationType) return false
        if (contentRedactionType != other.contentRedactionType) return false
        if (enablePartialResultsStabilization != other.enablePartialResultsStabilization) return false
        if (identifyLanguage != other.identifyLanguage) return false
        if (languageCode != other.languageCode) return false
        if (languageModelName != other.languageModelName) return false
        if (languageOptions != other.languageOptions) return false
        if (partialResultsStability != other.partialResultsStability) return false
        if (piiEntityTypes != other.piiEntityTypes) return false
        if (preferredLanguage != other.preferredLanguage) return false
        if (region != other.region) return false
        if (vocabularyFilterMethod != other.vocabularyFilterMethod) return false
        if (vocabularyFilterName != other.vocabularyFilterName) return false
        if (vocabularyFilterNames != other.vocabularyFilterNames) return false
        if (vocabularyName != other.vocabularyName) return false
        if (vocabularyNames != other.vocabularyNames) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.chimesdkmeetings.model.EngineTranscribeSettings = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Labels all personally identifiable information (PII) identified in your transcript. If you don't include `PiiEntityTypes`, all PII is identified.
         *
         * You can’t set `ContentIdentificationType` and `ContentRedactionType`.
         */
        public var contentIdentificationType: aws.sdk.kotlin.services.chimesdkmeetings.model.TranscribeContentIdentificationType? = null
        /**
         * Content redaction is performed at the segment level. If you don't include `PiiEntityTypes`, all PII is redacted.
         *
         * You can’t set `ContentRedactionType` and `ContentIdentificationType`.
         */
        public var contentRedactionType: aws.sdk.kotlin.services.chimesdkmeetings.model.TranscribeContentRedactionType? = null
        /**
         * Enables partial result stabilization for your transcription. Partial result stabilization can reduce latency in your output, but may impact accuracy.
         */
        public var enablePartialResultsStabilization: kotlin.Boolean = false
        /**
         * Enables automatic language identification for your transcription.
         *
         * If you include `IdentifyLanguage`, you can optionally use `LanguageOptions` to include a list of language codes that you think may be present in your audio stream. Including language options can improve transcription accuracy.
         *
         * You can also use `PreferredLanguage` to include a preferred language. Doing so can help Amazon Transcribe identify the language faster.
         *
         * You must include either `LanguageCode` or `IdentifyLanguage`.
         *
         * Language identification can't be combined with custom language models or redaction.
         */
        public var identifyLanguage: kotlin.Boolean = false
        /**
         * Specify the language code that represents the language spoken.
         *
         * If you're unsure of the language spoken in your audio, consider using `IdentifyLanguage` to enable automatic language identification.
         */
        public var languageCode: aws.sdk.kotlin.services.chimesdkmeetings.model.TranscribeLanguageCode? = null
        /**
         * Specify the name of the custom language model that you want to use when processing your transcription. Note that language model names are case sensitive.
         *
         * The language of the specified language model must match the language code. If the languages don't match, the custom language model isn't applied. There are no errors or warnings associated with a language mismatch.
         *
         * If you use Amazon Transcribe in multiple Regions, the custom language model must be available in Amazon Transcribe in each Region.
         */
        public var languageModelName: kotlin.String? = null
        /**
         * Specify two or more language codes that represent the languages you think may be present in your media; including more than five is not recommended. If you're unsure what languages are present, do not include this parameter.
         *
         * Including language options can improve the accuracy of language identification.
         *
         * If you include `LanguageOptions`, you must also include `IdentifyLanguage`.
         *
         * You can only include one language dialect per language. For example, you cannot include `en-US` and `en-AU`.
         */
        public var languageOptions: kotlin.String? = null
        /**
         * Specify the level of stability to use when you enable partial results stabilization (`EnablePartialResultsStabilization`).
         *
         * Low stability provides the highest accuracy. High stability transcribes faster, but with slightly lower accuracy.
         */
        public var partialResultsStability: aws.sdk.kotlin.services.chimesdkmeetings.model.TranscribePartialResultsStability? = null
        /**
         * Specify which types of personally identifiable information (PII) you want to redact in your transcript. You can include as many types as you'd like, or you can select `ALL`.
         *
         * Values must be comma-separated and can include: `ADDRESS`, `BANK_ACCOUNT_NUMBER`, `BANK_ROUTING`, `CREDIT_DEBIT_CVV`, `CREDIT_DEBIT_EXPIRY``CREDIT_DEBIT_NUMBER`, `EMAIL`,`NAME`, `PHONE`, `PIN`, `SSN`, or `ALL`.
         *
         * Note that if you include `PiiEntityTypes`, you must also include `ContentIdentificationType` or `ContentRedactionType`.
         *
         * If you include `ContentRedactionType` or `ContentIdentificationType`, but do not include PiiEntityTypes, all PII is redacted or identified.
         */
        public var piiEntityTypes: kotlin.String? = null
        /**
         * Specify a preferred language from the subset of languages codes you specified in `LanguageOptions`.
         *
         * You can only use this parameter if you include `IdentifyLanguage` and `LanguageOptions`.
         */
        public var preferredLanguage: aws.sdk.kotlin.services.chimesdkmeetings.model.TranscribeLanguageCode? = null
        /**
         * The Amazon Web Services Region in which to use Amazon Transcribe.
         *
         * If you don't specify a Region, then the [MediaRegion](https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_meeting-chime_CreateMeeting.html) of the meeting is used. However, if Amazon Transcribe is not available in the `MediaRegion`, then a `TranscriptFailed` event is sent.
         *
         * Use `auto` to use Amazon Transcribe in a Region near the meeting’s `MediaRegion`. For more information, refer to [Choosing a transcription Region](https://docs.aws.amazon.com/chime-sdk/latest/dg/transcription-options.html#choose-region) in the *Amazon Chime SDK Developer Guide*.
         */
        public var region: aws.sdk.kotlin.services.chimesdkmeetings.model.TranscribeRegion? = null
        /**
         * Specify how you want your vocabulary filter applied to your transcript.
         *
         * To replace words with `***`, choose `mask`.
         *
         * To delete words, choose `remove`.
         *
         * To flag words without changing them, choose `tag`.
         */
        public var vocabularyFilterMethod: aws.sdk.kotlin.services.chimesdkmeetings.model.TranscribeVocabularyFilterMethod? = null
        /**
         * Specify the name of the custom vocabulary filter that you want to use when processing your transcription. Note that vocabulary filter names are case sensitive.
         *
         * If you use Amazon Transcribe in multiple Regions, the vocabulary filter must be available in Amazon Transcribe in each Region.
         *
         * If you include `IdentifyLanguage` and want to use one or more vocabulary filters with your transcription, use the `VocabularyFilterNames` parameter instead.
         */
        public var vocabularyFilterName: kotlin.String? = null
        /**
         * Specify the names of the custom vocabulary filters that you want to use when processing your transcription. Note that vocabulary filter names are case sensitive.
         *
         * If you use Amazon Transcribe in multiple Regions, the vocabulary filter must be available in Amazon Transcribe in each Region.
         *
         *  If you're *not* including `IdentifyLanguage` and want to use a custom vocabulary filter with your transcription, use the `VocabularyFilterName` parameter instead.
         */
        public var vocabularyFilterNames: kotlin.String? = null
        /**
         * Specify the name of the custom vocabulary that you want to use when processing your transcription. Note that vocabulary names are case sensitive.
         *
         * If you use Amazon Transcribe multiple Regions, the vocabulary must be available in Amazon Transcribe in each Region.
         *
         * If you include `IdentifyLanguage` and want to use one or more custom vocabularies with your transcription, use the `VocabularyNames` parameter instead.
         */
        public var vocabularyName: kotlin.String? = null
        /**
         * Specify the names of the custom vocabularies that you want to use when processing your transcription. Note that vocabulary names are case sensitive.
         *
         * If you use Amazon Transcribe in multiple Regions, the vocabulary must be available in Amazon Transcribe in each Region.
         *
         * If you don't include `IdentifyLanguage` and want to use a custom vocabulary with your transcription, use the `VocabularyName` parameter instead.
         */
        public var vocabularyNames: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.chimesdkmeetings.model.EngineTranscribeSettings) : this() {
            this.contentIdentificationType = x.contentIdentificationType
            this.contentRedactionType = x.contentRedactionType
            this.enablePartialResultsStabilization = x.enablePartialResultsStabilization
            this.identifyLanguage = x.identifyLanguage
            this.languageCode = x.languageCode
            this.languageModelName = x.languageModelName
            this.languageOptions = x.languageOptions
            this.partialResultsStability = x.partialResultsStability
            this.piiEntityTypes = x.piiEntityTypes
            this.preferredLanguage = x.preferredLanguage
            this.region = x.region
            this.vocabularyFilterMethod = x.vocabularyFilterMethod
            this.vocabularyFilterName = x.vocabularyFilterName
            this.vocabularyFilterNames = x.vocabularyFilterNames
            this.vocabularyName = x.vocabularyName
            this.vocabularyNames = x.vocabularyNames
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.chimesdkmeetings.model.EngineTranscribeSettings = EngineTranscribeSettings(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
