// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chimesdkmeetings.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Settings specific to the Amazon Transcribe Medical engine.
 */
public class EngineTranscribeMedicalSettings private constructor(builder: Builder) {
    /**
     * Set this field to `PHI` to identify personal health information in the transcription output.
     */
    public val contentIdentificationType: aws.sdk.kotlin.services.chimesdkmeetings.model.TranscribeMedicalContentIdentificationType? = builder.contentIdentificationType
    /**
     * The language code specified for the Amazon Transcribe Medical engine.
     */
    public val languageCode: aws.sdk.kotlin.services.chimesdkmeetings.model.TranscribeMedicalLanguageCode = requireNotNull(builder.languageCode) { "A non-null value must be provided for languageCode" }
    /**
     * The Amazon Web Services Region passed to Amazon Transcribe Medical. If you don't specify a Region, Amazon Chime uses the meeting's Region.
     */
    public val region: aws.sdk.kotlin.services.chimesdkmeetings.model.TranscribeMedicalRegion? = builder.region
    /**
     * The specialty specified for the Amazon Transcribe Medical engine.
     */
    public val specialty: aws.sdk.kotlin.services.chimesdkmeetings.model.TranscribeMedicalSpecialty = requireNotNull(builder.specialty) { "A non-null value must be provided for specialty" }
    /**
     * The type of transcription.
     */
    public val type: aws.sdk.kotlin.services.chimesdkmeetings.model.TranscribeMedicalType = requireNotNull(builder.type) { "A non-null value must be provided for type" }
    /**
     * The name of the vocabulary passed to Amazon Transcribe Medical.
     */
    public val vocabularyName: kotlin.String? = builder.vocabularyName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.chimesdkmeetings.model.EngineTranscribeMedicalSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EngineTranscribeMedicalSettings(")
        append("contentIdentificationType=$contentIdentificationType,")
        append("languageCode=$languageCode,")
        append("region=$region,")
        append("specialty=$specialty,")
        append("type=$type,")
        append("vocabularyName=$vocabularyName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = contentIdentificationType?.hashCode() ?: 0
        result = 31 * result + (languageCode.hashCode())
        result = 31 * result + (region?.hashCode() ?: 0)
        result = 31 * result + (specialty.hashCode())
        result = 31 * result + (type.hashCode())
        result = 31 * result + (vocabularyName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EngineTranscribeMedicalSettings

        if (contentIdentificationType != other.contentIdentificationType) return false
        if (languageCode != other.languageCode) return false
        if (region != other.region) return false
        if (specialty != other.specialty) return false
        if (type != other.type) return false
        if (vocabularyName != other.vocabularyName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.chimesdkmeetings.model.EngineTranscribeMedicalSettings = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Set this field to `PHI` to identify personal health information in the transcription output.
         */
        public var contentIdentificationType: aws.sdk.kotlin.services.chimesdkmeetings.model.TranscribeMedicalContentIdentificationType? = null
        /**
         * The language code specified for the Amazon Transcribe Medical engine.
         */
        public var languageCode: aws.sdk.kotlin.services.chimesdkmeetings.model.TranscribeMedicalLanguageCode? = null
        /**
         * The Amazon Web Services Region passed to Amazon Transcribe Medical. If you don't specify a Region, Amazon Chime uses the meeting's Region.
         */
        public var region: aws.sdk.kotlin.services.chimesdkmeetings.model.TranscribeMedicalRegion? = null
        /**
         * The specialty specified for the Amazon Transcribe Medical engine.
         */
        public var specialty: aws.sdk.kotlin.services.chimesdkmeetings.model.TranscribeMedicalSpecialty? = null
        /**
         * The type of transcription.
         */
        public var type: aws.sdk.kotlin.services.chimesdkmeetings.model.TranscribeMedicalType? = null
        /**
         * The name of the vocabulary passed to Amazon Transcribe Medical.
         */
        public var vocabularyName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.chimesdkmeetings.model.EngineTranscribeMedicalSettings) : this() {
            this.contentIdentificationType = x.contentIdentificationType
            this.languageCode = x.languageCode
            this.region = x.region
            this.specialty = x.specialty
            this.type = x.type
            this.vocabularyName = x.vocabularyName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.chimesdkmeetings.model.EngineTranscribeMedicalSettings = EngineTranscribeMedicalSettings(this)

        internal fun correctErrors(): Builder {
            if (languageCode == null) languageCode = TranscribeMedicalLanguageCode.SdkUnknown("no value provided")
            if (specialty == null) specialty = TranscribeMedicalSpecialty.SdkUnknown("no value provided")
            if (type == null) type = TranscribeMedicalType.SdkUnknown("no value provided")
            return this
        }
    }
}
