// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chimesdkmeetings.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateMeetingRequest private constructor(builder: Builder) {
    /**
     * The unique identifier for the client request. Use a different token for different meetings.
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * The external meeting ID.
     *
     * Pattern: `[-_&@+=,(){}\[\]\/«».:|'"#a-zA-Z0-9À-ÿ\s]*`
     *
     * Values that begin with `aws:` are reserved. You can't configure a value that uses this prefix. Case insensitive.
     */
    public val externalMeetingId: kotlin.String? = builder.externalMeetingId
    /**
     * The Region in which to create the meeting.
     *
     *  Available values: `af-south-1`, `ap-northeast-1`, `ap-northeast-2`, `ap-south-1`, `ap-southeast-1`, `ap-southeast-2`, `ca-central-1`, `eu-central-1`, `eu-north-1`, `eu-south-1`, `eu-west-1`, `eu-west-2`, `eu-west-3`, `sa-east-1`, `us-east-1`, `us-east-2`, `us-west-1`, `us-west-2`.
     *
     * Available values in Amazon Web Services GovCloud (US) Regions: `us-gov-east-1`, `us-gov-west-1`.
     */
    public val mediaRegion: kotlin.String? = builder.mediaRegion
    /**
     * Lists the audio and video features enabled for a meeting, such as echo reduction.
     */
    public val meetingFeatures: aws.sdk.kotlin.services.chimesdkmeetings.model.MeetingFeaturesConfiguration? = builder.meetingFeatures
    /**
     * Reserved.
     */
    public val meetingHostId: kotlin.String? = builder.meetingHostId
    /**
     * The configuration for resource targets to receive notifications when meeting and attendee events occur.
     */
    public val notificationsConfiguration: aws.sdk.kotlin.services.chimesdkmeetings.model.NotificationsConfiguration? = builder.notificationsConfiguration
    /**
     * When specified, replicates the media from the primary meeting to the new meeting.
     */
    public val primaryMeetingId: kotlin.String? = builder.primaryMeetingId
    /**
     * Applies one or more tags to an Amazon Chime SDK meeting. Note the following:
     * + Not all resources have tags. For a list of services with resources that support tagging using this operation, see [Services that support the Resource Groups Tagging API](https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/supported-services.html). If the resource doesn't yet support this operation, the resource's service might support tagging using its own API operations. For more information, refer to the documentation for that service.
     * + Each resource can have up to 50 tags. For other limits, see [Tag Naming and Usage Conventions](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html#tag-conventions) in the *AWS General Reference*.
     * + You can only tag resources that are located in the specified Amazon Web Services Region for the Amazon Web Services account.
     * + To add tags to a resource, you need the necessary permissions for the service that the resource belongs to as well as permissions for adding tags. For more information, see the documentation for each service.
     *
     * Do not store personally identifiable information (PII) or other confidential or sensitive information in tags. We use tags to provide you with billing and administration services. Tags are not intended to be used for private or sensitive data.
     *
     * **Minimum permissions**
     *
     * In addition to the `tag:TagResources` permission required by this operation, you must also have the tagging permission defined by the service that created the resource. For example, to tag a `ChimeSDKMeetings` instance using the `TagResources` operation, you must have both of the following permissions:
     *
     * `tag:TagResources`
     *
     * `ChimeSDKMeetings:CreateTags`
     *
     * Some services might have specific requirements for tagging some resources. For example, to tag an Amazon S3 bucket, you must also have the `s3:GetBucketTagging` permission. If the expected minimum permissions don't work, check the documentation for that service's tagging APIs for more information.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * A consistent and opaque identifier, created and maintained by the builder to represent a segment of their users.
     */
    public val tenantIds: List<String>? = builder.tenantIds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.chimesdkmeetings.model.CreateMeetingRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateMeetingRequest(")
        append("clientRequestToken=*** Sensitive Data Redacted ***,")
        append("externalMeetingId=*** Sensitive Data Redacted ***,")
        append("mediaRegion=$mediaRegion,")
        append("meetingFeatures=$meetingFeatures,")
        append("meetingHostId=*** Sensitive Data Redacted ***,")
        append("notificationsConfiguration=$notificationsConfiguration,")
        append("primaryMeetingId=$primaryMeetingId,")
        append("tags=$tags,")
        append("tenantIds=$tenantIds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientRequestToken?.hashCode() ?: 0
        result = 31 * result + (externalMeetingId?.hashCode() ?: 0)
        result = 31 * result + (mediaRegion?.hashCode() ?: 0)
        result = 31 * result + (meetingFeatures?.hashCode() ?: 0)
        result = 31 * result + (meetingHostId?.hashCode() ?: 0)
        result = 31 * result + (notificationsConfiguration?.hashCode() ?: 0)
        result = 31 * result + (primaryMeetingId?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (tenantIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateMeetingRequest

        if (clientRequestToken != other.clientRequestToken) return false
        if (externalMeetingId != other.externalMeetingId) return false
        if (mediaRegion != other.mediaRegion) return false
        if (meetingFeatures != other.meetingFeatures) return false
        if (meetingHostId != other.meetingHostId) return false
        if (notificationsConfiguration != other.notificationsConfiguration) return false
        if (primaryMeetingId != other.primaryMeetingId) return false
        if (tags != other.tags) return false
        if (tenantIds != other.tenantIds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.chimesdkmeetings.model.CreateMeetingRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The unique identifier for the client request. Use a different token for different meetings.
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * The external meeting ID.
         *
         * Pattern: `[-_&@+=,(){}\[\]\/«».:|'"#a-zA-Z0-9À-ÿ\s]*`
         *
         * Values that begin with `aws:` are reserved. You can't configure a value that uses this prefix. Case insensitive.
         */
        public var externalMeetingId: kotlin.String? = null
        /**
         * The Region in which to create the meeting.
         *
         *  Available values: `af-south-1`, `ap-northeast-1`, `ap-northeast-2`, `ap-south-1`, `ap-southeast-1`, `ap-southeast-2`, `ca-central-1`, `eu-central-1`, `eu-north-1`, `eu-south-1`, `eu-west-1`, `eu-west-2`, `eu-west-3`, `sa-east-1`, `us-east-1`, `us-east-2`, `us-west-1`, `us-west-2`.
         *
         * Available values in Amazon Web Services GovCloud (US) Regions: `us-gov-east-1`, `us-gov-west-1`.
         */
        public var mediaRegion: kotlin.String? = null
        /**
         * Lists the audio and video features enabled for a meeting, such as echo reduction.
         */
        public var meetingFeatures: aws.sdk.kotlin.services.chimesdkmeetings.model.MeetingFeaturesConfiguration? = null
        /**
         * Reserved.
         */
        public var meetingHostId: kotlin.String? = null
        /**
         * The configuration for resource targets to receive notifications when meeting and attendee events occur.
         */
        public var notificationsConfiguration: aws.sdk.kotlin.services.chimesdkmeetings.model.NotificationsConfiguration? = null
        /**
         * When specified, replicates the media from the primary meeting to the new meeting.
         */
        public var primaryMeetingId: kotlin.String? = null
        /**
         * Applies one or more tags to an Amazon Chime SDK meeting. Note the following:
         * + Not all resources have tags. For a list of services with resources that support tagging using this operation, see [Services that support the Resource Groups Tagging API](https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/supported-services.html). If the resource doesn't yet support this operation, the resource's service might support tagging using its own API operations. For more information, refer to the documentation for that service.
         * + Each resource can have up to 50 tags. For other limits, see [Tag Naming and Usage Conventions](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html#tag-conventions) in the *AWS General Reference*.
         * + You can only tag resources that are located in the specified Amazon Web Services Region for the Amazon Web Services account.
         * + To add tags to a resource, you need the necessary permissions for the service that the resource belongs to as well as permissions for adding tags. For more information, see the documentation for each service.
         *
         * Do not store personally identifiable information (PII) or other confidential or sensitive information in tags. We use tags to provide you with billing and administration services. Tags are not intended to be used for private or sensitive data.
         *
         * **Minimum permissions**
         *
         * In addition to the `tag:TagResources` permission required by this operation, you must also have the tagging permission defined by the service that created the resource. For example, to tag a `ChimeSDKMeetings` instance using the `TagResources` operation, you must have both of the following permissions:
         *
         * `tag:TagResources`
         *
         * `ChimeSDKMeetings:CreateTags`
         *
         * Some services might have specific requirements for tagging some resources. For example, to tag an Amazon S3 bucket, you must also have the `s3:GetBucketTagging` permission. If the expected minimum permissions don't work, check the documentation for that service's tagging APIs for more information.
         */
        public var tags: List<Tag>? = null
        /**
         * A consistent and opaque identifier, created and maintained by the builder to represent a segment of their users.
         */
        public var tenantIds: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.chimesdkmeetings.model.CreateMeetingRequest) : this() {
            this.clientRequestToken = x.clientRequestToken
            this.externalMeetingId = x.externalMeetingId
            this.mediaRegion = x.mediaRegion
            this.meetingFeatures = x.meetingFeatures
            this.meetingHostId = x.meetingHostId
            this.notificationsConfiguration = x.notificationsConfiguration
            this.primaryMeetingId = x.primaryMeetingId
            this.tags = x.tags
            this.tenantIds = x.tenantIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.chimesdkmeetings.model.CreateMeetingRequest = CreateMeetingRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.chimesdkmeetings.model.MeetingFeaturesConfiguration] inside the given [block]
         */
        public fun meetingFeatures(block: aws.sdk.kotlin.services.chimesdkmeetings.model.MeetingFeaturesConfiguration.Builder.() -> kotlin.Unit) {
            this.meetingFeatures = aws.sdk.kotlin.services.chimesdkmeetings.model.MeetingFeaturesConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.chimesdkmeetings.model.NotificationsConfiguration] inside the given [block]
         */
        public fun notificationsConfiguration(block: aws.sdk.kotlin.services.chimesdkmeetings.model.NotificationsConfiguration.Builder.() -> kotlin.Unit) {
            this.notificationsConfiguration = aws.sdk.kotlin.services.chimesdkmeetings.model.NotificationsConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
