// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chimesdkmeetings.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The media capabilities of an attendee: audio, video, or content.
 *
 * You use the capabilities with a set of values that control what the capabilities can do, such as `SendReceive` data. For more information, refer to and .
 *
 * When using capabilities, be aware of these corner cases:
 * + If you specify `MeetingFeatures:Video:MaxResolution:None` when you create a meeting, all API requests that include `SendReceive`, `Send`, or `Receive` for `AttendeeCapabilities:Video` will be rejected with `ValidationError 400`.
 * + If you specify `MeetingFeatures:Content:MaxResolution:None` when you create a meeting, all API requests that include `SendReceive`, `Send`, or `Receive` for `AttendeeCapabilities:Content` will be rejected with `ValidationError 400`.
 * + You can't set `content` capabilities to `SendReceive` or `Receive` unless you also set `video` capabilities to `SendReceive` or `Receive`. If you don't set the `video` capability to receive, the response will contain an HTTP 400 Bad Request status code. However, you can set your `video` capability to receive and you set your `content` capability to not receive.
 * + When you change an `audio` capability from `None` or `Receive` to `Send` or `SendReceive` , and an attendee unmutes their microphone, audio flows from the attendee to the other meeting participants.
 * + When you change a `video` or `content` capability from `None` or `Receive` to `Send` or `SendReceive` , and the attendee turns on their video or content streams, remote attendees can receive those streams, but only after media renegotiation between the client and the Amazon Chime back-end server.
 */
public class AttendeeCapabilities private constructor(builder: Builder) {
    /**
     * The audio capability assigned to an attendee.
     */
    public val audio: aws.sdk.kotlin.services.chimesdkmeetings.model.MediaCapabilities = requireNotNull(builder.audio) { "A non-null value must be provided for audio" }
    /**
     * The content capability assigned to an attendee.
     */
    public val content: aws.sdk.kotlin.services.chimesdkmeetings.model.MediaCapabilities = requireNotNull(builder.content) { "A non-null value must be provided for content" }
    /**
     * The video capability assigned to an attendee.
     */
    public val video: aws.sdk.kotlin.services.chimesdkmeetings.model.MediaCapabilities = requireNotNull(builder.video) { "A non-null value must be provided for video" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.chimesdkmeetings.model.AttendeeCapabilities = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AttendeeCapabilities(")
        append("audio=$audio,")
        append("content=$content,")
        append("video=$video")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = audio.hashCode()
        result = 31 * result + (content.hashCode())
        result = 31 * result + (video.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AttendeeCapabilities

        if (audio != other.audio) return false
        if (content != other.content) return false
        if (video != other.video) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.chimesdkmeetings.model.AttendeeCapabilities = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The audio capability assigned to an attendee.
         */
        public var audio: aws.sdk.kotlin.services.chimesdkmeetings.model.MediaCapabilities? = null
        /**
         * The content capability assigned to an attendee.
         */
        public var content: aws.sdk.kotlin.services.chimesdkmeetings.model.MediaCapabilities? = null
        /**
         * The video capability assigned to an attendee.
         */
        public var video: aws.sdk.kotlin.services.chimesdkmeetings.model.MediaCapabilities? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.chimesdkmeetings.model.AttendeeCapabilities) : this() {
            this.audio = x.audio
            this.content = x.content
            this.video = x.video
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.chimesdkmeetings.model.AttendeeCapabilities = AttendeeCapabilities(this)

        internal fun correctErrors(): Builder {
            if (audio == null) audio = MediaCapabilities.SdkUnknown("no value provided")
            if (content == null) content = MediaCapabilities.SdkUnknown("no value provided")
            if (video == null) video = MediaCapabilities.SdkUnknown("no value provided")
            return this
        }
    }
}
