// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chimesdkmeetings.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * An Amazon Chime SDK meeting attendee. Includes a unique `AttendeeId` and `JoinToken`. The `JoinToken` allows a client to authenticate and join as the specified attendee. The `JoinToken` expires when the meeting ends, or when DeleteAttendee is called. After that, the attendee is unable to join the meeting.
 *
 * We recommend securely transferring each `JoinToken` from your server application to the client so that no other client has access to the token except for the one authorized to represent the attendee.
 */
public class Attendee private constructor(builder: Builder) {
    /**
     * The Amazon Chime SDK attendee ID.
     */
    public val attendeeId: kotlin.String? = builder.attendeeId
    /**
     * The capabilities assigned to an attendee: audio, video, or content.
     *
     * You use the capabilities with a set of values that control what the capabilities can do, such as `SendReceive` data. For more information about those values, see .
     *
     * When using capabilities, be aware of these corner cases:
     * + If you specify `MeetingFeatures:Video:MaxResolution:None` when you create a meeting, all API requests that include `SendReceive`, `Send`, or `Receive` for `AttendeeCapabilities:Video` will be rejected with `ValidationError 400`.
     * + If you specify `MeetingFeatures:Content:MaxResolution:None` when you create a meeting, all API requests that include `SendReceive`, `Send`, or `Receive` for `AttendeeCapabilities:Content` will be rejected with `ValidationError 400`.
     * + You can't set `content` capabilities to `SendReceive` or `Receive` unless you also set `video` capabilities to `SendReceive` or `Receive`. If you don't set the `video` capability to receive, the response will contain an HTTP 400 Bad Request status code. However, you can set your `video` capability to receive and you set your `content` capability to not receive.
     * + When you change an `audio` capability from `None` or `Receive` to `Send` or `SendReceive` , and if the attendee left their microphone unmuted, audio will flow from the attendee to the other meeting participants.
     * + When you change a `video` or `content` capability from `None` or `Receive` to `Send` or `SendReceive` , and if the attendee turned on their video or content streams, remote attendees can receive those streams, but only after media renegotiation between the client and the Amazon Chime back-end server.
     */
    public val capabilities: aws.sdk.kotlin.services.chimesdkmeetings.model.AttendeeCapabilities? = builder.capabilities
    /**
     * The Amazon Chime SDK external user ID. An idempotency token. Links the attendee to an identity managed by a builder application.
     *
     * Pattern: `[-_&@+=,(){}\[\]\/«».:|'"#a-zA-Z0-9À-ÿ\s]*`
     *
     * Values that begin with `aws:` are reserved. You can't configure a value that uses this prefix. Case insensitive.
     */
    public val externalUserId: kotlin.String? = builder.externalUserId
    /**
     * The join token used by the Amazon Chime SDK attendee.
     */
    public val joinToken: kotlin.String? = builder.joinToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.chimesdkmeetings.model.Attendee = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Attendee(")
        append("attendeeId=$attendeeId,")
        append("capabilities=$capabilities,")
        append("externalUserId=*** Sensitive Data Redacted ***,")
        append("joinToken=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attendeeId?.hashCode() ?: 0
        result = 31 * result + (capabilities?.hashCode() ?: 0)
        result = 31 * result + (externalUserId?.hashCode() ?: 0)
        result = 31 * result + (joinToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Attendee

        if (attendeeId != other.attendeeId) return false
        if (capabilities != other.capabilities) return false
        if (externalUserId != other.externalUserId) return false
        if (joinToken != other.joinToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.chimesdkmeetings.model.Attendee = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Chime SDK attendee ID.
         */
        public var attendeeId: kotlin.String? = null
        /**
         * The capabilities assigned to an attendee: audio, video, or content.
         *
         * You use the capabilities with a set of values that control what the capabilities can do, such as `SendReceive` data. For more information about those values, see .
         *
         * When using capabilities, be aware of these corner cases:
         * + If you specify `MeetingFeatures:Video:MaxResolution:None` when you create a meeting, all API requests that include `SendReceive`, `Send`, or `Receive` for `AttendeeCapabilities:Video` will be rejected with `ValidationError 400`.
         * + If you specify `MeetingFeatures:Content:MaxResolution:None` when you create a meeting, all API requests that include `SendReceive`, `Send`, or `Receive` for `AttendeeCapabilities:Content` will be rejected with `ValidationError 400`.
         * + You can't set `content` capabilities to `SendReceive` or `Receive` unless you also set `video` capabilities to `SendReceive` or `Receive`. If you don't set the `video` capability to receive, the response will contain an HTTP 400 Bad Request status code. However, you can set your `video` capability to receive and you set your `content` capability to not receive.
         * + When you change an `audio` capability from `None` or `Receive` to `Send` or `SendReceive` , and if the attendee left their microphone unmuted, audio will flow from the attendee to the other meeting participants.
         * + When you change a `video` or `content` capability from `None` or `Receive` to `Send` or `SendReceive` , and if the attendee turned on their video or content streams, remote attendees can receive those streams, but only after media renegotiation between the client and the Amazon Chime back-end server.
         */
        public var capabilities: aws.sdk.kotlin.services.chimesdkmeetings.model.AttendeeCapabilities? = null
        /**
         * The Amazon Chime SDK external user ID. An idempotency token. Links the attendee to an identity managed by a builder application.
         *
         * Pattern: `[-_&@+=,(){}\[\]\/«».:|'"#a-zA-Z0-9À-ÿ\s]*`
         *
         * Values that begin with `aws:` are reserved. You can't configure a value that uses this prefix. Case insensitive.
         */
        public var externalUserId: kotlin.String? = null
        /**
         * The join token used by the Amazon Chime SDK attendee.
         */
        public var joinToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.chimesdkmeetings.model.Attendee) : this() {
            this.attendeeId = x.attendeeId
            this.capabilities = x.capabilities
            this.externalUserId = x.externalUserId
            this.joinToken = x.joinToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.chimesdkmeetings.model.Attendee = Attendee(this)

        /**
         * construct an [aws.sdk.kotlin.services.chimesdkmeetings.model.AttendeeCapabilities] inside the given [block]
         */
        public fun capabilities(block: aws.sdk.kotlin.services.chimesdkmeetings.model.AttendeeCapabilities.Builder.() -> kotlin.Unit) {
            this.capabilities = aws.sdk.kotlin.services.chimesdkmeetings.model.AttendeeCapabilities.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
