// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chimesdkmediapipelines.paginators

import aws.sdk.kotlin.services.chimesdkmediapipelines.ChimeSdkMediaPipelinesClient
import aws.sdk.kotlin.services.chimesdkmediapipelines.model.ListMediaCapturePipelinesRequest
import aws.sdk.kotlin.services.chimesdkmediapipelines.model.ListMediaCapturePipelinesResponse
import aws.sdk.kotlin.services.chimesdkmediapipelines.model.ListMediaInsightsPipelineConfigurationsRequest
import aws.sdk.kotlin.services.chimesdkmediapipelines.model.ListMediaInsightsPipelineConfigurationsResponse
import aws.sdk.kotlin.services.chimesdkmediapipelines.model.ListMediaPipelinesRequest
import aws.sdk.kotlin.services.chimesdkmediapipelines.model.ListMediaPipelinesResponse
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow


/**
 * Paginate over [ListMediaCapturePipelinesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListMediaCapturePipelinesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMediaCapturePipelinesResponse]
 */
public fun ChimeSdkMediaPipelinesClient.listMediaCapturePipelinesPaginated(initialRequest: ListMediaCapturePipelinesRequest): Flow<ListMediaCapturePipelinesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listMediaCapturePipelinesPaginated.listMediaCapturePipelines(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListMediaCapturePipelinesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMediaCapturePipelinesResponse]
 */
public fun ChimeSdkMediaPipelinesClient.listMediaCapturePipelinesPaginated(block: ListMediaCapturePipelinesRequest.Builder.() -> Unit): Flow<ListMediaCapturePipelinesResponse> =
    listMediaCapturePipelinesPaginated(ListMediaCapturePipelinesRequest.Builder().apply(block).build())

/**
 * Paginate over [ListMediaInsightsPipelineConfigurationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListMediaInsightsPipelineConfigurationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMediaInsightsPipelineConfigurationsResponse]
 */
public fun ChimeSdkMediaPipelinesClient.listMediaInsightsPipelineConfigurationsPaginated(initialRequest: ListMediaInsightsPipelineConfigurationsRequest): Flow<ListMediaInsightsPipelineConfigurationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listMediaInsightsPipelineConfigurationsPaginated.listMediaInsightsPipelineConfigurations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListMediaInsightsPipelineConfigurationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMediaInsightsPipelineConfigurationsResponse]
 */
public fun ChimeSdkMediaPipelinesClient.listMediaInsightsPipelineConfigurationsPaginated(block: ListMediaInsightsPipelineConfigurationsRequest.Builder.() -> Unit): Flow<ListMediaInsightsPipelineConfigurationsResponse> =
    listMediaInsightsPipelineConfigurationsPaginated(ListMediaInsightsPipelineConfigurationsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListMediaPipelinesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListMediaPipelinesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMediaPipelinesResponse]
 */
public fun ChimeSdkMediaPipelinesClient.listMediaPipelinesPaginated(initialRequest: ListMediaPipelinesRequest): Flow<ListMediaPipelinesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listMediaPipelinesPaginated.listMediaPipelines(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListMediaPipelinesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMediaPipelinesResponse]
 */
public fun ChimeSdkMediaPipelinesClient.listMediaPipelinesPaginated(block: ListMediaPipelinesRequest.Builder.() -> Unit): Flow<ListMediaPipelinesResponse> =
    listMediaPipelinesPaginated(ListMediaPipelinesRequest.Builder().apply(block).build())
