// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chimesdkmediapipelines.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A media pipeline that streams call analytics data.
 */
public class MediaInsightsPipeline private constructor(builder: Builder) {
    /**
     * The time at which the media insights pipeline was created.
     */
    public val createdTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.createdTimestamp
    /**
     * The statuses that the elements in a media insights pipeline can have during data processing.
     */
    public val elementStatuses: List<MediaInsightsPipelineElementStatus>? = builder.elementStatuses
    /**
     * The runtime configuration settings for a Kinesis recording video stream in a media insights pipeline.
     */
    public val kinesisVideoStreamRecordingSourceRuntimeConfiguration: aws.sdk.kotlin.services.chimesdkmediapipelines.model.KinesisVideoStreamRecordingSourceRuntimeConfiguration? = builder.kinesisVideoStreamRecordingSourceRuntimeConfiguration
    /**
     * The configuration settings for a Kinesis runtime video stream in a media insights pipeline.
     */
    public val kinesisVideoStreamSourceRuntimeConfiguration: aws.sdk.kotlin.services.chimesdkmediapipelines.model.KinesisVideoStreamSourceRuntimeConfiguration? = builder.kinesisVideoStreamSourceRuntimeConfiguration
    /**
     * The ARN of a media insight pipeline's configuration settings.
     */
    public val mediaInsightsPipelineConfigurationArn: kotlin.String? = builder.mediaInsightsPipelineConfigurationArn
    /**
     * The runtime metadata of a media insights pipeline.
     */
    public val mediaInsightsRuntimeMetadata: Map<String, String>? = builder.mediaInsightsRuntimeMetadata
    /**
     * The ARN of a media insights pipeline.
     */
    public val mediaPipelineArn: kotlin.String? = builder.mediaPipelineArn
    /**
     * The ID of a media insights pipeline.
     */
    public val mediaPipelineId: kotlin.String? = builder.mediaPipelineId
    /**
     * The runtime configuration of the Amazon S3 bucket that stores recordings in a media insights pipeline.
     */
    public val s3RecordingSinkRuntimeConfiguration: aws.sdk.kotlin.services.chimesdkmediapipelines.model.S3RecordingSinkRuntimeConfiguration? = builder.s3RecordingSinkRuntimeConfiguration
    /**
     * The status of a media insights pipeline.
     */
    public val status: aws.sdk.kotlin.services.chimesdkmediapipelines.model.MediaPipelineStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.chimesdkmediapipelines.model.MediaInsightsPipeline = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MediaInsightsPipeline(")
        append("createdTimestamp=$createdTimestamp,")
        append("elementStatuses=$elementStatuses,")
        append("kinesisVideoStreamRecordingSourceRuntimeConfiguration=$kinesisVideoStreamRecordingSourceRuntimeConfiguration,")
        append("kinesisVideoStreamSourceRuntimeConfiguration=$kinesisVideoStreamSourceRuntimeConfiguration,")
        append("mediaInsightsPipelineConfigurationArn=*** Sensitive Data Redacted ***,")
        append("mediaInsightsRuntimeMetadata=*** Sensitive Data Redacted ***,")
        append("mediaPipelineArn=*** Sensitive Data Redacted ***,")
        append("mediaPipelineId=$mediaPipelineId,")
        append("s3RecordingSinkRuntimeConfiguration=$s3RecordingSinkRuntimeConfiguration,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdTimestamp?.hashCode() ?: 0
        result = 31 * result + (elementStatuses?.hashCode() ?: 0)
        result = 31 * result + (kinesisVideoStreamRecordingSourceRuntimeConfiguration?.hashCode() ?: 0)
        result = 31 * result + (kinesisVideoStreamSourceRuntimeConfiguration?.hashCode() ?: 0)
        result = 31 * result + (mediaInsightsPipelineConfigurationArn?.hashCode() ?: 0)
        result = 31 * result + (mediaInsightsRuntimeMetadata?.hashCode() ?: 0)
        result = 31 * result + (mediaPipelineArn?.hashCode() ?: 0)
        result = 31 * result + (mediaPipelineId?.hashCode() ?: 0)
        result = 31 * result + (s3RecordingSinkRuntimeConfiguration?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MediaInsightsPipeline

        if (createdTimestamp != other.createdTimestamp) return false
        if (elementStatuses != other.elementStatuses) return false
        if (kinesisVideoStreamRecordingSourceRuntimeConfiguration != other.kinesisVideoStreamRecordingSourceRuntimeConfiguration) return false
        if (kinesisVideoStreamSourceRuntimeConfiguration != other.kinesisVideoStreamSourceRuntimeConfiguration) return false
        if (mediaInsightsPipelineConfigurationArn != other.mediaInsightsPipelineConfigurationArn) return false
        if (mediaInsightsRuntimeMetadata != other.mediaInsightsRuntimeMetadata) return false
        if (mediaPipelineArn != other.mediaPipelineArn) return false
        if (mediaPipelineId != other.mediaPipelineId) return false
        if (s3RecordingSinkRuntimeConfiguration != other.s3RecordingSinkRuntimeConfiguration) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.chimesdkmediapipelines.model.MediaInsightsPipeline = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The time at which the media insights pipeline was created.
         */
        public var createdTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The statuses that the elements in a media insights pipeline can have during data processing.
         */
        public var elementStatuses: List<MediaInsightsPipelineElementStatus>? = null
        /**
         * The runtime configuration settings for a Kinesis recording video stream in a media insights pipeline.
         */
        public var kinesisVideoStreamRecordingSourceRuntimeConfiguration: aws.sdk.kotlin.services.chimesdkmediapipelines.model.KinesisVideoStreamRecordingSourceRuntimeConfiguration? = null
        /**
         * The configuration settings for a Kinesis runtime video stream in a media insights pipeline.
         */
        public var kinesisVideoStreamSourceRuntimeConfiguration: aws.sdk.kotlin.services.chimesdkmediapipelines.model.KinesisVideoStreamSourceRuntimeConfiguration? = null
        /**
         * The ARN of a media insight pipeline's configuration settings.
         */
        public var mediaInsightsPipelineConfigurationArn: kotlin.String? = null
        /**
         * The runtime metadata of a media insights pipeline.
         */
        public var mediaInsightsRuntimeMetadata: Map<String, String>? = null
        /**
         * The ARN of a media insights pipeline.
         */
        public var mediaPipelineArn: kotlin.String? = null
        /**
         * The ID of a media insights pipeline.
         */
        public var mediaPipelineId: kotlin.String? = null
        /**
         * The runtime configuration of the Amazon S3 bucket that stores recordings in a media insights pipeline.
         */
        public var s3RecordingSinkRuntimeConfiguration: aws.sdk.kotlin.services.chimesdkmediapipelines.model.S3RecordingSinkRuntimeConfiguration? = null
        /**
         * The status of a media insights pipeline.
         */
        public var status: aws.sdk.kotlin.services.chimesdkmediapipelines.model.MediaPipelineStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.chimesdkmediapipelines.model.MediaInsightsPipeline) : this() {
            this.createdTimestamp = x.createdTimestamp
            this.elementStatuses = x.elementStatuses
            this.kinesisVideoStreamRecordingSourceRuntimeConfiguration = x.kinesisVideoStreamRecordingSourceRuntimeConfiguration
            this.kinesisVideoStreamSourceRuntimeConfiguration = x.kinesisVideoStreamSourceRuntimeConfiguration
            this.mediaInsightsPipelineConfigurationArn = x.mediaInsightsPipelineConfigurationArn
            this.mediaInsightsRuntimeMetadata = x.mediaInsightsRuntimeMetadata
            this.mediaPipelineArn = x.mediaPipelineArn
            this.mediaPipelineId = x.mediaPipelineId
            this.s3RecordingSinkRuntimeConfiguration = x.s3RecordingSinkRuntimeConfiguration
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.chimesdkmediapipelines.model.MediaInsightsPipeline = MediaInsightsPipeline(this)

        /**
         * construct an [aws.sdk.kotlin.services.chimesdkmediapipelines.model.KinesisVideoStreamRecordingSourceRuntimeConfiguration] inside the given [block]
         */
        public fun kinesisVideoStreamRecordingSourceRuntimeConfiguration(block: aws.sdk.kotlin.services.chimesdkmediapipelines.model.KinesisVideoStreamRecordingSourceRuntimeConfiguration.Builder.() -> kotlin.Unit) {
            this.kinesisVideoStreamRecordingSourceRuntimeConfiguration = aws.sdk.kotlin.services.chimesdkmediapipelines.model.KinesisVideoStreamRecordingSourceRuntimeConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.chimesdkmediapipelines.model.KinesisVideoStreamSourceRuntimeConfiguration] inside the given [block]
         */
        public fun kinesisVideoStreamSourceRuntimeConfiguration(block: aws.sdk.kotlin.services.chimesdkmediapipelines.model.KinesisVideoStreamSourceRuntimeConfiguration.Builder.() -> kotlin.Unit) {
            this.kinesisVideoStreamSourceRuntimeConfiguration = aws.sdk.kotlin.services.chimesdkmediapipelines.model.KinesisVideoStreamSourceRuntimeConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.chimesdkmediapipelines.model.S3RecordingSinkRuntimeConfiguration] inside the given [block]
         */
        public fun s3RecordingSinkRuntimeConfiguration(block: aws.sdk.kotlin.services.chimesdkmediapipelines.model.S3RecordingSinkRuntimeConfiguration.Builder.() -> kotlin.Unit) {
            this.s3RecordingSinkRuntimeConfiguration = aws.sdk.kotlin.services.chimesdkmediapipelines.model.S3RecordingSinkRuntimeConfiguration.invoke(block)
        }
    }
}
