// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chimesdkmediapipelines.model



/**
 * A structure that contains the configuration settings for an Amazon Transcribe call analytics processor.
 */
public class AmazonTranscribeCallAnalyticsProcessorConfiguration private constructor(builder: Builder) {
    /**
     * By default, all `CategoryEvents` are sent to the insights target. If this parameter is specified, only included categories are sent to the insights target.
     */
    public val callAnalyticsStreamCategories: List<String>? = builder.callAnalyticsStreamCategories
    /**
     * Labels all personally identifiable information (PII) identified in your transcript.
     *
     * Content identification is performed at the segment level; PII specified in `PiiEntityTypes` is flagged upon complete transcription of an audio segment.
     *
     * You can’t set `ContentIdentificationType` and `ContentRedactionType` in the same request. If you do, your request returns a `BadRequestException`.
     *
     * For more information, see [Redacting or identifying personally identifiable information](https://docs.aws.amazon.com/transcribe/latest/dg/pii-redaction.html) in the *Amazon Transcribe Developer Guide*.
     */
    public val contentIdentificationType: aws.sdk.kotlin.services.chimesdkmediapipelines.model.ContentType? = builder.contentIdentificationType
    /**
     * Redacts all personally identifiable information (PII) identified in your transcript.
     *
     * Content redaction is performed at the segment level; PII specified in `PiiEntityTypes` is redacted upon complete transcription of an audio segment.
     *
     * You can’t set `ContentRedactionType` and `ContentIdentificationType` in the same request. If you do, your request returns a `BadRequestException`.
     *
     * For more information, see [Redacting or identifying personally identifiable information](https://docs.aws.amazon.com/transcribe/latest/dg/pii-redaction.html) in the *Amazon Transcribe Developer Guide*.
     */
    public val contentRedactionType: aws.sdk.kotlin.services.chimesdkmediapipelines.model.ContentType? = builder.contentRedactionType
    /**
     * Enables partial result stabilization for your transcription. Partial result stabilization can reduce latency in your output, but may impact accuracy. For more information, see [Partial-result stabilization](https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html#streaming-partial-result-stabilization) in the *Amazon Transcribe Developer Guide*.
     */
    public val enablePartialResultsStabilization: kotlin.Boolean = builder.enablePartialResultsStabilization
    /**
     * If true, `UtteranceEvents` with `IsPartial: true` are filtered out of the insights target.
     */
    public val filterPartialResults: kotlin.Boolean = builder.filterPartialResults
    /**
     * The language code in the configuration.
     */
    public val languageCode: aws.sdk.kotlin.services.chimesdkmediapipelines.model.CallAnalyticsLanguageCode? = builder.languageCode
    /**
     * Specifies the name of the custom language model to use when processing a transcription. Note that language model names are case sensitive.
     *
     * The language of the specified language model must match the language code specified in the transcription request. If the languages don't match, the custom language model isn't applied. Language mismatches don't generate errors or warnings.
     *
     * For more information, see [Custom language models](https://docs.aws.amazon.com/transcribe/latest/dg/custom-language-models.html) in the *Amazon Transcribe Developer Guide*.
     */
    public val languageModelName: kotlin.String? = builder.languageModelName
    /**
     * Specifies the level of stability to use when you enable partial results stabilization (`EnablePartialResultsStabilization`).
     *
     * Low stability provides the highest accuracy. High stability transcribes faster, but with slightly lower accuracy.
     *
     * For more information, see [Partial-result stabilization](https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html#streaming-partial-result-stabilization) in the *Amazon Transcribe Developer Guide*.
     */
    public val partialResultsStability: aws.sdk.kotlin.services.chimesdkmediapipelines.model.PartialResultsStability? = builder.partialResultsStability
    /**
     * Specifies the types of personally identifiable information (PII) to redact from a transcript. You can include as many types as you'd like, or you can select `ALL`.
     *
     * To include `PiiEntityTypes` in your Call Analytics request, you must also include `ContentIdentificationType` or `ContentRedactionType`, but you can't include both.
     *
     * Values must be comma-separated and can include: `ADDRESS`, `BANK_ACCOUNT_NUMBER`, `BANK_ROUTING`, `CREDIT_DEBIT_CVV`, `CREDIT_DEBIT_EXPIRY`, `CREDIT_DEBIT_NUMBER`, `EMAIL`, `NAME`, `PHONE`, `PIN`, `SSN`, or `ALL`.
     *
     * Length Constraints: Minimum length of 1. Maximum length of 300.
     */
    public val piiEntityTypes: kotlin.String? = builder.piiEntityTypes
    /**
     * The settings for a post-call analysis task in an analytics configuration.
     */
    public val postCallAnalyticsSettings: aws.sdk.kotlin.services.chimesdkmediapipelines.model.PostCallAnalyticsSettings? = builder.postCallAnalyticsSettings
    /**
     * Specifies how to apply a vocabulary filter to a transcript.
     *
     * To replace words with *******, choose `mask`.
     *
     * To delete words, choose `remove`.
     *
     * To flag words without changing them, choose `tag`.
     */
    public val vocabularyFilterMethod: aws.sdk.kotlin.services.chimesdkmediapipelines.model.VocabularyFilterMethod? = builder.vocabularyFilterMethod
    /**
     * Specifies the name of the custom vocabulary filter to use when processing a transcription. Note that vocabulary filter names are case sensitive.
     *
     * If the language of the specified custom vocabulary filter doesn't match the language identified in your media, the vocabulary filter is not applied to your transcription.
     *
     * For more information, see [Using vocabulary filtering with unwanted words](https://docs.aws.amazon.com/transcribe/latest/dg/vocabulary-filtering.html) in the *Amazon Transcribe Developer Guide*.
     *
     * Length Constraints: Minimum length of 1. Maximum length of 200.
     */
    public val vocabularyFilterName: kotlin.String? = builder.vocabularyFilterName
    /**
     * Specifies the name of the custom vocabulary to use when processing a transcription. Note that vocabulary names are case sensitive.
     *
     * If the language of the specified custom vocabulary doesn't match the language identified in your media, the custom vocabulary is not applied to your transcription.
     *
     * For more information, see [Custom vocabularies](https://docs.aws.amazon.com/transcribe/latest/dg/custom-vocabulary.html) in the *Amazon Transcribe Developer Guide*.
     *
     * Length Constraints: Minimum length of 1. Maximum length of 200.
     */
    public val vocabularyName: kotlin.String? = builder.vocabularyName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.chimesdkmediapipelines.model.AmazonTranscribeCallAnalyticsProcessorConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AmazonTranscribeCallAnalyticsProcessorConfiguration(")
        append("callAnalyticsStreamCategories=$callAnalyticsStreamCategories,")
        append("contentIdentificationType=$contentIdentificationType,")
        append("contentRedactionType=$contentRedactionType,")
        append("enablePartialResultsStabilization=$enablePartialResultsStabilization,")
        append("filterPartialResults=$filterPartialResults,")
        append("languageCode=$languageCode,")
        append("languageModelName=$languageModelName,")
        append("partialResultsStability=$partialResultsStability,")
        append("piiEntityTypes=$piiEntityTypes,")
        append("postCallAnalyticsSettings=$postCallAnalyticsSettings,")
        append("vocabularyFilterMethod=$vocabularyFilterMethod,")
        append("vocabularyFilterName=$vocabularyFilterName,")
        append("vocabularyName=$vocabularyName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = callAnalyticsStreamCategories?.hashCode() ?: 0
        result = 31 * result + (contentIdentificationType?.hashCode() ?: 0)
        result = 31 * result + (contentRedactionType?.hashCode() ?: 0)
        result = 31 * result + (enablePartialResultsStabilization.hashCode())
        result = 31 * result + (filterPartialResults.hashCode())
        result = 31 * result + (languageCode?.hashCode() ?: 0)
        result = 31 * result + (languageModelName?.hashCode() ?: 0)
        result = 31 * result + (partialResultsStability?.hashCode() ?: 0)
        result = 31 * result + (piiEntityTypes?.hashCode() ?: 0)
        result = 31 * result + (postCallAnalyticsSettings?.hashCode() ?: 0)
        result = 31 * result + (vocabularyFilterMethod?.hashCode() ?: 0)
        result = 31 * result + (vocabularyFilterName?.hashCode() ?: 0)
        result = 31 * result + (vocabularyName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AmazonTranscribeCallAnalyticsProcessorConfiguration

        if (callAnalyticsStreamCategories != other.callAnalyticsStreamCategories) return false
        if (contentIdentificationType != other.contentIdentificationType) return false
        if (contentRedactionType != other.contentRedactionType) return false
        if (enablePartialResultsStabilization != other.enablePartialResultsStabilization) return false
        if (filterPartialResults != other.filterPartialResults) return false
        if (languageCode != other.languageCode) return false
        if (languageModelName != other.languageModelName) return false
        if (partialResultsStability != other.partialResultsStability) return false
        if (piiEntityTypes != other.piiEntityTypes) return false
        if (postCallAnalyticsSettings != other.postCallAnalyticsSettings) return false
        if (vocabularyFilterMethod != other.vocabularyFilterMethod) return false
        if (vocabularyFilterName != other.vocabularyFilterName) return false
        if (vocabularyName != other.vocabularyName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.chimesdkmediapipelines.model.AmazonTranscribeCallAnalyticsProcessorConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * By default, all `CategoryEvents` are sent to the insights target. If this parameter is specified, only included categories are sent to the insights target.
         */
        public var callAnalyticsStreamCategories: List<String>? = null
        /**
         * Labels all personally identifiable information (PII) identified in your transcript.
         *
         * Content identification is performed at the segment level; PII specified in `PiiEntityTypes` is flagged upon complete transcription of an audio segment.
         *
         * You can’t set `ContentIdentificationType` and `ContentRedactionType` in the same request. If you do, your request returns a `BadRequestException`.
         *
         * For more information, see [Redacting or identifying personally identifiable information](https://docs.aws.amazon.com/transcribe/latest/dg/pii-redaction.html) in the *Amazon Transcribe Developer Guide*.
         */
        public var contentIdentificationType: aws.sdk.kotlin.services.chimesdkmediapipelines.model.ContentType? = null
        /**
         * Redacts all personally identifiable information (PII) identified in your transcript.
         *
         * Content redaction is performed at the segment level; PII specified in `PiiEntityTypes` is redacted upon complete transcription of an audio segment.
         *
         * You can’t set `ContentRedactionType` and `ContentIdentificationType` in the same request. If you do, your request returns a `BadRequestException`.
         *
         * For more information, see [Redacting or identifying personally identifiable information](https://docs.aws.amazon.com/transcribe/latest/dg/pii-redaction.html) in the *Amazon Transcribe Developer Guide*.
         */
        public var contentRedactionType: aws.sdk.kotlin.services.chimesdkmediapipelines.model.ContentType? = null
        /**
         * Enables partial result stabilization for your transcription. Partial result stabilization can reduce latency in your output, but may impact accuracy. For more information, see [Partial-result stabilization](https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html#streaming-partial-result-stabilization) in the *Amazon Transcribe Developer Guide*.
         */
        public var enablePartialResultsStabilization: kotlin.Boolean = false
        /**
         * If true, `UtteranceEvents` with `IsPartial: true` are filtered out of the insights target.
         */
        public var filterPartialResults: kotlin.Boolean = false
        /**
         * The language code in the configuration.
         */
        public var languageCode: aws.sdk.kotlin.services.chimesdkmediapipelines.model.CallAnalyticsLanguageCode? = null
        /**
         * Specifies the name of the custom language model to use when processing a transcription. Note that language model names are case sensitive.
         *
         * The language of the specified language model must match the language code specified in the transcription request. If the languages don't match, the custom language model isn't applied. Language mismatches don't generate errors or warnings.
         *
         * For more information, see [Custom language models](https://docs.aws.amazon.com/transcribe/latest/dg/custom-language-models.html) in the *Amazon Transcribe Developer Guide*.
         */
        public var languageModelName: kotlin.String? = null
        /**
         * Specifies the level of stability to use when you enable partial results stabilization (`EnablePartialResultsStabilization`).
         *
         * Low stability provides the highest accuracy. High stability transcribes faster, but with slightly lower accuracy.
         *
         * For more information, see [Partial-result stabilization](https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html#streaming-partial-result-stabilization) in the *Amazon Transcribe Developer Guide*.
         */
        public var partialResultsStability: aws.sdk.kotlin.services.chimesdkmediapipelines.model.PartialResultsStability? = null
        /**
         * Specifies the types of personally identifiable information (PII) to redact from a transcript. You can include as many types as you'd like, or you can select `ALL`.
         *
         * To include `PiiEntityTypes` in your Call Analytics request, you must also include `ContentIdentificationType` or `ContentRedactionType`, but you can't include both.
         *
         * Values must be comma-separated and can include: `ADDRESS`, `BANK_ACCOUNT_NUMBER`, `BANK_ROUTING`, `CREDIT_DEBIT_CVV`, `CREDIT_DEBIT_EXPIRY`, `CREDIT_DEBIT_NUMBER`, `EMAIL`, `NAME`, `PHONE`, `PIN`, `SSN`, or `ALL`.
         *
         * Length Constraints: Minimum length of 1. Maximum length of 300.
         */
        public var piiEntityTypes: kotlin.String? = null
        /**
         * The settings for a post-call analysis task in an analytics configuration.
         */
        public var postCallAnalyticsSettings: aws.sdk.kotlin.services.chimesdkmediapipelines.model.PostCallAnalyticsSettings? = null
        /**
         * Specifies how to apply a vocabulary filter to a transcript.
         *
         * To replace words with *******, choose `mask`.
         *
         * To delete words, choose `remove`.
         *
         * To flag words without changing them, choose `tag`.
         */
        public var vocabularyFilterMethod: aws.sdk.kotlin.services.chimesdkmediapipelines.model.VocabularyFilterMethod? = null
        /**
         * Specifies the name of the custom vocabulary filter to use when processing a transcription. Note that vocabulary filter names are case sensitive.
         *
         * If the language of the specified custom vocabulary filter doesn't match the language identified in your media, the vocabulary filter is not applied to your transcription.
         *
         * For more information, see [Using vocabulary filtering with unwanted words](https://docs.aws.amazon.com/transcribe/latest/dg/vocabulary-filtering.html) in the *Amazon Transcribe Developer Guide*.
         *
         * Length Constraints: Minimum length of 1. Maximum length of 200.
         */
        public var vocabularyFilterName: kotlin.String? = null
        /**
         * Specifies the name of the custom vocabulary to use when processing a transcription. Note that vocabulary names are case sensitive.
         *
         * If the language of the specified custom vocabulary doesn't match the language identified in your media, the custom vocabulary is not applied to your transcription.
         *
         * For more information, see [Custom vocabularies](https://docs.aws.amazon.com/transcribe/latest/dg/custom-vocabulary.html) in the *Amazon Transcribe Developer Guide*.
         *
         * Length Constraints: Minimum length of 1. Maximum length of 200.
         */
        public var vocabularyName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.chimesdkmediapipelines.model.AmazonTranscribeCallAnalyticsProcessorConfiguration) : this() {
            this.callAnalyticsStreamCategories = x.callAnalyticsStreamCategories
            this.contentIdentificationType = x.contentIdentificationType
            this.contentRedactionType = x.contentRedactionType
            this.enablePartialResultsStabilization = x.enablePartialResultsStabilization
            this.filterPartialResults = x.filterPartialResults
            this.languageCode = x.languageCode
            this.languageModelName = x.languageModelName
            this.partialResultsStability = x.partialResultsStability
            this.piiEntityTypes = x.piiEntityTypes
            this.postCallAnalyticsSettings = x.postCallAnalyticsSettings
            this.vocabularyFilterMethod = x.vocabularyFilterMethod
            this.vocabularyFilterName = x.vocabularyFilterName
            this.vocabularyName = x.vocabularyName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.chimesdkmediapipelines.model.AmazonTranscribeCallAnalyticsProcessorConfiguration = AmazonTranscribeCallAnalyticsProcessorConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.chimesdkmediapipelines.model.PostCallAnalyticsSettings] inside the given [block]
         */
        public fun postCallAnalyticsSettings(block: aws.sdk.kotlin.services.chimesdkmediapipelines.model.PostCallAnalyticsSettings.Builder.() -> kotlin.Unit) {
            this.postCallAnalyticsSettings = aws.sdk.kotlin.services.chimesdkmediapipelines.model.PostCallAnalyticsSettings.invoke(block)
        }
    }
}
