// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chimesdkmediapipelines.paginators

import aws.sdk.kotlin.services.chimesdkmediapipelines.ChimeSdkMediaPipelinesClient
import aws.sdk.kotlin.services.chimesdkmediapipelines.model.ListMediaCapturePipelinesRequest
import aws.sdk.kotlin.services.chimesdkmediapipelines.model.ListMediaCapturePipelinesResponse
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow


/**
 * Paginate over [ListMediaCapturePipelinesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListMediaCapturePipelinesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMediaCapturePipelinesResponse]
 */
fun ChimeSdkMediaPipelinesClient.listMediaCapturePipelinesPaginated(initialRequest: ListMediaCapturePipelinesRequest): Flow<ListMediaCapturePipelinesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listMediaCapturePipelinesPaginated.listMediaCapturePipelines(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListMediaCapturePipelinesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMediaCapturePipelinesResponse]
 */
fun ChimeSdkMediaPipelinesClient.listMediaCapturePipelinesPaginated(block: ListMediaCapturePipelinesRequest.Builder.() -> Unit): Flow<ListMediaCapturePipelinesResponse> =
    listMediaCapturePipelinesPaginated(ListMediaCapturePipelinesRequest.Builder().apply(block).build())
