// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chimesdkmediapipelines

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.chimesdkmediapipelines.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.chimesdkmediapipelines.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.config.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * The Amazon Chime SDK media pipeline APIs in this section allow software developers to create Amazon Chime SDK media pipelines and capture audio, video, events, and data messages from Amazon Chime SDK meetings. For more information about media pipleines, see [Amzon Chime SDK media pipelines](https://docs.aws.amazon.com/chime/latest/APIReference/API_Operations_Amazon_Chime_SDK_Media_Pipelines.html).
 */
interface ChimeSdkMediaPipelinesClient : SdkClient {

    override val serviceName: String
        get() = "Chime SDK Media Pipelines"
    /**
     * ChimeSdkMediaPipelinesClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): ChimeSdkMediaPipelinesClient {
            val config = Config.Builder().apply(block).build()
            return DefaultChimeSdkMediaPipelinesClient(config)
        }

        operator fun invoke(config: Config): ChimeSdkMediaPipelinesClient = DefaultChimeSdkMediaPipelinesClient(config)

        /**
         * Construct a [ChimeSdkMediaPipelinesClient] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): ChimeSdkMediaPipelinesClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultChimeSdkMediaPipelinesClient(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, IdempotencyTokenConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val idempotencyTokenProvider: IdempotencyTokenProvider? = builder.idempotencyTokenProvider
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            var idempotencyTokenProvider: IdempotencyTokenProvider? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Creates a media capture pipeline.
     */
    suspend fun createMediaCapturePipeline(input: CreateMediaCapturePipelineRequest): CreateMediaCapturePipelineResponse

    /**
     * Deletes the media capture pipeline.
     */
    suspend fun deleteMediaCapturePipeline(input: DeleteMediaCapturePipelineRequest): DeleteMediaCapturePipelineResponse

    /**
     * Gets an existing media capture pipeline.
     */
    suspend fun getMediaCapturePipeline(input: GetMediaCapturePipelineRequest): GetMediaCapturePipelineResponse

    /**
     * Returns a list of media capture pipelines.
     */
    suspend fun listMediaCapturePipelines(input: ListMediaCapturePipelinesRequest = ListMediaCapturePipelinesRequest {}): ListMediaCapturePipelinesResponse

    /**
     * Lists the tags applied to an Amazon Chime SDK media capture pipeline.
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Applies the specified tags to the specified Amazon Chime SDK media capture pipeline.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes the specified tags from the specified Amazon Chime SDK media capture pipeline.
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse
}

/**
 * Creates a media capture pipeline.
 */
suspend inline fun ChimeSdkMediaPipelinesClient.createMediaCapturePipeline(crossinline block: CreateMediaCapturePipelineRequest.Builder.() -> Unit) = createMediaCapturePipeline(CreateMediaCapturePipelineRequest.Builder().apply(block).build())

/**
 * Deletes the media capture pipeline.
 */
suspend inline fun ChimeSdkMediaPipelinesClient.deleteMediaCapturePipeline(crossinline block: DeleteMediaCapturePipelineRequest.Builder.() -> Unit) = deleteMediaCapturePipeline(DeleteMediaCapturePipelineRequest.Builder().apply(block).build())

/**
 * Gets an existing media capture pipeline.
 */
suspend inline fun ChimeSdkMediaPipelinesClient.getMediaCapturePipeline(crossinline block: GetMediaCapturePipelineRequest.Builder.() -> Unit) = getMediaCapturePipeline(GetMediaCapturePipelineRequest.Builder().apply(block).build())

/**
 * Returns a list of media capture pipelines.
 */
suspend inline fun ChimeSdkMediaPipelinesClient.listMediaCapturePipelines(crossinline block: ListMediaCapturePipelinesRequest.Builder.() -> Unit) = listMediaCapturePipelines(ListMediaCapturePipelinesRequest.Builder().apply(block).build())

/**
 * Lists the tags applied to an Amazon Chime SDK media capture pipeline.
 */
suspend inline fun ChimeSdkMediaPipelinesClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Applies the specified tags to the specified Amazon Chime SDK media capture pipeline.
 */
suspend inline fun ChimeSdkMediaPipelinesClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit) = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes the specified tags from the specified Amazon Chime SDK media capture pipeline.
 */
suspend inline fun ChimeSdkMediaPipelinesClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit) = untagResource(UntagResourceRequest.Builder().apply(block).build())
