// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chimesdkmediapipelines.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Structure that contains the settings for a media stream sink.
 */
public class MediaStreamSink private constructor(builder: Builder) {
    /**
     * The media stream sink's media stream type.
     */
    public val mediaStreamType: aws.sdk.kotlin.services.chimesdkmediapipelines.model.MediaStreamType = requireNotNull(builder.mediaStreamType) { "A non-null value must be provided for mediaStreamType" }
    /**
     * Specifies the number of streams that the sink can accept.
     */
    public val reservedStreamCapacity: kotlin.Int = requireNotNull(builder.reservedStreamCapacity) { "A non-null value must be provided for reservedStreamCapacity" }
    /**
     * The ARN of the Kinesis Video Stream pool returned by the CreateMediaPipelineKinesisVideoStreamPool API.
     */
    public val sinkArn: kotlin.String = requireNotNull(builder.sinkArn) { "A non-null value must be provided for sinkArn" }
    /**
     * The media stream sink's type.
     */
    public val sinkType: aws.sdk.kotlin.services.chimesdkmediapipelines.model.MediaStreamPipelineSinkType = requireNotNull(builder.sinkType) { "A non-null value must be provided for sinkType" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.chimesdkmediapipelines.model.MediaStreamSink = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MediaStreamSink(")
        append("mediaStreamType=$mediaStreamType,")
        append("reservedStreamCapacity=$reservedStreamCapacity,")
        append("sinkArn=*** Sensitive Data Redacted ***,")
        append("sinkType=$sinkType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = mediaStreamType.hashCode()
        result = 31 * result + (reservedStreamCapacity)
        result = 31 * result + (sinkArn.hashCode())
        result = 31 * result + (sinkType.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MediaStreamSink

        if (mediaStreamType != other.mediaStreamType) return false
        if (reservedStreamCapacity != other.reservedStreamCapacity) return false
        if (sinkArn != other.sinkArn) return false
        if (sinkType != other.sinkType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.chimesdkmediapipelines.model.MediaStreamSink = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The media stream sink's media stream type.
         */
        public var mediaStreamType: aws.sdk.kotlin.services.chimesdkmediapipelines.model.MediaStreamType? = null
        /**
         * Specifies the number of streams that the sink can accept.
         */
        public var reservedStreamCapacity: kotlin.Int? = null
        /**
         * The ARN of the Kinesis Video Stream pool returned by the CreateMediaPipelineKinesisVideoStreamPool API.
         */
        public var sinkArn: kotlin.String? = null
        /**
         * The media stream sink's type.
         */
        public var sinkType: aws.sdk.kotlin.services.chimesdkmediapipelines.model.MediaStreamPipelineSinkType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.chimesdkmediapipelines.model.MediaStreamSink) : this() {
            this.mediaStreamType = x.mediaStreamType
            this.reservedStreamCapacity = x.reservedStreamCapacity
            this.sinkArn = x.sinkArn
            this.sinkType = x.sinkType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.chimesdkmediapipelines.model.MediaStreamSink = MediaStreamSink(this)

        internal fun correctErrors(): Builder {
            if (mediaStreamType == null) mediaStreamType = MediaStreamType.SdkUnknown("no value provided")
            if (reservedStreamCapacity == null) reservedStreamCapacity = 0
            if (sinkArn == null) sinkArn = ""
            if (sinkType == null) sinkType = MediaStreamPipelineSinkType.SdkUnknown("no value provided")
            return this
        }
    }
}
