// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chimesdkmediapipelines.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * A media pipeline object consisting of an ID, source type, source ARN, a sink type, a sink ARN, and a configuration object.
 */
public class MediaCapturePipeline private constructor(builder: Builder) {
    /**
     * The configuration for a specified media pipeline. `SourceType` must be `ChimeSdkMeeting`.
     */
    public val chimeSdkMeetingConfiguration: aws.sdk.kotlin.services.chimesdkmediapipelines.model.ChimeSdkMeetingConfiguration? = builder.chimeSdkMeetingConfiguration
    /**
     * The time at which the pipeline was created, in ISO 8601 format.
     */
    public val createdTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.createdTimestamp
    /**
     * The ARN of the media capture pipeline
     */
    public val mediaPipelineArn: kotlin.String? = builder.mediaPipelineArn
    /**
     * The ID of a media pipeline.
     */
    public val mediaPipelineId: kotlin.String? = builder.mediaPipelineId
    /**
     * ARN of the destination to which the media artifacts are saved.
     */
    public val sinkArn: kotlin.String? = builder.sinkArn
    /**
     * Destination type to which the media artifacts are saved. You must use an S3 Bucket.
     */
    public val sinkType: aws.sdk.kotlin.services.chimesdkmediapipelines.model.MediaPipelineSinkType? = builder.sinkType
    /**
     * ARN of the source from which the media artifacts are saved.
     */
    public val sourceArn: kotlin.String? = builder.sourceArn
    /**
     * Source type from which media artifacts are saved. You must use `ChimeMeeting`.
     */
    public val sourceType: aws.sdk.kotlin.services.chimesdkmediapipelines.model.MediaPipelineSourceType? = builder.sourceType
    /**
     * The status of the media pipeline.
     */
    public val status: aws.sdk.kotlin.services.chimesdkmediapipelines.model.MediaPipelineStatus? = builder.status
    /**
     * The time at which the pipeline was updated, in ISO 8601 format.
     */
    public val updatedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.updatedTimestamp

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.chimesdkmediapipelines.model.MediaCapturePipeline = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MediaCapturePipeline(")
        append("chimeSdkMeetingConfiguration=$chimeSdkMeetingConfiguration,")
        append("createdTimestamp=$createdTimestamp,")
        append("mediaPipelineArn=$mediaPipelineArn,")
        append("mediaPipelineId=$mediaPipelineId,")
        append("sinkArn=*** Sensitive Data Redacted ***,")
        append("sinkType=$sinkType,")
        append("sourceArn=*** Sensitive Data Redacted ***,")
        append("sourceType=$sourceType,")
        append("status=$status,")
        append("updatedTimestamp=$updatedTimestamp")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = chimeSdkMeetingConfiguration?.hashCode() ?: 0
        result = 31 * result + (createdTimestamp?.hashCode() ?: 0)
        result = 31 * result + (mediaPipelineArn?.hashCode() ?: 0)
        result = 31 * result + (mediaPipelineId?.hashCode() ?: 0)
        result = 31 * result + (sinkArn?.hashCode() ?: 0)
        result = 31 * result + (sinkType?.hashCode() ?: 0)
        result = 31 * result + (sourceArn?.hashCode() ?: 0)
        result = 31 * result + (sourceType?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (updatedTimestamp?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MediaCapturePipeline

        if (chimeSdkMeetingConfiguration != other.chimeSdkMeetingConfiguration) return false
        if (createdTimestamp != other.createdTimestamp) return false
        if (mediaPipelineArn != other.mediaPipelineArn) return false
        if (mediaPipelineId != other.mediaPipelineId) return false
        if (sinkArn != other.sinkArn) return false
        if (sinkType != other.sinkType) return false
        if (sourceArn != other.sourceArn) return false
        if (sourceType != other.sourceType) return false
        if (status != other.status) return false
        if (updatedTimestamp != other.updatedTimestamp) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.chimesdkmediapipelines.model.MediaCapturePipeline = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The configuration for a specified media pipeline. `SourceType` must be `ChimeSdkMeeting`.
         */
        public var chimeSdkMeetingConfiguration: aws.sdk.kotlin.services.chimesdkmediapipelines.model.ChimeSdkMeetingConfiguration? = null
        /**
         * The time at which the pipeline was created, in ISO 8601 format.
         */
        public var createdTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ARN of the media capture pipeline
         */
        public var mediaPipelineArn: kotlin.String? = null
        /**
         * The ID of a media pipeline.
         */
        public var mediaPipelineId: kotlin.String? = null
        /**
         * ARN of the destination to which the media artifacts are saved.
         */
        public var sinkArn: kotlin.String? = null
        /**
         * Destination type to which the media artifacts are saved. You must use an S3 Bucket.
         */
        public var sinkType: aws.sdk.kotlin.services.chimesdkmediapipelines.model.MediaPipelineSinkType? = null
        /**
         * ARN of the source from which the media artifacts are saved.
         */
        public var sourceArn: kotlin.String? = null
        /**
         * Source type from which media artifacts are saved. You must use `ChimeMeeting`.
         */
        public var sourceType: aws.sdk.kotlin.services.chimesdkmediapipelines.model.MediaPipelineSourceType? = null
        /**
         * The status of the media pipeline.
         */
        public var status: aws.sdk.kotlin.services.chimesdkmediapipelines.model.MediaPipelineStatus? = null
        /**
         * The time at which the pipeline was updated, in ISO 8601 format.
         */
        public var updatedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.chimesdkmediapipelines.model.MediaCapturePipeline) : this() {
            this.chimeSdkMeetingConfiguration = x.chimeSdkMeetingConfiguration
            this.createdTimestamp = x.createdTimestamp
            this.mediaPipelineArn = x.mediaPipelineArn
            this.mediaPipelineId = x.mediaPipelineId
            this.sinkArn = x.sinkArn
            this.sinkType = x.sinkType
            this.sourceArn = x.sourceArn
            this.sourceType = x.sourceType
            this.status = x.status
            this.updatedTimestamp = x.updatedTimestamp
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.chimesdkmediapipelines.model.MediaCapturePipeline = MediaCapturePipeline(this)

        /**
         * construct an [aws.sdk.kotlin.services.chimesdkmediapipelines.model.ChimeSdkMeetingConfiguration] inside the given [block]
         */
        public fun chimeSdkMeetingConfiguration(block: aws.sdk.kotlin.services.chimesdkmediapipelines.model.ChimeSdkMeetingConfiguration.Builder.() -> kotlin.Unit) {
            this.chimeSdkMeetingConfiguration = aws.sdk.kotlin.services.chimesdkmediapipelines.model.ChimeSdkMeetingConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
