// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chimesdkmediapipelines.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes the timestamp range and timestamp origin of a range of fragments.
 *
 * Only fragments with a start timestamp greater than or equal to the given start time and less than or equal to the end time are returned. For example, say a stream contains fragments with the following start timestamps:
 * + 00:00:00
 * + 00:00:02
 * + 00:00:04
 * + 00:00:06
 *
 * A fragment selector range with a start time of 00:00:01 and end time of 00:00:04 would return the fragments with start times of 00:00:02 and 00:00:04.
 */
public class FragmentSelector private constructor(builder: Builder) {
    /**
     * The origin of the timestamps to use, `Server` or `Producer`. For more information, see [StartSelectorType](https://docs.aws.amazon.com/kinesisvideostreams/latest/dg/API_dataplane_StartSelector.html) in the *Amazon Kinesis Video Streams Developer Guide*.
     */
    public val fragmentSelectorType: aws.sdk.kotlin.services.chimesdkmediapipelines.model.FragmentSelectorType = requireNotNull(builder.fragmentSelectorType) { "A non-null value must be provided for fragmentSelectorType" }
    /**
     * The range of timestamps to return.
     */
    public val timestampRange: aws.sdk.kotlin.services.chimesdkmediapipelines.model.TimestampRange? = builder.timestampRange

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.chimesdkmediapipelines.model.FragmentSelector = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FragmentSelector(")
        append("fragmentSelectorType=$fragmentSelectorType,")
        append("timestampRange=$timestampRange")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = fragmentSelectorType.hashCode()
        result = 31 * result + (timestampRange?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FragmentSelector

        if (fragmentSelectorType != other.fragmentSelectorType) return false
        if (timestampRange != other.timestampRange) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.chimesdkmediapipelines.model.FragmentSelector = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The origin of the timestamps to use, `Server` or `Producer`. For more information, see [StartSelectorType](https://docs.aws.amazon.com/kinesisvideostreams/latest/dg/API_dataplane_StartSelector.html) in the *Amazon Kinesis Video Streams Developer Guide*.
         */
        public var fragmentSelectorType: aws.sdk.kotlin.services.chimesdkmediapipelines.model.FragmentSelectorType? = null
        /**
         * The range of timestamps to return.
         */
        public var timestampRange: aws.sdk.kotlin.services.chimesdkmediapipelines.model.TimestampRange? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.chimesdkmediapipelines.model.FragmentSelector) : this() {
            this.fragmentSelectorType = x.fragmentSelectorType
            this.timestampRange = x.timestampRange
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.chimesdkmediapipelines.model.FragmentSelector = FragmentSelector(this)

        /**
         * construct an [aws.sdk.kotlin.services.chimesdkmediapipelines.model.TimestampRange] inside the given [block]
         */
        public fun timestampRange(block: aws.sdk.kotlin.services.chimesdkmediapipelines.model.TimestampRange.Builder.() -> kotlin.Unit) {
            this.timestampRange = aws.sdk.kotlin.services.chimesdkmediapipelines.model.TimestampRange.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (fragmentSelectorType == null) fragmentSelectorType = FragmentSelectorType.SdkUnknown("no value provided")
            return this
        }
    }
}
