// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chimesdkmediapipelines

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.chimesdkmediapipelines.auth.ChimeSdkMediaPipelinesAuthSchemeProvider
import aws.sdk.kotlin.services.chimesdkmediapipelines.auth.DefaultChimeSdkMediaPipelinesAuthSchemeProvider
import aws.sdk.kotlin.services.chimesdkmediapipelines.endpoints.ChimeSdkMediaPipelinesEndpointParameters
import aws.sdk.kotlin.services.chimesdkmediapipelines.endpoints.ChimeSdkMediaPipelinesEndpointProvider
import aws.sdk.kotlin.services.chimesdkmediapipelines.endpoints.DefaultChimeSdkMediaPipelinesEndpointProvider
import aws.sdk.kotlin.services.chimesdkmediapipelines.model.CreateMediaCapturePipelineRequest
import aws.sdk.kotlin.services.chimesdkmediapipelines.model.CreateMediaCapturePipelineResponse
import aws.sdk.kotlin.services.chimesdkmediapipelines.model.CreateMediaConcatenationPipelineRequest
import aws.sdk.kotlin.services.chimesdkmediapipelines.model.CreateMediaConcatenationPipelineResponse
import aws.sdk.kotlin.services.chimesdkmediapipelines.model.CreateMediaInsightsPipelineConfigurationRequest
import aws.sdk.kotlin.services.chimesdkmediapipelines.model.CreateMediaInsightsPipelineConfigurationResponse
import aws.sdk.kotlin.services.chimesdkmediapipelines.model.CreateMediaInsightsPipelineRequest
import aws.sdk.kotlin.services.chimesdkmediapipelines.model.CreateMediaInsightsPipelineResponse
import aws.sdk.kotlin.services.chimesdkmediapipelines.model.CreateMediaLiveConnectorPipelineRequest
import aws.sdk.kotlin.services.chimesdkmediapipelines.model.CreateMediaLiveConnectorPipelineResponse
import aws.sdk.kotlin.services.chimesdkmediapipelines.model.CreateMediaPipelineKinesisVideoStreamPoolRequest
import aws.sdk.kotlin.services.chimesdkmediapipelines.model.CreateMediaPipelineKinesisVideoStreamPoolResponse
import aws.sdk.kotlin.services.chimesdkmediapipelines.model.CreateMediaStreamPipelineRequest
import aws.sdk.kotlin.services.chimesdkmediapipelines.model.CreateMediaStreamPipelineResponse
import aws.sdk.kotlin.services.chimesdkmediapipelines.model.DeleteMediaCapturePipelineRequest
import aws.sdk.kotlin.services.chimesdkmediapipelines.model.DeleteMediaCapturePipelineResponse
import aws.sdk.kotlin.services.chimesdkmediapipelines.model.DeleteMediaInsightsPipelineConfigurationRequest
import aws.sdk.kotlin.services.chimesdkmediapipelines.model.DeleteMediaInsightsPipelineConfigurationResponse
import aws.sdk.kotlin.services.chimesdkmediapipelines.model.DeleteMediaPipelineKinesisVideoStreamPoolRequest
import aws.sdk.kotlin.services.chimesdkmediapipelines.model.DeleteMediaPipelineKinesisVideoStreamPoolResponse
import aws.sdk.kotlin.services.chimesdkmediapipelines.model.DeleteMediaPipelineRequest
import aws.sdk.kotlin.services.chimesdkmediapipelines.model.DeleteMediaPipelineResponse
import aws.sdk.kotlin.services.chimesdkmediapipelines.model.GetMediaCapturePipelineRequest
import aws.sdk.kotlin.services.chimesdkmediapipelines.model.GetMediaCapturePipelineResponse
import aws.sdk.kotlin.services.chimesdkmediapipelines.model.GetMediaInsightsPipelineConfigurationRequest
import aws.sdk.kotlin.services.chimesdkmediapipelines.model.GetMediaInsightsPipelineConfigurationResponse
import aws.sdk.kotlin.services.chimesdkmediapipelines.model.GetMediaPipelineKinesisVideoStreamPoolRequest
import aws.sdk.kotlin.services.chimesdkmediapipelines.model.GetMediaPipelineKinesisVideoStreamPoolResponse
import aws.sdk.kotlin.services.chimesdkmediapipelines.model.GetMediaPipelineRequest
import aws.sdk.kotlin.services.chimesdkmediapipelines.model.GetMediaPipelineResponse
import aws.sdk.kotlin.services.chimesdkmediapipelines.model.GetSpeakerSearchTaskRequest
import aws.sdk.kotlin.services.chimesdkmediapipelines.model.GetSpeakerSearchTaskResponse
import aws.sdk.kotlin.services.chimesdkmediapipelines.model.GetVoiceToneAnalysisTaskRequest
import aws.sdk.kotlin.services.chimesdkmediapipelines.model.GetVoiceToneAnalysisTaskResponse
import aws.sdk.kotlin.services.chimesdkmediapipelines.model.ListMediaCapturePipelinesRequest
import aws.sdk.kotlin.services.chimesdkmediapipelines.model.ListMediaCapturePipelinesResponse
import aws.sdk.kotlin.services.chimesdkmediapipelines.model.ListMediaInsightsPipelineConfigurationsRequest
import aws.sdk.kotlin.services.chimesdkmediapipelines.model.ListMediaInsightsPipelineConfigurationsResponse
import aws.sdk.kotlin.services.chimesdkmediapipelines.model.ListMediaPipelineKinesisVideoStreamPoolsRequest
import aws.sdk.kotlin.services.chimesdkmediapipelines.model.ListMediaPipelineKinesisVideoStreamPoolsResponse
import aws.sdk.kotlin.services.chimesdkmediapipelines.model.ListMediaPipelinesRequest
import aws.sdk.kotlin.services.chimesdkmediapipelines.model.ListMediaPipelinesResponse
import aws.sdk.kotlin.services.chimesdkmediapipelines.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.chimesdkmediapipelines.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.chimesdkmediapipelines.model.StartSpeakerSearchTaskRequest
import aws.sdk.kotlin.services.chimesdkmediapipelines.model.StartSpeakerSearchTaskResponse
import aws.sdk.kotlin.services.chimesdkmediapipelines.model.StartVoiceToneAnalysisTaskRequest
import aws.sdk.kotlin.services.chimesdkmediapipelines.model.StartVoiceToneAnalysisTaskResponse
import aws.sdk.kotlin.services.chimesdkmediapipelines.model.StopSpeakerSearchTaskRequest
import aws.sdk.kotlin.services.chimesdkmediapipelines.model.StopSpeakerSearchTaskResponse
import aws.sdk.kotlin.services.chimesdkmediapipelines.model.StopVoiceToneAnalysisTaskRequest
import aws.sdk.kotlin.services.chimesdkmediapipelines.model.StopVoiceToneAnalysisTaskResponse
import aws.sdk.kotlin.services.chimesdkmediapipelines.model.TagResourceRequest
import aws.sdk.kotlin.services.chimesdkmediapipelines.model.TagResourceResponse
import aws.sdk.kotlin.services.chimesdkmediapipelines.model.UntagResourceRequest
import aws.sdk.kotlin.services.chimesdkmediapipelines.model.UntagResourceResponse
import aws.sdk.kotlin.services.chimesdkmediapipelines.model.UpdateMediaInsightsPipelineConfigurationRequest
import aws.sdk.kotlin.services.chimesdkmediapipelines.model.UpdateMediaInsightsPipelineConfigurationResponse
import aws.sdk.kotlin.services.chimesdkmediapipelines.model.UpdateMediaInsightsPipelineStatusRequest
import aws.sdk.kotlin.services.chimesdkmediapipelines.model.UpdateMediaInsightsPipelineStatusResponse
import aws.sdk.kotlin.services.chimesdkmediapipelines.model.UpdateMediaPipelineKinesisVideoStreamPoolRequest
import aws.sdk.kotlin.services.chimesdkmediapipelines.model.UpdateMediaPipelineKinesisVideoStreamPoolResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "Chime SDK Media Pipelines"
public const val SdkVersion: String = "1.3.54"
public const val ServiceApiVersion: String = "2021-07-15"

/**
 * The Amazon Chime SDK media pipeline APIs in this section allow software developers to create Amazon Chime SDK media pipelines that capture, concatenate, or stream your Amazon Chime SDK meetings. For more information about media pipelines, see [Amazon Chime SDK media pipelines](https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_Operations_Amazon_Chime_SDK_Media_Pipelines.html).
 */
public interface ChimeSdkMediaPipelinesClient : SdkClient {
    /**
     * ChimeSdkMediaPipelinesClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, ChimeSdkMediaPipelinesClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "ChimeSdkMediaPipelines",
                "CHIME_SDK_MEDIA_PIPELINES",
                "chime_sdk_media_pipelines",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, ChimeSdkMediaPipelinesClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): ChimeSdkMediaPipelinesClient = DefaultChimeSdkMediaPipelinesClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: ChimeSdkMediaPipelinesEndpointProvider = builder.endpointProvider ?: DefaultChimeSdkMediaPipelinesEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: ChimeSdkMediaPipelinesAuthSchemeProvider = builder.authSchemeProvider ?: DefaultChimeSdkMediaPipelinesAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "Chime SDK Media Pipelines"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: ChimeSdkMediaPipelinesEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: ChimeSdkMediaPipelinesAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Creates a media pipeline.
     */
    public suspend fun createMediaCapturePipeline(input: CreateMediaCapturePipelineRequest): CreateMediaCapturePipelineResponse

    /**
     * Creates a media concatenation pipeline.
     */
    public suspend fun createMediaConcatenationPipeline(input: CreateMediaConcatenationPipelineRequest): CreateMediaConcatenationPipelineResponse

    /**
     * Creates a media insights pipeline.
     */
    public suspend fun createMediaInsightsPipeline(input: CreateMediaInsightsPipelineRequest): CreateMediaInsightsPipelineResponse

    /**
     * A structure that contains the static configurations for a media insights pipeline.
     */
    public suspend fun createMediaInsightsPipelineConfiguration(input: CreateMediaInsightsPipelineConfigurationRequest): CreateMediaInsightsPipelineConfigurationResponse

    /**
     * Creates a media live connector pipeline in an Amazon Chime SDK meeting.
     */
    public suspend fun createMediaLiveConnectorPipeline(input: CreateMediaLiveConnectorPipelineRequest): CreateMediaLiveConnectorPipelineResponse

    /**
     * Creates an Amazon Kinesis Video Stream pool for use with media stream pipelines.
     *
     * If a meeting uses an opt-in Region as its [MediaRegion](https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_meeting-chime_CreateMeeting.html#chimesdk-meeting-chime_CreateMeeting-request-MediaRegion), the KVS stream must be in that same Region. For example, if a meeting uses the `af-south-1` Region, the KVS stream must also be in `af-south-1`. However, if the meeting uses a Region that AWS turns on by default, the KVS stream can be in any available Region, including an opt-in Region. For example, if the meeting uses `ca-central-1`, the KVS stream can be in `eu-west-2`, `us-east-1`, `af-south-1`, or any other Region that the Amazon Chime SDK supports.
     *
     * To learn which AWS Region a meeting uses, call the [GetMeeting](https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_meeting-chime_GetMeeting.html) API and use the [MediaRegion](https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_meeting-chime_CreateMeeting.html#chimesdk-meeting-chime_CreateMeeting-request-MediaRegion) parameter from the response.
     *
     * For more information about opt-in Regions, refer to [Available Regions](https://docs.aws.amazon.com/chime-sdk/latest/dg/sdk-available-regions.html) in the *Amazon Chime SDK Developer Guide*, and [Specify which AWS Regions your account can use](https://docs.aws.amazon.com/accounts/latest/reference/manage-acct-regions.html#rande-manage-enable.html), in the *AWS Account Management Reference Guide*.
     */
    public suspend fun createMediaPipelineKinesisVideoStreamPool(input: CreateMediaPipelineKinesisVideoStreamPoolRequest): CreateMediaPipelineKinesisVideoStreamPoolResponse

    /**
     * Creates a streaming media pipeline.
     */
    public suspend fun createMediaStreamPipeline(input: CreateMediaStreamPipelineRequest): CreateMediaStreamPipelineResponse

    /**
     * Deletes the media pipeline.
     */
    public suspend fun deleteMediaCapturePipeline(input: DeleteMediaCapturePipelineRequest): DeleteMediaCapturePipelineResponse

    /**
     * Deletes the specified configuration settings.
     */
    public suspend fun deleteMediaInsightsPipelineConfiguration(input: DeleteMediaInsightsPipelineConfigurationRequest): DeleteMediaInsightsPipelineConfigurationResponse

    /**
     * Deletes the media pipeline.
     */
    public suspend fun deleteMediaPipeline(input: DeleteMediaPipelineRequest): DeleteMediaPipelineResponse

    /**
     * Deletes an Amazon Kinesis Video Stream pool.
     */
    public suspend fun deleteMediaPipelineKinesisVideoStreamPool(input: DeleteMediaPipelineKinesisVideoStreamPoolRequest): DeleteMediaPipelineKinesisVideoStreamPoolResponse

    /**
     * Gets an existing media pipeline.
     */
    public suspend fun getMediaCapturePipeline(input: GetMediaCapturePipelineRequest): GetMediaCapturePipelineResponse

    /**
     * Gets the configuration settings for a media insights pipeline.
     */
    public suspend fun getMediaInsightsPipelineConfiguration(input: GetMediaInsightsPipelineConfigurationRequest): GetMediaInsightsPipelineConfigurationResponse

    /**
     * Gets an existing media pipeline.
     */
    public suspend fun getMediaPipeline(input: GetMediaPipelineRequest): GetMediaPipelineResponse

    /**
     * Gets an Kinesis video stream pool.
     */
    public suspend fun getMediaPipelineKinesisVideoStreamPool(input: GetMediaPipelineKinesisVideoStreamPoolRequest): GetMediaPipelineKinesisVideoStreamPoolResponse

    /**
     * Retrieves the details of the specified speaker search task.
     */
    public suspend fun getSpeakerSearchTask(input: GetSpeakerSearchTaskRequest): GetSpeakerSearchTaskResponse

    /**
     * Retrieves the details of a voice tone analysis task.
     */
    public suspend fun getVoiceToneAnalysisTask(input: GetVoiceToneAnalysisTaskRequest): GetVoiceToneAnalysisTaskResponse

    /**
     * Returns a list of media pipelines.
     */
    public suspend fun listMediaCapturePipelines(input: ListMediaCapturePipelinesRequest = ListMediaCapturePipelinesRequest { }): ListMediaCapturePipelinesResponse

    /**
     * Lists the available media insights pipeline configurations.
     */
    public suspend fun listMediaInsightsPipelineConfigurations(input: ListMediaInsightsPipelineConfigurationsRequest = ListMediaInsightsPipelineConfigurationsRequest { }): ListMediaInsightsPipelineConfigurationsResponse

    /**
     * Lists the video stream pools in the media pipeline.
     */
    public suspend fun listMediaPipelineKinesisVideoStreamPools(input: ListMediaPipelineKinesisVideoStreamPoolsRequest = ListMediaPipelineKinesisVideoStreamPoolsRequest { }): ListMediaPipelineKinesisVideoStreamPoolsResponse

    /**
     * Returns a list of media pipelines.
     */
    public suspend fun listMediaPipelines(input: ListMediaPipelinesRequest = ListMediaPipelinesRequest { }): ListMediaPipelinesResponse

    /**
     * Lists the tags available for a media pipeline.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Starts a speaker search task.
     *
     * Before starting any speaker search tasks, you must provide all notices and obtain all consents from the speaker as required under applicable privacy and biometrics laws, and as required under the [AWS service terms](https://aws.amazon.com/service-terms/) for the Amazon Chime SDK.
     */
    public suspend fun startSpeakerSearchTask(input: StartSpeakerSearchTaskRequest): StartSpeakerSearchTaskResponse

    /**
     * Starts a voice tone analysis task. For more information about voice tone analysis, see [Using Amazon Chime SDK voice analytics](https://docs.aws.amazon.com/chime-sdk/latest/dg/voice-analytics.html) in the *Amazon Chime SDK Developer Guide*.
     *
     * Before starting any voice tone analysis tasks, you must provide all notices and obtain all consents from the speaker as required under applicable privacy and biometrics laws, and as required under the [AWS service terms](https://aws.amazon.com/service-terms/) for the Amazon Chime SDK.
     */
    public suspend fun startVoiceToneAnalysisTask(input: StartVoiceToneAnalysisTaskRequest): StartVoiceToneAnalysisTaskResponse

    /**
     * Stops a speaker search task.
     */
    public suspend fun stopSpeakerSearchTask(input: StopSpeakerSearchTaskRequest): StopSpeakerSearchTaskResponse

    /**
     * Stops a voice tone analysis task.
     */
    public suspend fun stopVoiceToneAnalysisTask(input: StopVoiceToneAnalysisTaskRequest): StopVoiceToneAnalysisTaskResponse

    /**
     * The ARN of the media pipeline that you want to tag. Consists of the pipeline's endpoint region, resource ID, and pipeline ID.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes any tags from a media pipeline.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates the media insights pipeline's configuration settings.
     */
    public suspend fun updateMediaInsightsPipelineConfiguration(input: UpdateMediaInsightsPipelineConfigurationRequest): UpdateMediaInsightsPipelineConfigurationResponse

    /**
     * Updates the status of a media insights pipeline.
     */
    public suspend fun updateMediaInsightsPipelineStatus(input: UpdateMediaInsightsPipelineStatusRequest): UpdateMediaInsightsPipelineStatusResponse

    /**
     * Updates an Amazon Kinesis Video Stream pool in a media pipeline.
     */
    public suspend fun updateMediaPipelineKinesisVideoStreamPool(input: UpdateMediaPipelineKinesisVideoStreamPoolRequest): UpdateMediaPipelineKinesisVideoStreamPoolResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun ChimeSdkMediaPipelinesClient.withConfig(block: ChimeSdkMediaPipelinesClient.Config.Builder.() -> Unit): ChimeSdkMediaPipelinesClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultChimeSdkMediaPipelinesClient(newConfig)
}

/**
 * Creates a media pipeline.
 */
public suspend inline fun ChimeSdkMediaPipelinesClient.createMediaCapturePipeline(crossinline block: CreateMediaCapturePipelineRequest.Builder.() -> Unit): CreateMediaCapturePipelineResponse = createMediaCapturePipeline(CreateMediaCapturePipelineRequest.Builder().apply(block).build())

/**
 * Creates a media concatenation pipeline.
 */
public suspend inline fun ChimeSdkMediaPipelinesClient.createMediaConcatenationPipeline(crossinline block: CreateMediaConcatenationPipelineRequest.Builder.() -> Unit): CreateMediaConcatenationPipelineResponse = createMediaConcatenationPipeline(CreateMediaConcatenationPipelineRequest.Builder().apply(block).build())

/**
 * Creates a media insights pipeline.
 */
public suspend inline fun ChimeSdkMediaPipelinesClient.createMediaInsightsPipeline(crossinline block: CreateMediaInsightsPipelineRequest.Builder.() -> Unit): CreateMediaInsightsPipelineResponse = createMediaInsightsPipeline(CreateMediaInsightsPipelineRequest.Builder().apply(block).build())

/**
 * A structure that contains the static configurations for a media insights pipeline.
 */
public suspend inline fun ChimeSdkMediaPipelinesClient.createMediaInsightsPipelineConfiguration(crossinline block: CreateMediaInsightsPipelineConfigurationRequest.Builder.() -> Unit): CreateMediaInsightsPipelineConfigurationResponse = createMediaInsightsPipelineConfiguration(CreateMediaInsightsPipelineConfigurationRequest.Builder().apply(block).build())

/**
 * Creates a media live connector pipeline in an Amazon Chime SDK meeting.
 */
public suspend inline fun ChimeSdkMediaPipelinesClient.createMediaLiveConnectorPipeline(crossinline block: CreateMediaLiveConnectorPipelineRequest.Builder.() -> Unit): CreateMediaLiveConnectorPipelineResponse = createMediaLiveConnectorPipeline(CreateMediaLiveConnectorPipelineRequest.Builder().apply(block).build())

/**
 * Creates an Amazon Kinesis Video Stream pool for use with media stream pipelines.
 *
 * If a meeting uses an opt-in Region as its [MediaRegion](https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_meeting-chime_CreateMeeting.html#chimesdk-meeting-chime_CreateMeeting-request-MediaRegion), the KVS stream must be in that same Region. For example, if a meeting uses the `af-south-1` Region, the KVS stream must also be in `af-south-1`. However, if the meeting uses a Region that AWS turns on by default, the KVS stream can be in any available Region, including an opt-in Region. For example, if the meeting uses `ca-central-1`, the KVS stream can be in `eu-west-2`, `us-east-1`, `af-south-1`, or any other Region that the Amazon Chime SDK supports.
 *
 * To learn which AWS Region a meeting uses, call the [GetMeeting](https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_meeting-chime_GetMeeting.html) API and use the [MediaRegion](https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_meeting-chime_CreateMeeting.html#chimesdk-meeting-chime_CreateMeeting-request-MediaRegion) parameter from the response.
 *
 * For more information about opt-in Regions, refer to [Available Regions](https://docs.aws.amazon.com/chime-sdk/latest/dg/sdk-available-regions.html) in the *Amazon Chime SDK Developer Guide*, and [Specify which AWS Regions your account can use](https://docs.aws.amazon.com/accounts/latest/reference/manage-acct-regions.html#rande-manage-enable.html), in the *AWS Account Management Reference Guide*.
 */
public suspend inline fun ChimeSdkMediaPipelinesClient.createMediaPipelineKinesisVideoStreamPool(crossinline block: CreateMediaPipelineKinesisVideoStreamPoolRequest.Builder.() -> Unit): CreateMediaPipelineKinesisVideoStreamPoolResponse = createMediaPipelineKinesisVideoStreamPool(CreateMediaPipelineKinesisVideoStreamPoolRequest.Builder().apply(block).build())

/**
 * Creates a streaming media pipeline.
 */
public suspend inline fun ChimeSdkMediaPipelinesClient.createMediaStreamPipeline(crossinline block: CreateMediaStreamPipelineRequest.Builder.() -> Unit): CreateMediaStreamPipelineResponse = createMediaStreamPipeline(CreateMediaStreamPipelineRequest.Builder().apply(block).build())

/**
 * Deletes the media pipeline.
 */
public suspend inline fun ChimeSdkMediaPipelinesClient.deleteMediaCapturePipeline(crossinline block: DeleteMediaCapturePipelineRequest.Builder.() -> Unit): DeleteMediaCapturePipelineResponse = deleteMediaCapturePipeline(DeleteMediaCapturePipelineRequest.Builder().apply(block).build())

/**
 * Deletes the specified configuration settings.
 */
public suspend inline fun ChimeSdkMediaPipelinesClient.deleteMediaInsightsPipelineConfiguration(crossinline block: DeleteMediaInsightsPipelineConfigurationRequest.Builder.() -> Unit): DeleteMediaInsightsPipelineConfigurationResponse = deleteMediaInsightsPipelineConfiguration(DeleteMediaInsightsPipelineConfigurationRequest.Builder().apply(block).build())

/**
 * Deletes the media pipeline.
 */
public suspend inline fun ChimeSdkMediaPipelinesClient.deleteMediaPipeline(crossinline block: DeleteMediaPipelineRequest.Builder.() -> Unit): DeleteMediaPipelineResponse = deleteMediaPipeline(DeleteMediaPipelineRequest.Builder().apply(block).build())

/**
 * Deletes an Amazon Kinesis Video Stream pool.
 */
public suspend inline fun ChimeSdkMediaPipelinesClient.deleteMediaPipelineKinesisVideoStreamPool(crossinline block: DeleteMediaPipelineKinesisVideoStreamPoolRequest.Builder.() -> Unit): DeleteMediaPipelineKinesisVideoStreamPoolResponse = deleteMediaPipelineKinesisVideoStreamPool(DeleteMediaPipelineKinesisVideoStreamPoolRequest.Builder().apply(block).build())

/**
 * Gets an existing media pipeline.
 */
public suspend inline fun ChimeSdkMediaPipelinesClient.getMediaCapturePipeline(crossinline block: GetMediaCapturePipelineRequest.Builder.() -> Unit): GetMediaCapturePipelineResponse = getMediaCapturePipeline(GetMediaCapturePipelineRequest.Builder().apply(block).build())

/**
 * Gets the configuration settings for a media insights pipeline.
 */
public suspend inline fun ChimeSdkMediaPipelinesClient.getMediaInsightsPipelineConfiguration(crossinline block: GetMediaInsightsPipelineConfigurationRequest.Builder.() -> Unit): GetMediaInsightsPipelineConfigurationResponse = getMediaInsightsPipelineConfiguration(GetMediaInsightsPipelineConfigurationRequest.Builder().apply(block).build())

/**
 * Gets an existing media pipeline.
 */
public suspend inline fun ChimeSdkMediaPipelinesClient.getMediaPipeline(crossinline block: GetMediaPipelineRequest.Builder.() -> Unit): GetMediaPipelineResponse = getMediaPipeline(GetMediaPipelineRequest.Builder().apply(block).build())

/**
 * Gets an Kinesis video stream pool.
 */
public suspend inline fun ChimeSdkMediaPipelinesClient.getMediaPipelineKinesisVideoStreamPool(crossinline block: GetMediaPipelineKinesisVideoStreamPoolRequest.Builder.() -> Unit): GetMediaPipelineKinesisVideoStreamPoolResponse = getMediaPipelineKinesisVideoStreamPool(GetMediaPipelineKinesisVideoStreamPoolRequest.Builder().apply(block).build())

/**
 * Retrieves the details of the specified speaker search task.
 */
public suspend inline fun ChimeSdkMediaPipelinesClient.getSpeakerSearchTask(crossinline block: GetSpeakerSearchTaskRequest.Builder.() -> Unit): GetSpeakerSearchTaskResponse = getSpeakerSearchTask(GetSpeakerSearchTaskRequest.Builder().apply(block).build())

/**
 * Retrieves the details of a voice tone analysis task.
 */
public suspend inline fun ChimeSdkMediaPipelinesClient.getVoiceToneAnalysisTask(crossinline block: GetVoiceToneAnalysisTaskRequest.Builder.() -> Unit): GetVoiceToneAnalysisTaskResponse = getVoiceToneAnalysisTask(GetVoiceToneAnalysisTaskRequest.Builder().apply(block).build())

/**
 * Returns a list of media pipelines.
 */
public suspend inline fun ChimeSdkMediaPipelinesClient.listMediaCapturePipelines(crossinline block: ListMediaCapturePipelinesRequest.Builder.() -> Unit): ListMediaCapturePipelinesResponse = listMediaCapturePipelines(ListMediaCapturePipelinesRequest.Builder().apply(block).build())

/**
 * Lists the available media insights pipeline configurations.
 */
public suspend inline fun ChimeSdkMediaPipelinesClient.listMediaInsightsPipelineConfigurations(crossinline block: ListMediaInsightsPipelineConfigurationsRequest.Builder.() -> Unit): ListMediaInsightsPipelineConfigurationsResponse = listMediaInsightsPipelineConfigurations(ListMediaInsightsPipelineConfigurationsRequest.Builder().apply(block).build())

/**
 * Lists the video stream pools in the media pipeline.
 */
public suspend inline fun ChimeSdkMediaPipelinesClient.listMediaPipelineKinesisVideoStreamPools(crossinline block: ListMediaPipelineKinesisVideoStreamPoolsRequest.Builder.() -> Unit): ListMediaPipelineKinesisVideoStreamPoolsResponse = listMediaPipelineKinesisVideoStreamPools(ListMediaPipelineKinesisVideoStreamPoolsRequest.Builder().apply(block).build())

/**
 * Returns a list of media pipelines.
 */
public suspend inline fun ChimeSdkMediaPipelinesClient.listMediaPipelines(crossinline block: ListMediaPipelinesRequest.Builder.() -> Unit): ListMediaPipelinesResponse = listMediaPipelines(ListMediaPipelinesRequest.Builder().apply(block).build())

/**
 * Lists the tags available for a media pipeline.
 */
public suspend inline fun ChimeSdkMediaPipelinesClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Starts a speaker search task.
 *
 * Before starting any speaker search tasks, you must provide all notices and obtain all consents from the speaker as required under applicable privacy and biometrics laws, and as required under the [AWS service terms](https://aws.amazon.com/service-terms/) for the Amazon Chime SDK.
 */
public suspend inline fun ChimeSdkMediaPipelinesClient.startSpeakerSearchTask(crossinline block: StartSpeakerSearchTaskRequest.Builder.() -> Unit): StartSpeakerSearchTaskResponse = startSpeakerSearchTask(StartSpeakerSearchTaskRequest.Builder().apply(block).build())

/**
 * Starts a voice tone analysis task. For more information about voice tone analysis, see [Using Amazon Chime SDK voice analytics](https://docs.aws.amazon.com/chime-sdk/latest/dg/voice-analytics.html) in the *Amazon Chime SDK Developer Guide*.
 *
 * Before starting any voice tone analysis tasks, you must provide all notices and obtain all consents from the speaker as required under applicable privacy and biometrics laws, and as required under the [AWS service terms](https://aws.amazon.com/service-terms/) for the Amazon Chime SDK.
 */
public suspend inline fun ChimeSdkMediaPipelinesClient.startVoiceToneAnalysisTask(crossinline block: StartVoiceToneAnalysisTaskRequest.Builder.() -> Unit): StartVoiceToneAnalysisTaskResponse = startVoiceToneAnalysisTask(StartVoiceToneAnalysisTaskRequest.Builder().apply(block).build())

/**
 * Stops a speaker search task.
 */
public suspend inline fun ChimeSdkMediaPipelinesClient.stopSpeakerSearchTask(crossinline block: StopSpeakerSearchTaskRequest.Builder.() -> Unit): StopSpeakerSearchTaskResponse = stopSpeakerSearchTask(StopSpeakerSearchTaskRequest.Builder().apply(block).build())

/**
 * Stops a voice tone analysis task.
 */
public suspend inline fun ChimeSdkMediaPipelinesClient.stopVoiceToneAnalysisTask(crossinline block: StopVoiceToneAnalysisTaskRequest.Builder.() -> Unit): StopVoiceToneAnalysisTaskResponse = stopVoiceToneAnalysisTask(StopVoiceToneAnalysisTaskRequest.Builder().apply(block).build())

/**
 * The ARN of the media pipeline that you want to tag. Consists of the pipeline's endpoint region, resource ID, and pipeline ID.
 */
public suspend inline fun ChimeSdkMediaPipelinesClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes any tags from a media pipeline.
 */
public suspend inline fun ChimeSdkMediaPipelinesClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates the media insights pipeline's configuration settings.
 */
public suspend inline fun ChimeSdkMediaPipelinesClient.updateMediaInsightsPipelineConfiguration(crossinline block: UpdateMediaInsightsPipelineConfigurationRequest.Builder.() -> Unit): UpdateMediaInsightsPipelineConfigurationResponse = updateMediaInsightsPipelineConfiguration(UpdateMediaInsightsPipelineConfigurationRequest.Builder().apply(block).build())

/**
 * Updates the status of a media insights pipeline.
 */
public suspend inline fun ChimeSdkMediaPipelinesClient.updateMediaInsightsPipelineStatus(crossinline block: UpdateMediaInsightsPipelineStatusRequest.Builder.() -> Unit): UpdateMediaInsightsPipelineStatusResponse = updateMediaInsightsPipelineStatus(UpdateMediaInsightsPipelineStatusRequest.Builder().apply(block).build())

/**
 * Updates an Amazon Kinesis Video Stream pool in a media pipeline.
 */
public suspend inline fun ChimeSdkMediaPipelinesClient.updateMediaPipelineKinesisVideoStreamPool(crossinline block: UpdateMediaPipelineKinesisVideoStreamPoolRequest.Builder.() -> Unit): UpdateMediaPipelineKinesisVideoStreamPoolResponse = updateMediaPipelineKinesisVideoStreamPool(UpdateMediaPipelineKinesisVideoStreamPoolRequest.Builder().apply(block).build())
