// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chimesdkmediapipelines.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Allows you to specify additional settings for your Call Analytics post-call request, including output locations for your redacted transcript, which IAM role to use, and which encryption key to use.
 *
 * `DataAccessRoleArn` and `OutputLocation` are required fields.
 *
 * `PostCallAnalyticsSettings` provides the same insights as a Call Analytics post-call transcription. For more information, refer to [Post-call analytics with real-time transcriptions](https://docs.aws.amazon.com/transcribe/latest/dg/tca-post-call.html) in the *Amazon Transcribe Developer Guide*.
 */
public class PostCallAnalyticsSettings private constructor(builder: Builder) {
    /**
     * The content redaction output settings for a post-call analysis task.
     */
    public val contentRedactionOutput: aws.sdk.kotlin.services.chimesdkmediapipelines.model.ContentRedactionOutput? = builder.contentRedactionOutput
    /**
     * The ARN of the role used by Amazon Web Services Transcribe to upload your post call analysis. For more information, see [Post-call analytics with real-time transcriptions](https://docs.aws.amazon.com/transcribe/latest/dg/tca-post-call.html) in the *Amazon Transcribe Developer Guide*.
     */
    public val dataAccessRoleArn: kotlin.String = requireNotNull(builder.dataAccessRoleArn) { "A non-null value must be provided for dataAccessRoleArn" }
    /**
     * The ID of the KMS (Key Management Service) key used to encrypt the output.
     */
    public val outputEncryptionKmsKeyId: kotlin.String? = builder.outputEncryptionKmsKeyId
    /**
     * The URL of the Amazon S3 bucket that contains the post-call data.
     */
    public val outputLocation: kotlin.String = requireNotNull(builder.outputLocation) { "A non-null value must be provided for outputLocation" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.chimesdkmediapipelines.model.PostCallAnalyticsSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PostCallAnalyticsSettings(")
        append("contentRedactionOutput=$contentRedactionOutput,")
        append("dataAccessRoleArn=$dataAccessRoleArn,")
        append("outputEncryptionKmsKeyId=$outputEncryptionKmsKeyId,")
        append("outputLocation=$outputLocation")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = contentRedactionOutput?.hashCode() ?: 0
        result = 31 * result + (dataAccessRoleArn.hashCode())
        result = 31 * result + (outputEncryptionKmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (outputLocation.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PostCallAnalyticsSettings

        if (contentRedactionOutput != other.contentRedactionOutput) return false
        if (dataAccessRoleArn != other.dataAccessRoleArn) return false
        if (outputEncryptionKmsKeyId != other.outputEncryptionKmsKeyId) return false
        if (outputLocation != other.outputLocation) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.chimesdkmediapipelines.model.PostCallAnalyticsSettings = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The content redaction output settings for a post-call analysis task.
         */
        public var contentRedactionOutput: aws.sdk.kotlin.services.chimesdkmediapipelines.model.ContentRedactionOutput? = null
        /**
         * The ARN of the role used by Amazon Web Services Transcribe to upload your post call analysis. For more information, see [Post-call analytics with real-time transcriptions](https://docs.aws.amazon.com/transcribe/latest/dg/tca-post-call.html) in the *Amazon Transcribe Developer Guide*.
         */
        public var dataAccessRoleArn: kotlin.String? = null
        /**
         * The ID of the KMS (Key Management Service) key used to encrypt the output.
         */
        public var outputEncryptionKmsKeyId: kotlin.String? = null
        /**
         * The URL of the Amazon S3 bucket that contains the post-call data.
         */
        public var outputLocation: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.chimesdkmediapipelines.model.PostCallAnalyticsSettings) : this() {
            this.contentRedactionOutput = x.contentRedactionOutput
            this.dataAccessRoleArn = x.dataAccessRoleArn
            this.outputEncryptionKmsKeyId = x.outputEncryptionKmsKeyId
            this.outputLocation = x.outputLocation
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.chimesdkmediapipelines.model.PostCallAnalyticsSettings = PostCallAnalyticsSettings(this)

        internal fun correctErrors(): Builder {
            if (dataAccessRoleArn == null) dataAccessRoleArn = ""
            if (outputLocation == null) outputLocation = ""
            return this
        }
    }
}
