// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chimesdkmediapipelines.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The configuration of an Kinesis video stream.
 *
 * If a meeting uses an opt-in Region as its [MediaRegion](https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_meeting-chime_CreateMeeting.html#chimesdk-meeting-chime_CreateMeeting-request-MediaRegion), the KVS stream must be in that same Region. For example, if a meeting uses the `af-south-1` Region, the KVS stream must also be in `af-south-1`. However, if the meeting uses a Region that AWS turns on by default, the KVS stream can be in any available Region, including an opt-in Region. For example, if the meeting uses `ca-central-1`, the KVS stream can be in `eu-west-2`, `us-east-1`, `af-south-1`, or any other Region that the Amazon Chime SDK supports.
 *
 * To learn which AWS Region a meeting uses, call the [GetMeeting](https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_meeting-chime_GetMeeting.html) API and use the [MediaRegion](https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_meeting-chime_CreateMeeting.html#chimesdk-meeting-chime_CreateMeeting-request-MediaRegion) parameter from the response.
 *
 * For more information about opt-in Regions, refer to [Available Regions](https://docs.aws.amazon.com/chime-sdk/latest/dg/sdk-available-regions.html) in the *Amazon Chime SDK Developer Guide*, and [Specify which AWS Regions your account can use](https://docs.aws.amazon.com/accounts/latest/reference/manage-acct-regions.html#rande-manage-enable.html), in the *AWS Account Management Reference Guide*.
 */
public class KinesisVideoStreamConfiguration private constructor(builder: Builder) {
    /**
     * The amount of time that data is retained.
     */
    public val dataRetentionInHours: kotlin.Int? = builder.dataRetentionInHours
    /**
     * The Amazon Web Services Region of the video stream.
     */
    public val region: kotlin.String = requireNotNull(builder.region) { "A non-null value must be provided for region" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.chimesdkmediapipelines.model.KinesisVideoStreamConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("KinesisVideoStreamConfiguration(")
        append("dataRetentionInHours=$dataRetentionInHours,")
        append("region=$region")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataRetentionInHours ?: 0
        result = 31 * result + (region.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as KinesisVideoStreamConfiguration

        if (dataRetentionInHours != other.dataRetentionInHours) return false
        if (region != other.region) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.chimesdkmediapipelines.model.KinesisVideoStreamConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The amount of time that data is retained.
         */
        public var dataRetentionInHours: kotlin.Int? = null
        /**
         * The Amazon Web Services Region of the video stream.
         */
        public var region: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.chimesdkmediapipelines.model.KinesisVideoStreamConfiguration) : this() {
            this.dataRetentionInHours = x.dataRetentionInHours
            this.region = x.region
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.chimesdkmediapipelines.model.KinesisVideoStreamConfiguration = KinesisVideoStreamConfiguration(this)

        internal fun correctErrors(): Builder {
            if (region == null) region = ""
            return this
        }
    }
}
