// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chimesdkmediapipelines.serde

import aws.sdk.kotlin.services.chimesdkmediapipelines.model.KinesisVideoStreamSourceTaskConfiguration
import aws.sdk.kotlin.services.chimesdkmediapipelines.model.StartSpeakerSearchTaskRequest
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class StartSpeakerSearchTaskOperationSerializer: HttpSerializer.NonStreaming<StartSpeakerSearchTaskRequest> {
    override fun serialize(context: ExecutionContext, input: StartSpeakerSearchTaskRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.identifier) { "identifier is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("media-insights-pipelines"))
                add(PercentEncoding.SmithyLabel.encode("${input.identifier}"))
                add(PercentEncoding.Path.encode("speaker-search-tasks"))
            }
            parameters.decodedParameters {
                add("operation", "start")
            }
        }

        val payload = serializeStartSpeakerSearchTaskOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeStartSpeakerSearchTaskOperationBody(context: ExecutionContext, input: StartSpeakerSearchTaskRequest): ByteArray {
    val serializer = JsonSerializer()
    val CLIENTREQUESTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ClientRequestToken"))
    val KINESISVIDEOSTREAMSOURCETASKCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("KinesisVideoStreamSourceTaskConfiguration"))
    val VOICEPROFILEDOMAINARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("VoiceProfileDomainArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLIENTREQUESTTOKEN_DESCRIPTOR)
        field(KINESISVIDEOSTREAMSOURCETASKCONFIGURATION_DESCRIPTOR)
        field(VOICEPROFILEDOMAINARN_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.clientRequestToken?.let { field(CLIENTREQUESTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTREQUESTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.kinesisVideoStreamSourceTaskConfiguration?.let { field(KINESISVIDEOSTREAMSOURCETASKCONFIGURATION_DESCRIPTOR, it, ::serializeKinesisVideoStreamSourceTaskConfigurationDocument) }
        input.voiceProfileDomainArn?.let { field(VOICEPROFILEDOMAINARN_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
