// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chimesdkmediapipelines.model



/**
 * The runtime configuration settings for the Kinesis video stream source.
 */
public class KinesisVideoStreamSourceRuntimeConfiguration private constructor(builder: Builder) {
    /**
     * Specifies the encoding of your input audio. Supported format: PCM (only signed 16-bit little-endian audio formats, which does not include WAV)
     *
     * For more information, see [Media formats](https://docs.aws.amazon.com/transcribe/latest/dg/how-input.html#how-input-audio) in the *Amazon Transcribe Developer Guide*.
     */
    public val mediaEncoding: aws.sdk.kotlin.services.chimesdkmediapipelines.model.MediaEncoding = requireNotNull(builder.mediaEncoding) { "A non-null value must be provided for mediaEncoding" }
    /**
     * The sample rate of the input audio (in hertz). Low-quality audio, such as telephone audio, is typically around 8,000 Hz. High-quality audio typically ranges from 16,000 Hz to 48,000 Hz. Note that the sample rate you specify must match that of your audio.
     *
     * Valid Range: Minimum value of 8000. Maximum value of 48000.
     */
    public val mediaSampleRate: kotlin.Int = requireNotNull(builder.mediaSampleRate) { "A non-null value must be provided for mediaSampleRate" }
    /**
     * The streams in the source runtime configuration of a Kinesis video stream.
     */
    public val streams: List<StreamConfiguration> = requireNotNull(builder.streams) { "A non-null value must be provided for streams" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.chimesdkmediapipelines.model.KinesisVideoStreamSourceRuntimeConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("KinesisVideoStreamSourceRuntimeConfiguration(")
        append("mediaEncoding=$mediaEncoding,")
        append("mediaSampleRate=$mediaSampleRate,")
        append("streams=$streams")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = mediaEncoding.hashCode()
        result = 31 * result + (mediaSampleRate)
        result = 31 * result + (streams.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as KinesisVideoStreamSourceRuntimeConfiguration

        if (mediaEncoding != other.mediaEncoding) return false
        if (mediaSampleRate != other.mediaSampleRate) return false
        if (streams != other.streams) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.chimesdkmediapipelines.model.KinesisVideoStreamSourceRuntimeConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies the encoding of your input audio. Supported format: PCM (only signed 16-bit little-endian audio formats, which does not include WAV)
         *
         * For more information, see [Media formats](https://docs.aws.amazon.com/transcribe/latest/dg/how-input.html#how-input-audio) in the *Amazon Transcribe Developer Guide*.
         */
        public var mediaEncoding: aws.sdk.kotlin.services.chimesdkmediapipelines.model.MediaEncoding? = null
        /**
         * The sample rate of the input audio (in hertz). Low-quality audio, such as telephone audio, is typically around 8,000 Hz. High-quality audio typically ranges from 16,000 Hz to 48,000 Hz. Note that the sample rate you specify must match that of your audio.
         *
         * Valid Range: Minimum value of 8000. Maximum value of 48000.
         */
        public var mediaSampleRate: kotlin.Int? = null
        /**
         * The streams in the source runtime configuration of a Kinesis video stream.
         */
        public var streams: List<StreamConfiguration>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.chimesdkmediapipelines.model.KinesisVideoStreamSourceRuntimeConfiguration) : this() {
            this.mediaEncoding = x.mediaEncoding
            this.mediaSampleRate = x.mediaSampleRate
            this.streams = x.streams
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.chimesdkmediapipelines.model.KinesisVideoStreamSourceRuntimeConfiguration = KinesisVideoStreamSourceRuntimeConfiguration(this)

        internal fun correctErrors(): Builder {
            if (mediaEncoding == null) mediaEncoding = MediaEncoding.SdkUnknown("no value provided")
            if (mediaSampleRate == null) mediaSampleRate = 0
            if (streams == null) streams = emptyList()
            return this
        }
    }
}
