// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chimesdkidentity.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * An endpoint under an Amazon Chime AppInstanceUser that receives messages for a user. For push notifications, the endpoint is a mobile device used to receive mobile push notifications for a user.
 */
class AppInstanceUserEndpoint private constructor(builder: Builder) {
    /**
     * Boolean that controls whether the AppInstanceUserEndpoint is opted in to receive messages. ALL indicates the endpoint will receive all messages.
     * NONE indicates the endpoint will receive no messages.
     */
    val allowMessages: aws.sdk.kotlin.services.chimesdkidentity.model.AllowMessages? = builder.allowMessages
    /**
     * The ARN of the AppInstanceUser.
     */
    val appInstanceUserArn: kotlin.String? = builder.appInstanceUserArn
    /**
     * The time at which an AppInstanceUserEndpoint was created.
     */
    val createdTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.createdTimestamp
    /**
     * The attributes of an Endpoint.
     */
    val endpointAttributes: aws.sdk.kotlin.services.chimesdkidentity.model.EndpointAttributes? = builder.endpointAttributes
    /**
     * The unique identifier of the AppInstanceUserEndpoint.
     */
    val endpointId: kotlin.String? = builder.endpointId
    /**
     * A read-only field that represents the state of an AppInstanceUserEndpoint. Supported values:
     *
     *
     *
     * ACTIVE: The AppInstanceUserEndpoint is active and able to receive messages. When ACTIVE, the EndpointStatusReason remains empty.
     *
     *
     * INACTIVE: The AppInstanceUserEndpoint is inactive and can't receive message. When INACTIVE, the corresponding reason will be
     * conveyed through EndpointStatusReason.
     *
     *
     * INVALID_DEVICE_TOKEN indicates that an AppInstanceUserEndpoint is INACTIVE due to invalid device token
     *
     *
     * INVALID_PINPOINT_ARN indicates that an AppInstanceUserEndpoint is INACTIVE due to an invalid pinpoint ARN that was input
     * through the ResourceArn field.
     */
    val endpointState: aws.sdk.kotlin.services.chimesdkidentity.model.EndpointState? = builder.endpointState
    /**
     * The time at which an AppInstanceUserEndpoint was last updated.
     */
    val lastUpdatedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedTimestamp
    /**
     * The name of the AppInstanceUserEndpoint.
     */
    val name: kotlin.String? = builder.name
    /**
     * The ARN of the resource to which the endpoint belongs.
     */
    val resourceArn: kotlin.String? = builder.resourceArn
    /**
     * The type of the AppInstanceUserEndpoint.
     */
    val type: aws.sdk.kotlin.services.chimesdkidentity.model.AppInstanceUserEndpointType? = builder.type

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.chimesdkidentity.model.AppInstanceUserEndpoint = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AppInstanceUserEndpoint(")
        append("allowMessages=$allowMessages,")
        append("appInstanceUserArn=*** Sensitive Data Redacted ***,")
        append("createdTimestamp=$createdTimestamp,")
        append("endpointAttributes=$endpointAttributes,")
        append("endpointId=*** Sensitive Data Redacted ***,")
        append("endpointState=$endpointState,")
        append("lastUpdatedTimestamp=$lastUpdatedTimestamp,")
        append("name=*** Sensitive Data Redacted ***,")
        append("resourceArn=*** Sensitive Data Redacted ***,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowMessages?.hashCode() ?: 0
        result = 31 * result + (appInstanceUserArn?.hashCode() ?: 0)
        result = 31 * result + (createdTimestamp?.hashCode() ?: 0)
        result = 31 * result + (endpointAttributes?.hashCode() ?: 0)
        result = 31 * result + (endpointId?.hashCode() ?: 0)
        result = 31 * result + (endpointState?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedTimestamp?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (resourceArn?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AppInstanceUserEndpoint

        if (allowMessages != other.allowMessages) return false
        if (appInstanceUserArn != other.appInstanceUserArn) return false
        if (createdTimestamp != other.createdTimestamp) return false
        if (endpointAttributes != other.endpointAttributes) return false
        if (endpointId != other.endpointId) return false
        if (endpointState != other.endpointState) return false
        if (lastUpdatedTimestamp != other.lastUpdatedTimestamp) return false
        if (name != other.name) return false
        if (resourceArn != other.resourceArn) return false
        if (type != other.type) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.chimesdkidentity.model.AppInstanceUserEndpoint = Builder(this).apply(block).build()

    class Builder {
        /**
         * Boolean that controls whether the AppInstanceUserEndpoint is opted in to receive messages. ALL indicates the endpoint will receive all messages.
         * NONE indicates the endpoint will receive no messages.
         */
        var allowMessages: aws.sdk.kotlin.services.chimesdkidentity.model.AllowMessages? = null
        /**
         * The ARN of the AppInstanceUser.
         */
        var appInstanceUserArn: kotlin.String? = null
        /**
         * The time at which an AppInstanceUserEndpoint was created.
         */
        var createdTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The attributes of an Endpoint.
         */
        var endpointAttributes: aws.sdk.kotlin.services.chimesdkidentity.model.EndpointAttributes? = null
        /**
         * The unique identifier of the AppInstanceUserEndpoint.
         */
        var endpointId: kotlin.String? = null
        /**
         * A read-only field that represents the state of an AppInstanceUserEndpoint. Supported values:
         *
         *
         *
         * ACTIVE: The AppInstanceUserEndpoint is active and able to receive messages. When ACTIVE, the EndpointStatusReason remains empty.
         *
         *
         * INACTIVE: The AppInstanceUserEndpoint is inactive and can't receive message. When INACTIVE, the corresponding reason will be
         * conveyed through EndpointStatusReason.
         *
         *
         * INVALID_DEVICE_TOKEN indicates that an AppInstanceUserEndpoint is INACTIVE due to invalid device token
         *
         *
         * INVALID_PINPOINT_ARN indicates that an AppInstanceUserEndpoint is INACTIVE due to an invalid pinpoint ARN that was input
         * through the ResourceArn field.
         */
        var endpointState: aws.sdk.kotlin.services.chimesdkidentity.model.EndpointState? = null
        /**
         * The time at which an AppInstanceUserEndpoint was last updated.
         */
        var lastUpdatedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the AppInstanceUserEndpoint.
         */
        var name: kotlin.String? = null
        /**
         * The ARN of the resource to which the endpoint belongs.
         */
        var resourceArn: kotlin.String? = null
        /**
         * The type of the AppInstanceUserEndpoint.
         */
        var type: aws.sdk.kotlin.services.chimesdkidentity.model.AppInstanceUserEndpointType? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.chimesdkidentity.model.AppInstanceUserEndpoint) : this() {
            this.allowMessages = x.allowMessages
            this.appInstanceUserArn = x.appInstanceUserArn
            this.createdTimestamp = x.createdTimestamp
            this.endpointAttributes = x.endpointAttributes
            this.endpointId = x.endpointId
            this.endpointState = x.endpointState
            this.lastUpdatedTimestamp = x.lastUpdatedTimestamp
            this.name = x.name
            this.resourceArn = x.resourceArn
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.chimesdkidentity.model.AppInstanceUserEndpoint = AppInstanceUserEndpoint(this)

        /**
         * construct an [aws.sdk.kotlin.services.chimesdkidentity.model.EndpointAttributes] inside the given [block]
         */
        fun endpointAttributes(block: aws.sdk.kotlin.services.chimesdkidentity.model.EndpointAttributes.Builder.() -> kotlin.Unit) {
            this.endpointAttributes = aws.sdk.kotlin.services.chimesdkidentity.model.EndpointAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.chimesdkidentity.model.EndpointState] inside the given [block]
         */
        fun endpointState(block: aws.sdk.kotlin.services.chimesdkidentity.model.EndpointState.Builder.() -> kotlin.Unit) {
            this.endpointState = aws.sdk.kotlin.services.chimesdkidentity.model.EndpointState.invoke(block)
        }
    }
}
