// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chimesdkidentity

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.chimesdkidentity.model.*
import aws.sdk.kotlin.services.chimesdkidentity.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.middleware.Retry
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "Chime SDK Identity"
const val ServiceApiVersion: String = "2021-04-20"
const val SdkVersion: String = "0.15.1-beta"

internal class DefaultChimeSdkIdentityClient(override val config: ChimeSdkIdentityClient.Config) : ChimeSdkIdentityClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Creates an Amazon Chime SDK messaging AppInstance under an AWS account.
     * Only SDK messaging customers use this API. CreateAppInstance supports
     * idempotency behavior as described in the AWS API Standard.
     * identity
     */
    override suspend fun createAppInstance(input: CreateAppInstanceRequest): CreateAppInstanceResponse {
        val op = SdkHttpOperation.build<CreateAppInstanceRequest, CreateAppInstanceResponse> {
            serializer = CreateAppInstanceOperationSerializer()
            deserializer = CreateAppInstanceOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateAppInstance"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Promotes an AppInstanceUser to an AppInstanceAdmin. The
     * promoted user can perform the following actions.
     *
     *
     *
     *
     * ChannelModerator actions across all channels in the
     * AppInstance.
     *
     *
     * DeleteChannelMessage actions.
     *
     *
     *
     * Only an AppInstanceUser can be promoted to an AppInstanceAdmin
     * role.
     */
    override suspend fun createAppInstanceAdmin(input: CreateAppInstanceAdminRequest): CreateAppInstanceAdminResponse {
        val op = SdkHttpOperation.build<CreateAppInstanceAdminRequest, CreateAppInstanceAdminResponse> {
            serializer = CreateAppInstanceAdminOperationSerializer()
            deserializer = CreateAppInstanceAdminOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateAppInstanceAdmin"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a user under an Amazon Chime AppInstance. The request consists of a
     * unique appInstanceUserId and Name for that user.
     */
    override suspend fun createAppInstanceUser(input: CreateAppInstanceUserRequest): CreateAppInstanceUserResponse {
        val op = SdkHttpOperation.build<CreateAppInstanceUserRequest, CreateAppInstanceUserResponse> {
            serializer = CreateAppInstanceUserOperationSerializer()
            deserializer = CreateAppInstanceUserOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateAppInstanceUser"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an AppInstance and all associated data asynchronously.
     */
    override suspend fun deleteAppInstance(input: DeleteAppInstanceRequest): DeleteAppInstanceResponse {
        val op = SdkHttpOperation.build<DeleteAppInstanceRequest, DeleteAppInstanceResponse> {
            serializer = DeleteAppInstanceOperationSerializer()
            deserializer = DeleteAppInstanceOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteAppInstance"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Demotes an AppInstanceAdmin to an AppInstanceUser. This action
     * does not delete the user.
     */
    override suspend fun deleteAppInstanceAdmin(input: DeleteAppInstanceAdminRequest): DeleteAppInstanceAdminResponse {
        val op = SdkHttpOperation.build<DeleteAppInstanceAdminRequest, DeleteAppInstanceAdminResponse> {
            serializer = DeleteAppInstanceAdminOperationSerializer()
            deserializer = DeleteAppInstanceAdminOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteAppInstanceAdmin"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an AppInstanceUser.
     */
    override suspend fun deleteAppInstanceUser(input: DeleteAppInstanceUserRequest): DeleteAppInstanceUserResponse {
        val op = SdkHttpOperation.build<DeleteAppInstanceUserRequest, DeleteAppInstanceUserResponse> {
            serializer = DeleteAppInstanceUserOperationSerializer()
            deserializer = DeleteAppInstanceUserOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteAppInstanceUser"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deregisters an AppInstanceUserEndpoint.
     */
    override suspend fun deregisterAppInstanceUserEndpoint(input: DeregisterAppInstanceUserEndpointRequest): DeregisterAppInstanceUserEndpointResponse {
        val op = SdkHttpOperation.build<DeregisterAppInstanceUserEndpointRequest, DeregisterAppInstanceUserEndpointResponse> {
            serializer = DeregisterAppInstanceUserEndpointOperationSerializer()
            deserializer = DeregisterAppInstanceUserEndpointOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeregisterAppInstanceUserEndpoint"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the full details of an AppInstance.
     */
    override suspend fun describeAppInstance(input: DescribeAppInstanceRequest): DescribeAppInstanceResponse {
        val op = SdkHttpOperation.build<DescribeAppInstanceRequest, DescribeAppInstanceResponse> {
            serializer = DescribeAppInstanceOperationSerializer()
            deserializer = DescribeAppInstanceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeAppInstance"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the full details of an AppInstanceAdmin.
     */
    override suspend fun describeAppInstanceAdmin(input: DescribeAppInstanceAdminRequest): DescribeAppInstanceAdminResponse {
        val op = SdkHttpOperation.build<DescribeAppInstanceAdminRequest, DescribeAppInstanceAdminResponse> {
            serializer = DescribeAppInstanceAdminOperationSerializer()
            deserializer = DescribeAppInstanceAdminOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeAppInstanceAdmin"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the full details of an AppInstanceUser.
     */
    override suspend fun describeAppInstanceUser(input: DescribeAppInstanceUserRequest): DescribeAppInstanceUserResponse {
        val op = SdkHttpOperation.build<DescribeAppInstanceUserRequest, DescribeAppInstanceUserResponse> {
            serializer = DescribeAppInstanceUserOperationSerializer()
            deserializer = DescribeAppInstanceUserOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeAppInstanceUser"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the full details of an AppInstanceUserEndpoint.
     */
    override suspend fun describeAppInstanceUserEndpoint(input: DescribeAppInstanceUserEndpointRequest): DescribeAppInstanceUserEndpointResponse {
        val op = SdkHttpOperation.build<DescribeAppInstanceUserEndpointRequest, DescribeAppInstanceUserEndpointResponse> {
            serializer = DescribeAppInstanceUserEndpointOperationSerializer()
            deserializer = DescribeAppInstanceUserEndpointOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeAppInstanceUserEndpoint"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets the retention settings for an AppInstance.
     */
    override suspend fun getAppInstanceRetentionSettings(input: GetAppInstanceRetentionSettingsRequest): GetAppInstanceRetentionSettingsResponse {
        val op = SdkHttpOperation.build<GetAppInstanceRetentionSettingsRequest, GetAppInstanceRetentionSettingsResponse> {
            serializer = GetAppInstanceRetentionSettingsOperationSerializer()
            deserializer = GetAppInstanceRetentionSettingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetAppInstanceRetentionSettings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of the administrators in the AppInstance.
     */
    override suspend fun listAppInstanceAdmins(input: ListAppInstanceAdminsRequest): ListAppInstanceAdminsResponse {
        val op = SdkHttpOperation.build<ListAppInstanceAdminsRequest, ListAppInstanceAdminsResponse> {
            serializer = ListAppInstanceAdminsOperationSerializer()
            deserializer = ListAppInstanceAdminsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAppInstanceAdmins"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all the AppInstanceUserEndpoints created under a single AppInstanceUser.
     */
    override suspend fun listAppInstanceUserEndpoints(input: ListAppInstanceUserEndpointsRequest): ListAppInstanceUserEndpointsResponse {
        val op = SdkHttpOperation.build<ListAppInstanceUserEndpointsRequest, ListAppInstanceUserEndpointsResponse> {
            serializer = ListAppInstanceUserEndpointsOperationSerializer()
            deserializer = ListAppInstanceUserEndpointsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAppInstanceUserEndpoints"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * List all AppInstanceUsers created under a single
     * AppInstance.
     */
    override suspend fun listAppInstanceUsers(input: ListAppInstanceUsersRequest): ListAppInstanceUsersResponse {
        val op = SdkHttpOperation.build<ListAppInstanceUsersRequest, ListAppInstanceUsersResponse> {
            serializer = ListAppInstanceUsersOperationSerializer()
            deserializer = ListAppInstanceUsersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAppInstanceUsers"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all Amazon Chime AppInstances created under a single AWS
     * account.
     */
    override suspend fun listAppInstances(input: ListAppInstancesRequest): ListAppInstancesResponse {
        val op = SdkHttpOperation.build<ListAppInstancesRequest, ListAppInstancesResponse> {
            serializer = ListAppInstancesOperationSerializer()
            deserializer = ListAppInstancesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAppInstances"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the tags applied to an Amazon Chime SDK identity resource.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Sets the amount of time in days that a given AppInstance retains
     * data.
     */
    override suspend fun putAppInstanceRetentionSettings(input: PutAppInstanceRetentionSettingsRequest): PutAppInstanceRetentionSettingsResponse {
        val op = SdkHttpOperation.build<PutAppInstanceRetentionSettingsRequest, PutAppInstanceRetentionSettingsResponse> {
            serializer = PutAppInstanceRetentionSettingsOperationSerializer()
            deserializer = PutAppInstanceRetentionSettingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutAppInstanceRetentionSettings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Registers an endpoint under an Amazon Chime AppInstanceUser. The endpoint receives messages for a user. For push notifications, the endpoint is a mobile device used to receive mobile push notifications for a user.
     */
    override suspend fun registerAppInstanceUserEndpoint(input: RegisterAppInstanceUserEndpointRequest): RegisterAppInstanceUserEndpointResponse {
        val op = SdkHttpOperation.build<RegisterAppInstanceUserEndpointRequest, RegisterAppInstanceUserEndpointResponse> {
            serializer = RegisterAppInstanceUserEndpointOperationSerializer()
            deserializer = RegisterAppInstanceUserEndpointOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "RegisterAppInstanceUserEndpoint"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Applies the specified tags to the specified Amazon Chime SDK identity resource.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "TagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes the specified tags from the specified Amazon Chime SDK identity resource.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "UntagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates AppInstance metadata.
     */
    override suspend fun updateAppInstance(input: UpdateAppInstanceRequest): UpdateAppInstanceResponse {
        val op = SdkHttpOperation.build<UpdateAppInstanceRequest, UpdateAppInstanceResponse> {
            serializer = UpdateAppInstanceOperationSerializer()
            deserializer = UpdateAppInstanceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateAppInstance"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the details of an AppInstanceUser. You can update names and
     * metadata.
     */
    override suspend fun updateAppInstanceUser(input: UpdateAppInstanceUserRequest): UpdateAppInstanceUserResponse {
        val op = SdkHttpOperation.build<UpdateAppInstanceUserRequest, UpdateAppInstanceUserResponse> {
            serializer = UpdateAppInstanceUserOperationSerializer()
            deserializer = UpdateAppInstanceUserOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateAppInstanceUser"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the details of an AppInstanceUserEndpoint. You can update the name and AllowMessage values.
     */
    override suspend fun updateAppInstanceUserEndpoint(input: UpdateAppInstanceUserEndpointRequest): UpdateAppInstanceUserEndpointResponse {
        val op = SdkHttpOperation.build<UpdateAppInstanceUserEndpointRequest, UpdateAppInstanceUserEndpointResponse> {
            serializer = UpdateAppInstanceUserEndpointOperationSerializer()
            deserializer = UpdateAppInstanceUserEndpointOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateAppInstanceUserEndpoint"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "chime")
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
        config.idempotencyTokenProvider?.let { ctx[SdkClientOption.IdempotencyTokenProvider] = it }
    }
}
