// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chimesdkidentity

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.chimesdkidentity.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.chimesdkidentity.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.crt.CrtAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.config.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * The Amazon Chime SDK Identity APIs in this section allow software developers to create
 * and manage unique instances of their messaging applications. These APIs provide the
 * overarching framework for creating and sending messages. For more information about the
 * identity APIs, refer to <a href="https://docs.aws.amazon.com/chime/latest/APIReference/API_Operations_Amazon_Chime_SDK_Identity.html">Amazon Chime SDK identity.
 */
interface ChimeSdkIdentityClient : SdkClient {

    override val serviceName: String
        get() = "Chime SDK Identity"
    /**
     * ChimeSdkIdentityClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): ChimeSdkIdentityClient {
            val config = Config.Builder().apply(block).build()
            return DefaultChimeSdkIdentityClient(config)
        }

        operator fun invoke(config: Config): ChimeSdkIdentityClient = DefaultChimeSdkIdentityClient(config)

        /**
         * Construct a [ChimeSdkIdentityClient] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): ChimeSdkIdentityClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultChimeSdkIdentityClient(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, IdempotencyTokenConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val idempotencyTokenProvider: IdempotencyTokenProvider? = builder.idempotencyTokenProvider
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        val signer: AwsSigner = builder.signer ?: CrtAwsSigner
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            var idempotencyTokenProvider: IdempotencyTokenProvider? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Creates an Amazon Chime SDK messaging AppInstance under an AWS account.
     * Only SDK messaging customers use this API. CreateAppInstance supports
     * idempotency behavior as described in the AWS API Standard.
     * identity
     */
    suspend fun createAppInstance(input: CreateAppInstanceRequest): CreateAppInstanceResponse

    /**
     * Creates an Amazon Chime SDK messaging AppInstance under an AWS account.
     * Only SDK messaging customers use this API. CreateAppInstance supports
     * idempotency behavior as described in the AWS API Standard.
     * identity
     */
    suspend fun createAppInstance(block: CreateAppInstanceRequest.Builder.() -> Unit) = createAppInstance(CreateAppInstanceRequest.Builder().apply(block).build())

    /**
     * Promotes an AppInstanceUser to an AppInstanceAdmin. The
     * promoted user can perform the following actions.
     *
     *
     *
     *
     * ChannelModerator actions across all channels in the
     * AppInstance.
     *
     *
     * DeleteChannelMessage actions.
     *
     *
     *
     * Only an AppInstanceUser can be promoted to an AppInstanceAdmin
     * role.
     */
    suspend fun createAppInstanceAdmin(input: CreateAppInstanceAdminRequest): CreateAppInstanceAdminResponse

    /**
     * Promotes an AppInstanceUser to an AppInstanceAdmin. The
     * promoted user can perform the following actions.
     *
     *
     *
     *
     * ChannelModerator actions across all channels in the
     * AppInstance.
     *
     *
     * DeleteChannelMessage actions.
     *
     *
     *
     * Only an AppInstanceUser can be promoted to an AppInstanceAdmin
     * role.
     */
    suspend fun createAppInstanceAdmin(block: CreateAppInstanceAdminRequest.Builder.() -> Unit) = createAppInstanceAdmin(CreateAppInstanceAdminRequest.Builder().apply(block).build())

    /**
     * Creates a user under an Amazon Chime AppInstance. The request consists of a
     * unique appInstanceUserId and Name for that user.
     */
    suspend fun createAppInstanceUser(input: CreateAppInstanceUserRequest): CreateAppInstanceUserResponse

    /**
     * Creates a user under an Amazon Chime AppInstance. The request consists of a
     * unique appInstanceUserId and Name for that user.
     */
    suspend fun createAppInstanceUser(block: CreateAppInstanceUserRequest.Builder.() -> Unit) = createAppInstanceUser(CreateAppInstanceUserRequest.Builder().apply(block).build())

    /**
     * Deletes an AppInstance and all associated data asynchronously.
     */
    suspend fun deleteAppInstance(input: DeleteAppInstanceRequest): DeleteAppInstanceResponse

    /**
     * Deletes an AppInstance and all associated data asynchronously.
     */
    suspend fun deleteAppInstance(block: DeleteAppInstanceRequest.Builder.() -> Unit) = deleteAppInstance(DeleteAppInstanceRequest.Builder().apply(block).build())

    /**
     * Demotes an AppInstanceAdmin to an AppInstanceUser. This action
     * does not delete the user.
     */
    suspend fun deleteAppInstanceAdmin(input: DeleteAppInstanceAdminRequest): DeleteAppInstanceAdminResponse

    /**
     * Demotes an AppInstanceAdmin to an AppInstanceUser. This action
     * does not delete the user.
     */
    suspend fun deleteAppInstanceAdmin(block: DeleteAppInstanceAdminRequest.Builder.() -> Unit) = deleteAppInstanceAdmin(DeleteAppInstanceAdminRequest.Builder().apply(block).build())

    /**
     * Deletes an AppInstanceUser.
     */
    suspend fun deleteAppInstanceUser(input: DeleteAppInstanceUserRequest): DeleteAppInstanceUserResponse

    /**
     * Deletes an AppInstanceUser.
     */
    suspend fun deleteAppInstanceUser(block: DeleteAppInstanceUserRequest.Builder.() -> Unit) = deleteAppInstanceUser(DeleteAppInstanceUserRequest.Builder().apply(block).build())

    /**
     * Deregisters an AppInstanceUserEndpoint.
     */
    suspend fun deregisterAppInstanceUserEndpoint(input: DeregisterAppInstanceUserEndpointRequest): DeregisterAppInstanceUserEndpointResponse

    /**
     * Deregisters an AppInstanceUserEndpoint.
     */
    suspend fun deregisterAppInstanceUserEndpoint(block: DeregisterAppInstanceUserEndpointRequest.Builder.() -> Unit) = deregisterAppInstanceUserEndpoint(DeregisterAppInstanceUserEndpointRequest.Builder().apply(block).build())

    /**
     * Returns the full details of an AppInstance.
     */
    suspend fun describeAppInstance(input: DescribeAppInstanceRequest): DescribeAppInstanceResponse

    /**
     * Returns the full details of an AppInstance.
     */
    suspend fun describeAppInstance(block: DescribeAppInstanceRequest.Builder.() -> Unit) = describeAppInstance(DescribeAppInstanceRequest.Builder().apply(block).build())

    /**
     * Returns the full details of an AppInstanceAdmin.
     */
    suspend fun describeAppInstanceAdmin(input: DescribeAppInstanceAdminRequest): DescribeAppInstanceAdminResponse

    /**
     * Returns the full details of an AppInstanceAdmin.
     */
    suspend fun describeAppInstanceAdmin(block: DescribeAppInstanceAdminRequest.Builder.() -> Unit) = describeAppInstanceAdmin(DescribeAppInstanceAdminRequest.Builder().apply(block).build())

    /**
     * Returns the full details of an AppInstanceUser.
     */
    suspend fun describeAppInstanceUser(input: DescribeAppInstanceUserRequest): DescribeAppInstanceUserResponse

    /**
     * Returns the full details of an AppInstanceUser.
     */
    suspend fun describeAppInstanceUser(block: DescribeAppInstanceUserRequest.Builder.() -> Unit) = describeAppInstanceUser(DescribeAppInstanceUserRequest.Builder().apply(block).build())

    /**
     * Returns the full details of an AppInstanceUserEndpoint.
     */
    suspend fun describeAppInstanceUserEndpoint(input: DescribeAppInstanceUserEndpointRequest): DescribeAppInstanceUserEndpointResponse

    /**
     * Returns the full details of an AppInstanceUserEndpoint.
     */
    suspend fun describeAppInstanceUserEndpoint(block: DescribeAppInstanceUserEndpointRequest.Builder.() -> Unit) = describeAppInstanceUserEndpoint(DescribeAppInstanceUserEndpointRequest.Builder().apply(block).build())

    /**
     * Gets the retention settings for an AppInstance.
     */
    suspend fun getAppInstanceRetentionSettings(input: GetAppInstanceRetentionSettingsRequest): GetAppInstanceRetentionSettingsResponse

    /**
     * Gets the retention settings for an AppInstance.
     */
    suspend fun getAppInstanceRetentionSettings(block: GetAppInstanceRetentionSettingsRequest.Builder.() -> Unit) = getAppInstanceRetentionSettings(GetAppInstanceRetentionSettingsRequest.Builder().apply(block).build())

    /**
     * Returns a list of the administrators in the AppInstance.
     */
    suspend fun listAppInstanceAdmins(input: ListAppInstanceAdminsRequest): ListAppInstanceAdminsResponse

    /**
     * Returns a list of the administrators in the AppInstance.
     */
    suspend fun listAppInstanceAdmins(block: ListAppInstanceAdminsRequest.Builder.() -> Unit) = listAppInstanceAdmins(ListAppInstanceAdminsRequest.Builder().apply(block).build())

    /**
     * Lists all the AppInstanceUserEndpoints created under a single AppInstanceUser.
     */
    suspend fun listAppInstanceUserEndpoints(input: ListAppInstanceUserEndpointsRequest): ListAppInstanceUserEndpointsResponse

    /**
     * Lists all the AppInstanceUserEndpoints created under a single AppInstanceUser.
     */
    suspend fun listAppInstanceUserEndpoints(block: ListAppInstanceUserEndpointsRequest.Builder.() -> Unit) = listAppInstanceUserEndpoints(ListAppInstanceUserEndpointsRequest.Builder().apply(block).build())

    /**
     * List all AppInstanceUsers created under a single
     * AppInstance.
     */
    suspend fun listAppInstanceUsers(input: ListAppInstanceUsersRequest): ListAppInstanceUsersResponse

    /**
     * List all AppInstanceUsers created under a single
     * AppInstance.
     */
    suspend fun listAppInstanceUsers(block: ListAppInstanceUsersRequest.Builder.() -> Unit) = listAppInstanceUsers(ListAppInstanceUsersRequest.Builder().apply(block).build())

    /**
     * Lists all Amazon Chime AppInstances created under a single AWS
     * account.
     */
    suspend fun listAppInstances(input: ListAppInstancesRequest): ListAppInstancesResponse

    /**
     * Lists all Amazon Chime AppInstances created under a single AWS
     * account.
     */
    suspend fun listAppInstances(block: ListAppInstancesRequest.Builder.() -> Unit) = listAppInstances(ListAppInstancesRequest.Builder().apply(block).build())

    /**
     * Lists the tags applied to an Amazon Chime SDK identity resource.
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Lists the tags applied to an Amazon Chime SDK identity resource.
     */
    suspend fun listTagsForResource(block: ListTagsForResourceRequest.Builder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

    /**
     * Sets the amount of time in days that a given AppInstance retains
     * data.
     */
    suspend fun putAppInstanceRetentionSettings(input: PutAppInstanceRetentionSettingsRequest): PutAppInstanceRetentionSettingsResponse

    /**
     * Sets the amount of time in days that a given AppInstance retains
     * data.
     */
    suspend fun putAppInstanceRetentionSettings(block: PutAppInstanceRetentionSettingsRequest.Builder.() -> Unit) = putAppInstanceRetentionSettings(PutAppInstanceRetentionSettingsRequest.Builder().apply(block).build())

    /**
     * Registers an endpoint under an Amazon Chime AppInstanceUser. The endpoint receives messages for a user. For push notifications, the endpoint is a mobile device used to receive mobile push notifications for a user.
     */
    suspend fun registerAppInstanceUserEndpoint(input: RegisterAppInstanceUserEndpointRequest): RegisterAppInstanceUserEndpointResponse

    /**
     * Registers an endpoint under an Amazon Chime AppInstanceUser. The endpoint receives messages for a user. For push notifications, the endpoint is a mobile device used to receive mobile push notifications for a user.
     */
    suspend fun registerAppInstanceUserEndpoint(block: RegisterAppInstanceUserEndpointRequest.Builder.() -> Unit) = registerAppInstanceUserEndpoint(RegisterAppInstanceUserEndpointRequest.Builder().apply(block).build())

    /**
     * Applies the specified tags to the specified Amazon Chime SDK identity resource.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Applies the specified tags to the specified Amazon Chime SDK identity resource.
     */
    suspend fun tagResource(block: TagResourceRequest.Builder.() -> Unit) = tagResource(TagResourceRequest.Builder().apply(block).build())

    /**
     * Removes the specified tags from the specified Amazon Chime SDK identity resource.
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Removes the specified tags from the specified Amazon Chime SDK identity resource.
     */
    suspend fun untagResource(block: UntagResourceRequest.Builder.() -> Unit) = untagResource(UntagResourceRequest.Builder().apply(block).build())

    /**
     * Updates AppInstance metadata.
     */
    suspend fun updateAppInstance(input: UpdateAppInstanceRequest): UpdateAppInstanceResponse

    /**
     * Updates AppInstance metadata.
     */
    suspend fun updateAppInstance(block: UpdateAppInstanceRequest.Builder.() -> Unit) = updateAppInstance(UpdateAppInstanceRequest.Builder().apply(block).build())

    /**
     * Updates the details of an AppInstanceUser. You can update names and
     * metadata.
     */
    suspend fun updateAppInstanceUser(input: UpdateAppInstanceUserRequest): UpdateAppInstanceUserResponse

    /**
     * Updates the details of an AppInstanceUser. You can update names and
     * metadata.
     */
    suspend fun updateAppInstanceUser(block: UpdateAppInstanceUserRequest.Builder.() -> Unit) = updateAppInstanceUser(UpdateAppInstanceUserRequest.Builder().apply(block).build())

    /**
     * Updates the details of an AppInstanceUserEndpoint. You can update the name and AllowMessage values.
     */
    suspend fun updateAppInstanceUserEndpoint(input: UpdateAppInstanceUserEndpointRequest): UpdateAppInstanceUserEndpointResponse

    /**
     * Updates the details of an AppInstanceUserEndpoint. You can update the name and AllowMessage values.
     */
    suspend fun updateAppInstanceUserEndpoint(block: UpdateAppInstanceUserEndpointRequest.Builder.() -> Unit) = updateAppInstanceUserEndpoint(UpdateAppInstanceUserEndpointRequest.Builder().apply(block).build())
}
