// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chimesdkidentity.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Specifies the type of message that triggers a bot.
 */
public class InvokedBy private constructor(builder: Builder) {
    /**
     * Sets standard messages as the bot trigger. For standard messages:
     * + `ALL`: The bot processes all standard messages.
     * + `AUTO`: The bot responds to ALL messages when the channel has one other non-hidden member, and responds to MENTIONS when the channel has more than one other non-hidden member.
     * + `MENTIONS`: The bot processes all standard messages that have a message attribute with `CHIME.mentions` and a value of the bot ARN.
     * + `NONE`: The bot processes no standard messages.
     */
    public val standardMessages: aws.sdk.kotlin.services.chimesdkidentity.model.StandardMessages = requireNotNull(builder.standardMessages) { "A non-null value must be provided for standardMessages" }
    /**
     * Sets targeted messages as the bot trigger. For targeted messages:
     * + `ALL`: The bot processes all `TargetedMessages` sent to it. The bot then responds with a targeted message back to the sender.
     * + `NONE`: The bot processes no targeted messages.
     */
    public val targetedMessages: aws.sdk.kotlin.services.chimesdkidentity.model.TargetedMessages = requireNotNull(builder.targetedMessages) { "A non-null value must be provided for targetedMessages" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.chimesdkidentity.model.InvokedBy = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InvokedBy(")
        append("standardMessages=$standardMessages,")
        append("targetedMessages=$targetedMessages")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = standardMessages.hashCode()
        result = 31 * result + (targetedMessages.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InvokedBy

        if (standardMessages != other.standardMessages) return false
        if (targetedMessages != other.targetedMessages) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.chimesdkidentity.model.InvokedBy = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Sets standard messages as the bot trigger. For standard messages:
         * + `ALL`: The bot processes all standard messages.
         * + `AUTO`: The bot responds to ALL messages when the channel has one other non-hidden member, and responds to MENTIONS when the channel has more than one other non-hidden member.
         * + `MENTIONS`: The bot processes all standard messages that have a message attribute with `CHIME.mentions` and a value of the bot ARN.
         * + `NONE`: The bot processes no standard messages.
         */
        public var standardMessages: aws.sdk.kotlin.services.chimesdkidentity.model.StandardMessages? = null
        /**
         * Sets targeted messages as the bot trigger. For targeted messages:
         * + `ALL`: The bot processes all `TargetedMessages` sent to it. The bot then responds with a targeted message back to the sender.
         * + `NONE`: The bot processes no targeted messages.
         */
        public var targetedMessages: aws.sdk.kotlin.services.chimesdkidentity.model.TargetedMessages? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.chimesdkidentity.model.InvokedBy) : this() {
            this.standardMessages = x.standardMessages
            this.targetedMessages = x.targetedMessages
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.chimesdkidentity.model.InvokedBy = InvokedBy(this)

        internal fun correctErrors(): Builder {
            if (standardMessages == null) standardMessages = StandardMessages.SdkUnknown("no value provided")
            if (targetedMessages == null) targetedMessages = TargetedMessages.SdkUnknown("no value provided")
            return this
        }
    }
}
