// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chimesdkidentity.paginators

import aws.sdk.kotlin.services.chimesdkidentity.ChimeSdkIdentityClient
import aws.sdk.kotlin.services.chimesdkidentity.model.ListAppInstanceAdminsRequest
import aws.sdk.kotlin.services.chimesdkidentity.model.ListAppInstanceAdminsResponse
import aws.sdk.kotlin.services.chimesdkidentity.model.ListAppInstanceBotsRequest
import aws.sdk.kotlin.services.chimesdkidentity.model.ListAppInstanceBotsResponse
import aws.sdk.kotlin.services.chimesdkidentity.model.ListAppInstanceUserEndpointsRequest
import aws.sdk.kotlin.services.chimesdkidentity.model.ListAppInstanceUserEndpointsResponse
import aws.sdk.kotlin.services.chimesdkidentity.model.ListAppInstanceUsersRequest
import aws.sdk.kotlin.services.chimesdkidentity.model.ListAppInstanceUsersResponse
import aws.sdk.kotlin.services.chimesdkidentity.model.ListAppInstancesRequest
import aws.sdk.kotlin.services.chimesdkidentity.model.ListAppInstancesResponse
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow


/**
 * Paginate over [ListAppInstanceAdminsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAppInstanceAdminsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAppInstanceAdminsResponse]
 */
public fun ChimeSdkIdentityClient.listAppInstanceAdminsPaginated(initialRequest: ListAppInstanceAdminsRequest): Flow<ListAppInstanceAdminsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAppInstanceAdminsPaginated.listAppInstanceAdmins(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListAppInstanceAdminsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAppInstanceAdminsResponse]
 */
public fun ChimeSdkIdentityClient.listAppInstanceAdminsPaginated(block: ListAppInstanceAdminsRequest.Builder.() -> Unit): Flow<ListAppInstanceAdminsResponse> =
    listAppInstanceAdminsPaginated(ListAppInstanceAdminsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListAppInstanceBotsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAppInstanceBotsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAppInstanceBotsResponse]
 */
public fun ChimeSdkIdentityClient.listAppInstanceBotsPaginated(initialRequest: ListAppInstanceBotsRequest): Flow<ListAppInstanceBotsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAppInstanceBotsPaginated.listAppInstanceBots(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListAppInstanceBotsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAppInstanceBotsResponse]
 */
public fun ChimeSdkIdentityClient.listAppInstanceBotsPaginated(block: ListAppInstanceBotsRequest.Builder.() -> Unit): Flow<ListAppInstanceBotsResponse> =
    listAppInstanceBotsPaginated(ListAppInstanceBotsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListAppInstancesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAppInstancesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAppInstancesResponse]
 */
public fun ChimeSdkIdentityClient.listAppInstancesPaginated(initialRequest: ListAppInstancesRequest = ListAppInstancesRequest { }): Flow<ListAppInstancesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAppInstancesPaginated.listAppInstances(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListAppInstancesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAppInstancesResponse]
 */
public fun ChimeSdkIdentityClient.listAppInstancesPaginated(block: ListAppInstancesRequest.Builder.() -> Unit): Flow<ListAppInstancesResponse> =
    listAppInstancesPaginated(ListAppInstancesRequest.Builder().apply(block).build())

/**
 * Paginate over [ListAppInstanceUserEndpointsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAppInstanceUserEndpointsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAppInstanceUserEndpointsResponse]
 */
public fun ChimeSdkIdentityClient.listAppInstanceUserEndpointsPaginated(initialRequest: ListAppInstanceUserEndpointsRequest): Flow<ListAppInstanceUserEndpointsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAppInstanceUserEndpointsPaginated.listAppInstanceUserEndpoints(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListAppInstanceUserEndpointsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAppInstanceUserEndpointsResponse]
 */
public fun ChimeSdkIdentityClient.listAppInstanceUserEndpointsPaginated(block: ListAppInstanceUserEndpointsRequest.Builder.() -> Unit): Flow<ListAppInstanceUserEndpointsResponse> =
    listAppInstanceUserEndpointsPaginated(ListAppInstanceUserEndpointsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListAppInstanceUsersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAppInstanceUsersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAppInstanceUsersResponse]
 */
public fun ChimeSdkIdentityClient.listAppInstanceUsersPaginated(initialRequest: ListAppInstanceUsersRequest): Flow<ListAppInstanceUsersResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAppInstanceUsersPaginated.listAppInstanceUsers(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListAppInstanceUsersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAppInstanceUsersResponse]
 */
public fun ChimeSdkIdentityClient.listAppInstanceUsersPaginated(block: ListAppInstanceUsersRequest.Builder.() -> Unit): Flow<ListAppInstanceUsersResponse> =
    listAppInstanceUsersPaginated(ListAppInstanceUsersRequest.Builder().apply(block).build())
