// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chimesdkidentity.model



/**
 * The configuration for an Amazon Lex V2 bot.
 */
public class LexConfiguration private constructor(builder: Builder) {
    /**
     * Specifies the type of message that triggers a bot.
     */
    public val invokedBy: aws.sdk.kotlin.services.chimesdkidentity.model.InvokedBy? = builder.invokedBy
    /**
     * The ARN of the Amazon Lex V2 bot's alias. The ARN uses this format: `arn:aws:lex:REGION:ACCOUNT:bot-alias/MYBOTID/MYBOTALIAS`
     */
    public val lexBotAliasArn: kotlin.String = requireNotNull(builder.lexBotAliasArn) { "A non-null value must be provided for lexBotAliasArn" }
    /**
     * Identifies the Amazon Lex V2 bot's language and locale. The string must match one of the supported locales in Amazon Lex V2. All of the intents, slot types, and slots used in the bot must have the same locale. For more information, see [Supported languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html) in the *Amazon Lex V2 Developer Guide*.
     */
    public val localeId: kotlin.String = requireNotNull(builder.localeId) { "A non-null value must be provided for localeId" }
    /**
     * **Deprecated**. Use `InvokedBy` instead.
     *
     * Determines whether the Amazon Lex V2 bot responds to all standard messages. Control messages are not supported.
     */
    public val respondsTo: aws.sdk.kotlin.services.chimesdkidentity.model.RespondsTo? = builder.respondsTo
    /**
     * The name of the welcome intent configured in the Amazon Lex V2 bot.
     */
    public val welcomeIntent: kotlin.String? = builder.welcomeIntent

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.chimesdkidentity.model.LexConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LexConfiguration(")
        append("invokedBy=$invokedBy,")
        append("lexBotAliasArn=$lexBotAliasArn,")
        append("localeId=$localeId,")
        append("respondsTo=$respondsTo,")
        append("welcomeIntent=$welcomeIntent")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = invokedBy?.hashCode() ?: 0
        result = 31 * result + (lexBotAliasArn.hashCode())
        result = 31 * result + (localeId.hashCode())
        result = 31 * result + (respondsTo?.hashCode() ?: 0)
        result = 31 * result + (welcomeIntent?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LexConfiguration

        if (invokedBy != other.invokedBy) return false
        if (lexBotAliasArn != other.lexBotAliasArn) return false
        if (localeId != other.localeId) return false
        if (respondsTo != other.respondsTo) return false
        if (welcomeIntent != other.welcomeIntent) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.chimesdkidentity.model.LexConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies the type of message that triggers a bot.
         */
        public var invokedBy: aws.sdk.kotlin.services.chimesdkidentity.model.InvokedBy? = null
        /**
         * The ARN of the Amazon Lex V2 bot's alias. The ARN uses this format: `arn:aws:lex:REGION:ACCOUNT:bot-alias/MYBOTID/MYBOTALIAS`
         */
        public var lexBotAliasArn: kotlin.String? = null
        /**
         * Identifies the Amazon Lex V2 bot's language and locale. The string must match one of the supported locales in Amazon Lex V2. All of the intents, slot types, and slots used in the bot must have the same locale. For more information, see [Supported languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html) in the *Amazon Lex V2 Developer Guide*.
         */
        public var localeId: kotlin.String? = null
        /**
         * **Deprecated**. Use `InvokedBy` instead.
         *
         * Determines whether the Amazon Lex V2 bot responds to all standard messages. Control messages are not supported.
         */
        public var respondsTo: aws.sdk.kotlin.services.chimesdkidentity.model.RespondsTo? = null
        /**
         * The name of the welcome intent configured in the Amazon Lex V2 bot.
         */
        public var welcomeIntent: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.chimesdkidentity.model.LexConfiguration) : this() {
            this.invokedBy = x.invokedBy
            this.lexBotAliasArn = x.lexBotAliasArn
            this.localeId = x.localeId
            this.respondsTo = x.respondsTo
            this.welcomeIntent = x.welcomeIntent
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.chimesdkidentity.model.LexConfiguration = LexConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.chimesdkidentity.model.InvokedBy] inside the given [block]
         */
        public fun invokedBy(block: aws.sdk.kotlin.services.chimesdkidentity.model.InvokedBy.Builder.() -> kotlin.Unit) {
            this.invokedBy = aws.sdk.kotlin.services.chimesdkidentity.model.InvokedBy.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (lexBotAliasArn == null) lexBotAliasArn = ""
            if (localeId == null) localeId = ""
            return this
        }
    }
}
