// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chimesdkidentity

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.interceptors.AwsSpanInterceptor
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryHeaderMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.services.chimesdkidentity.auth.ChimeSdkIdentityAuthSchemeProviderAdapter
import aws.sdk.kotlin.services.chimesdkidentity.auth.ChimeSdkIdentityIdentityProviderConfigAdapter
import aws.sdk.kotlin.services.chimesdkidentity.endpoints.internal.EndpointResolverAdapter
import aws.sdk.kotlin.services.chimesdkidentity.model.*
import aws.sdk.kotlin.services.chimesdkidentity.serde.*
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.collections.attributesOf
import aws.smithy.kotlin.runtime.collections.putIfAbsent
import aws.smithy.kotlin.runtime.collections.putIfAbsentNotNull
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.SigV4AuthScheme
import aws.smithy.kotlin.runtime.http.operation.OperationAuthConfig
import aws.smithy.kotlin.runtime.http.operation.OperationMetrics
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.operation.telemetry
import aws.smithy.kotlin.runtime.io.SdkManagedGroup
import aws.smithy.kotlin.runtime.io.addIfManaged
import aws.smithy.kotlin.runtime.operation.ExecutionContext


public const val ServiceApiVersion: String = "2021-04-20"

internal class DefaultChimeSdkIdentityClient(override val config: ChimeSdkIdentityClient.Config) : ChimeSdkIdentityClient {
    private val managedResources = SdkManagedGroup()
    private val client = SdkHttpClient(config.httpClient)
    private val identityProviderConfig = ChimeSdkIdentityIdentityProviderConfigAdapter(config)
    private val configuredAuthSchemes = with(config.authSchemes.associateBy(AuthScheme::schemeId).toMutableMap()){
        getOrPut(AuthSchemeId.AwsSigV4){
            SigV4AuthScheme(DefaultAwsSigner, "chime")
        }
        toMap()
    }
    private val authSchemeAdapter = ChimeSdkIdentityAuthSchemeProviderAdapter(config)
    private val telemetryScope = "aws.sdk.kotlin.services.chimesdkidentity"
    private val opMetrics = OperationMetrics(telemetryScope, config.telemetryProvider)

    init {
        managedResources.addIfManaged(config.httpClient)
        managedResources.addIfManaged(config.credentialsProvider)
    }

    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion), config.applicationId)

    /**
     * Creates an Amazon Chime SDK messaging `AppInstance` under an AWS account. Only SDK messaging customers use this API. `CreateAppInstance` supports idempotency behavior as described in the AWS API Standard.
     *
     * identity
     */
    override suspend fun createAppInstance(input: CreateAppInstanceRequest): CreateAppInstanceResponse {
        val op = SdkHttpOperation.build<CreateAppInstanceRequest, CreateAppInstanceResponse> {
            serializer = CreateAppInstanceOperationSerializer()
            deserializer = CreateAppInstanceOperationDeserializer()
            operationName = "CreateAppInstance"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Promotes an `AppInstanceUser` or `AppInstanceBot` to an `AppInstanceAdmin`. The promoted entity can perform the following actions.
     * + `ChannelModerator` actions across all channels in the `AppInstance`.
     * + `DeleteChannelMessage` actions.
     *
     * Only an `AppInstanceUser` and `AppInstanceBot` can be promoted to an `AppInstanceAdmin` role.
     */
    override suspend fun createAppInstanceAdmin(input: CreateAppInstanceAdminRequest): CreateAppInstanceAdminResponse {
        val op = SdkHttpOperation.build<CreateAppInstanceAdminRequest, CreateAppInstanceAdminResponse> {
            serializer = CreateAppInstanceAdminOperationSerializer()
            deserializer = CreateAppInstanceAdminOperationDeserializer()
            operationName = "CreateAppInstanceAdmin"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a bot under an Amazon Chime `AppInstance`. The request consists of a unique `Configuration` and `Name` for that bot.
     */
    override suspend fun createAppInstanceBot(input: CreateAppInstanceBotRequest): CreateAppInstanceBotResponse {
        val op = SdkHttpOperation.build<CreateAppInstanceBotRequest, CreateAppInstanceBotResponse> {
            serializer = CreateAppInstanceBotOperationSerializer()
            deserializer = CreateAppInstanceBotOperationDeserializer()
            operationName = "CreateAppInstanceBot"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a user under an Amazon Chime `AppInstance`. The request consists of a unique `appInstanceUserId` and `Name` for that user.
     */
    override suspend fun createAppInstanceUser(input: CreateAppInstanceUserRequest): CreateAppInstanceUserResponse {
        val op = SdkHttpOperation.build<CreateAppInstanceUserRequest, CreateAppInstanceUserResponse> {
            serializer = CreateAppInstanceUserOperationSerializer()
            deserializer = CreateAppInstanceUserOperationDeserializer()
            operationName = "CreateAppInstanceUser"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an `AppInstance` and all associated data asynchronously.
     */
    override suspend fun deleteAppInstance(input: DeleteAppInstanceRequest): DeleteAppInstanceResponse {
        val op = SdkHttpOperation.build<DeleteAppInstanceRequest, DeleteAppInstanceResponse> {
            serializer = DeleteAppInstanceOperationSerializer()
            deserializer = DeleteAppInstanceOperationDeserializer()
            operationName = "DeleteAppInstance"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Demotes an `AppInstanceAdmin` to an `AppInstanceUser` or `AppInstanceBot`. This action does not delete the user.
     */
    override suspend fun deleteAppInstanceAdmin(input: DeleteAppInstanceAdminRequest): DeleteAppInstanceAdminResponse {
        val op = SdkHttpOperation.build<DeleteAppInstanceAdminRequest, DeleteAppInstanceAdminResponse> {
            serializer = DeleteAppInstanceAdminOperationSerializer()
            deserializer = DeleteAppInstanceAdminOperationDeserializer()
            operationName = "DeleteAppInstanceAdmin"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an `AppInstanceBot`.
     */
    override suspend fun deleteAppInstanceBot(input: DeleteAppInstanceBotRequest): DeleteAppInstanceBotResponse {
        val op = SdkHttpOperation.build<DeleteAppInstanceBotRequest, DeleteAppInstanceBotResponse> {
            serializer = DeleteAppInstanceBotOperationSerializer()
            deserializer = DeleteAppInstanceBotOperationDeserializer()
            operationName = "DeleteAppInstanceBot"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an `AppInstanceUser`.
     */
    override suspend fun deleteAppInstanceUser(input: DeleteAppInstanceUserRequest): DeleteAppInstanceUserResponse {
        val op = SdkHttpOperation.build<DeleteAppInstanceUserRequest, DeleteAppInstanceUserResponse> {
            serializer = DeleteAppInstanceUserOperationSerializer()
            deserializer = DeleteAppInstanceUserOperationDeserializer()
            operationName = "DeleteAppInstanceUser"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deregisters an `AppInstanceUserEndpoint`.
     */
    override suspend fun deregisterAppInstanceUserEndpoint(input: DeregisterAppInstanceUserEndpointRequest): DeregisterAppInstanceUserEndpointResponse {
        val op = SdkHttpOperation.build<DeregisterAppInstanceUserEndpointRequest, DeregisterAppInstanceUserEndpointResponse> {
            serializer = DeregisterAppInstanceUserEndpointOperationSerializer()
            deserializer = DeregisterAppInstanceUserEndpointOperationDeserializer()
            operationName = "DeregisterAppInstanceUserEndpoint"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the full details of an `AppInstance`.
     */
    override suspend fun describeAppInstance(input: DescribeAppInstanceRequest): DescribeAppInstanceResponse {
        val op = SdkHttpOperation.build<DescribeAppInstanceRequest, DescribeAppInstanceResponse> {
            serializer = DescribeAppInstanceOperationSerializer()
            deserializer = DescribeAppInstanceOperationDeserializer()
            operationName = "DescribeAppInstance"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the full details of an `AppInstanceAdmin`.
     */
    override suspend fun describeAppInstanceAdmin(input: DescribeAppInstanceAdminRequest): DescribeAppInstanceAdminResponse {
        val op = SdkHttpOperation.build<DescribeAppInstanceAdminRequest, DescribeAppInstanceAdminResponse> {
            serializer = DescribeAppInstanceAdminOperationSerializer()
            deserializer = DescribeAppInstanceAdminOperationDeserializer()
            operationName = "DescribeAppInstanceAdmin"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * The `AppInstanceBot's` information.
     */
    override suspend fun describeAppInstanceBot(input: DescribeAppInstanceBotRequest): DescribeAppInstanceBotResponse {
        val op = SdkHttpOperation.build<DescribeAppInstanceBotRequest, DescribeAppInstanceBotResponse> {
            serializer = DescribeAppInstanceBotOperationSerializer()
            deserializer = DescribeAppInstanceBotOperationDeserializer()
            operationName = "DescribeAppInstanceBot"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the full details of an `AppInstanceUser`.
     */
    override suspend fun describeAppInstanceUser(input: DescribeAppInstanceUserRequest): DescribeAppInstanceUserResponse {
        val op = SdkHttpOperation.build<DescribeAppInstanceUserRequest, DescribeAppInstanceUserResponse> {
            serializer = DescribeAppInstanceUserOperationSerializer()
            deserializer = DescribeAppInstanceUserOperationDeserializer()
            operationName = "DescribeAppInstanceUser"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the full details of an `AppInstanceUserEndpoint`.
     */
    override suspend fun describeAppInstanceUserEndpoint(input: DescribeAppInstanceUserEndpointRequest): DescribeAppInstanceUserEndpointResponse {
        val op = SdkHttpOperation.build<DescribeAppInstanceUserEndpointRequest, DescribeAppInstanceUserEndpointResponse> {
            serializer = DescribeAppInstanceUserEndpointOperationSerializer()
            deserializer = DescribeAppInstanceUserEndpointOperationDeserializer()
            operationName = "DescribeAppInstanceUserEndpoint"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets the retention settings for an `AppInstance`.
     */
    override suspend fun getAppInstanceRetentionSettings(input: GetAppInstanceRetentionSettingsRequest): GetAppInstanceRetentionSettingsResponse {
        val op = SdkHttpOperation.build<GetAppInstanceRetentionSettingsRequest, GetAppInstanceRetentionSettingsResponse> {
            serializer = GetAppInstanceRetentionSettingsOperationSerializer()
            deserializer = GetAppInstanceRetentionSettingsOperationDeserializer()
            operationName = "GetAppInstanceRetentionSettings"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of the administrators in the `AppInstance`.
     */
    override suspend fun listAppInstanceAdmins(input: ListAppInstanceAdminsRequest): ListAppInstanceAdminsResponse {
        val op = SdkHttpOperation.build<ListAppInstanceAdminsRequest, ListAppInstanceAdminsResponse> {
            serializer = ListAppInstanceAdminsOperationSerializer()
            deserializer = ListAppInstanceAdminsOperationDeserializer()
            operationName = "ListAppInstanceAdmins"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists all `AppInstanceBots` created under a single `AppInstance`.
     */
    override suspend fun listAppInstanceBots(input: ListAppInstanceBotsRequest): ListAppInstanceBotsResponse {
        val op = SdkHttpOperation.build<ListAppInstanceBotsRequest, ListAppInstanceBotsResponse> {
            serializer = ListAppInstanceBotsOperationSerializer()
            deserializer = ListAppInstanceBotsOperationDeserializer()
            operationName = "ListAppInstanceBots"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists all the `AppInstanceUserEndpoints` created under a single `AppInstanceUser`.
     */
    override suspend fun listAppInstanceUserEndpoints(input: ListAppInstanceUserEndpointsRequest): ListAppInstanceUserEndpointsResponse {
        val op = SdkHttpOperation.build<ListAppInstanceUserEndpointsRequest, ListAppInstanceUserEndpointsResponse> {
            serializer = ListAppInstanceUserEndpointsOperationSerializer()
            deserializer = ListAppInstanceUserEndpointsOperationDeserializer()
            operationName = "ListAppInstanceUserEndpoints"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * List all `AppInstanceUsers` created under a single `AppInstance`.
     */
    override suspend fun listAppInstanceUsers(input: ListAppInstanceUsersRequest): ListAppInstanceUsersResponse {
        val op = SdkHttpOperation.build<ListAppInstanceUsersRequest, ListAppInstanceUsersResponse> {
            serializer = ListAppInstanceUsersOperationSerializer()
            deserializer = ListAppInstanceUsersOperationDeserializer()
            operationName = "ListAppInstanceUsers"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists all Amazon Chime `AppInstance`s created under a single AWS account.
     */
    override suspend fun listAppInstances(input: ListAppInstancesRequest): ListAppInstancesResponse {
        val op = SdkHttpOperation.build<ListAppInstancesRequest, ListAppInstancesResponse> {
            serializer = ListAppInstancesOperationSerializer()
            deserializer = ListAppInstancesOperationDeserializer()
            operationName = "ListAppInstances"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the tags applied to an Amazon Chime SDK identity resource.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            operationName = "ListTagsForResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Sets the amount of time in days that a given `AppInstance` retains data.
     */
    override suspend fun putAppInstanceRetentionSettings(input: PutAppInstanceRetentionSettingsRequest): PutAppInstanceRetentionSettingsResponse {
        val op = SdkHttpOperation.build<PutAppInstanceRetentionSettingsRequest, PutAppInstanceRetentionSettingsResponse> {
            serializer = PutAppInstanceRetentionSettingsOperationSerializer()
            deserializer = PutAppInstanceRetentionSettingsOperationDeserializer()
            operationName = "PutAppInstanceRetentionSettings"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Sets the number of days before the `AppInstanceUser` is automatically deleted.
     *
     * A background process deletes expired `AppInstanceUsers` within 6 hours of expiration. Actual deletion times may vary.
     *
     * Expired `AppInstanceUsers` that have not yet been deleted appear as active, and you can update their expiration settings. The system honors the new settings.
     */
    override suspend fun putAppInstanceUserExpirationSettings(input: PutAppInstanceUserExpirationSettingsRequest): PutAppInstanceUserExpirationSettingsResponse {
        val op = SdkHttpOperation.build<PutAppInstanceUserExpirationSettingsRequest, PutAppInstanceUserExpirationSettingsResponse> {
            serializer = PutAppInstanceUserExpirationSettingsOperationSerializer()
            deserializer = PutAppInstanceUserExpirationSettingsOperationDeserializer()
            operationName = "PutAppInstanceUserExpirationSettings"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Registers an endpoint under an Amazon Chime `AppInstanceUser`. The endpoint receives messages for a user. For push notifications, the endpoint is a mobile device used to receive mobile push notifications for a user.
     */
    override suspend fun registerAppInstanceUserEndpoint(input: RegisterAppInstanceUserEndpointRequest): RegisterAppInstanceUserEndpointResponse {
        val op = SdkHttpOperation.build<RegisterAppInstanceUserEndpointRequest, RegisterAppInstanceUserEndpointResponse> {
            serializer = RegisterAppInstanceUserEndpointOperationSerializer()
            deserializer = RegisterAppInstanceUserEndpointOperationDeserializer()
            operationName = "RegisterAppInstanceUserEndpoint"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Applies the specified tags to the specified Amazon Chime SDK identity resource.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            operationName = "TagResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Removes the specified tags from the specified Amazon Chime SDK identity resource.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            operationName = "UntagResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates `AppInstance` metadata.
     */
    override suspend fun updateAppInstance(input: UpdateAppInstanceRequest): UpdateAppInstanceResponse {
        val op = SdkHttpOperation.build<UpdateAppInstanceRequest, UpdateAppInstanceResponse> {
            serializer = UpdateAppInstanceOperationSerializer()
            deserializer = UpdateAppInstanceOperationDeserializer()
            operationName = "UpdateAppInstance"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the name and metadata of an `AppInstanceBot`.
     */
    override suspend fun updateAppInstanceBot(input: UpdateAppInstanceBotRequest): UpdateAppInstanceBotResponse {
        val op = SdkHttpOperation.build<UpdateAppInstanceBotRequest, UpdateAppInstanceBotResponse> {
            serializer = UpdateAppInstanceBotOperationSerializer()
            deserializer = UpdateAppInstanceBotOperationDeserializer()
            operationName = "UpdateAppInstanceBot"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the details of an `AppInstanceUser`. You can update names and metadata.
     */
    override suspend fun updateAppInstanceUser(input: UpdateAppInstanceUserRequest): UpdateAppInstanceUserResponse {
        val op = SdkHttpOperation.build<UpdateAppInstanceUserRequest, UpdateAppInstanceUserResponse> {
            serializer = UpdateAppInstanceUserOperationSerializer()
            deserializer = UpdateAppInstanceUserOperationDeserializer()
            operationName = "UpdateAppInstanceUser"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the details of an `AppInstanceUserEndpoint`. You can update the name and `AllowMessage` values.
     */
    override suspend fun updateAppInstanceUserEndpoint(input: UpdateAppInstanceUserEndpointRequest): UpdateAppInstanceUserEndpointResponse {
        val op = SdkHttpOperation.build<UpdateAppInstanceUserEndpointRequest, UpdateAppInstanceUserEndpointResponse> {
            serializer = UpdateAppInstanceUserEndpointOperationSerializer()
            deserializer = UpdateAppInstanceUserEndpointOperationDeserializer()
            operationName = "UpdateAppInstanceUserEndpoint"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    override fun close() {
        managedResources.unshareAll()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsentNotNull(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ClientName, config.clientName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.logMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "chime")
        ctx.putIfAbsentNotNull(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
        ctx.putIfAbsentNotNull(SdkClientOption.IdempotencyTokenProvider, config.idempotencyTokenProvider)
    }
}
