// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chime

import aws.sdk.kotlin.runtime.auth.credentials.StaticCredentialsProvider
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.interceptors.AwsSpanInterceptor
import aws.sdk.kotlin.runtime.http.interceptors.businessmetrics.AwsBusinessMetric
import aws.sdk.kotlin.runtime.http.interceptors.businessmetrics.BusinessMetricsInterceptor
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryHeaderMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.services.chime.auth.ChimeAuthSchemeProviderAdapter
import aws.sdk.kotlin.services.chime.auth.ChimeIdentityProviderConfigAdapter
import aws.sdk.kotlin.services.chime.endpoints.internal.EndpointResolverAdapter
import aws.sdk.kotlin.services.chime.model.*
import aws.sdk.kotlin.services.chime.serde.*
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.awsprotocol.AwsAttributes
import aws.smithy.kotlin.runtime.businessmetrics.emitBusinessMetric
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.collections.attributesOf
import aws.smithy.kotlin.runtime.collections.putIfAbsent
import aws.smithy.kotlin.runtime.collections.putIfAbsentNotNull
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.SigV4AuthScheme
import aws.smithy.kotlin.runtime.http.operation.OperationAuthConfig
import aws.smithy.kotlin.runtime.http.operation.OperationMetrics
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.operation.telemetry
import aws.smithy.kotlin.runtime.io.SdkManagedGroup
import aws.smithy.kotlin.runtime.io.addIfManaged
import aws.smithy.kotlin.runtime.operation.ExecutionContext

internal class DefaultChimeClient(override val config: ChimeClient.Config) : ChimeClient {
    private val managedResources = SdkManagedGroup()
    private val client = SdkHttpClient(config.httpClient)
    private val identityProviderConfig = ChimeIdentityProviderConfigAdapter(config)
    private val configuredAuthSchemes = with(config.authSchemes.associateBy(AuthScheme::schemeId).toMutableMap()){
        getOrPut(AuthSchemeId.AwsSigV4){
            SigV4AuthScheme(DefaultAwsSigner, "chime")
        }
        toMap()
    }
    private val authSchemeAdapter = ChimeAuthSchemeProviderAdapter(config)
    private val telemetryScope = "aws.sdk.kotlin.services.chime"
    private val opMetrics = OperationMetrics(telemetryScope, config.telemetryProvider)

    init {
        managedResources.addIfManaged(config.httpClient)
        managedResources.addIfManaged(config.credentialsProvider)
    }

    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion), config.applicationId)

    /**
     * Associates a phone number with the specified Amazon Chime user.
     */
    override suspend fun associatePhoneNumberWithUser(input: AssociatePhoneNumberWithUserRequest): AssociatePhoneNumberWithUserResponse {
        val op = SdkHttpOperation.build<AssociatePhoneNumberWithUserRequest, AssociatePhoneNumberWithUserResponse> {
            serializeWith = AssociatePhoneNumberWithUserOperationSerializer()
            deserializeWith = AssociatePhoneNumberWithUserOperationDeserializer()
            operationName = "AssociatePhoneNumberWithUser"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Associates the specified sign-in delegate groups with the specified Amazon Chime account.
     */
    override suspend fun associateSigninDelegateGroupsWithAccount(input: AssociateSigninDelegateGroupsWithAccountRequest): AssociateSigninDelegateGroupsWithAccountResponse {
        val op = SdkHttpOperation.build<AssociateSigninDelegateGroupsWithAccountRequest, AssociateSigninDelegateGroupsWithAccountResponse> {
            serializeWith = AssociateSigninDelegateGroupsWithAccountOperationSerializer()
            deserializeWith = AssociateSigninDelegateGroupsWithAccountOperationDeserializer()
            operationName = "AssociateSigninDelegateGroupsWithAccount"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Adds up to 50 members to a chat room in an Amazon Chime Enterprise account. Members can be users or bots. The member role designates whether the member is a chat room administrator or a general chat room member.
     */
    override suspend fun batchCreateRoomMembership(input: BatchCreateRoomMembershipRequest): BatchCreateRoomMembershipResponse {
        val op = SdkHttpOperation.build<BatchCreateRoomMembershipRequest, BatchCreateRoomMembershipResponse> {
            serializeWith = BatchCreateRoomMembershipOperationSerializer()
            deserializeWith = BatchCreateRoomMembershipOperationDeserializer()
            operationName = "BatchCreateRoomMembership"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Moves phone numbers into the **Deletion queue**. Phone numbers must be disassociated from any users or Amazon Chime Voice Connectors before they can be deleted.
     *
     *  Phone numbers remain in the **Deletion queue** for 7 days before they are deleted permanently.
     */
    override suspend fun batchDeletePhoneNumber(input: BatchDeletePhoneNumberRequest): BatchDeletePhoneNumberResponse {
        val op = SdkHttpOperation.build<BatchDeletePhoneNumberRequest, BatchDeletePhoneNumberResponse> {
            serializeWith = BatchDeletePhoneNumberOperationSerializer()
            deserializeWith = BatchDeletePhoneNumberOperationDeserializer()
            operationName = "BatchDeletePhoneNumber"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Suspends up to 50 users from a `Team` or `EnterpriseLWA` Amazon Chime account. For more information about different account types, see [Managing Your Amazon Chime Accounts](https://docs.aws.amazon.com/chime/latest/ag/manage-chime-account.html) in the *Amazon Chime Administration Guide*.
     *
     * Users suspended from a `Team` account are disassociated from the account,but they can continue to use Amazon Chime as free users. To remove the suspension from suspended `Team` account users, invite them to the `Team` account again. You can use the InviteUsers action to do so.
     *
     * Users suspended from an `EnterpriseLWA` account are immediately signed out of Amazon Chime and can no longer sign in. To remove the suspension from suspended `EnterpriseLWA` account users, use the BatchUnsuspendUser action.
     *
     *  To sign out users without suspending them, use the LogoutUser action.
     */
    override suspend fun batchSuspendUser(input: BatchSuspendUserRequest): BatchSuspendUserResponse {
        val op = SdkHttpOperation.build<BatchSuspendUserRequest, BatchSuspendUserResponse> {
            serializeWith = BatchSuspendUserOperationSerializer()
            deserializeWith = BatchSuspendUserOperationDeserializer()
            operationName = "BatchSuspendUser"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Removes the suspension from up to 50 previously suspended users for the specified Amazon Chime `EnterpriseLWA` account. Only users on `EnterpriseLWA` accounts can be unsuspended using this action. For more information about different account types, see [ Managing Your Amazon Chime Accounts ](https://docs.aws.amazon.com/chime/latest/ag/manage-chime-account.html) in the account types, in the *Amazon Chime Administration Guide*.
     *
     * Previously suspended users who are unsuspended using this action are returned to `Registered` status. Users who are not previously suspended are ignored.
     */
    override suspend fun batchUnsuspendUser(input: BatchUnsuspendUserRequest): BatchUnsuspendUserResponse {
        val op = SdkHttpOperation.build<BatchUnsuspendUserRequest, BatchUnsuspendUserResponse> {
            serializeWith = BatchUnsuspendUserOperationSerializer()
            deserializeWith = BatchUnsuspendUserOperationDeserializer()
            operationName = "BatchUnsuspendUser"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates phone number product types or calling names. You can update one attribute at a time for each `UpdatePhoneNumberRequestItem`. For example, you can update the product type or the calling name.
     *
     * For toll-free numbers, you cannot use the Amazon Chime Business Calling product type. For numbers outside the U.S., you must use the Amazon Chime SIP Media Application Dial-In product type.
     *
     * Updates to outbound calling names can take up to 72 hours to complete. Pending updates to outbound calling names must be complete before you can request another update.
     */
    override suspend fun batchUpdatePhoneNumber(input: BatchUpdatePhoneNumberRequest): BatchUpdatePhoneNumberResponse {
        val op = SdkHttpOperation.build<BatchUpdatePhoneNumberRequest, BatchUpdatePhoneNumberResponse> {
            serializeWith = BatchUpdatePhoneNumberOperationSerializer()
            deserializeWith = BatchUpdatePhoneNumberOperationDeserializer()
            operationName = "BatchUpdatePhoneNumber"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates user details within the UpdateUserRequestItem object for up to 20 users for the specified Amazon Chime account. Currently, only `LicenseType` updates are supported for this action.
     */
    override suspend fun batchUpdateUser(input: BatchUpdateUserRequest): BatchUpdateUserResponse {
        val op = SdkHttpOperation.build<BatchUpdateUserRequest, BatchUpdateUserResponse> {
            serializeWith = BatchUpdateUserOperationSerializer()
            deserializeWith = BatchUpdateUserOperationDeserializer()
            operationName = "BatchUpdateUser"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates an Amazon Chime account under the administrator's AWS account. Only `Team` account types are currently supported for this action. For more information about different account types, see [Managing Your Amazon Chime Accounts](https://docs.aws.amazon.com/chime/latest/ag/manage-chime-account.html) in the *Amazon Chime Administration Guide*.
     */
    override suspend fun createAccount(input: CreateAccountRequest): CreateAccountResponse {
        val op = SdkHttpOperation.build<CreateAccountRequest, CreateAccountResponse> {
            serializeWith = CreateAccountOperationSerializer()
            deserializeWith = CreateAccountOperationDeserializer()
            operationName = "CreateAccount"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a bot for an Amazon Chime Enterprise account.
     */
    override suspend fun createBot(input: CreateBotRequest): CreateBotResponse {
        val op = SdkHttpOperation.build<CreateBotRequest, CreateBotResponse> {
            serializeWith = CreateBotOperationSerializer()
            deserializeWith = CreateBotOperationDeserializer()
            operationName = "CreateBot"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Uses the join token and call metadata in a meeting request (From number, To number, and so forth) to initiate an outbound call to a public switched telephone network (PSTN) and join them into a Chime meeting. Also ensures that the From number belongs to the customer.
     *
     * To play welcome audio or implement an interactive voice response (IVR), use the `CreateSipMediaApplicationCall` action with the corresponding SIP media application ID.
     *
     * **This API is not available in a dedicated namespace.**
     */
    override suspend fun createMeetingDialOut(input: CreateMeetingDialOutRequest): CreateMeetingDialOutResponse {
        val op = SdkHttpOperation.build<CreateMeetingDialOutRequest, CreateMeetingDialOutResponse> {
            serializeWith = CreateMeetingDialOutOperationSerializer()
            deserializeWith = CreateMeetingDialOutOperationDeserializer()
            operationName = "CreateMeetingDialOut"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates an order for phone numbers to be provisioned. For toll-free numbers, you cannot use the Amazon Chime Business Calling product type. For numbers outside the U.S., you must use the Amazon Chime SIP Media Application Dial-In product type.
     */
    override suspend fun createPhoneNumberOrder(input: CreatePhoneNumberOrderRequest): CreatePhoneNumberOrderResponse {
        val op = SdkHttpOperation.build<CreatePhoneNumberOrderRequest, CreatePhoneNumberOrderResponse> {
            serializeWith = CreatePhoneNumberOrderOperationSerializer()
            deserializeWith = CreatePhoneNumberOrderOperationDeserializer()
            operationName = "CreatePhoneNumberOrder"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a chat room for the specified Amazon Chime Enterprise account.
     */
    override suspend fun createRoom(input: CreateRoomRequest): CreateRoomResponse {
        val op = SdkHttpOperation.build<CreateRoomRequest, CreateRoomResponse> {
            serializeWith = CreateRoomOperationSerializer()
            deserializeWith = CreateRoomOperationDeserializer()
            operationName = "CreateRoom"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Adds a member to a chat room in an Amazon Chime Enterprise account. A member can be either a user or a bot. The member role designates whether the member is a chat room administrator or a general chat room member.
     */
    override suspend fun createRoomMembership(input: CreateRoomMembershipRequest): CreateRoomMembershipResponse {
        val op = SdkHttpOperation.build<CreateRoomMembershipRequest, CreateRoomMembershipResponse> {
            serializeWith = CreateRoomMembershipOperationSerializer()
            deserializeWith = CreateRoomMembershipOperationDeserializer()
            operationName = "CreateRoomMembership"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a user under the specified Amazon Chime account.
     */
    override suspend fun createUser(input: CreateUserRequest): CreateUserResponse {
        val op = SdkHttpOperation.build<CreateUserRequest, CreateUserResponse> {
            serializeWith = CreateUserOperationSerializer()
            deserializeWith = CreateUserOperationDeserializer()
            operationName = "CreateUser"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified Amazon Chime account. You must suspend all users before deleting `Team` account. You can use the BatchSuspendUser action to dodo.
     *
     * For `EnterpriseLWA` and `EnterpriseAD` accounts, you must release the claimed domains for your Amazon Chime account before deletion. As soon as you release the domain, all users under that account are suspended.
     *
     * Deleted accounts appear in your `Disabled` accounts list for 90 days. To restore deleted account from your `Disabled` accounts list, you must contact AWS Support.
     *
     * After 90 days, deleted accounts are permanently removed from your `Disabled` accounts list.
     */
    override suspend fun deleteAccount(input: DeleteAccountRequest): DeleteAccountResponse {
        val op = SdkHttpOperation.build<DeleteAccountRequest, DeleteAccountResponse> {
            serializeWith = DeleteAccountOperationSerializer()
            deserializeWith = DeleteAccountOperationDeserializer()
            operationName = "DeleteAccount"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the events configuration that allows a bot to receive outgoing events.
     */
    override suspend fun deleteEventsConfiguration(input: DeleteEventsConfigurationRequest): DeleteEventsConfigurationResponse {
        val op = SdkHttpOperation.build<DeleteEventsConfigurationRequest, DeleteEventsConfigurationResponse> {
            serializeWith = DeleteEventsConfigurationOperationSerializer()
            deserializeWith = DeleteEventsConfigurationOperationDeserializer()
            operationName = "DeleteEventsConfiguration"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Moves the specified phone number into the **Deletion queue**. A phone number must be disassociated from any users or Amazon Chime Voice Connectors before it can be deleted.
     *
     * Deleted phone numbers remain in the **Deletion queue** for 7 days before they are deleted permanently.
     */
    override suspend fun deletePhoneNumber(input: DeletePhoneNumberRequest): DeletePhoneNumberResponse {
        val op = SdkHttpOperation.build<DeletePhoneNumberRequest, DeletePhoneNumberResponse> {
            serializeWith = DeletePhoneNumberOperationSerializer()
            deserializeWith = DeletePhoneNumberOperationDeserializer()
            operationName = "DeletePhoneNumber"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a chat room in an Amazon Chime Enterprise account.
     */
    override suspend fun deleteRoom(input: DeleteRoomRequest): DeleteRoomResponse {
        val op = SdkHttpOperation.build<DeleteRoomRequest, DeleteRoomResponse> {
            serializeWith = DeleteRoomOperationSerializer()
            deserializeWith = DeleteRoomOperationDeserializer()
            operationName = "DeleteRoom"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Removes a member from a chat room in an Amazon Chime Enterprise account.
     */
    override suspend fun deleteRoomMembership(input: DeleteRoomMembershipRequest): DeleteRoomMembershipResponse {
        val op = SdkHttpOperation.build<DeleteRoomMembershipRequest, DeleteRoomMembershipResponse> {
            serializeWith = DeleteRoomMembershipOperationSerializer()
            deserializeWith = DeleteRoomMembershipOperationDeserializer()
            operationName = "DeleteRoomMembership"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates the primary provisioned phone number from the specified Amazon Chime user.
     */
    override suspend fun disassociatePhoneNumberFromUser(input: DisassociatePhoneNumberFromUserRequest): DisassociatePhoneNumberFromUserResponse {
        val op = SdkHttpOperation.build<DisassociatePhoneNumberFromUserRequest, DisassociatePhoneNumberFromUserResponse> {
            serializeWith = DisassociatePhoneNumberFromUserOperationSerializer()
            deserializeWith = DisassociatePhoneNumberFromUserOperationDeserializer()
            operationName = "DisassociatePhoneNumberFromUser"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates the specified sign-in delegate groups from the specified Amazon Chime account.
     */
    override suspend fun disassociateSigninDelegateGroupsFromAccount(input: DisassociateSigninDelegateGroupsFromAccountRequest): DisassociateSigninDelegateGroupsFromAccountResponse {
        val op = SdkHttpOperation.build<DisassociateSigninDelegateGroupsFromAccountRequest, DisassociateSigninDelegateGroupsFromAccountResponse> {
            serializeWith = DisassociateSigninDelegateGroupsFromAccountOperationSerializer()
            deserializeWith = DisassociateSigninDelegateGroupsFromAccountOperationDeserializer()
            operationName = "DisassociateSigninDelegateGroupsFromAccount"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves details for the specified Amazon Chime account, such as account type and supported licenses.
     */
    override suspend fun getAccount(input: GetAccountRequest): GetAccountResponse {
        val op = SdkHttpOperation.build<GetAccountRequest, GetAccountResponse> {
            serializeWith = GetAccountOperationSerializer()
            deserializeWith = GetAccountOperationDeserializer()
            operationName = "GetAccount"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves account settings for the specified Amazon Chime account ID, such as remote control and dialout settings. For more information about these settings, see [Use the Policies Page](https://docs.aws.amazon.com/chime/latest/ag/policies.html) in the *Amazon Chime Administration Guide*.
     */
    override suspend fun getAccountSettings(input: GetAccountSettingsRequest): GetAccountSettingsResponse {
        val op = SdkHttpOperation.build<GetAccountSettingsRequest, GetAccountSettingsResponse> {
            serializeWith = GetAccountSettingsOperationSerializer()
            deserializeWith = GetAccountSettingsOperationDeserializer()
            operationName = "GetAccountSettings"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves details for the specified bot, such as bot email address, bot type, status, and display name.
     */
    override suspend fun getBot(input: GetBotRequest): GetBotResponse {
        val op = SdkHttpOperation.build<GetBotRequest, GetBotResponse> {
            serializeWith = GetBotOperationSerializer()
            deserializeWith = GetBotOperationDeserializer()
            operationName = "GetBot"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets details for an events configuration that allows a bot to receive outgoing events, such as an HTTPS endpoint or Lambda function ARN.
     */
    override suspend fun getEventsConfiguration(input: GetEventsConfigurationRequest): GetEventsConfigurationResponse {
        val op = SdkHttpOperation.build<GetEventsConfigurationRequest, GetEventsConfigurationResponse> {
            serializeWith = GetEventsConfigurationOperationSerializer()
            deserializeWith = GetEventsConfigurationOperationDeserializer()
            operationName = "GetEventsConfiguration"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves global settings for the administrator's AWS account, such as Amazon Chime Business Calling and Amazon Chime Voice Connector settings.
     */
    override suspend fun getGlobalSettings(input: GetGlobalSettingsRequest): GetGlobalSettingsResponse {
        val op = SdkHttpOperation.build<GetGlobalSettingsRequest, GetGlobalSettingsResponse> {
            serializeWith = GetGlobalSettingsOperationSerializer()
            deserializeWith = GetGlobalSettingsOperationDeserializer()
            operationName = "GetGlobalSettings"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves details for the specified phone number ID, such as associations, capabilities, and product type.
     */
    override suspend fun getPhoneNumber(input: GetPhoneNumberRequest): GetPhoneNumberResponse {
        val op = SdkHttpOperation.build<GetPhoneNumberRequest, GetPhoneNumberResponse> {
            serializeWith = GetPhoneNumberOperationSerializer()
            deserializeWith = GetPhoneNumberOperationDeserializer()
            operationName = "GetPhoneNumber"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves details for the specified phone number order, such as the order creation timestamp, phone numbers in E.164 format, product type, and order status.
     */
    override suspend fun getPhoneNumberOrder(input: GetPhoneNumberOrderRequest): GetPhoneNumberOrderResponse {
        val op = SdkHttpOperation.build<GetPhoneNumberOrderRequest, GetPhoneNumberOrderResponse> {
            serializeWith = GetPhoneNumberOrderOperationSerializer()
            deserializeWith = GetPhoneNumberOrderOperationDeserializer()
            operationName = "GetPhoneNumberOrder"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the phone number settings for the administrator's AWS account, such as the default outbound calling name.
     */
    override suspend fun getPhoneNumberSettings(input: GetPhoneNumberSettingsRequest): GetPhoneNumberSettingsResponse {
        val op = SdkHttpOperation.build<GetPhoneNumberSettingsRequest, GetPhoneNumberSettingsResponse> {
            serializeWith = GetPhoneNumberSettingsOperationSerializer()
            deserializeWith = GetPhoneNumberSettingsOperationDeserializer()
            operationName = "GetPhoneNumberSettings"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets the retention settings for the specified Amazon Chime Enterprise account. For more information about retention settings, see [Managing Chat Retention Policies](https://docs.aws.amazon.com/chime/latest/ag/chat-retention.html) in the *Amazon Chime Administration Guide*.
     */
    override suspend fun getRetentionSettings(input: GetRetentionSettingsRequest): GetRetentionSettingsResponse {
        val op = SdkHttpOperation.build<GetRetentionSettingsRequest, GetRetentionSettingsResponse> {
            serializeWith = GetRetentionSettingsOperationSerializer()
            deserializeWith = GetRetentionSettingsOperationDeserializer()
            operationName = "GetRetentionSettings"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves room details, such as the room name, for a room in an Amazon Chime Enterprise account.
     */
    override suspend fun getRoom(input: GetRoomRequest): GetRoomResponse {
        val op = SdkHttpOperation.build<GetRoomRequest, GetRoomResponse> {
            serializeWith = GetRoomOperationSerializer()
            deserializeWith = GetRoomOperationDeserializer()
            operationName = "GetRoom"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves details for the specified user ID, such as primary email address, license type,and personal meeting PIN.
     *
     *  To retrieve user details with an email address instead of a user ID, use the ListUsers action, and then filter by email address.
     */
    override suspend fun getUser(input: GetUserRequest): GetUserResponse {
        val op = SdkHttpOperation.build<GetUserRequest, GetUserResponse> {
            serializeWith = GetUserOperationSerializer()
            deserializeWith = GetUserOperationDeserializer()
            operationName = "GetUser"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves settings for the specified user ID, such as any associated phone number settings.
     */
    override suspend fun getUserSettings(input: GetUserSettingsRequest): GetUserSettingsResponse {
        val op = SdkHttpOperation.build<GetUserSettingsRequest, GetUserSettingsResponse> {
            serializeWith = GetUserSettingsOperationSerializer()
            deserializeWith = GetUserSettingsOperationDeserializer()
            operationName = "GetUserSettings"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Sends email to a maximum of 50 users, inviting them to the specified Amazon Chime `Team` account. Only `Team` account types are currently supported for this action.
     */
    override suspend fun inviteUsers(input: InviteUsersRequest): InviteUsersResponse {
        val op = SdkHttpOperation.build<InviteUsersRequest, InviteUsersResponse> {
            serializeWith = InviteUsersOperationSerializer()
            deserializeWith = InviteUsersOperationDeserializer()
            operationName = "InviteUsers"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the Amazon Chime accounts under the administrator's AWS account. You can filter accounts by account name prefix. To find out which Amazon Chime account a user belongs to, you can filter by the user's email address, which returns one account result.
     */
    override suspend fun listAccounts(input: ListAccountsRequest): ListAccountsResponse {
        val op = SdkHttpOperation.build<ListAccountsRequest, ListAccountsResponse> {
            serializeWith = ListAccountsOperationSerializer()
            deserializeWith = ListAccountsOperationDeserializer()
            operationName = "ListAccounts"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the bots associated with the administrator's Amazon Chime Enterprise account ID.
     */
    override suspend fun listBots(input: ListBotsRequest): ListBotsResponse {
        val op = SdkHttpOperation.build<ListBotsRequest, ListBotsResponse> {
            serializeWith = ListBotsOperationSerializer()
            deserializeWith = ListBotsOperationDeserializer()
            operationName = "ListBots"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the phone number orders for the administrator's Amazon Chime account.
     */
    override suspend fun listPhoneNumberOrders(input: ListPhoneNumberOrdersRequest): ListPhoneNumberOrdersResponse {
        val op = SdkHttpOperation.build<ListPhoneNumberOrdersRequest, ListPhoneNumberOrdersResponse> {
            serializeWith = ListPhoneNumberOrdersOperationSerializer()
            deserializeWith = ListPhoneNumberOrdersOperationDeserializer()
            operationName = "ListPhoneNumberOrders"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the phone numbers for the specified Amazon Chime account, Amazon Chime user, Amazon Chime Voice Connector, or Amazon Chime Voice Connector group.
     */
    override suspend fun listPhoneNumbers(input: ListPhoneNumbersRequest): ListPhoneNumbersResponse {
        val op = SdkHttpOperation.build<ListPhoneNumbersRequest, ListPhoneNumbersResponse> {
            serializeWith = ListPhoneNumbersOperationSerializer()
            deserializeWith = ListPhoneNumbersOperationDeserializer()
            operationName = "ListPhoneNumbers"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the membership details for the specified room in an Amazon Chime Enterprise account, such as the members' IDs, email addresses, and names.
     */
    override suspend fun listRoomMemberships(input: ListRoomMembershipsRequest): ListRoomMembershipsResponse {
        val op = SdkHttpOperation.build<ListRoomMembershipsRequest, ListRoomMembershipsResponse> {
            serializeWith = ListRoomMembershipsOperationSerializer()
            deserializeWith = ListRoomMembershipsOperationDeserializer()
            operationName = "ListRoomMemberships"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the room details for the specified Amazon Chime Enterprise account. Optionally, filter the results by a member ID (user ID or bot ID) to see a list of rooms that the member belongs to.
     */
    override suspend fun listRooms(input: ListRoomsRequest): ListRoomsResponse {
        val op = SdkHttpOperation.build<ListRoomsRequest, ListRoomsResponse> {
            serializeWith = ListRoomsOperationSerializer()
            deserializeWith = ListRoomsOperationDeserializer()
            operationName = "ListRooms"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists supported phone number countries.
     */
    override suspend fun listSupportedPhoneNumberCountries(input: ListSupportedPhoneNumberCountriesRequest): ListSupportedPhoneNumberCountriesResponse {
        val op = SdkHttpOperation.build<ListSupportedPhoneNumberCountriesRequest, ListSupportedPhoneNumberCountriesResponse> {
            serializeWith = ListSupportedPhoneNumberCountriesOperationSerializer()
            deserializeWith = ListSupportedPhoneNumberCountriesOperationDeserializer()
            operationName = "ListSupportedPhoneNumberCountries"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the users that belong to the specified Amazon Chime account. You can specify an email address to list only the user that the email address belongs to.
     */
    override suspend fun listUsers(input: ListUsersRequest): ListUsersResponse {
        val op = SdkHttpOperation.build<ListUsersRequest, ListUsersResponse> {
            serializeWith = ListUsersOperationSerializer()
            deserializeWith = ListUsersOperationDeserializer()
            operationName = "ListUsers"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Logs out the specified user from all of the devices they are currently logged into.
     */
    override suspend fun logoutUser(input: LogoutUserRequest): LogoutUserResponse {
        val op = SdkHttpOperation.build<LogoutUserRequest, LogoutUserResponse> {
            serializeWith = LogoutUserOperationSerializer()
            deserializeWith = LogoutUserOperationDeserializer()
            operationName = "LogoutUser"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates an events configuration that allows a bot to receive outgoing events sent by Amazon Chime. Choose either an HTTPS endpoint or a Lambda function ARN. For more information, see Bot.
     */
    override suspend fun putEventsConfiguration(input: PutEventsConfigurationRequest): PutEventsConfigurationResponse {
        val op = SdkHttpOperation.build<PutEventsConfigurationRequest, PutEventsConfigurationResponse> {
            serializeWith = PutEventsConfigurationOperationSerializer()
            deserializeWith = PutEventsConfigurationOperationDeserializer()
            operationName = "PutEventsConfiguration"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Puts retention settings for the specified Amazon Chime Enterprise account. We recommend using AWS CloudTrail to monitor usage of this API for your account. For more information, see [Logging Amazon Chime API Calls with AWS CloudTrail](https://docs.aws.amazon.com/chime/latest/ag/cloudtrail.html) in the *Amazon Chime Administration Guide*.
     *
     *  To turn off existing retention settings, remove the number of days from the corresponding **RetentionDays** field in the **RetentionSettings** object. For more information about retention settings, see [Managing Chat Retention Policies](https://docs.aws.amazon.com/chime/latest/ag/chat-retention.html) in the *Amazon Chime Administration Guide*.
     */
    override suspend fun putRetentionSettings(input: PutRetentionSettingsRequest): PutRetentionSettingsResponse {
        val op = SdkHttpOperation.build<PutRetentionSettingsRequest, PutRetentionSettingsResponse> {
            serializeWith = PutRetentionSettingsOperationSerializer()
            deserializeWith = PutRetentionSettingsOperationDeserializer()
            operationName = "PutRetentionSettings"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Redacts the specified message from the specified Amazon Chime conversation.
     */
    override suspend fun redactConversationMessage(input: RedactConversationMessageRequest): RedactConversationMessageResponse {
        val op = SdkHttpOperation.build<RedactConversationMessageRequest, RedactConversationMessageResponse> {
            serializeWith = RedactConversationMessageOperationSerializer()
            deserializeWith = RedactConversationMessageOperationDeserializer()
            operationName = "RedactConversationMessage"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Redacts the specified message from the specified Amazon Chime channel.
     */
    override suspend fun redactRoomMessage(input: RedactRoomMessageRequest): RedactRoomMessageResponse {
        val op = SdkHttpOperation.build<RedactRoomMessageRequest, RedactRoomMessageResponse> {
            serializeWith = RedactRoomMessageOperationSerializer()
            deserializeWith = RedactRoomMessageOperationDeserializer()
            operationName = "RedactRoomMessage"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Regenerates the security token for a bot.
     */
    override suspend fun regenerateSecurityToken(input: RegenerateSecurityTokenRequest): RegenerateSecurityTokenResponse {
        val op = SdkHttpOperation.build<RegenerateSecurityTokenRequest, RegenerateSecurityTokenResponse> {
            serializeWith = RegenerateSecurityTokenOperationSerializer()
            deserializeWith = RegenerateSecurityTokenOperationDeserializer()
            operationName = "RegenerateSecurityToken"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Resets the personal meeting PIN for the specified user on an Amazon Chime account. Returns the User object with the updated personal meeting PIN.
     */
    override suspend fun resetPersonalPin(input: ResetPersonalPinRequest): ResetPersonalPinResponse {
        val op = SdkHttpOperation.build<ResetPersonalPinRequest, ResetPersonalPinResponse> {
            serializeWith = ResetPersonalPINOperationSerializer()
            deserializeWith = ResetPersonalPINOperationDeserializer()
            operationName = "ResetPersonalPIN"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Moves a phone number from the **Deletion queue** back into the phone number **Inventory**.
     */
    override suspend fun restorePhoneNumber(input: RestorePhoneNumberRequest): RestorePhoneNumberResponse {
        val op = SdkHttpOperation.build<RestorePhoneNumberRequest, RestorePhoneNumberResponse> {
            serializeWith = RestorePhoneNumberOperationSerializer()
            deserializeWith = RestorePhoneNumberOperationDeserializer()
            operationName = "RestorePhoneNumber"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Searches for phone numbers that can be ordered. For US numbers, provide at least one of the following search filters: `AreaCode`, `City`, `State`, or `TollFreePrefix`. If you provide `City`, you must also provide `State`. Numbers outside the US only support the `PhoneNumberType` filter, which you must use.
     */
    override suspend fun searchAvailablePhoneNumbers(input: SearchAvailablePhoneNumbersRequest): SearchAvailablePhoneNumbersResponse {
        val op = SdkHttpOperation.build<SearchAvailablePhoneNumbersRequest, SearchAvailablePhoneNumbersResponse> {
            serializeWith = SearchAvailablePhoneNumbersOperationSerializer()
            deserializeWith = SearchAvailablePhoneNumbersOperationDeserializer()
            operationName = "SearchAvailablePhoneNumbers"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates account details for the specified Amazon Chime account. Currently, only account name and default license updates are supported for this action.
     */
    override suspend fun updateAccount(input: UpdateAccountRequest): UpdateAccountResponse {
        val op = SdkHttpOperation.build<UpdateAccountRequest, UpdateAccountResponse> {
            serializeWith = UpdateAccountOperationSerializer()
            deserializeWith = UpdateAccountOperationDeserializer()
            operationName = "UpdateAccount"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the settings for the specified Amazon Chime account. You can update settings for remote control of shared screens, or for the dial-out option. For more information about these settings, see [Use the Policies Page](https://docs.aws.amazon.com/chime/latest/ag/policies.html) in the *Amazon Chime Administration Guide*.
     */
    override suspend fun updateAccountSettings(input: UpdateAccountSettingsRequest): UpdateAccountSettingsResponse {
        val op = SdkHttpOperation.build<UpdateAccountSettingsRequest, UpdateAccountSettingsResponse> {
            serializeWith = UpdateAccountSettingsOperationSerializer()
            deserializeWith = UpdateAccountSettingsOperationDeserializer()
            operationName = "UpdateAccountSettings"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the status of the specified bot, such as starting or stopping the bot from running in your Amazon Chime Enterprise account.
     */
    override suspend fun updateBot(input: UpdateBotRequest): UpdateBotResponse {
        val op = SdkHttpOperation.build<UpdateBotRequest, UpdateBotResponse> {
            serializeWith = UpdateBotOperationSerializer()
            deserializeWith = UpdateBotOperationDeserializer()
            operationName = "UpdateBot"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates global settings for the administrator's AWS account, such as Amazon Chime Business Calling and Amazon Chime Voice Connector settings.
     */
    override suspend fun updateGlobalSettings(input: UpdateGlobalSettingsRequest): UpdateGlobalSettingsResponse {
        val op = SdkHttpOperation.build<UpdateGlobalSettingsRequest, UpdateGlobalSettingsResponse> {
            serializeWith = UpdateGlobalSettingsOperationSerializer()
            deserializeWith = UpdateGlobalSettingsOperationDeserializer()
            operationName = "UpdateGlobalSettings"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates phone number details, such as product type or calling name, for the specified phone number ID. You can update one phone number detail at a time. For example, you can update either the product type or the calling name in one action.
     *
     * For toll-free numbers, you cannot use the Amazon Chime Business Calling product type. For numbers outside the U.S., you must use the Amazon Chime SIP Media Application Dial-In product type.
     *
     * Updates to outbound calling names can take 72 hours to complete. Pending updates to outbound calling names must be complete before you can request another update.
     */
    override suspend fun updatePhoneNumber(input: UpdatePhoneNumberRequest): UpdatePhoneNumberResponse {
        val op = SdkHttpOperation.build<UpdatePhoneNumberRequest, UpdatePhoneNumberResponse> {
            serializeWith = UpdatePhoneNumberOperationSerializer()
            deserializeWith = UpdatePhoneNumberOperationDeserializer()
            operationName = "UpdatePhoneNumber"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the phone number settings for the administrator's AWS account, such as the default outbound calling name. You can update the default outbound calling name once every seven days. Outbound calling names can take up to 72 hours to update.
     */
    override suspend fun updatePhoneNumberSettings(input: UpdatePhoneNumberSettingsRequest): UpdatePhoneNumberSettingsResponse {
        val op = SdkHttpOperation.build<UpdatePhoneNumberSettingsRequest, UpdatePhoneNumberSettingsResponse> {
            serializeWith = UpdatePhoneNumberSettingsOperationSerializer()
            deserializeWith = UpdatePhoneNumberSettingsOperationDeserializer()
            operationName = "UpdatePhoneNumberSettings"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates room details, such as the room name, for a room in an Amazon Chime Enterprise account.
     */
    override suspend fun updateRoom(input: UpdateRoomRequest): UpdateRoomResponse {
        val op = SdkHttpOperation.build<UpdateRoomRequest, UpdateRoomResponse> {
            serializeWith = UpdateRoomOperationSerializer()
            deserializeWith = UpdateRoomOperationDeserializer()
            operationName = "UpdateRoom"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates room membership details, such as the member role, for a room in an Amazon Chime Enterprise account. The member role designates whether the member is a chat room administrator or a general chat room member. The member role can be updated only for user IDs.
     */
    override suspend fun updateRoomMembership(input: UpdateRoomMembershipRequest): UpdateRoomMembershipResponse {
        val op = SdkHttpOperation.build<UpdateRoomMembershipRequest, UpdateRoomMembershipResponse> {
            serializeWith = UpdateRoomMembershipOperationSerializer()
            deserializeWith = UpdateRoomMembershipOperationDeserializer()
            operationName = "UpdateRoomMembership"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates user details for a specified user ID. Currently, only `LicenseType` updates are supported for this action.
     */
    override suspend fun updateUser(input: UpdateUserRequest): UpdateUserResponse {
        val op = SdkHttpOperation.build<UpdateUserRequest, UpdateUserResponse> {
            serializeWith = UpdateUserOperationSerializer()
            deserializeWith = UpdateUserOperationDeserializer()
            operationName = "UpdateUser"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the settings for the specified user, such as phone number settings.
     */
    override suspend fun updateUserSettings(input: UpdateUserSettingsRequest): UpdateUserSettingsResponse {
        val op = SdkHttpOperation.build<UpdateUserSettingsRequest, UpdateUserSettingsResponse> {
            serializeWith = UpdateUserSettingsOperationSerializer()
            deserializeWith = UpdateUserSettingsOperationDeserializer()
            operationName = "UpdateUserSettings"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    override fun close() {
        managedResources.unshareAll()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(SdkClientOption.ClientName, config.clientName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.logMode)
        ctx.putIfAbsentNotNull(SdkClientOption.IdempotencyTokenProvider, config.idempotencyTokenProvider)
        ctx.putIfAbsentNotNull(AwsAttributes.Region, config.region)
        ctx.putIfAbsentNotNull(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "chime")
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }

}
