// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chime.serde

import aws.sdk.kotlin.services.chime.model.CreateUserRequest
import aws.sdk.kotlin.services.chime.model.UserType
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class CreateUserOperationSerializer: HttpSerializer.NonStreaming<CreateUserRequest> {
    override fun serialize(context: ExecutionContext, input: CreateUserRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.accountId) { "accountId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("accounts"))
                add(PercentEncoding.SmithyLabel.encode(input.accountId))
                add(PercentEncoding.Path.encode("users"))
            }
            parameters.decodedParameters {
                add("operation", "create")
            }
        }

        val payload = serializeCreateUserOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateUserOperationBody(context: ExecutionContext, input: CreateUserRequest): ByteArray {
    val serializer = JsonSerializer()
    val EMAIL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Email"))
    val USERTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("UserType"))
    val USERNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Username"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(EMAIL_DESCRIPTOR)
        field(USERTYPE_DESCRIPTOR)
        field(USERNAME_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.email?.let { field(EMAIL_DESCRIPTOR, it) }
        input.userType?.let { field(USERTYPE_DESCRIPTOR, it.value) }
        input.username?.let { field(USERNAME_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
