// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chime.paginators

import aws.sdk.kotlin.services.chime.ChimeClient
import aws.sdk.kotlin.services.chime.model.ListAccountsRequest
import aws.sdk.kotlin.services.chime.model.ListAccountsResponse
import aws.sdk.kotlin.services.chime.model.ListBotsRequest
import aws.sdk.kotlin.services.chime.model.ListBotsResponse
import aws.sdk.kotlin.services.chime.model.ListPhoneNumberOrdersRequest
import aws.sdk.kotlin.services.chime.model.ListPhoneNumberOrdersResponse
import aws.sdk.kotlin.services.chime.model.ListPhoneNumbersRequest
import aws.sdk.kotlin.services.chime.model.ListPhoneNumbersResponse
import aws.sdk.kotlin.services.chime.model.ListRoomMembershipsRequest
import aws.sdk.kotlin.services.chime.model.ListRoomMembershipsResponse
import aws.sdk.kotlin.services.chime.model.ListRoomsRequest
import aws.sdk.kotlin.services.chime.model.ListRoomsResponse
import aws.sdk.kotlin.services.chime.model.ListUsersRequest
import aws.sdk.kotlin.services.chime.model.ListUsersResponse
import aws.sdk.kotlin.services.chime.model.SearchAvailablePhoneNumbersRequest
import aws.sdk.kotlin.services.chime.model.SearchAvailablePhoneNumbersResponse
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow


/**
 * Paginate over [ListAccountsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAccountsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAccountsResponse]
 */
public fun ChimeClient.listAccountsPaginated(initialRequest: ListAccountsRequest = ListAccountsRequest { }): Flow<ListAccountsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAccountsPaginated.listAccounts(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListAccountsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAccountsResponse]
 */
public fun ChimeClient.listAccountsPaginated(block: ListAccountsRequest.Builder.() -> Unit): Flow<ListAccountsResponse> =
    listAccountsPaginated(ListAccountsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListBotsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListBotsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListBotsResponse]
 */
public fun ChimeClient.listBotsPaginated(initialRequest: ListBotsRequest): Flow<ListBotsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listBotsPaginated.listBots(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListBotsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListBotsResponse]
 */
public fun ChimeClient.listBotsPaginated(block: ListBotsRequest.Builder.() -> Unit): Flow<ListBotsResponse> =
    listBotsPaginated(ListBotsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListPhoneNumberOrdersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListPhoneNumberOrdersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPhoneNumberOrdersResponse]
 */
public fun ChimeClient.listPhoneNumberOrdersPaginated(initialRequest: ListPhoneNumberOrdersRequest = ListPhoneNumberOrdersRequest { }): Flow<ListPhoneNumberOrdersResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listPhoneNumberOrdersPaginated.listPhoneNumberOrders(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListPhoneNumberOrdersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPhoneNumberOrdersResponse]
 */
public fun ChimeClient.listPhoneNumberOrdersPaginated(block: ListPhoneNumberOrdersRequest.Builder.() -> Unit): Flow<ListPhoneNumberOrdersResponse> =
    listPhoneNumberOrdersPaginated(ListPhoneNumberOrdersRequest.Builder().apply(block).build())

/**
 * Paginate over [ListPhoneNumbersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListPhoneNumbersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPhoneNumbersResponse]
 */
public fun ChimeClient.listPhoneNumbersPaginated(initialRequest: ListPhoneNumbersRequest = ListPhoneNumbersRequest { }): Flow<ListPhoneNumbersResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listPhoneNumbersPaginated.listPhoneNumbers(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListPhoneNumbersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPhoneNumbersResponse]
 */
public fun ChimeClient.listPhoneNumbersPaginated(block: ListPhoneNumbersRequest.Builder.() -> Unit): Flow<ListPhoneNumbersResponse> =
    listPhoneNumbersPaginated(ListPhoneNumbersRequest.Builder().apply(block).build())

/**
 * Paginate over [ListRoomMembershipsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListRoomMembershipsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRoomMembershipsResponse]
 */
public fun ChimeClient.listRoomMembershipsPaginated(initialRequest: ListRoomMembershipsRequest): Flow<ListRoomMembershipsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listRoomMembershipsPaginated.listRoomMemberships(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListRoomMembershipsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRoomMembershipsResponse]
 */
public fun ChimeClient.listRoomMembershipsPaginated(block: ListRoomMembershipsRequest.Builder.() -> Unit): Flow<ListRoomMembershipsResponse> =
    listRoomMembershipsPaginated(ListRoomMembershipsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListRoomsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListRoomsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRoomsResponse]
 */
public fun ChimeClient.listRoomsPaginated(initialRequest: ListRoomsRequest): Flow<ListRoomsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listRoomsPaginated.listRooms(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListRoomsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRoomsResponse]
 */
public fun ChimeClient.listRoomsPaginated(block: ListRoomsRequest.Builder.() -> Unit): Flow<ListRoomsResponse> =
    listRoomsPaginated(ListRoomsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListUsersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListUsersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListUsersResponse]
 */
public fun ChimeClient.listUsersPaginated(initialRequest: ListUsersRequest): Flow<ListUsersResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listUsersPaginated.listUsers(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListUsersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListUsersResponse]
 */
public fun ChimeClient.listUsersPaginated(block: ListUsersRequest.Builder.() -> Unit): Flow<ListUsersResponse> =
    listUsersPaginated(ListUsersRequest.Builder().apply(block).build())

/**
 * Paginate over [SearchAvailablePhoneNumbersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [SearchAvailablePhoneNumbersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchAvailablePhoneNumbersResponse]
 */
public fun ChimeClient.searchAvailablePhoneNumbersPaginated(initialRequest: SearchAvailablePhoneNumbersRequest = SearchAvailablePhoneNumbersRequest { }): Flow<SearchAvailablePhoneNumbersResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@searchAvailablePhoneNumbersPaginated.searchAvailablePhoneNumbers(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [SearchAvailablePhoneNumbersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchAvailablePhoneNumbersResponse]
 */
public fun ChimeClient.searchAvailablePhoneNumbersPaginated(block: SearchAvailablePhoneNumbersRequest.Builder.() -> Unit): Flow<SearchAvailablePhoneNumbersResponse> =
    searchAvailablePhoneNumbersPaginated(SearchAvailablePhoneNumbersRequest.Builder().apply(block).build())
