// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chime.model

import aws.smithy.kotlin.runtime.SdkDsl


/**
 * Settings related to the Amazon Chime account. This includes settings that start or stop remote control of shared screens, or start or stop the dial-out option in the Amazon Chime web application. For more information about these settings, see [Use the Policies Page](https://docs.aws.amazon.com/chime/latest/ag/policies.html) in the *Amazon Chime Administration Guide*.
 */
public class AccountSettings private constructor(builder: Builder) {
    /**
     * Setting that stops or starts remote control of shared screens during meetings.
     */
    public val disableRemoteControl: kotlin.Boolean? = builder.disableRemoteControl
    /**
     * Setting that allows meeting participants to choose the **Call me at a phone number** option. For more information, see [Join a Meeting without the Amazon Chime App](https://docs.aws.amazon.com/chime/latest/ug/chime-join-meeting.html).
     */
    public val enableDialOut: kotlin.Boolean? = builder.enableDialOut

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.chime.model.AccountSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AccountSettings(")
        append("disableRemoteControl=$disableRemoteControl,")
        append("enableDialOut=$enableDialOut")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = disableRemoteControl?.hashCode() ?: 0
        result = 31 * result + (this.enableDialOut?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AccountSettings

        if (disableRemoteControl != other.disableRemoteControl) return false
        if (enableDialOut != other.enableDialOut) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.chime.model.AccountSettings = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Setting that stops or starts remote control of shared screens during meetings.
         */
        public var disableRemoteControl: kotlin.Boolean? = null
        /**
         * Setting that allows meeting participants to choose the **Call me at a phone number** option. For more information, see [Join a Meeting without the Amazon Chime App](https://docs.aws.amazon.com/chime/latest/ug/chime-join-meeting.html).
         */
        public var enableDialOut: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.chime.model.AccountSettings) : this() {
            this.disableRemoteControl = x.disableRemoteControl
            this.enableDialOut = x.enableDialOut
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.chime.model.AccountSettings = AccountSettings(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
