// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chime.serde

import aws.sdk.kotlin.services.chime.model.AlexaForBusinessMetadata
import aws.sdk.kotlin.services.chime.model.License
import aws.sdk.kotlin.services.chime.model.UpdateUserRequest
import aws.sdk.kotlin.services.chime.model.UserType
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateUserOperationSerializer: HttpSerializer.NonStreaming<UpdateUserRequest> {
    override fun serialize(context: ExecutionContext, input: UpdateUserRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.accountId) { "accountId is bound to the URI and must not be null" }
            requireNotNull(input.userId) { "userId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("accounts"))
                add(PercentEncoding.SmithyLabel.encode(input.accountId))
                add(PercentEncoding.Path.encode("users"))
                add(PercentEncoding.SmithyLabel.encode(input.userId))
            }
        }

        val payload = serializeUpdateUserOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateUserOperationBody(context: ExecutionContext, input: UpdateUserRequest): ByteArray {
    val serializer = JsonSerializer()
    val ALEXAFORBUSINESSMETADATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("AlexaForBusinessMetadata"))
    val LICENSETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("LicenseType"))
    val USERTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("UserType"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ALEXAFORBUSINESSMETADATA_DESCRIPTOR)
        field(LICENSETYPE_DESCRIPTOR)
        field(USERTYPE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.alexaForBusinessMetadata?.let { field(ALEXAFORBUSINESSMETADATA_DESCRIPTOR, it, ::serializeAlexaForBusinessMetadataDocument) }
        input.licenseType?.let { field(LICENSETYPE_DESCRIPTOR, it.value) }
        input.userType?.let { field(USERTYPE_DESCRIPTOR, it.value) }
    }
    return serializer.toByteArray()
}
