// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chime.serde

import aws.sdk.kotlin.services.chime.model.BatchDeletePhoneNumberResponse
import aws.sdk.kotlin.services.chime.model.ChimeException
import aws.sdk.kotlin.services.chime.model.PhoneNumberError
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class BatchDeletePhoneNumberOperationDeserializer: HttpDeserializer.NonStreaming<BatchDeletePhoneNumberResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): BatchDeletePhoneNumberResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwBatchDeletePhoneNumberError(context, call, payload)
        }
        val builder = BatchDeletePhoneNumberResponse.Builder()

        if (payload != null) {
            deserializeBatchDeletePhoneNumberOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwBatchDeletePhoneNumberError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ChimeException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ForbiddenException" -> ForbiddenExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceFailureException" -> ServiceFailureExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottledClientException" -> ThrottledClientExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnauthorizedClientException" -> UnauthorizedClientExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ChimeException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeBatchDeletePhoneNumberOperationBody(builder: BatchDeletePhoneNumberResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val PHONENUMBERERRORS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("PhoneNumberErrors"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(PHONENUMBERERRORS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                PHONENUMBERERRORS_DESCRIPTOR.index -> builder.phoneNumberErrors =
                    deserializer.deserializeList(PHONENUMBERERRORS_DESCRIPTOR) {
                        val col0 = mutableListOf<PhoneNumberError>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializePhoneNumberErrorDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
