// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chime

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.runtime.region.DefaultRegionProviderChain
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.chime.auth.ChimeAuthSchemeProvider
import aws.sdk.kotlin.services.chime.auth.DefaultChimeAuthSchemeProvider
import aws.sdk.kotlin.services.chime.endpoints.ChimeEndpointParameters
import aws.sdk.kotlin.services.chime.endpoints.ChimeEndpointProvider
import aws.sdk.kotlin.services.chime.endpoints.DefaultChimeEndpointProvider
import aws.sdk.kotlin.services.chime.model.AssociatePhoneNumberWithUserRequest
import aws.sdk.kotlin.services.chime.model.AssociatePhoneNumberWithUserResponse
import aws.sdk.kotlin.services.chime.model.AssociateSigninDelegateGroupsWithAccountRequest
import aws.sdk.kotlin.services.chime.model.AssociateSigninDelegateGroupsWithAccountResponse
import aws.sdk.kotlin.services.chime.model.BatchCreateRoomMembershipRequest
import aws.sdk.kotlin.services.chime.model.BatchCreateRoomMembershipResponse
import aws.sdk.kotlin.services.chime.model.BatchDeletePhoneNumberRequest
import aws.sdk.kotlin.services.chime.model.BatchDeletePhoneNumberResponse
import aws.sdk.kotlin.services.chime.model.BatchSuspendUserRequest
import aws.sdk.kotlin.services.chime.model.BatchSuspendUserResponse
import aws.sdk.kotlin.services.chime.model.BatchUnsuspendUserRequest
import aws.sdk.kotlin.services.chime.model.BatchUnsuspendUserResponse
import aws.sdk.kotlin.services.chime.model.BatchUpdatePhoneNumberRequest
import aws.sdk.kotlin.services.chime.model.BatchUpdatePhoneNumberResponse
import aws.sdk.kotlin.services.chime.model.BatchUpdateUserRequest
import aws.sdk.kotlin.services.chime.model.BatchUpdateUserResponse
import aws.sdk.kotlin.services.chime.model.CreateAccountRequest
import aws.sdk.kotlin.services.chime.model.CreateAccountResponse
import aws.sdk.kotlin.services.chime.model.CreateBotRequest
import aws.sdk.kotlin.services.chime.model.CreateBotResponse
import aws.sdk.kotlin.services.chime.model.CreateMeetingDialOutRequest
import aws.sdk.kotlin.services.chime.model.CreateMeetingDialOutResponse
import aws.sdk.kotlin.services.chime.model.CreatePhoneNumberOrderRequest
import aws.sdk.kotlin.services.chime.model.CreatePhoneNumberOrderResponse
import aws.sdk.kotlin.services.chime.model.CreateRoomMembershipRequest
import aws.sdk.kotlin.services.chime.model.CreateRoomMembershipResponse
import aws.sdk.kotlin.services.chime.model.CreateRoomRequest
import aws.sdk.kotlin.services.chime.model.CreateRoomResponse
import aws.sdk.kotlin.services.chime.model.CreateUserRequest
import aws.sdk.kotlin.services.chime.model.CreateUserResponse
import aws.sdk.kotlin.services.chime.model.DeleteAccountRequest
import aws.sdk.kotlin.services.chime.model.DeleteAccountResponse
import aws.sdk.kotlin.services.chime.model.DeleteEventsConfigurationRequest
import aws.sdk.kotlin.services.chime.model.DeleteEventsConfigurationResponse
import aws.sdk.kotlin.services.chime.model.DeletePhoneNumberRequest
import aws.sdk.kotlin.services.chime.model.DeletePhoneNumberResponse
import aws.sdk.kotlin.services.chime.model.DeleteRoomMembershipRequest
import aws.sdk.kotlin.services.chime.model.DeleteRoomMembershipResponse
import aws.sdk.kotlin.services.chime.model.DeleteRoomRequest
import aws.sdk.kotlin.services.chime.model.DeleteRoomResponse
import aws.sdk.kotlin.services.chime.model.DisassociatePhoneNumberFromUserRequest
import aws.sdk.kotlin.services.chime.model.DisassociatePhoneNumberFromUserResponse
import aws.sdk.kotlin.services.chime.model.DisassociateSigninDelegateGroupsFromAccountRequest
import aws.sdk.kotlin.services.chime.model.DisassociateSigninDelegateGroupsFromAccountResponse
import aws.sdk.kotlin.services.chime.model.GetAccountRequest
import aws.sdk.kotlin.services.chime.model.GetAccountResponse
import aws.sdk.kotlin.services.chime.model.GetAccountSettingsRequest
import aws.sdk.kotlin.services.chime.model.GetAccountSettingsResponse
import aws.sdk.kotlin.services.chime.model.GetBotRequest
import aws.sdk.kotlin.services.chime.model.GetBotResponse
import aws.sdk.kotlin.services.chime.model.GetEventsConfigurationRequest
import aws.sdk.kotlin.services.chime.model.GetEventsConfigurationResponse
import aws.sdk.kotlin.services.chime.model.GetGlobalSettingsRequest
import aws.sdk.kotlin.services.chime.model.GetGlobalSettingsResponse
import aws.sdk.kotlin.services.chime.model.GetPhoneNumberOrderRequest
import aws.sdk.kotlin.services.chime.model.GetPhoneNumberOrderResponse
import aws.sdk.kotlin.services.chime.model.GetPhoneNumberRequest
import aws.sdk.kotlin.services.chime.model.GetPhoneNumberResponse
import aws.sdk.kotlin.services.chime.model.GetPhoneNumberSettingsRequest
import aws.sdk.kotlin.services.chime.model.GetPhoneNumberSettingsResponse
import aws.sdk.kotlin.services.chime.model.GetRetentionSettingsRequest
import aws.sdk.kotlin.services.chime.model.GetRetentionSettingsResponse
import aws.sdk.kotlin.services.chime.model.GetRoomRequest
import aws.sdk.kotlin.services.chime.model.GetRoomResponse
import aws.sdk.kotlin.services.chime.model.GetUserRequest
import aws.sdk.kotlin.services.chime.model.GetUserResponse
import aws.sdk.kotlin.services.chime.model.GetUserSettingsRequest
import aws.sdk.kotlin.services.chime.model.GetUserSettingsResponse
import aws.sdk.kotlin.services.chime.model.InviteUsersRequest
import aws.sdk.kotlin.services.chime.model.InviteUsersResponse
import aws.sdk.kotlin.services.chime.model.ListAccountsRequest
import aws.sdk.kotlin.services.chime.model.ListAccountsResponse
import aws.sdk.kotlin.services.chime.model.ListBotsRequest
import aws.sdk.kotlin.services.chime.model.ListBotsResponse
import aws.sdk.kotlin.services.chime.model.ListPhoneNumberOrdersRequest
import aws.sdk.kotlin.services.chime.model.ListPhoneNumberOrdersResponse
import aws.sdk.kotlin.services.chime.model.ListPhoneNumbersRequest
import aws.sdk.kotlin.services.chime.model.ListPhoneNumbersResponse
import aws.sdk.kotlin.services.chime.model.ListRoomMembershipsRequest
import aws.sdk.kotlin.services.chime.model.ListRoomMembershipsResponse
import aws.sdk.kotlin.services.chime.model.ListRoomsRequest
import aws.sdk.kotlin.services.chime.model.ListRoomsResponse
import aws.sdk.kotlin.services.chime.model.ListSupportedPhoneNumberCountriesRequest
import aws.sdk.kotlin.services.chime.model.ListSupportedPhoneNumberCountriesResponse
import aws.sdk.kotlin.services.chime.model.ListUsersRequest
import aws.sdk.kotlin.services.chime.model.ListUsersResponse
import aws.sdk.kotlin.services.chime.model.LogoutUserRequest
import aws.sdk.kotlin.services.chime.model.LogoutUserResponse
import aws.sdk.kotlin.services.chime.model.PutEventsConfigurationRequest
import aws.sdk.kotlin.services.chime.model.PutEventsConfigurationResponse
import aws.sdk.kotlin.services.chime.model.PutRetentionSettingsRequest
import aws.sdk.kotlin.services.chime.model.PutRetentionSettingsResponse
import aws.sdk.kotlin.services.chime.model.RedactConversationMessageRequest
import aws.sdk.kotlin.services.chime.model.RedactConversationMessageResponse
import aws.sdk.kotlin.services.chime.model.RedactRoomMessageRequest
import aws.sdk.kotlin.services.chime.model.RedactRoomMessageResponse
import aws.sdk.kotlin.services.chime.model.RegenerateSecurityTokenRequest
import aws.sdk.kotlin.services.chime.model.RegenerateSecurityTokenResponse
import aws.sdk.kotlin.services.chime.model.ResetPersonalPinRequest
import aws.sdk.kotlin.services.chime.model.ResetPersonalPinResponse
import aws.sdk.kotlin.services.chime.model.RestorePhoneNumberRequest
import aws.sdk.kotlin.services.chime.model.RestorePhoneNumberResponse
import aws.sdk.kotlin.services.chime.model.SearchAvailablePhoneNumbersRequest
import aws.sdk.kotlin.services.chime.model.SearchAvailablePhoneNumbersResponse
import aws.sdk.kotlin.services.chime.model.UpdateAccountRequest
import aws.sdk.kotlin.services.chime.model.UpdateAccountResponse
import aws.sdk.kotlin.services.chime.model.UpdateAccountSettingsRequest
import aws.sdk.kotlin.services.chime.model.UpdateAccountSettingsResponse
import aws.sdk.kotlin.services.chime.model.UpdateBotRequest
import aws.sdk.kotlin.services.chime.model.UpdateBotResponse
import aws.sdk.kotlin.services.chime.model.UpdateGlobalSettingsRequest
import aws.sdk.kotlin.services.chime.model.UpdateGlobalSettingsResponse
import aws.sdk.kotlin.services.chime.model.UpdatePhoneNumberRequest
import aws.sdk.kotlin.services.chime.model.UpdatePhoneNumberResponse
import aws.sdk.kotlin.services.chime.model.UpdatePhoneNumberSettingsRequest
import aws.sdk.kotlin.services.chime.model.UpdatePhoneNumberSettingsResponse
import aws.sdk.kotlin.services.chime.model.UpdateRoomMembershipRequest
import aws.sdk.kotlin.services.chime.model.UpdateRoomMembershipResponse
import aws.sdk.kotlin.services.chime.model.UpdateRoomRequest
import aws.sdk.kotlin.services.chime.model.UpdateRoomResponse
import aws.sdk.kotlin.services.chime.model.UpdateUserRequest
import aws.sdk.kotlin.services.chime.model.UpdateUserResponse
import aws.sdk.kotlin.services.chime.model.UpdateUserSettingsRequest
import aws.sdk.kotlin.services.chime.model.UpdateUserSettingsResponse
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.region.RegionProvider
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.config.TimeoutConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic
import kotlin.time.Duration
import kotlinx.coroutines.runBlocking


public const val ServiceId: String = "Chime"
public const val SdkVersion: String = "1.5.24"
public const val ServiceApiVersion: String = "2018-05-01"

/**
 * **Most of these APIs are no longer supported and will not be updated.** We recommend using the latest versions in the [Amazon Chime SDK API reference](https://docs.aws.amazon.com/chime-sdk/latest/APIReference/welcome.html), in the Amazon Chime SDK.
 *
 * Using the latest versions requires migrating to dedicated namespaces. For more information, refer to [Migrating from the Amazon Chime namespace](https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html) in the *Amazon Chime SDK Developer Guide*.
 *
 * The Amazon Chime application programming interface (API) is designed so administrators can perform key tasks, such as creating and managing Amazon Chime accounts, users, and Voice Connectors. This guide provides detailed information about the Amazon Chime API, including operations, types, inputs and outputs, and error codes.
 *
 * You can use an AWS SDK, the AWS Command Line Interface (AWS CLI), or the REST API to make API calls for Amazon Chime. We recommend using an AWS SDK or the AWS CLI. The page for each API action contains a *See Also* section that includes links to information about using the action with a language-specific AWS SDK or the AWS CLI.
 *
 * ## Using an AWS SDK
 *  You don't need to write code to calculate a signature for request authentication. The SDK clients authenticate your requests by using access keys that you provide. For more information about AWS SDKs, see the [AWS Developer Center](http://aws.amazon.com/developer/).
 *
 * ## Using the AWS CLI
 * Use your access keys with the AWS CLI to make API calls. For information about setting up the AWS CLI, see [Installing the AWS Command Line Interface](https://docs.aws.amazon.com/cli/latest/userguide/installing.html) in the *AWS Command Line Interface User Guide*. For a list of available Amazon Chime commands, see the [Amazon Chime commands](https://docs.aws.amazon.com/cli/latest/reference/chime/index.html) in the *AWS CLI Command Reference*.
 *
 * ## Using REST APIs
 * If you use REST to make API calls, you must authenticate your request by providing a signature. Amazon Chime supports Signature Version 4. For more information, see [Signature Version 4 Signing Process](https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html) in the *Amazon Web Services General Reference*.
 *
 * When making REST API calls, use the service name `chime` and REST endpoint `https://service.chime.aws.amazon.com`.
 *
 * Administrative permissions are controlled using AWS Identity and Access Management (IAM). For more information, see [Identity and Access Management for Amazon Chime](https://docs.aws.amazon.com/chime/latest/ag/security-iam.html) in the *Amazon Chime Administration Guide*.
 */
@Deprecated("This namespace has been deprecated")
public interface ChimeClient : SdkClient {
    /**
     * ChimeClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, ChimeClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "Chime",
                "CHIME",
                "chime",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, ChimeClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): ChimeClient = DefaultChimeClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig, TimeoutConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region ?: runBlocking { builder.regionProvider?.getRegion() ?: resolveRegion() }
        override val regionProvider: RegionProvider = builder.regionProvider ?: DefaultRegionProviderChain()
        override val attemptTimeout: Duration? = builder.attemptTimeout
        override val authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = builder.authSchemePreference
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val callTimeout: Duration? = builder.callTimeout
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: ChimeEndpointProvider = builder.endpointProvider ?: DefaultChimeEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: ChimeAuthSchemeProvider = builder.authSchemeProvider ?: DefaultChimeAuthSchemeProvider(authSchemePreference = authSchemePreference)
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            regionProvider = this@Config.regionProvider
            attemptTimeout = this@Config.attemptTimeout
            authSchemePreference = this@Config.authSchemePreference
            authSchemes = this@Config.authSchemes
            callTimeout = this@Config.callTimeout
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder, TimeoutConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "Chime"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more information.
             * When specified, this static region configuration takes precedence over other region resolution methods.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var region: String? = null

            /**
             * An optional region provider that determines the AWS region for client operations. When specified, this provider
             * takes precedence over the default region provider chain, unless a static region is explicitly configured.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var regionProvider: RegionProvider? = null

            /**
             * The maximum amount of time to wait for any single attempt of a request within the retry loop. By default,
             * the value is `null` indicating no timeout is enforced. Attempt timeouts may be retried if allowed by the
             * current retry policy and retry capacity.
             */
            override var attemptTimeout: Duration? = null

            /**
             * The ordered preference of [AuthScheme] that this client will use.
             */
            override var authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The maximum amount of time to wait for completion of a call, including any retries after the first attempt.
             * By default, the value is `null` indicating no timeout is enforced. Call timeouts are not retried.
             */
            override var callTimeout: Duration? = null

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: ChimeEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: ChimeAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Associates a phone number with the specified Amazon Chime user.
     */
    public suspend fun associatePhoneNumberWithUser(input: AssociatePhoneNumberWithUserRequest): AssociatePhoneNumberWithUserResponse

    /**
     * Associates the specified sign-in delegate groups with the specified Amazon Chime account.
     */
    public suspend fun associateSigninDelegateGroupsWithAccount(input: AssociateSigninDelegateGroupsWithAccountRequest): AssociateSigninDelegateGroupsWithAccountResponse

    /**
     * Adds up to 50 members to a chat room in an Amazon Chime Enterprise account. Members can be users or bots. The member role designates whether the member is a chat room administrator or a general chat room member.
     */
    public suspend fun batchCreateRoomMembership(input: BatchCreateRoomMembershipRequest): BatchCreateRoomMembershipResponse

    /**
     * Moves phone numbers into the **Deletion queue**. Phone numbers must be disassociated from any users or Amazon Chime Voice Connectors before they can be deleted.
     *
     *  Phone numbers remain in the **Deletion queue** for 7 days before they are deleted permanently.
     */
    public suspend fun batchDeletePhoneNumber(input: BatchDeletePhoneNumberRequest): BatchDeletePhoneNumberResponse

    /**
     * Suspends up to 50 users from a `Team` or `EnterpriseLWA` Amazon Chime account. For more information about different account types, see [Managing Your Amazon Chime Accounts](https://docs.aws.amazon.com/chime/latest/ag/manage-chime-account.html) in the *Amazon Chime Administration Guide*.
     *
     * Users suspended from a `Team` account are disassociated from the account,but they can continue to use Amazon Chime as free users. To remove the suspension from suspended `Team` account users, invite them to the `Team` account again. You can use the InviteUsers action to do so.
     *
     * Users suspended from an `EnterpriseLWA` account are immediately signed out of Amazon Chime and can no longer sign in. To remove the suspension from suspended `EnterpriseLWA` account users, use the BatchUnsuspendUser action.
     *
     *  To sign out users without suspending them, use the LogoutUser action.
     */
    public suspend fun batchSuspendUser(input: BatchSuspendUserRequest): BatchSuspendUserResponse

    /**
     * Removes the suspension from up to 50 previously suspended users for the specified Amazon Chime `EnterpriseLWA` account. Only users on `EnterpriseLWA` accounts can be unsuspended using this action. For more information about different account types, see [ Managing Your Amazon Chime Accounts ](https://docs.aws.amazon.com/chime/latest/ag/manage-chime-account.html) in the account types, in the *Amazon Chime Administration Guide*.
     *
     * Previously suspended users who are unsuspended using this action are returned to `Registered` status. Users who are not previously suspended are ignored.
     */
    public suspend fun batchUnsuspendUser(input: BatchUnsuspendUserRequest): BatchUnsuspendUserResponse

    /**
     * Updates phone number product types or calling names. You can update one attribute at a time for each `UpdatePhoneNumberRequestItem`. For example, you can update the product type or the calling name.
     *
     * For toll-free numbers, you cannot use the Amazon Chime Business Calling product type. For numbers outside the U.S., you must use the Amazon Chime SIP Media Application Dial-In product type.
     *
     * Updates to outbound calling names can take up to 72 hours to complete. Pending updates to outbound calling names must be complete before you can request another update.
     */
    public suspend fun batchUpdatePhoneNumber(input: BatchUpdatePhoneNumberRequest): BatchUpdatePhoneNumberResponse

    /**
     * Updates user details within the UpdateUserRequestItem object for up to 20 users for the specified Amazon Chime account. Currently, only `LicenseType` updates are supported for this action.
     */
    public suspend fun batchUpdateUser(input: BatchUpdateUserRequest): BatchUpdateUserResponse

    /**
     * Creates an Amazon Chime account under the administrator's AWS account. Only `Team` account types are currently supported for this action. For more information about different account types, see [Managing Your Amazon Chime Accounts](https://docs.aws.amazon.com/chime/latest/ag/manage-chime-account.html) in the *Amazon Chime Administration Guide*.
     */
    public suspend fun createAccount(input: CreateAccountRequest): CreateAccountResponse

    /**
     * Creates a bot for an Amazon Chime Enterprise account.
     */
    public suspend fun createBot(input: CreateBotRequest): CreateBotResponse

    /**
     * Uses the join token and call metadata in a meeting request (From number, To number, and so forth) to initiate an outbound call to a public switched telephone network (PSTN) and join them into a Chime meeting. Also ensures that the From number belongs to the customer.
     *
     * To play welcome audio or implement an interactive voice response (IVR), use the `CreateSipMediaApplicationCall` action with the corresponding SIP media application ID.
     *
     * **This API is not available in a dedicated namespace.**
     */
    public suspend fun createMeetingDialOut(input: CreateMeetingDialOutRequest): CreateMeetingDialOutResponse

    /**
     * Creates an order for phone numbers to be provisioned. For toll-free numbers, you cannot use the Amazon Chime Business Calling product type. For numbers outside the U.S., you must use the Amazon Chime SIP Media Application Dial-In product type.
     */
    public suspend fun createPhoneNumberOrder(input: CreatePhoneNumberOrderRequest): CreatePhoneNumberOrderResponse

    /**
     * Creates a chat room for the specified Amazon Chime Enterprise account.
     */
    public suspend fun createRoom(input: CreateRoomRequest): CreateRoomResponse

    /**
     * Adds a member to a chat room in an Amazon Chime Enterprise account. A member can be either a user or a bot. The member role designates whether the member is a chat room administrator or a general chat room member.
     */
    public suspend fun createRoomMembership(input: CreateRoomMembershipRequest): CreateRoomMembershipResponse

    /**
     * Creates a user under the specified Amazon Chime account.
     */
    public suspend fun createUser(input: CreateUserRequest): CreateUserResponse

    /**
     * Deletes the specified Amazon Chime account. You must suspend all users before deleting `Team` account. You can use the BatchSuspendUser action to dodo.
     *
     * For `EnterpriseLWA` and `EnterpriseAD` accounts, you must release the claimed domains for your Amazon Chime account before deletion. As soon as you release the domain, all users under that account are suspended.
     *
     * Deleted accounts appear in your `Disabled` accounts list for 90 days. To restore deleted account from your `Disabled` accounts list, you must contact AWS Support.
     *
     * After 90 days, deleted accounts are permanently removed from your `Disabled` accounts list.
     */
    public suspend fun deleteAccount(input: DeleteAccountRequest): DeleteAccountResponse

    /**
     * Deletes the events configuration that allows a bot to receive outgoing events.
     */
    public suspend fun deleteEventsConfiguration(input: DeleteEventsConfigurationRequest): DeleteEventsConfigurationResponse

    /**
     * Moves the specified phone number into the **Deletion queue**. A phone number must be disassociated from any users or Amazon Chime Voice Connectors before it can be deleted.
     *
     * Deleted phone numbers remain in the **Deletion queue** for 7 days before they are deleted permanently.
     */
    public suspend fun deletePhoneNumber(input: DeletePhoneNumberRequest): DeletePhoneNumberResponse

    /**
     * Deletes a chat room in an Amazon Chime Enterprise account.
     */
    public suspend fun deleteRoom(input: DeleteRoomRequest): DeleteRoomResponse

    /**
     * Removes a member from a chat room in an Amazon Chime Enterprise account.
     */
    public suspend fun deleteRoomMembership(input: DeleteRoomMembershipRequest): DeleteRoomMembershipResponse

    /**
     * Disassociates the primary provisioned phone number from the specified Amazon Chime user.
     */
    public suspend fun disassociatePhoneNumberFromUser(input: DisassociatePhoneNumberFromUserRequest): DisassociatePhoneNumberFromUserResponse

    /**
     * Disassociates the specified sign-in delegate groups from the specified Amazon Chime account.
     */
    public suspend fun disassociateSigninDelegateGroupsFromAccount(input: DisassociateSigninDelegateGroupsFromAccountRequest): DisassociateSigninDelegateGroupsFromAccountResponse

    /**
     * Retrieves details for the specified Amazon Chime account, such as account type and supported licenses.
     */
    public suspend fun getAccount(input: GetAccountRequest): GetAccountResponse

    /**
     * Retrieves account settings for the specified Amazon Chime account ID, such as remote control and dialout settings. For more information about these settings, see [Use the Policies Page](https://docs.aws.amazon.com/chime/latest/ag/policies.html) in the *Amazon Chime Administration Guide*.
     */
    public suspend fun getAccountSettings(input: GetAccountSettingsRequest): GetAccountSettingsResponse

    /**
     * Retrieves details for the specified bot, such as bot email address, bot type, status, and display name.
     */
    public suspend fun getBot(input: GetBotRequest): GetBotResponse

    /**
     * Gets details for an events configuration that allows a bot to receive outgoing events, such as an HTTPS endpoint or Lambda function ARN.
     */
    public suspend fun getEventsConfiguration(input: GetEventsConfigurationRequest): GetEventsConfigurationResponse

    /**
     * Retrieves global settings for the administrator's AWS account, such as Amazon Chime Business Calling and Amazon Chime Voice Connector settings.
     */
    public suspend fun getGlobalSettings(input: GetGlobalSettingsRequest = GetGlobalSettingsRequest { }): GetGlobalSettingsResponse

    /**
     * Retrieves details for the specified phone number ID, such as associations, capabilities, and product type.
     */
    public suspend fun getPhoneNumber(input: GetPhoneNumberRequest): GetPhoneNumberResponse

    /**
     * Retrieves details for the specified phone number order, such as the order creation timestamp, phone numbers in E.164 format, product type, and order status.
     */
    public suspend fun getPhoneNumberOrder(input: GetPhoneNumberOrderRequest): GetPhoneNumberOrderResponse

    /**
     * Retrieves the phone number settings for the administrator's AWS account, such as the default outbound calling name.
     */
    public suspend fun getPhoneNumberSettings(input: GetPhoneNumberSettingsRequest = GetPhoneNumberSettingsRequest { }): GetPhoneNumberSettingsResponse

    /**
     * Gets the retention settings for the specified Amazon Chime Enterprise account. For more information about retention settings, see [Managing Chat Retention Policies](https://docs.aws.amazon.com/chime/latest/ag/chat-retention.html) in the *Amazon Chime Administration Guide*.
     */
    public suspend fun getRetentionSettings(input: GetRetentionSettingsRequest): GetRetentionSettingsResponse

    /**
     * Retrieves room details, such as the room name, for a room in an Amazon Chime Enterprise account.
     */
    public suspend fun getRoom(input: GetRoomRequest): GetRoomResponse

    /**
     * Retrieves details for the specified user ID, such as primary email address, license type,and personal meeting PIN.
     *
     *  To retrieve user details with an email address instead of a user ID, use the ListUsers action, and then filter by email address.
     */
    public suspend fun getUser(input: GetUserRequest): GetUserResponse

    /**
     * Retrieves settings for the specified user ID, such as any associated phone number settings.
     */
    public suspend fun getUserSettings(input: GetUserSettingsRequest): GetUserSettingsResponse

    /**
     * Sends email to a maximum of 50 users, inviting them to the specified Amazon Chime `Team` account. Only `Team` account types are currently supported for this action.
     */
    public suspend fun inviteUsers(input: InviteUsersRequest): InviteUsersResponse

    /**
     * Lists the Amazon Chime accounts under the administrator's AWS account. You can filter accounts by account name prefix. To find out which Amazon Chime account a user belongs to, you can filter by the user's email address, which returns one account result.
     */
    public suspend fun listAccounts(input: ListAccountsRequest = ListAccountsRequest { }): ListAccountsResponse

    /**
     * Lists the bots associated with the administrator's Amazon Chime Enterprise account ID.
     */
    public suspend fun listBots(input: ListBotsRequest): ListBotsResponse

    /**
     * Lists the phone number orders for the administrator's Amazon Chime account.
     */
    public suspend fun listPhoneNumberOrders(input: ListPhoneNumberOrdersRequest = ListPhoneNumberOrdersRequest { }): ListPhoneNumberOrdersResponse

    /**
     * Lists the phone numbers for the specified Amazon Chime account, Amazon Chime user, Amazon Chime Voice Connector, or Amazon Chime Voice Connector group.
     */
    public suspend fun listPhoneNumbers(input: ListPhoneNumbersRequest = ListPhoneNumbersRequest { }): ListPhoneNumbersResponse

    /**
     * Lists the membership details for the specified room in an Amazon Chime Enterprise account, such as the members' IDs, email addresses, and names.
     */
    public suspend fun listRoomMemberships(input: ListRoomMembershipsRequest): ListRoomMembershipsResponse

    /**
     * Lists the room details for the specified Amazon Chime Enterprise account. Optionally, filter the results by a member ID (user ID or bot ID) to see a list of rooms that the member belongs to.
     */
    public suspend fun listRooms(input: ListRoomsRequest): ListRoomsResponse

    /**
     * Lists supported phone number countries.
     */
    public suspend fun listSupportedPhoneNumberCountries(input: ListSupportedPhoneNumberCountriesRequest): ListSupportedPhoneNumberCountriesResponse

    /**
     * Lists the users that belong to the specified Amazon Chime account. You can specify an email address to list only the user that the email address belongs to.
     */
    public suspend fun listUsers(input: ListUsersRequest): ListUsersResponse

    /**
     * Logs out the specified user from all of the devices they are currently logged into.
     */
    public suspend fun logoutUser(input: LogoutUserRequest): LogoutUserResponse

    /**
     * Creates an events configuration that allows a bot to receive outgoing events sent by Amazon Chime. Choose either an HTTPS endpoint or a Lambda function ARN. For more information, see Bot.
     */
    public suspend fun putEventsConfiguration(input: PutEventsConfigurationRequest): PutEventsConfigurationResponse

    /**
     * Puts retention settings for the specified Amazon Chime Enterprise account. We recommend using AWS CloudTrail to monitor usage of this API for your account. For more information, see [Logging Amazon Chime API Calls with AWS CloudTrail](https://docs.aws.amazon.com/chime/latest/ag/cloudtrail.html) in the *Amazon Chime Administration Guide*.
     *
     *  To turn off existing retention settings, remove the number of days from the corresponding **RetentionDays** field in the **RetentionSettings** object. For more information about retention settings, see [Managing Chat Retention Policies](https://docs.aws.amazon.com/chime/latest/ag/chat-retention.html) in the *Amazon Chime Administration Guide*.
     */
    public suspend fun putRetentionSettings(input: PutRetentionSettingsRequest): PutRetentionSettingsResponse

    /**
     * Redacts the specified message from the specified Amazon Chime conversation.
     */
    public suspend fun redactConversationMessage(input: RedactConversationMessageRequest): RedactConversationMessageResponse

    /**
     * Redacts the specified message from the specified Amazon Chime channel.
     */
    public suspend fun redactRoomMessage(input: RedactRoomMessageRequest): RedactRoomMessageResponse

    /**
     * Regenerates the security token for a bot.
     */
    public suspend fun regenerateSecurityToken(input: RegenerateSecurityTokenRequest): RegenerateSecurityTokenResponse

    /**
     * Resets the personal meeting PIN for the specified user on an Amazon Chime account. Returns the User object with the updated personal meeting PIN.
     */
    public suspend fun resetPersonalPin(input: ResetPersonalPinRequest): ResetPersonalPinResponse

    /**
     * Moves a phone number from the **Deletion queue** back into the phone number **Inventory**.
     */
    public suspend fun restorePhoneNumber(input: RestorePhoneNumberRequest): RestorePhoneNumberResponse

    /**
     * Searches for phone numbers that can be ordered. For US numbers, provide at least one of the following search filters: `AreaCode`, `City`, `State`, or `TollFreePrefix`. If you provide `City`, you must also provide `State`. Numbers outside the US only support the `PhoneNumberType` filter, which you must use.
     */
    public suspend fun searchAvailablePhoneNumbers(input: SearchAvailablePhoneNumbersRequest = SearchAvailablePhoneNumbersRequest { }): SearchAvailablePhoneNumbersResponse

    /**
     * Updates account details for the specified Amazon Chime account. Currently, only account name and default license updates are supported for this action.
     */
    public suspend fun updateAccount(input: UpdateAccountRequest): UpdateAccountResponse

    /**
     * Updates the settings for the specified Amazon Chime account. You can update settings for remote control of shared screens, or for the dial-out option. For more information about these settings, see [Use the Policies Page](https://docs.aws.amazon.com/chime/latest/ag/policies.html) in the *Amazon Chime Administration Guide*.
     */
    public suspend fun updateAccountSettings(input: UpdateAccountSettingsRequest): UpdateAccountSettingsResponse

    /**
     * Updates the status of the specified bot, such as starting or stopping the bot from running in your Amazon Chime Enterprise account.
     */
    public suspend fun updateBot(input: UpdateBotRequest): UpdateBotResponse

    /**
     * Updates global settings for the administrator's AWS account, such as Amazon Chime Business Calling and Amazon Chime Voice Connector settings.
     */
    public suspend fun updateGlobalSettings(input: UpdateGlobalSettingsRequest = UpdateGlobalSettingsRequest { }): UpdateGlobalSettingsResponse

    /**
     * Updates phone number details, such as product type or calling name, for the specified phone number ID. You can update one phone number detail at a time. For example, you can update either the product type or the calling name in one action.
     *
     * For toll-free numbers, you cannot use the Amazon Chime Business Calling product type. For numbers outside the U.S., you must use the Amazon Chime SIP Media Application Dial-In product type.
     *
     * Updates to outbound calling names can take 72 hours to complete. Pending updates to outbound calling names must be complete before you can request another update.
     */
    public suspend fun updatePhoneNumber(input: UpdatePhoneNumberRequest): UpdatePhoneNumberResponse

    /**
     * Updates the phone number settings for the administrator's AWS account, such as the default outbound calling name. You can update the default outbound calling name once every seven days. Outbound calling names can take up to 72 hours to update.
     */
    public suspend fun updatePhoneNumberSettings(input: UpdatePhoneNumberSettingsRequest): UpdatePhoneNumberSettingsResponse

    /**
     * Updates room details, such as the room name, for a room in an Amazon Chime Enterprise account.
     */
    public suspend fun updateRoom(input: UpdateRoomRequest): UpdateRoomResponse

    /**
     * Updates room membership details, such as the member role, for a room in an Amazon Chime Enterprise account. The member role designates whether the member is a chat room administrator or a general chat room member. The member role can be updated only for user IDs.
     */
    public suspend fun updateRoomMembership(input: UpdateRoomMembershipRequest): UpdateRoomMembershipResponse

    /**
     * Updates user details for a specified user ID. Currently, only `LicenseType` updates are supported for this action.
     */
    public suspend fun updateUser(input: UpdateUserRequest): UpdateUserResponse

    /**
     * Updates the settings for the specified user, such as phone number settings.
     */
    public suspend fun updateUserSettings(input: UpdateUserSettingsRequest): UpdateUserSettingsResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun ChimeClient.withConfig(block: ChimeClient.Config.Builder.() -> Unit): ChimeClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultChimeClient(newConfig)
}

/**
 * Associates a phone number with the specified Amazon Chime user.
 */
public suspend inline fun ChimeClient.associatePhoneNumberWithUser(crossinline block: AssociatePhoneNumberWithUserRequest.Builder.() -> Unit): AssociatePhoneNumberWithUserResponse = associatePhoneNumberWithUser(AssociatePhoneNumberWithUserRequest.Builder().apply(block).build())

/**
 * Associates the specified sign-in delegate groups with the specified Amazon Chime account.
 */
public suspend inline fun ChimeClient.associateSigninDelegateGroupsWithAccount(crossinline block: AssociateSigninDelegateGroupsWithAccountRequest.Builder.() -> Unit): AssociateSigninDelegateGroupsWithAccountResponse = associateSigninDelegateGroupsWithAccount(AssociateSigninDelegateGroupsWithAccountRequest.Builder().apply(block).build())

/**
 * Adds up to 50 members to a chat room in an Amazon Chime Enterprise account. Members can be users or bots. The member role designates whether the member is a chat room administrator or a general chat room member.
 */
public suspend inline fun ChimeClient.batchCreateRoomMembership(crossinline block: BatchCreateRoomMembershipRequest.Builder.() -> Unit): BatchCreateRoomMembershipResponse = batchCreateRoomMembership(BatchCreateRoomMembershipRequest.Builder().apply(block).build())

/**
 * Moves phone numbers into the **Deletion queue**. Phone numbers must be disassociated from any users or Amazon Chime Voice Connectors before they can be deleted.
 *
 *  Phone numbers remain in the **Deletion queue** for 7 days before they are deleted permanently.
 */
public suspend inline fun ChimeClient.batchDeletePhoneNumber(crossinline block: BatchDeletePhoneNumberRequest.Builder.() -> Unit): BatchDeletePhoneNumberResponse = batchDeletePhoneNumber(BatchDeletePhoneNumberRequest.Builder().apply(block).build())

/**
 * Suspends up to 50 users from a `Team` or `EnterpriseLWA` Amazon Chime account. For more information about different account types, see [Managing Your Amazon Chime Accounts](https://docs.aws.amazon.com/chime/latest/ag/manage-chime-account.html) in the *Amazon Chime Administration Guide*.
 *
 * Users suspended from a `Team` account are disassociated from the account,but they can continue to use Amazon Chime as free users. To remove the suspension from suspended `Team` account users, invite them to the `Team` account again. You can use the InviteUsers action to do so.
 *
 * Users suspended from an `EnterpriseLWA` account are immediately signed out of Amazon Chime and can no longer sign in. To remove the suspension from suspended `EnterpriseLWA` account users, use the BatchUnsuspendUser action.
 *
 *  To sign out users without suspending them, use the LogoutUser action.
 */
public suspend inline fun ChimeClient.batchSuspendUser(crossinline block: BatchSuspendUserRequest.Builder.() -> Unit): BatchSuspendUserResponse = batchSuspendUser(BatchSuspendUserRequest.Builder().apply(block).build())

/**
 * Removes the suspension from up to 50 previously suspended users for the specified Amazon Chime `EnterpriseLWA` account. Only users on `EnterpriseLWA` accounts can be unsuspended using this action. For more information about different account types, see [ Managing Your Amazon Chime Accounts ](https://docs.aws.amazon.com/chime/latest/ag/manage-chime-account.html) in the account types, in the *Amazon Chime Administration Guide*.
 *
 * Previously suspended users who are unsuspended using this action are returned to `Registered` status. Users who are not previously suspended are ignored.
 */
public suspend inline fun ChimeClient.batchUnsuspendUser(crossinline block: BatchUnsuspendUserRequest.Builder.() -> Unit): BatchUnsuspendUserResponse = batchUnsuspendUser(BatchUnsuspendUserRequest.Builder().apply(block).build())

/**
 * Updates phone number product types or calling names. You can update one attribute at a time for each `UpdatePhoneNumberRequestItem`. For example, you can update the product type or the calling name.
 *
 * For toll-free numbers, you cannot use the Amazon Chime Business Calling product type. For numbers outside the U.S., you must use the Amazon Chime SIP Media Application Dial-In product type.
 *
 * Updates to outbound calling names can take up to 72 hours to complete. Pending updates to outbound calling names must be complete before you can request another update.
 */
public suspend inline fun ChimeClient.batchUpdatePhoneNumber(crossinline block: BatchUpdatePhoneNumberRequest.Builder.() -> Unit): BatchUpdatePhoneNumberResponse = batchUpdatePhoneNumber(BatchUpdatePhoneNumberRequest.Builder().apply(block).build())

/**
 * Updates user details within the UpdateUserRequestItem object for up to 20 users for the specified Amazon Chime account. Currently, only `LicenseType` updates are supported for this action.
 */
public suspend inline fun ChimeClient.batchUpdateUser(crossinline block: BatchUpdateUserRequest.Builder.() -> Unit): BatchUpdateUserResponse = batchUpdateUser(BatchUpdateUserRequest.Builder().apply(block).build())

/**
 * Creates an Amazon Chime account under the administrator's AWS account. Only `Team` account types are currently supported for this action. For more information about different account types, see [Managing Your Amazon Chime Accounts](https://docs.aws.amazon.com/chime/latest/ag/manage-chime-account.html) in the *Amazon Chime Administration Guide*.
 */
public suspend inline fun ChimeClient.createAccount(crossinline block: CreateAccountRequest.Builder.() -> Unit): CreateAccountResponse = createAccount(CreateAccountRequest.Builder().apply(block).build())

/**
 * Creates a bot for an Amazon Chime Enterprise account.
 */
public suspend inline fun ChimeClient.createBot(crossinline block: CreateBotRequest.Builder.() -> Unit): CreateBotResponse = createBot(CreateBotRequest.Builder().apply(block).build())

/**
 * Uses the join token and call metadata in a meeting request (From number, To number, and so forth) to initiate an outbound call to a public switched telephone network (PSTN) and join them into a Chime meeting. Also ensures that the From number belongs to the customer.
 *
 * To play welcome audio or implement an interactive voice response (IVR), use the `CreateSipMediaApplicationCall` action with the corresponding SIP media application ID.
 *
 * **This API is not available in a dedicated namespace.**
 */
public suspend inline fun ChimeClient.createMeetingDialOut(crossinline block: CreateMeetingDialOutRequest.Builder.() -> Unit): CreateMeetingDialOutResponse = createMeetingDialOut(CreateMeetingDialOutRequest.Builder().apply(block).build())

/**
 * Creates an order for phone numbers to be provisioned. For toll-free numbers, you cannot use the Amazon Chime Business Calling product type. For numbers outside the U.S., you must use the Amazon Chime SIP Media Application Dial-In product type.
 */
public suspend inline fun ChimeClient.createPhoneNumberOrder(crossinline block: CreatePhoneNumberOrderRequest.Builder.() -> Unit): CreatePhoneNumberOrderResponse = createPhoneNumberOrder(CreatePhoneNumberOrderRequest.Builder().apply(block).build())

/**
 * Creates a chat room for the specified Amazon Chime Enterprise account.
 */
public suspend inline fun ChimeClient.createRoom(crossinline block: CreateRoomRequest.Builder.() -> Unit): CreateRoomResponse = createRoom(CreateRoomRequest.Builder().apply(block).build())

/**
 * Adds a member to a chat room in an Amazon Chime Enterprise account. A member can be either a user or a bot. The member role designates whether the member is a chat room administrator or a general chat room member.
 */
public suspend inline fun ChimeClient.createRoomMembership(crossinline block: CreateRoomMembershipRequest.Builder.() -> Unit): CreateRoomMembershipResponse = createRoomMembership(CreateRoomMembershipRequest.Builder().apply(block).build())

/**
 * Creates a user under the specified Amazon Chime account.
 */
public suspend inline fun ChimeClient.createUser(crossinline block: CreateUserRequest.Builder.() -> Unit): CreateUserResponse = createUser(CreateUserRequest.Builder().apply(block).build())

/**
 * Deletes the specified Amazon Chime account. You must suspend all users before deleting `Team` account. You can use the BatchSuspendUser action to dodo.
 *
 * For `EnterpriseLWA` and `EnterpriseAD` accounts, you must release the claimed domains for your Amazon Chime account before deletion. As soon as you release the domain, all users under that account are suspended.
 *
 * Deleted accounts appear in your `Disabled` accounts list for 90 days. To restore deleted account from your `Disabled` accounts list, you must contact AWS Support.
 *
 * After 90 days, deleted accounts are permanently removed from your `Disabled` accounts list.
 */
public suspend inline fun ChimeClient.deleteAccount(crossinline block: DeleteAccountRequest.Builder.() -> Unit): DeleteAccountResponse = deleteAccount(DeleteAccountRequest.Builder().apply(block).build())

/**
 * Deletes the events configuration that allows a bot to receive outgoing events.
 */
public suspend inline fun ChimeClient.deleteEventsConfiguration(crossinline block: DeleteEventsConfigurationRequest.Builder.() -> Unit): DeleteEventsConfigurationResponse = deleteEventsConfiguration(DeleteEventsConfigurationRequest.Builder().apply(block).build())

/**
 * Moves the specified phone number into the **Deletion queue**. A phone number must be disassociated from any users or Amazon Chime Voice Connectors before it can be deleted.
 *
 * Deleted phone numbers remain in the **Deletion queue** for 7 days before they are deleted permanently.
 */
public suspend inline fun ChimeClient.deletePhoneNumber(crossinline block: DeletePhoneNumberRequest.Builder.() -> Unit): DeletePhoneNumberResponse = deletePhoneNumber(DeletePhoneNumberRequest.Builder().apply(block).build())

/**
 * Deletes a chat room in an Amazon Chime Enterprise account.
 */
public suspend inline fun ChimeClient.deleteRoom(crossinline block: DeleteRoomRequest.Builder.() -> Unit): DeleteRoomResponse = deleteRoom(DeleteRoomRequest.Builder().apply(block).build())

/**
 * Removes a member from a chat room in an Amazon Chime Enterprise account.
 */
public suspend inline fun ChimeClient.deleteRoomMembership(crossinline block: DeleteRoomMembershipRequest.Builder.() -> Unit): DeleteRoomMembershipResponse = deleteRoomMembership(DeleteRoomMembershipRequest.Builder().apply(block).build())

/**
 * Disassociates the primary provisioned phone number from the specified Amazon Chime user.
 */
public suspend inline fun ChimeClient.disassociatePhoneNumberFromUser(crossinline block: DisassociatePhoneNumberFromUserRequest.Builder.() -> Unit): DisassociatePhoneNumberFromUserResponse = disassociatePhoneNumberFromUser(DisassociatePhoneNumberFromUserRequest.Builder().apply(block).build())

/**
 * Disassociates the specified sign-in delegate groups from the specified Amazon Chime account.
 */
public suspend inline fun ChimeClient.disassociateSigninDelegateGroupsFromAccount(crossinline block: DisassociateSigninDelegateGroupsFromAccountRequest.Builder.() -> Unit): DisassociateSigninDelegateGroupsFromAccountResponse = disassociateSigninDelegateGroupsFromAccount(DisassociateSigninDelegateGroupsFromAccountRequest.Builder().apply(block).build())

/**
 * Retrieves details for the specified Amazon Chime account, such as account type and supported licenses.
 */
public suspend inline fun ChimeClient.getAccount(crossinline block: GetAccountRequest.Builder.() -> Unit): GetAccountResponse = getAccount(GetAccountRequest.Builder().apply(block).build())

/**
 * Retrieves account settings for the specified Amazon Chime account ID, such as remote control and dialout settings. For more information about these settings, see [Use the Policies Page](https://docs.aws.amazon.com/chime/latest/ag/policies.html) in the *Amazon Chime Administration Guide*.
 */
public suspend inline fun ChimeClient.getAccountSettings(crossinline block: GetAccountSettingsRequest.Builder.() -> Unit): GetAccountSettingsResponse = getAccountSettings(GetAccountSettingsRequest.Builder().apply(block).build())

/**
 * Retrieves details for the specified bot, such as bot email address, bot type, status, and display name.
 */
public suspend inline fun ChimeClient.getBot(crossinline block: GetBotRequest.Builder.() -> Unit): GetBotResponse = getBot(GetBotRequest.Builder().apply(block).build())

/**
 * Gets details for an events configuration that allows a bot to receive outgoing events, such as an HTTPS endpoint or Lambda function ARN.
 */
public suspend inline fun ChimeClient.getEventsConfiguration(crossinline block: GetEventsConfigurationRequest.Builder.() -> Unit): GetEventsConfigurationResponse = getEventsConfiguration(GetEventsConfigurationRequest.Builder().apply(block).build())

/**
 * Retrieves global settings for the administrator's AWS account, such as Amazon Chime Business Calling and Amazon Chime Voice Connector settings.
 */
public suspend inline fun ChimeClient.getGlobalSettings(crossinline block: GetGlobalSettingsRequest.Builder.() -> Unit): GetGlobalSettingsResponse = getGlobalSettings(GetGlobalSettingsRequest.Builder().apply(block).build())

/**
 * Retrieves details for the specified phone number ID, such as associations, capabilities, and product type.
 */
public suspend inline fun ChimeClient.getPhoneNumber(crossinline block: GetPhoneNumberRequest.Builder.() -> Unit): GetPhoneNumberResponse = getPhoneNumber(GetPhoneNumberRequest.Builder().apply(block).build())

/**
 * Retrieves details for the specified phone number order, such as the order creation timestamp, phone numbers in E.164 format, product type, and order status.
 */
public suspend inline fun ChimeClient.getPhoneNumberOrder(crossinline block: GetPhoneNumberOrderRequest.Builder.() -> Unit): GetPhoneNumberOrderResponse = getPhoneNumberOrder(GetPhoneNumberOrderRequest.Builder().apply(block).build())

/**
 * Retrieves the phone number settings for the administrator's AWS account, such as the default outbound calling name.
 */
public suspend inline fun ChimeClient.getPhoneNumberSettings(crossinline block: GetPhoneNumberSettingsRequest.Builder.() -> Unit): GetPhoneNumberSettingsResponse = getPhoneNumberSettings(GetPhoneNumberSettingsRequest.Builder().apply(block).build())

/**
 * Gets the retention settings for the specified Amazon Chime Enterprise account. For more information about retention settings, see [Managing Chat Retention Policies](https://docs.aws.amazon.com/chime/latest/ag/chat-retention.html) in the *Amazon Chime Administration Guide*.
 */
public suspend inline fun ChimeClient.getRetentionSettings(crossinline block: GetRetentionSettingsRequest.Builder.() -> Unit): GetRetentionSettingsResponse = getRetentionSettings(GetRetentionSettingsRequest.Builder().apply(block).build())

/**
 * Retrieves room details, such as the room name, for a room in an Amazon Chime Enterprise account.
 */
public suspend inline fun ChimeClient.getRoom(crossinline block: GetRoomRequest.Builder.() -> Unit): GetRoomResponse = getRoom(GetRoomRequest.Builder().apply(block).build())

/**
 * Retrieves details for the specified user ID, such as primary email address, license type,and personal meeting PIN.
 *
 *  To retrieve user details with an email address instead of a user ID, use the ListUsers action, and then filter by email address.
 */
public suspend inline fun ChimeClient.getUser(crossinline block: GetUserRequest.Builder.() -> Unit): GetUserResponse = getUser(GetUserRequest.Builder().apply(block).build())

/**
 * Retrieves settings for the specified user ID, such as any associated phone number settings.
 */
public suspend inline fun ChimeClient.getUserSettings(crossinline block: GetUserSettingsRequest.Builder.() -> Unit): GetUserSettingsResponse = getUserSettings(GetUserSettingsRequest.Builder().apply(block).build())

/**
 * Sends email to a maximum of 50 users, inviting them to the specified Amazon Chime `Team` account. Only `Team` account types are currently supported for this action.
 */
public suspend inline fun ChimeClient.inviteUsers(crossinline block: InviteUsersRequest.Builder.() -> Unit): InviteUsersResponse = inviteUsers(InviteUsersRequest.Builder().apply(block).build())

/**
 * Lists the Amazon Chime accounts under the administrator's AWS account. You can filter accounts by account name prefix. To find out which Amazon Chime account a user belongs to, you can filter by the user's email address, which returns one account result.
 */
public suspend inline fun ChimeClient.listAccounts(crossinline block: ListAccountsRequest.Builder.() -> Unit): ListAccountsResponse = listAccounts(ListAccountsRequest.Builder().apply(block).build())

/**
 * Lists the bots associated with the administrator's Amazon Chime Enterprise account ID.
 */
public suspend inline fun ChimeClient.listBots(crossinline block: ListBotsRequest.Builder.() -> Unit): ListBotsResponse = listBots(ListBotsRequest.Builder().apply(block).build())

/**
 * Lists the phone number orders for the administrator's Amazon Chime account.
 */
public suspend inline fun ChimeClient.listPhoneNumberOrders(crossinline block: ListPhoneNumberOrdersRequest.Builder.() -> Unit): ListPhoneNumberOrdersResponse = listPhoneNumberOrders(ListPhoneNumberOrdersRequest.Builder().apply(block).build())

/**
 * Lists the phone numbers for the specified Amazon Chime account, Amazon Chime user, Amazon Chime Voice Connector, or Amazon Chime Voice Connector group.
 */
public suspend inline fun ChimeClient.listPhoneNumbers(crossinline block: ListPhoneNumbersRequest.Builder.() -> Unit): ListPhoneNumbersResponse = listPhoneNumbers(ListPhoneNumbersRequest.Builder().apply(block).build())

/**
 * Lists the membership details for the specified room in an Amazon Chime Enterprise account, such as the members' IDs, email addresses, and names.
 */
public suspend inline fun ChimeClient.listRoomMemberships(crossinline block: ListRoomMembershipsRequest.Builder.() -> Unit): ListRoomMembershipsResponse = listRoomMemberships(ListRoomMembershipsRequest.Builder().apply(block).build())

/**
 * Lists the room details for the specified Amazon Chime Enterprise account. Optionally, filter the results by a member ID (user ID or bot ID) to see a list of rooms that the member belongs to.
 */
public suspend inline fun ChimeClient.listRooms(crossinline block: ListRoomsRequest.Builder.() -> Unit): ListRoomsResponse = listRooms(ListRoomsRequest.Builder().apply(block).build())

/**
 * Lists supported phone number countries.
 */
public suspend inline fun ChimeClient.listSupportedPhoneNumberCountries(crossinline block: ListSupportedPhoneNumberCountriesRequest.Builder.() -> Unit): ListSupportedPhoneNumberCountriesResponse = listSupportedPhoneNumberCountries(ListSupportedPhoneNumberCountriesRequest.Builder().apply(block).build())

/**
 * Lists the users that belong to the specified Amazon Chime account. You can specify an email address to list only the user that the email address belongs to.
 */
public suspend inline fun ChimeClient.listUsers(crossinline block: ListUsersRequest.Builder.() -> Unit): ListUsersResponse = listUsers(ListUsersRequest.Builder().apply(block).build())

/**
 * Logs out the specified user from all of the devices they are currently logged into.
 */
public suspend inline fun ChimeClient.logoutUser(crossinline block: LogoutUserRequest.Builder.() -> Unit): LogoutUserResponse = logoutUser(LogoutUserRequest.Builder().apply(block).build())

/**
 * Creates an events configuration that allows a bot to receive outgoing events sent by Amazon Chime. Choose either an HTTPS endpoint or a Lambda function ARN. For more information, see Bot.
 */
public suspend inline fun ChimeClient.putEventsConfiguration(crossinline block: PutEventsConfigurationRequest.Builder.() -> Unit): PutEventsConfigurationResponse = putEventsConfiguration(PutEventsConfigurationRequest.Builder().apply(block).build())

/**
 * Puts retention settings for the specified Amazon Chime Enterprise account. We recommend using AWS CloudTrail to monitor usage of this API for your account. For more information, see [Logging Amazon Chime API Calls with AWS CloudTrail](https://docs.aws.amazon.com/chime/latest/ag/cloudtrail.html) in the *Amazon Chime Administration Guide*.
 *
 *  To turn off existing retention settings, remove the number of days from the corresponding **RetentionDays** field in the **RetentionSettings** object. For more information about retention settings, see [Managing Chat Retention Policies](https://docs.aws.amazon.com/chime/latest/ag/chat-retention.html) in the *Amazon Chime Administration Guide*.
 */
public suspend inline fun ChimeClient.putRetentionSettings(crossinline block: PutRetentionSettingsRequest.Builder.() -> Unit): PutRetentionSettingsResponse = putRetentionSettings(PutRetentionSettingsRequest.Builder().apply(block).build())

/**
 * Redacts the specified message from the specified Amazon Chime conversation.
 */
public suspend inline fun ChimeClient.redactConversationMessage(crossinline block: RedactConversationMessageRequest.Builder.() -> Unit): RedactConversationMessageResponse = redactConversationMessage(RedactConversationMessageRequest.Builder().apply(block).build())

/**
 * Redacts the specified message from the specified Amazon Chime channel.
 */
public suspend inline fun ChimeClient.redactRoomMessage(crossinline block: RedactRoomMessageRequest.Builder.() -> Unit): RedactRoomMessageResponse = redactRoomMessage(RedactRoomMessageRequest.Builder().apply(block).build())

/**
 * Regenerates the security token for a bot.
 */
public suspend inline fun ChimeClient.regenerateSecurityToken(crossinline block: RegenerateSecurityTokenRequest.Builder.() -> Unit): RegenerateSecurityTokenResponse = regenerateSecurityToken(RegenerateSecurityTokenRequest.Builder().apply(block).build())

/**
 * Resets the personal meeting PIN for the specified user on an Amazon Chime account. Returns the User object with the updated personal meeting PIN.
 */
public suspend inline fun ChimeClient.resetPersonalPin(crossinline block: ResetPersonalPinRequest.Builder.() -> Unit): ResetPersonalPinResponse = resetPersonalPin(ResetPersonalPinRequest.Builder().apply(block).build())

/**
 * Moves a phone number from the **Deletion queue** back into the phone number **Inventory**.
 */
public suspend inline fun ChimeClient.restorePhoneNumber(crossinline block: RestorePhoneNumberRequest.Builder.() -> Unit): RestorePhoneNumberResponse = restorePhoneNumber(RestorePhoneNumberRequest.Builder().apply(block).build())

/**
 * Searches for phone numbers that can be ordered. For US numbers, provide at least one of the following search filters: `AreaCode`, `City`, `State`, or `TollFreePrefix`. If you provide `City`, you must also provide `State`. Numbers outside the US only support the `PhoneNumberType` filter, which you must use.
 */
public suspend inline fun ChimeClient.searchAvailablePhoneNumbers(crossinline block: SearchAvailablePhoneNumbersRequest.Builder.() -> Unit): SearchAvailablePhoneNumbersResponse = searchAvailablePhoneNumbers(SearchAvailablePhoneNumbersRequest.Builder().apply(block).build())

/**
 * Updates account details for the specified Amazon Chime account. Currently, only account name and default license updates are supported for this action.
 */
public suspend inline fun ChimeClient.updateAccount(crossinline block: UpdateAccountRequest.Builder.() -> Unit): UpdateAccountResponse = updateAccount(UpdateAccountRequest.Builder().apply(block).build())

/**
 * Updates the settings for the specified Amazon Chime account. You can update settings for remote control of shared screens, or for the dial-out option. For more information about these settings, see [Use the Policies Page](https://docs.aws.amazon.com/chime/latest/ag/policies.html) in the *Amazon Chime Administration Guide*.
 */
public suspend inline fun ChimeClient.updateAccountSettings(crossinline block: UpdateAccountSettingsRequest.Builder.() -> Unit): UpdateAccountSettingsResponse = updateAccountSettings(UpdateAccountSettingsRequest.Builder().apply(block).build())

/**
 * Updates the status of the specified bot, such as starting or stopping the bot from running in your Amazon Chime Enterprise account.
 */
public suspend inline fun ChimeClient.updateBot(crossinline block: UpdateBotRequest.Builder.() -> Unit): UpdateBotResponse = updateBot(UpdateBotRequest.Builder().apply(block).build())

/**
 * Updates global settings for the administrator's AWS account, such as Amazon Chime Business Calling and Amazon Chime Voice Connector settings.
 */
public suspend inline fun ChimeClient.updateGlobalSettings(crossinline block: UpdateGlobalSettingsRequest.Builder.() -> Unit): UpdateGlobalSettingsResponse = updateGlobalSettings(UpdateGlobalSettingsRequest.Builder().apply(block).build())

/**
 * Updates phone number details, such as product type or calling name, for the specified phone number ID. You can update one phone number detail at a time. For example, you can update either the product type or the calling name in one action.
 *
 * For toll-free numbers, you cannot use the Amazon Chime Business Calling product type. For numbers outside the U.S., you must use the Amazon Chime SIP Media Application Dial-In product type.
 *
 * Updates to outbound calling names can take 72 hours to complete. Pending updates to outbound calling names must be complete before you can request another update.
 */
public suspend inline fun ChimeClient.updatePhoneNumber(crossinline block: UpdatePhoneNumberRequest.Builder.() -> Unit): UpdatePhoneNumberResponse = updatePhoneNumber(UpdatePhoneNumberRequest.Builder().apply(block).build())

/**
 * Updates the phone number settings for the administrator's AWS account, such as the default outbound calling name. You can update the default outbound calling name once every seven days. Outbound calling names can take up to 72 hours to update.
 */
public suspend inline fun ChimeClient.updatePhoneNumberSettings(crossinline block: UpdatePhoneNumberSettingsRequest.Builder.() -> Unit): UpdatePhoneNumberSettingsResponse = updatePhoneNumberSettings(UpdatePhoneNumberSettingsRequest.Builder().apply(block).build())

/**
 * Updates room details, such as the room name, for a room in an Amazon Chime Enterprise account.
 */
public suspend inline fun ChimeClient.updateRoom(crossinline block: UpdateRoomRequest.Builder.() -> Unit): UpdateRoomResponse = updateRoom(UpdateRoomRequest.Builder().apply(block).build())

/**
 * Updates room membership details, such as the member role, for a room in an Amazon Chime Enterprise account. The member role designates whether the member is a chat room administrator or a general chat room member. The member role can be updated only for user IDs.
 */
public suspend inline fun ChimeClient.updateRoomMembership(crossinline block: UpdateRoomMembershipRequest.Builder.() -> Unit): UpdateRoomMembershipResponse = updateRoomMembership(UpdateRoomMembershipRequest.Builder().apply(block).build())

/**
 * Updates user details for a specified user ID. Currently, only `LicenseType` updates are supported for this action.
 */
public suspend inline fun ChimeClient.updateUser(crossinline block: UpdateUserRequest.Builder.() -> Unit): UpdateUserResponse = updateUser(UpdateUserRequest.Builder().apply(block).build())

/**
 * Updates the settings for the specified user, such as phone number settings.
 */
public suspend inline fun ChimeClient.updateUserSettings(crossinline block: UpdateUserSettingsRequest.Builder.() -> Unit): UpdateUserSettingsResponse = updateUserSettings(UpdateUserSettingsRequest.Builder().apply(block).build())
