// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.budgets.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The amount of cost or usage that's measured for a budget.
 *
 * *Cost example:* A `Spend` for `3 USD` of costs has the following parameters:
 * + An `Amount` of `3`
 * + A `Unit` of `USD`
 *
 * *Usage example:* A `Spend` for `3 GB` of S3 usage has the following parameters:
 * + An `Amount` of `3`
 * + A `Unit` of `GB`
 */
public class Spend private constructor(builder: Builder) {
    /**
     * The cost or usage amount that's associated with a budget forecast, actual spend, or budget threshold.
     */
    public val amount: kotlin.String = requireNotNull(builder.amount) { "A non-null value must be provided for amount" }
    /**
     * The unit of measurement that's used for the budget forecast, actual spend, or budget threshold.
     */
    public val unit: kotlin.String = requireNotNull(builder.unit) { "A non-null value must be provided for unit" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.budgets.model.Spend = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Spend(")
        append("amount=$amount,")
        append("unit=$unit")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = amount.hashCode()
        result = 31 * result + (unit.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Spend

        if (amount != other.amount) return false
        if (unit != other.unit) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.budgets.model.Spend = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The cost or usage amount that's associated with a budget forecast, actual spend, or budget threshold.
         */
        public var amount: kotlin.String? = null
        /**
         * The unit of measurement that's used for the budget forecast, actual spend, or budget threshold.
         */
        public var unit: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.budgets.model.Spend) : this() {
            this.amount = x.amount
            this.unit = x.unit
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.budgets.model.Spend = Spend(this)

        internal fun correctErrors(): Builder {
            if (amount == null) amount = ""
            if (unit == null) unit = ""
            return this
        }
    }
}
