// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.budgets.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A notification that's associated with a budget. A budget can have up to ten notifications.
 *
 * Each notification must have at least one subscriber. A notification can have one SNS subscriber and up to 10 email subscribers, for a total of 11 subscribers.
 *
 * For example, if you have a budget for 200 dollars and you want to be notified when you go over 160 dollars, create a notification with the following parameters:
 * + A notificationType of `ACTUAL`
 * + A `thresholdType` of `PERCENTAGE`
 * + A `comparisonOperator` of `GREATER_THAN`
 * + A notification `threshold` of `80`
 */
public class Notification private constructor(builder: Builder) {
    /**
     * The comparison that's used for this notification.
     */
    public val comparisonOperator: aws.sdk.kotlin.services.budgets.model.ComparisonOperator = requireNotNull(builder.comparisonOperator) { "A non-null value must be provided for comparisonOperator" }
    /**
     * Specifies whether this notification is in alarm. If a budget notification is in the `ALARM` state, you passed the set threshold for the budget.
     */
    public val notificationState: aws.sdk.kotlin.services.budgets.model.NotificationState? = builder.notificationState
    /**
     * Specifies whether the notification is for how much you have spent (`ACTUAL`) or for how much that you're forecasted to spend (`FORECASTED`).
     */
    public val notificationType: aws.sdk.kotlin.services.budgets.model.NotificationType = requireNotNull(builder.notificationType) { "A non-null value must be provided for notificationType" }
    /**
     * The threshold that's associated with a notification. Thresholds are always a percentage, and many customers find value being alerted between 50% - 200% of the budgeted amount. The maximum limit for your threshold is 1,000,000% above the budgeted amount.
     */
    public val threshold: kotlin.Double = builder.threshold
    /**
     * The type of threshold for a notification. For `ABSOLUTE_VALUE` thresholds, Amazon Web Services notifies you when you go over or are forecasted to go over your total cost threshold. For `PERCENTAGE` thresholds, Amazon Web Services notifies you when you go over or are forecasted to go over a certain percentage of your forecasted spend. For example, if you have a budget for 200 dollars and you have a `PERCENTAGE` threshold of 80%, Amazon Web Services notifies you when you go over 160 dollars.
     */
    public val thresholdType: aws.sdk.kotlin.services.budgets.model.ThresholdType? = builder.thresholdType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.budgets.model.Notification = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Notification(")
        append("comparisonOperator=$comparisonOperator,")
        append("notificationState=$notificationState,")
        append("notificationType=$notificationType,")
        append("threshold=$threshold,")
        append("thresholdType=$thresholdType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = comparisonOperator.hashCode()
        result = 31 * result + (notificationState?.hashCode() ?: 0)
        result = 31 * result + (notificationType.hashCode())
        result = 31 * result + (threshold.hashCode())
        result = 31 * result + (thresholdType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Notification

        if (comparisonOperator != other.comparisonOperator) return false
        if (notificationState != other.notificationState) return false
        if (notificationType != other.notificationType) return false
        if (!(threshold?.equals(other.threshold) ?: (other.threshold == null))) return false
        if (thresholdType != other.thresholdType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.budgets.model.Notification = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The comparison that's used for this notification.
         */
        public var comparisonOperator: aws.sdk.kotlin.services.budgets.model.ComparisonOperator? = null
        /**
         * Specifies whether this notification is in alarm. If a budget notification is in the `ALARM` state, you passed the set threshold for the budget.
         */
        public var notificationState: aws.sdk.kotlin.services.budgets.model.NotificationState? = null
        /**
         * Specifies whether the notification is for how much you have spent (`ACTUAL`) or for how much that you're forecasted to spend (`FORECASTED`).
         */
        public var notificationType: aws.sdk.kotlin.services.budgets.model.NotificationType? = null
        /**
         * The threshold that's associated with a notification. Thresholds are always a percentage, and many customers find value being alerted between 50% - 200% of the budgeted amount. The maximum limit for your threshold is 1,000,000% above the budgeted amount.
         */
        public var threshold: kotlin.Double = 0.0
        /**
         * The type of threshold for a notification. For `ABSOLUTE_VALUE` thresholds, Amazon Web Services notifies you when you go over or are forecasted to go over your total cost threshold. For `PERCENTAGE` thresholds, Amazon Web Services notifies you when you go over or are forecasted to go over a certain percentage of your forecasted spend. For example, if you have a budget for 200 dollars and you have a `PERCENTAGE` threshold of 80%, Amazon Web Services notifies you when you go over 160 dollars.
         */
        public var thresholdType: aws.sdk.kotlin.services.budgets.model.ThresholdType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.budgets.model.Notification) : this() {
            this.comparisonOperator = x.comparisonOperator
            this.notificationState = x.notificationState
            this.notificationType = x.notificationType
            this.threshold = x.threshold
            this.thresholdType = x.thresholdType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.budgets.model.Notification = Notification(this)

        internal fun correctErrors(): Builder {
            if (comparisonOperator == null) comparisonOperator = ComparisonOperator.SdkUnknown("no value provided")
            if (notificationType == null) notificationType = NotificationType.SdkUnknown("no value provided")
            return this
        }
    }
}
