// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.budgets.serde

import aws.sdk.kotlin.services.budgets.model.Action
import aws.sdk.kotlin.services.budgets.model.BudgetsException
import aws.sdk.kotlin.services.budgets.model.UpdateBudgetActionResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateBudgetActionOperationDeserializer: HttpDeserializer.NonStreaming<UpdateBudgetActionResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): UpdateBudgetActionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdateBudgetActionError(context, call, payload)
        }
        val builder = UpdateBudgetActionResponse.Builder()

        if (payload != null) {
            deserializeUpdateBudgetActionOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwUpdateBudgetActionError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw BudgetsException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalErrorException" -> InternalErrorExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceLockedException" -> ResourceLockedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> BudgetsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateBudgetActionOperationBody(builder: UpdateBudgetActionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ACCOUNTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AccountId"))
    val BUDGETNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("BudgetName"))
    val NEWACTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("NewAction"))
    val OLDACTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("OldAction"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACCOUNTID_DESCRIPTOR)
        field(BUDGETNAME_DESCRIPTOR)
        field(NEWACTION_DESCRIPTOR)
        field(OLDACTION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ACCOUNTID_DESCRIPTOR.index -> builder.accountId = deserializeString()
                BUDGETNAME_DESCRIPTOR.index -> builder.budgetName = deserializeString()
                NEWACTION_DESCRIPTOR.index -> builder.newAction = deserializeActionDocument(deserializer)
                OLDACTION_DESCRIPTOR.index -> builder.oldAction = deserializeActionDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
