// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.budgets.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * The period of time that's covered by a budget. The period has a start date and an end date. The start date must come before the end date. There are no restrictions on the end date.
 */
public class TimePeriod private constructor(builder: Builder) {
    /**
     * The end date for a budget. If you didn't specify an end date, Amazon Web Services set your end date to `06/15/87 00:00 UTC`. The defaults are the same for the Billing and Cost Management console and the API.
     *
     * After the end date, Amazon Web Services deletes the budget and all the associated notifications and subscribers. You can change your end date with the `UpdateBudget` operation.
     */
    public val end: aws.smithy.kotlin.runtime.time.Instant? = builder.end
    /**
     * The start date for a budget. If you created your budget and didn't specify a start date, Amazon Web Services defaults to the start of your chosen time period (DAILY, MONTHLY, QUARTERLY, or ANNUALLY). For example, if you created your budget on January 24, 2018, chose `DAILY`, and didn't set a start date, Amazon Web Services set your start date to `01/24/18 00:00 UTC`. If you chose `MONTHLY`, Amazon Web Services set your start date to `01/01/18 00:00 UTC`. The defaults are the same for the Billing and Cost Management console and the API.
     *
     * You can change your start date with the `UpdateBudget` operation.
     */
    public val start: aws.smithy.kotlin.runtime.time.Instant? = builder.start

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.budgets.model.TimePeriod = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TimePeriod(")
        append("end=$end,")
        append("start=$start")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = end?.hashCode() ?: 0
        result = 31 * result + (start?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TimePeriod

        if (end != other.end) return false
        if (start != other.start) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.budgets.model.TimePeriod = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The end date for a budget. If you didn't specify an end date, Amazon Web Services set your end date to `06/15/87 00:00 UTC`. The defaults are the same for the Billing and Cost Management console and the API.
         *
         * After the end date, Amazon Web Services deletes the budget and all the associated notifications and subscribers. You can change your end date with the `UpdateBudget` operation.
         */
        public var end: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The start date for a budget. If you created your budget and didn't specify a start date, Amazon Web Services defaults to the start of your chosen time period (DAILY, MONTHLY, QUARTERLY, or ANNUALLY). For example, if you created your budget on January 24, 2018, chose `DAILY`, and didn't set a start date, Amazon Web Services set your start date to `01/24/18 00:00 UTC`. If you chose `MONTHLY`, Amazon Web Services set your start date to `01/01/18 00:00 UTC`. The defaults are the same for the Billing and Cost Management console and the API.
         *
         * You can change your start date with the `UpdateBudget` operation.
         */
        public var start: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.budgets.model.TimePeriod) : this() {
            this.end = x.end
            this.start = x.start
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.budgets.model.TimePeriod = TimePeriod(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
