// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.budgets.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Represents the output of the `CreateBudget` operation. The content consists of the detailed metadata and data file information, and the current status of the `budget` object.
 *
 * This is the Amazon Resource Name (ARN) pattern for a budget:
 *
 * `arn:aws:budgets::AccountId:budget/budgetName`
 */
public class Budget private constructor(builder: Builder) {
    /**
     * The parameters that determine the budget amount for an auto-adjusting budget.
     */
    public val autoAdjustData: aws.sdk.kotlin.services.budgets.model.AutoAdjustData? = builder.autoAdjustData
    /**
     * The total amount of cost, usage, RI utilization, RI coverage, Savings Plans utilization, or Savings Plans coverage that you want to track with your budget.
     *
     * `BudgetLimit` is required for cost or usage budgets, but optional for RI or Savings Plans utilization or coverage budgets. RI and Savings Plans utilization or coverage budgets default to `100`. This is the only valid value for RI or Savings Plans utilization or coverage budgets. You can't use `BudgetLimit` with `PlannedBudgetLimits` for `CreateBudget` and `UpdateBudget` actions.
     */
    public val budgetLimit: aws.sdk.kotlin.services.budgets.model.Spend? = builder.budgetLimit
    /**
     * The name of a budget. The name must be unique within an account. The `:` and `\` characters, and the "/action/" substring, aren't allowed in `BudgetName`.
     */
    public val budgetName: kotlin.String = requireNotNull(builder.budgetName) { "A non-null value must be provided for budgetName" }
    /**
     * Specifies whether this budget tracks costs, usage, RI utilization, RI coverage, Savings Plans utilization, or Savings Plans coverage.
     */
    public val budgetType: aws.sdk.kotlin.services.budgets.model.BudgetType = requireNotNull(builder.budgetType) { "A non-null value must be provided for budgetType" }
    /**
     * The actual and forecasted cost or usage that the budget tracks.
     */
    public val calculatedSpend: aws.sdk.kotlin.services.budgets.model.CalculatedSpend? = builder.calculatedSpend
    /**
     * The cost filters, such as `Region`, `Service`, `LinkedAccount`, `Tag`, or `CostCategory`, that are applied to a budget.
     *
     * Amazon Web Services Budgets supports the following services as a `Service` filter for RI budgets:
     * + Amazon EC2
     * + Amazon Redshift
     * + Amazon Relational Database Service
     * + Amazon ElastiCache
     * + Amazon OpenSearch Service
     */
    @Deprecated("CostFilters lack support for newer dimensions and filtering options. Please consider using the new 'FilterExpression' field.")
    public val costFilters: Map<String, List<String>>? = builder.costFilters
    /**
     * The types of costs that are included in this `COST` budget.
     *
     * `USAGE`, `RI_UTILIZATION`, `RI_COVERAGE`, `SAVINGS_PLANS_UTILIZATION`, and `SAVINGS_PLANS_COVERAGE` budgets do not have `CostTypes`.
     */
    @Deprecated("CostTypes lack support for newer record type dimensions and filtering options. Please consider using the new 'Metrics' field.")
    public val costTypes: aws.sdk.kotlin.services.budgets.model.CostTypes? = builder.costTypes
    /**
     * The filtering dimensions for the budget and their corresponding values.
     */
    public val filterExpression: aws.sdk.kotlin.services.budgets.model.Expression? = builder.filterExpression
    /**
     * The last time that you updated this budget.
     */
    public val lastUpdatedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedTime
    /**
     * The definition for how the budget data is aggregated.
     */
    public val metrics: List<Metric>? = builder.metrics
    /**
     * A map containing multiple `BudgetLimit`, including current or future limits.
     *
     * `PlannedBudgetLimits` is available for cost or usage budget and supports both monthly and quarterly `TimeUnit`.
     *
     * For monthly budgets, provide 12 months of `PlannedBudgetLimits` values. This must start from the current month and include the next 11 months. The `key` is the start of the month, `UTC` in epoch seconds.
     *
     * For quarterly budgets, provide four quarters of `PlannedBudgetLimits` value entries in standard calendar quarter increments. This must start from the current quarter and include the next three quarters. The `key` is the start of the quarter, `UTC` in epoch seconds.
     *
     * If the planned budget expires before 12 months for monthly or four quarters for quarterly, provide the `PlannedBudgetLimits` values only for the remaining periods.
     *
     * If the budget begins at a date in the future, provide `PlannedBudgetLimits` values from the start date of the budget.
     *
     * After all of the `BudgetLimit` values in `PlannedBudgetLimits` are used, the budget continues to use the last limit as the `BudgetLimit`. At that point, the planned budget provides the same experience as a fixed budget.
     *
     * `DescribeBudget` and `DescribeBudgets` response along with `PlannedBudgetLimits` also contain `BudgetLimit` representing the current month or quarter limit present in `PlannedBudgetLimits`. This only applies to budgets that are created with `PlannedBudgetLimits`. Budgets that are created without `PlannedBudgetLimits` only contain `BudgetLimit`. They don't contain `PlannedBudgetLimits`.
     */
    public val plannedBudgetLimits: Map<String, Spend>? = builder.plannedBudgetLimits
    /**
     * The period of time that's covered by a budget. You set the start date and end date. The start date must come before the end date. The end date must come before `06/15/87 00:00 UTC`.
     *
     * If you create your budget and don't specify a start date, Amazon Web Services defaults to the start of your chosen time period (DAILY, MONTHLY, QUARTERLY, or ANNUALLY). For example, if you created your budget on January 24, 2018, chose `DAILY`, and didn't set a start date, Amazon Web Services set your start date to `01/24/18 00:00 UTC`. If you chose `MONTHLY`, Amazon Web Services set your start date to `01/01/18 00:00 UTC`. If you didn't specify an end date, Amazon Web Services set your end date to `06/15/87 00:00 UTC`. The defaults are the same for the Billing and Cost Management console and the API.
     *
     * You can change either date with the `UpdateBudget` operation.
     *
     * After the end date, Amazon Web Services deletes the budget and all the associated notifications and subscribers.
     */
    public val timePeriod: aws.sdk.kotlin.services.budgets.model.TimePeriod? = builder.timePeriod
    /**
     * The length of time until a budget resets the actual and forecasted spend.
     */
    public val timeUnit: aws.sdk.kotlin.services.budgets.model.TimeUnit = requireNotNull(builder.timeUnit) { "A non-null value must be provided for timeUnit" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.budgets.model.Budget = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Budget(")
        append("autoAdjustData=$autoAdjustData,")
        append("budgetLimit=$budgetLimit,")
        append("budgetName=$budgetName,")
        append("budgetType=$budgetType,")
        append("calculatedSpend=$calculatedSpend,")
        append("costFilters=$costFilters,")
        append("costTypes=$costTypes,")
        append("filterExpression=$filterExpression,")
        append("lastUpdatedTime=$lastUpdatedTime,")
        append("metrics=$metrics,")
        append("plannedBudgetLimits=$plannedBudgetLimits,")
        append("timePeriod=$timePeriod,")
        append("timeUnit=$timeUnit")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = autoAdjustData?.hashCode() ?: 0
        result = 31 * result + (budgetLimit?.hashCode() ?: 0)
        result = 31 * result + (budgetName.hashCode())
        result = 31 * result + (budgetType.hashCode())
        result = 31 * result + (calculatedSpend?.hashCode() ?: 0)
        result = 31 * result + (costFilters?.hashCode() ?: 0)
        result = 31 * result + (costTypes?.hashCode() ?: 0)
        result = 31 * result + (filterExpression?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedTime?.hashCode() ?: 0)
        result = 31 * result + (metrics?.hashCode() ?: 0)
        result = 31 * result + (plannedBudgetLimits?.hashCode() ?: 0)
        result = 31 * result + (timePeriod?.hashCode() ?: 0)
        result = 31 * result + (timeUnit.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Budget

        if (autoAdjustData != other.autoAdjustData) return false
        if (budgetLimit != other.budgetLimit) return false
        if (budgetName != other.budgetName) return false
        if (budgetType != other.budgetType) return false
        if (calculatedSpend != other.calculatedSpend) return false
        if (costFilters != other.costFilters) return false
        if (costTypes != other.costTypes) return false
        if (filterExpression != other.filterExpression) return false
        if (lastUpdatedTime != other.lastUpdatedTime) return false
        if (metrics != other.metrics) return false
        if (plannedBudgetLimits != other.plannedBudgetLimits) return false
        if (timePeriod != other.timePeriod) return false
        if (timeUnit != other.timeUnit) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.budgets.model.Budget = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The parameters that determine the budget amount for an auto-adjusting budget.
         */
        public var autoAdjustData: aws.sdk.kotlin.services.budgets.model.AutoAdjustData? = null
        /**
         * The total amount of cost, usage, RI utilization, RI coverage, Savings Plans utilization, or Savings Plans coverage that you want to track with your budget.
         *
         * `BudgetLimit` is required for cost or usage budgets, but optional for RI or Savings Plans utilization or coverage budgets. RI and Savings Plans utilization or coverage budgets default to `100`. This is the only valid value for RI or Savings Plans utilization or coverage budgets. You can't use `BudgetLimit` with `PlannedBudgetLimits` for `CreateBudget` and `UpdateBudget` actions.
         */
        public var budgetLimit: aws.sdk.kotlin.services.budgets.model.Spend? = null
        /**
         * The name of a budget. The name must be unique within an account. The `:` and `\` characters, and the "/action/" substring, aren't allowed in `BudgetName`.
         */
        public var budgetName: kotlin.String? = null
        /**
         * Specifies whether this budget tracks costs, usage, RI utilization, RI coverage, Savings Plans utilization, or Savings Plans coverage.
         */
        public var budgetType: aws.sdk.kotlin.services.budgets.model.BudgetType? = null
        /**
         * The actual and forecasted cost or usage that the budget tracks.
         */
        public var calculatedSpend: aws.sdk.kotlin.services.budgets.model.CalculatedSpend? = null
        /**
         * The cost filters, such as `Region`, `Service`, `LinkedAccount`, `Tag`, or `CostCategory`, that are applied to a budget.
         *
         * Amazon Web Services Budgets supports the following services as a `Service` filter for RI budgets:
         * + Amazon EC2
         * + Amazon Redshift
         * + Amazon Relational Database Service
         * + Amazon ElastiCache
         * + Amazon OpenSearch Service
         */
        @Deprecated("CostFilters lack support for newer dimensions and filtering options. Please consider using the new 'FilterExpression' field.")
        public var costFilters: Map<String, List<String>>? = null
        /**
         * The types of costs that are included in this `COST` budget.
         *
         * `USAGE`, `RI_UTILIZATION`, `RI_COVERAGE`, `SAVINGS_PLANS_UTILIZATION`, and `SAVINGS_PLANS_COVERAGE` budgets do not have `CostTypes`.
         */
        @Deprecated("CostTypes lack support for newer record type dimensions and filtering options. Please consider using the new 'Metrics' field.")
        public var costTypes: aws.sdk.kotlin.services.budgets.model.CostTypes? = null
        /**
         * The filtering dimensions for the budget and their corresponding values.
         */
        public var filterExpression: aws.sdk.kotlin.services.budgets.model.Expression? = null
        /**
         * The last time that you updated this budget.
         */
        public var lastUpdatedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The definition for how the budget data is aggregated.
         */
        public var metrics: List<Metric>? = null
        /**
         * A map containing multiple `BudgetLimit`, including current or future limits.
         *
         * `PlannedBudgetLimits` is available for cost or usage budget and supports both monthly and quarterly `TimeUnit`.
         *
         * For monthly budgets, provide 12 months of `PlannedBudgetLimits` values. This must start from the current month and include the next 11 months. The `key` is the start of the month, `UTC` in epoch seconds.
         *
         * For quarterly budgets, provide four quarters of `PlannedBudgetLimits` value entries in standard calendar quarter increments. This must start from the current quarter and include the next three quarters. The `key` is the start of the quarter, `UTC` in epoch seconds.
         *
         * If the planned budget expires before 12 months for monthly or four quarters for quarterly, provide the `PlannedBudgetLimits` values only for the remaining periods.
         *
         * If the budget begins at a date in the future, provide `PlannedBudgetLimits` values from the start date of the budget.
         *
         * After all of the `BudgetLimit` values in `PlannedBudgetLimits` are used, the budget continues to use the last limit as the `BudgetLimit`. At that point, the planned budget provides the same experience as a fixed budget.
         *
         * `DescribeBudget` and `DescribeBudgets` response along with `PlannedBudgetLimits` also contain `BudgetLimit` representing the current month or quarter limit present in `PlannedBudgetLimits`. This only applies to budgets that are created with `PlannedBudgetLimits`. Budgets that are created without `PlannedBudgetLimits` only contain `BudgetLimit`. They don't contain `PlannedBudgetLimits`.
         */
        public var plannedBudgetLimits: Map<String, Spend>? = null
        /**
         * The period of time that's covered by a budget. You set the start date and end date. The start date must come before the end date. The end date must come before `06/15/87 00:00 UTC`.
         *
         * If you create your budget and don't specify a start date, Amazon Web Services defaults to the start of your chosen time period (DAILY, MONTHLY, QUARTERLY, or ANNUALLY). For example, if you created your budget on January 24, 2018, chose `DAILY`, and didn't set a start date, Amazon Web Services set your start date to `01/24/18 00:00 UTC`. If you chose `MONTHLY`, Amazon Web Services set your start date to `01/01/18 00:00 UTC`. If you didn't specify an end date, Amazon Web Services set your end date to `06/15/87 00:00 UTC`. The defaults are the same for the Billing and Cost Management console and the API.
         *
         * You can change either date with the `UpdateBudget` operation.
         *
         * After the end date, Amazon Web Services deletes the budget and all the associated notifications and subscribers.
         */
        public var timePeriod: aws.sdk.kotlin.services.budgets.model.TimePeriod? = null
        /**
         * The length of time until a budget resets the actual and forecasted spend.
         */
        public var timeUnit: aws.sdk.kotlin.services.budgets.model.TimeUnit? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.budgets.model.Budget) : this() {
            this.autoAdjustData = x.autoAdjustData
            this.budgetLimit = x.budgetLimit
            this.budgetName = x.budgetName
            this.budgetType = x.budgetType
            this.calculatedSpend = x.calculatedSpend
            this.costFilters = x.costFilters
            this.costTypes = x.costTypes
            this.filterExpression = x.filterExpression
            this.lastUpdatedTime = x.lastUpdatedTime
            this.metrics = x.metrics
            this.plannedBudgetLimits = x.plannedBudgetLimits
            this.timePeriod = x.timePeriod
            this.timeUnit = x.timeUnit
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.budgets.model.Budget = Budget(this)

        /**
         * construct an [aws.sdk.kotlin.services.budgets.model.AutoAdjustData] inside the given [block]
         */
        public fun autoAdjustData(block: aws.sdk.kotlin.services.budgets.model.AutoAdjustData.Builder.() -> kotlin.Unit) {
            this.autoAdjustData = aws.sdk.kotlin.services.budgets.model.AutoAdjustData.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.budgets.model.Spend] inside the given [block]
         */
        public fun budgetLimit(block: aws.sdk.kotlin.services.budgets.model.Spend.Builder.() -> kotlin.Unit) {
            this.budgetLimit = aws.sdk.kotlin.services.budgets.model.Spend.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.budgets.model.CalculatedSpend] inside the given [block]
         */
        public fun calculatedSpend(block: aws.sdk.kotlin.services.budgets.model.CalculatedSpend.Builder.() -> kotlin.Unit) {
            this.calculatedSpend = aws.sdk.kotlin.services.budgets.model.CalculatedSpend.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.budgets.model.CostTypes] inside the given [block]
         */
        @Deprecated("CostTypes lack support for newer record type dimensions and filtering options. Please consider using the new 'Metrics' field.")
        public fun costTypes(block: aws.sdk.kotlin.services.budgets.model.CostTypes.Builder.() -> kotlin.Unit) {
            this.costTypes = aws.sdk.kotlin.services.budgets.model.CostTypes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.budgets.model.Expression] inside the given [block]
         */
        public fun filterExpression(block: aws.sdk.kotlin.services.budgets.model.Expression.Builder.() -> kotlin.Unit) {
            this.filterExpression = aws.sdk.kotlin.services.budgets.model.Expression.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.budgets.model.TimePeriod] inside the given [block]
         */
        public fun timePeriod(block: aws.sdk.kotlin.services.budgets.model.TimePeriod.Builder.() -> kotlin.Unit) {
            this.timePeriod = aws.sdk.kotlin.services.budgets.model.TimePeriod.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (budgetName == null) budgetName = ""
            if (budgetType == null) budgetType = BudgetType.SdkUnknown("no value provided")
            if (timeUnit == null) timeUnit = TimeUnit.SdkUnknown("no value provided")
            return this
        }
    }
}
