// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.budgets.endpoints

import aws.sdk.kotlin.services.budgets.endpoints.internal.partition
import aws.smithy.kotlin.runtime.businessmetrics.ServiceEndpointOverride
import aws.smithy.kotlin.runtime.client.endpoints.Endpoint
import aws.smithy.kotlin.runtime.client.endpoints.EndpointProviderException
import aws.smithy.kotlin.runtime.client.endpoints.SigningContextAttributeKey
import aws.smithy.kotlin.runtime.collections.attributesOf
import aws.smithy.kotlin.runtime.http.auth.sigV4
import aws.smithy.kotlin.runtime.net.url.Url

/**
 * The default endpoint provider as specified by the service model.
 */
public class DefaultBudgetsEndpointProvider: BudgetsEndpointProvider {
    public override suspend fun resolveEndpoint(params: BudgetsEndpointParameters): Endpoint {
        if (
            params.endpoint != null
        ) {
            if (
                params.useFips == true
            ) {
                throw EndpointProviderException("Invalid Configuration: FIPS and custom endpoint are not supported")
            }
            if (
                params.useDualStack == true
            ) {
                throw EndpointProviderException("Invalid Configuration: Dualstack and custom endpoint are not supported")
            }
            return Endpoint(
                Url.parse(params.endpoint),
                attributes = attributesOf {
                    ServiceEndpointOverride to true
                },
            )
        }
        if (
            params.region != null
        ) {
            run {
                val partitionResult = partition(params.region)
                if (
                    partitionResult != null
                ) {
                    if (
                        partitionResult?.name == "aws" &&
                        params.useFips == false &&
                        params.useDualStack == true
                    ) {
                        return Endpoint(
                            Url.parse("https://budgets.us-east-1.api.aws"),
                            attributes = attributesOf {
                                SigningContextAttributeKey to listOf(
                                    sigV4(
                                        serviceName = null,
                                        disableDoubleUriEncode = false,
                                        signingRegion = "us-east-1",
                                    ),
                                )
                            },
                        )
                    }
                    if (
                        partitionResult?.name == "aws-iso-b" &&
                        params.useFips == false &&
                        params.useDualStack == false
                    ) {
                        return Endpoint(
                            Url.parse("https://budgets.global.sc2s.sgov.gov"),
                            attributes = attributesOf {
                                SigningContextAttributeKey to listOf(
                                    sigV4(
                                        serviceName = null,
                                        disableDoubleUriEncode = false,
                                        signingRegion = "us-isob-east-1",
                                    ),
                                )
                            },
                        )
                    }
                    if (
                        partitionResult?.name == "aws-iso-e" &&
                        params.useFips == false &&
                        params.useDualStack == false
                    ) {
                        return Endpoint(
                            Url.parse("https://budgets.global.cloud.adc-e.uk"),
                            attributes = attributesOf {
                                SigningContextAttributeKey to listOf(
                                    sigV4(
                                        serviceName = null,
                                        disableDoubleUriEncode = false,
                                        signingRegion = "eu-isoe-west-1",
                                    ),
                                )
                            },
                        )
                    }
                    if (
                        partitionResult?.name == "aws-iso-f" &&
                        params.useFips == false &&
                        params.useDualStack == false
                    ) {
                        return Endpoint(
                            Url.parse("https://budgets.global.csp.hci.ic.gov"),
                            attributes = attributesOf {
                                SigningContextAttributeKey to listOf(
                                    sigV4(
                                        serviceName = null,
                                        disableDoubleUriEncode = false,
                                        signingRegion = "us-isof-south-1",
                                    ),
                                )
                            },
                        )
                    }
                    if (
                        params.useFips == true &&
                        params.useDualStack == true
                    ) {
                        if (
                            true == partitionResult?.supportsFIPS &&
                            true == partitionResult?.supportsDualStack
                        ) {
                            return Endpoint(
                                Url.parse("https://budgets-fips.${partitionResult?.dualStackDnsSuffix}"),
                                attributes = attributesOf {
                                    SigningContextAttributeKey to listOf(
                                        sigV4(
                                            serviceName = null,
                                            disableDoubleUriEncode = false,
                                            signingRegion = "${partitionResult?.implicitGlobalRegion}",
                                        ),
                                    )
                                },
                            )
                        }
                        throw EndpointProviderException("FIPS and DualStack are enabled, but this partition does not support one or both")
                    }
                    if (
                        params.useFips == true &&
                        params.useDualStack == false
                    ) {
                        if (
                            partitionResult?.supportsFIPS == true
                        ) {
                            return Endpoint(
                                Url.parse("https://budgets-fips.${partitionResult?.dnsSuffix}"),
                                attributes = attributesOf {
                                    SigningContextAttributeKey to listOf(
                                        sigV4(
                                            serviceName = null,
                                            disableDoubleUriEncode = false,
                                            signingRegion = "${partitionResult?.implicitGlobalRegion}",
                                        ),
                                    )
                                },
                            )
                        }
                        throw EndpointProviderException("FIPS is enabled but this partition does not support FIPS")
                    }
                    if (
                        params.useFips == false &&
                        params.useDualStack == true
                    ) {
                        if (
                            true == partitionResult?.supportsDualStack
                        ) {
                            return Endpoint(
                                Url.parse("https://budgets.${partitionResult?.dualStackDnsSuffix}"),
                                attributes = attributesOf {
                                    SigningContextAttributeKey to listOf(
                                        sigV4(
                                            serviceName = null,
                                            disableDoubleUriEncode = false,
                                            signingRegion = "${partitionResult?.implicitGlobalRegion}",
                                        ),
                                    )
                                },
                            )
                        }
                        throw EndpointProviderException("DualStack is enabled but this partition does not support DualStack")
                    }
                    return Endpoint(
                        Url.parse("https://budgets.${partitionResult?.dnsSuffix}"),
                        attributes = attributesOf {
                            SigningContextAttributeKey to listOf(
                                sigV4(
                                    serviceName = null,
                                    disableDoubleUriEncode = false,
                                    signingRegion = "${partitionResult?.implicitGlobalRegion}",
                                ),
                            )
                        },
                    )
                }
            }
        }
        throw EndpointProviderException("Invalid Configuration: Missing Region")

        throw EndpointProviderException("endpoint rules were exhausted without a match")
    }
}
