// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.budgets

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.runtime.region.DefaultRegionProviderChain
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.budgets.auth.BudgetsAuthSchemeProvider
import aws.sdk.kotlin.services.budgets.auth.DefaultBudgetsAuthSchemeProvider
import aws.sdk.kotlin.services.budgets.endpoints.BudgetsEndpointParameters
import aws.sdk.kotlin.services.budgets.endpoints.BudgetsEndpointProvider
import aws.sdk.kotlin.services.budgets.endpoints.DefaultBudgetsEndpointProvider
import aws.sdk.kotlin.services.budgets.model.CreateBudgetActionRequest
import aws.sdk.kotlin.services.budgets.model.CreateBudgetActionResponse
import aws.sdk.kotlin.services.budgets.model.CreateBudgetRequest
import aws.sdk.kotlin.services.budgets.model.CreateBudgetResponse
import aws.sdk.kotlin.services.budgets.model.CreateNotificationRequest
import aws.sdk.kotlin.services.budgets.model.CreateNotificationResponse
import aws.sdk.kotlin.services.budgets.model.CreateSubscriberRequest
import aws.sdk.kotlin.services.budgets.model.CreateSubscriberResponse
import aws.sdk.kotlin.services.budgets.model.DeleteBudgetActionRequest
import aws.sdk.kotlin.services.budgets.model.DeleteBudgetActionResponse
import aws.sdk.kotlin.services.budgets.model.DeleteBudgetRequest
import aws.sdk.kotlin.services.budgets.model.DeleteBudgetResponse
import aws.sdk.kotlin.services.budgets.model.DeleteNotificationRequest
import aws.sdk.kotlin.services.budgets.model.DeleteNotificationResponse
import aws.sdk.kotlin.services.budgets.model.DeleteSubscriberRequest
import aws.sdk.kotlin.services.budgets.model.DeleteSubscriberResponse
import aws.sdk.kotlin.services.budgets.model.DescribeBudgetActionHistoriesRequest
import aws.sdk.kotlin.services.budgets.model.DescribeBudgetActionHistoriesResponse
import aws.sdk.kotlin.services.budgets.model.DescribeBudgetActionRequest
import aws.sdk.kotlin.services.budgets.model.DescribeBudgetActionResponse
import aws.sdk.kotlin.services.budgets.model.DescribeBudgetActionsForAccountRequest
import aws.sdk.kotlin.services.budgets.model.DescribeBudgetActionsForAccountResponse
import aws.sdk.kotlin.services.budgets.model.DescribeBudgetActionsForBudgetRequest
import aws.sdk.kotlin.services.budgets.model.DescribeBudgetActionsForBudgetResponse
import aws.sdk.kotlin.services.budgets.model.DescribeBudgetNotificationsForAccountRequest
import aws.sdk.kotlin.services.budgets.model.DescribeBudgetNotificationsForAccountResponse
import aws.sdk.kotlin.services.budgets.model.DescribeBudgetPerformanceHistoryRequest
import aws.sdk.kotlin.services.budgets.model.DescribeBudgetPerformanceHistoryResponse
import aws.sdk.kotlin.services.budgets.model.DescribeBudgetRequest
import aws.sdk.kotlin.services.budgets.model.DescribeBudgetResponse
import aws.sdk.kotlin.services.budgets.model.DescribeBudgetsRequest
import aws.sdk.kotlin.services.budgets.model.DescribeBudgetsResponse
import aws.sdk.kotlin.services.budgets.model.DescribeNotificationsForBudgetRequest
import aws.sdk.kotlin.services.budgets.model.DescribeNotificationsForBudgetResponse
import aws.sdk.kotlin.services.budgets.model.DescribeSubscribersForNotificationRequest
import aws.sdk.kotlin.services.budgets.model.DescribeSubscribersForNotificationResponse
import aws.sdk.kotlin.services.budgets.model.ExecuteBudgetActionRequest
import aws.sdk.kotlin.services.budgets.model.ExecuteBudgetActionResponse
import aws.sdk.kotlin.services.budgets.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.budgets.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.budgets.model.TagResourceRequest
import aws.sdk.kotlin.services.budgets.model.TagResourceResponse
import aws.sdk.kotlin.services.budgets.model.UntagResourceRequest
import aws.sdk.kotlin.services.budgets.model.UntagResourceResponse
import aws.sdk.kotlin.services.budgets.model.UpdateBudgetActionRequest
import aws.sdk.kotlin.services.budgets.model.UpdateBudgetActionResponse
import aws.sdk.kotlin.services.budgets.model.UpdateBudgetRequest
import aws.sdk.kotlin.services.budgets.model.UpdateBudgetResponse
import aws.sdk.kotlin.services.budgets.model.UpdateNotificationRequest
import aws.sdk.kotlin.services.budgets.model.UpdateNotificationResponse
import aws.sdk.kotlin.services.budgets.model.UpdateSubscriberRequest
import aws.sdk.kotlin.services.budgets.model.UpdateSubscriberResponse
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.region.RegionProvider
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic
import kotlinx.coroutines.runBlocking


public const val ServiceId: String = "Budgets"
public const val SdkVersion: String = "1.5.5"
public const val ServiceApiVersion: String = "2016-10-20"

/**
 * Use the Amazon Web Services Budgets API to plan your service usage, service costs, and instance reservations. This API reference provides descriptions, syntax, and usage examples for each of the actions and data types for the Amazon Web Services Budgets feature.
 *
 * Budgets provide you with a way to see the following information:
 * + How close your plan is to your budgeted amount or to the free tier limits
 * + Your usage-to-date, including how much you've used of your Reserved Instances (RIs)
 * + Your current estimated charges from Amazon Web Services, and how much your predicted usage will accrue in charges by the end of the month
 * + How much of your budget has been used
 *
 * Amazon Web Services updates your budget status several times a day. Budgets track your unblended costs, subscriptions, refunds, and RIs. You can create the following types of budgets:
 * + **Cost budgets** - Plan how much you want to spend on a service.
 * + **Usage budgets** - Plan how much you want to use one or more services.
 * + **RI utilization budgets** - Define a utilization threshold, and receive alerts when your RI usage falls below that threshold. This lets you see if your RIs are unused or under-utilized.
 * + **RI coverage budgets** - Define a coverage threshold, and receive alerts when the number of your instance hours that are covered by RIs fall below that threshold. This lets you see how much of your instance usage is covered by a reservation.
 *
 * Service Endpoint
 *
 * The Amazon Web Services Budgets API provides the following endpoint:
 * + https://budgets.amazonaws.com
 *
 * For information about costs that are associated with the Amazon Web Services Budgets API, see [Amazon Web Services Cost Management Pricing](https://aws.amazon.com/aws-cost-management/pricing/).
 */
public interface BudgetsClient : SdkClient {
    /**
     * BudgetsClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, BudgetsClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "Budgets",
                "BUDGETS",
                "budgets",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, BudgetsClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): BudgetsClient = DefaultBudgetsClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region ?: runBlocking { builder.regionProvider?.getRegion() ?: resolveRegion() }
        override val regionProvider: RegionProvider = builder.regionProvider ?: DefaultRegionProviderChain()
        override val authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = builder.authSchemePreference
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: BudgetsEndpointProvider = builder.endpointProvider ?: DefaultBudgetsEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: BudgetsAuthSchemeProvider = builder.authSchemeProvider ?: DefaultBudgetsAuthSchemeProvider(authSchemePreference = authSchemePreference)
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            regionProvider = this@Config.regionProvider
            authSchemePreference = this@Config.authSchemePreference
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "Budgets"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more information.
             * When specified, this static region configuration takes precedence over other region resolution methods.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var region: String? = null

            /**
             * An optional region provider that determines the AWS region for client operations. When specified, this provider
             * takes precedence over the default region provider chain, unless a static region is explicitly configured.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var regionProvider: RegionProvider? = null

            /**
             * The ordered preference of [AuthScheme] that this client will use.
             */
            override var authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: BudgetsEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: BudgetsAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Creates a budget and, if included, notifications and subscribers.
     *
     * Only one of `BudgetLimit` or `PlannedBudgetLimits` can be present in the syntax at one time. Use the syntax that matches your use case. The Request Syntax section shows the `BudgetLimit` syntax. For `PlannedBudgetLimits`, see the [Examples](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_budgets_CreateBudget.html#API_CreateBudget_Examples) section.
     *
     * Similarly, only one set of filter and metric selections can be present in the syntax at one time. Either `FilterExpression` and `Metrics` or `CostFilters` and `CostTypes`, not both or a different combination. We recommend using `FilterExpression` and `Metrics` as they provide more flexible and powerful filtering capabilities. The Request Syntax section shows the `FilterExpression`/`Metrics` syntax.
     */
    public suspend fun createBudget(input: CreateBudgetRequest): CreateBudgetResponse

    /**
     * Creates a budget action.
     */
    public suspend fun createBudgetAction(input: CreateBudgetActionRequest): CreateBudgetActionResponse

    /**
     * Creates a notification. You must create the budget before you create the associated notification.
     */
    public suspend fun createNotification(input: CreateNotificationRequest): CreateNotificationResponse

    /**
     * Creates a subscriber. You must create the associated budget and notification before you create the subscriber.
     */
    public suspend fun createSubscriber(input: CreateSubscriberRequest): CreateSubscriberResponse

    /**
     * Deletes a budget. You can delete your budget at any time.
     *
     * Deleting a budget also deletes the notifications and subscribers that are associated with that budget.
     */
    public suspend fun deleteBudget(input: DeleteBudgetRequest): DeleteBudgetResponse

    /**
     * Deletes a budget action.
     */
    public suspend fun deleteBudgetAction(input: DeleteBudgetActionRequest): DeleteBudgetActionResponse

    /**
     * Deletes a notification.
     *
     * Deleting a notification also deletes the subscribers that are associated with the notification.
     */
    public suspend fun deleteNotification(input: DeleteNotificationRequest): DeleteNotificationResponse

    /**
     * Deletes a subscriber.
     *
     * Deleting the last subscriber to a notification also deletes the notification.
     */
    public suspend fun deleteSubscriber(input: DeleteSubscriberRequest): DeleteSubscriberResponse

    /**
     * Describes a budget.
     *
     * The Request Syntax section shows the `BudgetLimit` syntax. For `PlannedBudgetLimits`, see the [Examples](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_budgets_DescribeBudget.html#API_DescribeBudget_Examples) section.
     */
    public suspend fun describeBudget(input: DescribeBudgetRequest): DescribeBudgetResponse

    /**
     * Describes a budget action detail.
     */
    public suspend fun describeBudgetAction(input: DescribeBudgetActionRequest): DescribeBudgetActionResponse

    /**
     * Describes a budget action history detail.
     */
    public suspend fun describeBudgetActionHistories(input: DescribeBudgetActionHistoriesRequest): DescribeBudgetActionHistoriesResponse

    /**
     * Describes all of the budget actions for an account.
     */
    public suspend fun describeBudgetActionsForAccount(input: DescribeBudgetActionsForAccountRequest): DescribeBudgetActionsForAccountResponse

    /**
     * Describes all of the budget actions for a budget.
     */
    public suspend fun describeBudgetActionsForBudget(input: DescribeBudgetActionsForBudgetRequest): DescribeBudgetActionsForBudgetResponse

    /**
     * Lists the budget names and notifications that are associated with an account.
     */
    public suspend fun describeBudgetNotificationsForAccount(input: DescribeBudgetNotificationsForAccountRequest): DescribeBudgetNotificationsForAccountResponse

    /**
     * Describes the history for `DAILY`, `MONTHLY`, and `QUARTERLY` budgets. Budget history isn't available for `ANNUAL` budgets.
     */
    public suspend fun describeBudgetPerformanceHistory(input: DescribeBudgetPerformanceHistoryRequest): DescribeBudgetPerformanceHistoryResponse

    /**
     * Lists the budgets that are associated with an account.
     *
     * The Request Syntax section shows the `BudgetLimit` syntax. For `PlannedBudgetLimits`, see the [Examples](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_budgets_DescribeBudgets.html#API_DescribeBudgets_Examples) section.
     */
    public suspend fun describeBudgets(input: DescribeBudgetsRequest): DescribeBudgetsResponse

    /**
     * Lists the notifications that are associated with a budget.
     */
    public suspend fun describeNotificationsForBudget(input: DescribeNotificationsForBudgetRequest): DescribeNotificationsForBudgetResponse

    /**
     * Lists the subscribers that are associated with a notification.
     */
    public suspend fun describeSubscribersForNotification(input: DescribeSubscribersForNotificationRequest): DescribeSubscribersForNotificationResponse

    /**
     * Executes a budget action.
     */
    public suspend fun executeBudgetAction(input: ExecuteBudgetActionRequest): ExecuteBudgetActionResponse

    /**
     * Lists tags associated with a budget or budget action resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Creates tags for a budget or budget action resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Deletes tags associated with a budget or budget action resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates a budget. You can change every part of a budget except for the `budgetName` and the `calculatedSpend`. When you modify a budget, the `calculatedSpend` drops to zero until Amazon Web Services has new usage data to use for forecasting.
     *
     * Only one of `BudgetLimit` or `PlannedBudgetLimits` can be present in the syntax at one time. Use the syntax that matches your case. The Request Syntax section shows the `BudgetLimit` syntax. For `PlannedBudgetLimits`, see the [Examples](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_budgets_UpdateBudget.html#API_UpdateBudget_Examples) section.
     *
     * Similarly, only one set of filter and metric selections can be present in the syntax at one time. Either `FilterExpression` and `Metrics` or `CostFilters` and `CostTypes`, not both or a different combination. We recommend using `FilterExpression` and `Metrics` as they provide more flexible and powerful filtering capabilities. The Request Syntax section shows the `FilterExpression`/`Metrics` syntax.
     */
    public suspend fun updateBudget(input: UpdateBudgetRequest): UpdateBudgetResponse

    /**
     * Updates a budget action.
     */
    public suspend fun updateBudgetAction(input: UpdateBudgetActionRequest): UpdateBudgetActionResponse

    /**
     * Updates a notification.
     */
    public suspend fun updateNotification(input: UpdateNotificationRequest): UpdateNotificationResponse

    /**
     * Updates a subscriber.
     */
    public suspend fun updateSubscriber(input: UpdateSubscriberRequest): UpdateSubscriberResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun BudgetsClient.withConfig(block: BudgetsClient.Config.Builder.() -> Unit): BudgetsClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultBudgetsClient(newConfig)
}

/**
 * Creates a budget and, if included, notifications and subscribers.
 *
 * Only one of `BudgetLimit` or `PlannedBudgetLimits` can be present in the syntax at one time. Use the syntax that matches your use case. The Request Syntax section shows the `BudgetLimit` syntax. For `PlannedBudgetLimits`, see the [Examples](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_budgets_CreateBudget.html#API_CreateBudget_Examples) section.
 *
 * Similarly, only one set of filter and metric selections can be present in the syntax at one time. Either `FilterExpression` and `Metrics` or `CostFilters` and `CostTypes`, not both or a different combination. We recommend using `FilterExpression` and `Metrics` as they provide more flexible and powerful filtering capabilities. The Request Syntax section shows the `FilterExpression`/`Metrics` syntax.
 */
public suspend inline fun BudgetsClient.createBudget(crossinline block: CreateBudgetRequest.Builder.() -> Unit): CreateBudgetResponse = createBudget(CreateBudgetRequest.Builder().apply(block).build())

/**
 * Creates a budget action.
 */
public suspend inline fun BudgetsClient.createBudgetAction(crossinline block: CreateBudgetActionRequest.Builder.() -> Unit): CreateBudgetActionResponse = createBudgetAction(CreateBudgetActionRequest.Builder().apply(block).build())

/**
 * Creates a notification. You must create the budget before you create the associated notification.
 */
public suspend inline fun BudgetsClient.createNotification(crossinline block: CreateNotificationRequest.Builder.() -> Unit): CreateNotificationResponse = createNotification(CreateNotificationRequest.Builder().apply(block).build())

/**
 * Creates a subscriber. You must create the associated budget and notification before you create the subscriber.
 */
public suspend inline fun BudgetsClient.createSubscriber(crossinline block: CreateSubscriberRequest.Builder.() -> Unit): CreateSubscriberResponse = createSubscriber(CreateSubscriberRequest.Builder().apply(block).build())

/**
 * Deletes a budget. You can delete your budget at any time.
 *
 * Deleting a budget also deletes the notifications and subscribers that are associated with that budget.
 */
public suspend inline fun BudgetsClient.deleteBudget(crossinline block: DeleteBudgetRequest.Builder.() -> Unit): DeleteBudgetResponse = deleteBudget(DeleteBudgetRequest.Builder().apply(block).build())

/**
 * Deletes a budget action.
 */
public suspend inline fun BudgetsClient.deleteBudgetAction(crossinline block: DeleteBudgetActionRequest.Builder.() -> Unit): DeleteBudgetActionResponse = deleteBudgetAction(DeleteBudgetActionRequest.Builder().apply(block).build())

/**
 * Deletes a notification.
 *
 * Deleting a notification also deletes the subscribers that are associated with the notification.
 */
public suspend inline fun BudgetsClient.deleteNotification(crossinline block: DeleteNotificationRequest.Builder.() -> Unit): DeleteNotificationResponse = deleteNotification(DeleteNotificationRequest.Builder().apply(block).build())

/**
 * Deletes a subscriber.
 *
 * Deleting the last subscriber to a notification also deletes the notification.
 */
public suspend inline fun BudgetsClient.deleteSubscriber(crossinline block: DeleteSubscriberRequest.Builder.() -> Unit): DeleteSubscriberResponse = deleteSubscriber(DeleteSubscriberRequest.Builder().apply(block).build())

/**
 * Describes a budget.
 *
 * The Request Syntax section shows the `BudgetLimit` syntax. For `PlannedBudgetLimits`, see the [Examples](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_budgets_DescribeBudget.html#API_DescribeBudget_Examples) section.
 */
public suspend inline fun BudgetsClient.describeBudget(crossinline block: DescribeBudgetRequest.Builder.() -> Unit): DescribeBudgetResponse = describeBudget(DescribeBudgetRequest.Builder().apply(block).build())

/**
 * Describes a budget action detail.
 */
public suspend inline fun BudgetsClient.describeBudgetAction(crossinline block: DescribeBudgetActionRequest.Builder.() -> Unit): DescribeBudgetActionResponse = describeBudgetAction(DescribeBudgetActionRequest.Builder().apply(block).build())

/**
 * Describes a budget action history detail.
 */
public suspend inline fun BudgetsClient.describeBudgetActionHistories(crossinline block: DescribeBudgetActionHistoriesRequest.Builder.() -> Unit): DescribeBudgetActionHistoriesResponse = describeBudgetActionHistories(DescribeBudgetActionHistoriesRequest.Builder().apply(block).build())

/**
 * Describes all of the budget actions for an account.
 */
public suspend inline fun BudgetsClient.describeBudgetActionsForAccount(crossinline block: DescribeBudgetActionsForAccountRequest.Builder.() -> Unit): DescribeBudgetActionsForAccountResponse = describeBudgetActionsForAccount(DescribeBudgetActionsForAccountRequest.Builder().apply(block).build())

/**
 * Describes all of the budget actions for a budget.
 */
public suspend inline fun BudgetsClient.describeBudgetActionsForBudget(crossinline block: DescribeBudgetActionsForBudgetRequest.Builder.() -> Unit): DescribeBudgetActionsForBudgetResponse = describeBudgetActionsForBudget(DescribeBudgetActionsForBudgetRequest.Builder().apply(block).build())

/**
 * Lists the budget names and notifications that are associated with an account.
 */
public suspend inline fun BudgetsClient.describeBudgetNotificationsForAccount(crossinline block: DescribeBudgetNotificationsForAccountRequest.Builder.() -> Unit): DescribeBudgetNotificationsForAccountResponse = describeBudgetNotificationsForAccount(DescribeBudgetNotificationsForAccountRequest.Builder().apply(block).build())

/**
 * Describes the history for `DAILY`, `MONTHLY`, and `QUARTERLY` budgets. Budget history isn't available for `ANNUAL` budgets.
 */
public suspend inline fun BudgetsClient.describeBudgetPerformanceHistory(crossinline block: DescribeBudgetPerformanceHistoryRequest.Builder.() -> Unit): DescribeBudgetPerformanceHistoryResponse = describeBudgetPerformanceHistory(DescribeBudgetPerformanceHistoryRequest.Builder().apply(block).build())

/**
 * Lists the budgets that are associated with an account.
 *
 * The Request Syntax section shows the `BudgetLimit` syntax. For `PlannedBudgetLimits`, see the [Examples](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_budgets_DescribeBudgets.html#API_DescribeBudgets_Examples) section.
 */
public suspend inline fun BudgetsClient.describeBudgets(crossinline block: DescribeBudgetsRequest.Builder.() -> Unit): DescribeBudgetsResponse = describeBudgets(DescribeBudgetsRequest.Builder().apply(block).build())

/**
 * Lists the notifications that are associated with a budget.
 */
public suspend inline fun BudgetsClient.describeNotificationsForBudget(crossinline block: DescribeNotificationsForBudgetRequest.Builder.() -> Unit): DescribeNotificationsForBudgetResponse = describeNotificationsForBudget(DescribeNotificationsForBudgetRequest.Builder().apply(block).build())

/**
 * Lists the subscribers that are associated with a notification.
 */
public suspend inline fun BudgetsClient.describeSubscribersForNotification(crossinline block: DescribeSubscribersForNotificationRequest.Builder.() -> Unit): DescribeSubscribersForNotificationResponse = describeSubscribersForNotification(DescribeSubscribersForNotificationRequest.Builder().apply(block).build())

/**
 * Executes a budget action.
 */
public suspend inline fun BudgetsClient.executeBudgetAction(crossinline block: ExecuteBudgetActionRequest.Builder.() -> Unit): ExecuteBudgetActionResponse = executeBudgetAction(ExecuteBudgetActionRequest.Builder().apply(block).build())

/**
 * Lists tags associated with a budget or budget action resource.
 */
public suspend inline fun BudgetsClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Creates tags for a budget or budget action resource.
 */
public suspend inline fun BudgetsClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Deletes tags associated with a budget or budget action resource.
 */
public suspend inline fun BudgetsClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates a budget. You can change every part of a budget except for the `budgetName` and the `calculatedSpend`. When you modify a budget, the `calculatedSpend` drops to zero until Amazon Web Services has new usage data to use for forecasting.
 *
 * Only one of `BudgetLimit` or `PlannedBudgetLimits` can be present in the syntax at one time. Use the syntax that matches your case. The Request Syntax section shows the `BudgetLimit` syntax. For `PlannedBudgetLimits`, see the [Examples](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_budgets_UpdateBudget.html#API_UpdateBudget_Examples) section.
 *
 * Similarly, only one set of filter and metric selections can be present in the syntax at one time. Either `FilterExpression` and `Metrics` or `CostFilters` and `CostTypes`, not both or a different combination. We recommend using `FilterExpression` and `Metrics` as they provide more flexible and powerful filtering capabilities. The Request Syntax section shows the `FilterExpression`/`Metrics` syntax.
 */
public suspend inline fun BudgetsClient.updateBudget(crossinline block: UpdateBudgetRequest.Builder.() -> Unit): UpdateBudgetResponse = updateBudget(UpdateBudgetRequest.Builder().apply(block).build())

/**
 * Updates a budget action.
 */
public suspend inline fun BudgetsClient.updateBudgetAction(crossinline block: UpdateBudgetActionRequest.Builder.() -> Unit): UpdateBudgetActionResponse = updateBudgetAction(UpdateBudgetActionRequest.Builder().apply(block).build())

/**
 * Updates a notification.
 */
public suspend inline fun BudgetsClient.updateNotification(crossinline block: UpdateNotificationRequest.Builder.() -> Unit): UpdateNotificationResponse = updateNotification(UpdateNotificationRequest.Builder().apply(block).build())

/**
 * Updates a subscriber.
 */
public suspend inline fun BudgetsClient.updateSubscriber(crossinline block: UpdateSubscriberRequest.Builder.() -> Unit): UpdateSubscriberResponse = updateSubscriber(UpdateSubscriberRequest.Builder().apply(block).build())
