// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.budgets.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The parameters that define or describe the historical data that your auto-adjusting budget is based on.
 */
public class HistoricalOptions private constructor(builder: Builder) {
    /**
     * The number of budget periods included in the moving-average calculation that determines your auto-adjusted budget amount. The maximum value depends on the `TimeUnit` granularity of the budget:
     * + For the `DAILY` granularity, the maximum value is `60`.
     * + For the `MONTHLY` granularity, the maximum value is `12`.
     * + For the `QUARTERLY` granularity, the maximum value is `4`.
     * + For the `ANNUALLY` granularity, the maximum value is `1`.
     */
    public val budgetAdjustmentPeriod: kotlin.Int = requireNotNull(builder.budgetAdjustmentPeriod) { "A non-null value must be provided for budgetAdjustmentPeriod" }
    /**
     * The integer that describes how many budget periods in your `BudgetAdjustmentPeriod` are included in the calculation of your current `BudgetLimit`. If the first budget period in your `BudgetAdjustmentPeriod` has no cost data, then that budget period isn’t included in the average that determines your budget limit.
     *
     * For example, if you set `BudgetAdjustmentPeriod` as `4` quarters, but your account had no cost data in the first quarter, then only the last three quarters are included in the calculation. In this scenario, `LookBackAvailablePeriods` returns `3`.
     *
     * You can’t set your own `LookBackAvailablePeriods`. The value is automatically calculated from the `BudgetAdjustmentPeriod` and your historical cost data.
     */
    public val lookBackAvailablePeriods: kotlin.Int? = builder.lookBackAvailablePeriods

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.budgets.model.HistoricalOptions = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HistoricalOptions(")
        append("budgetAdjustmentPeriod=$budgetAdjustmentPeriod,")
        append("lookBackAvailablePeriods=$lookBackAvailablePeriods")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = budgetAdjustmentPeriod
        result = 31 * result + (lookBackAvailablePeriods ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HistoricalOptions

        if (budgetAdjustmentPeriod != other.budgetAdjustmentPeriod) return false
        if (lookBackAvailablePeriods != other.lookBackAvailablePeriods) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.budgets.model.HistoricalOptions = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The number of budget periods included in the moving-average calculation that determines your auto-adjusted budget amount. The maximum value depends on the `TimeUnit` granularity of the budget:
         * + For the `DAILY` granularity, the maximum value is `60`.
         * + For the `MONTHLY` granularity, the maximum value is `12`.
         * + For the `QUARTERLY` granularity, the maximum value is `4`.
         * + For the `ANNUALLY` granularity, the maximum value is `1`.
         */
        public var budgetAdjustmentPeriod: kotlin.Int? = null
        /**
         * The integer that describes how many budget periods in your `BudgetAdjustmentPeriod` are included in the calculation of your current `BudgetLimit`. If the first budget period in your `BudgetAdjustmentPeriod` has no cost data, then that budget period isn’t included in the average that determines your budget limit.
         *
         * For example, if you set `BudgetAdjustmentPeriod` as `4` quarters, but your account had no cost data in the first quarter, then only the last three quarters are included in the calculation. In this scenario, `LookBackAvailablePeriods` returns `3`.
         *
         * You can’t set your own `LookBackAvailablePeriods`. The value is automatically calculated from the `BudgetAdjustmentPeriod` and your historical cost data.
         */
        public var lookBackAvailablePeriods: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.budgets.model.HistoricalOptions) : this() {
            this.budgetAdjustmentPeriod = x.budgetAdjustmentPeriod
            this.lookBackAvailablePeriods = x.lookBackAvailablePeriods
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.budgets.model.HistoricalOptions = HistoricalOptions(this)

        internal fun correctErrors(): Builder {
            if (budgetAdjustmentPeriod == null) budgetAdjustmentPeriod = 0
            return this
        }
    }
}
