// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.budgets.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Request of CreateBudget
 */
public class CreateBudgetRequest private constructor(builder: Builder) {
    /**
     * The `accountId` that is associated with the budget.
     */
    public val accountId: kotlin.String? = builder.accountId
    /**
     * The budget object that you want to create.
     */
    public val budget: aws.sdk.kotlin.services.budgets.model.Budget? = builder.budget
    /**
     * A notification that you want to associate with a budget. A budget can have up to five notifications, and each notification can have one SNS subscriber and up to 10 email subscribers. If you include notifications and subscribers in your `CreateBudget` call, Amazon Web Services creates the notifications and subscribers for you.
     */
    public val notificationsWithSubscribers: List<NotificationWithSubscribers>? = builder.notificationsWithSubscribers
    /**
     * An optional list of tags to associate with the specified budget. Each tag consists of a key and a value, and each key must be unique for the resource.
     */
    public val resourceTags: List<ResourceTag>? = builder.resourceTags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.budgets.model.CreateBudgetRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateBudgetRequest(")
        append("accountId=$accountId,")
        append("budget=$budget,")
        append("notificationsWithSubscribers=$notificationsWithSubscribers,")
        append("resourceTags=$resourceTags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (budget?.hashCode() ?: 0)
        result = 31 * result + (notificationsWithSubscribers?.hashCode() ?: 0)
        result = 31 * result + (resourceTags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateBudgetRequest

        if (accountId != other.accountId) return false
        if (budget != other.budget) return false
        if (notificationsWithSubscribers != other.notificationsWithSubscribers) return false
        if (resourceTags != other.resourceTags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.budgets.model.CreateBudgetRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The `accountId` that is associated with the budget.
         */
        public var accountId: kotlin.String? = null
        /**
         * The budget object that you want to create.
         */
        public var budget: aws.sdk.kotlin.services.budgets.model.Budget? = null
        /**
         * A notification that you want to associate with a budget. A budget can have up to five notifications, and each notification can have one SNS subscriber and up to 10 email subscribers. If you include notifications and subscribers in your `CreateBudget` call, Amazon Web Services creates the notifications and subscribers for you.
         */
        public var notificationsWithSubscribers: List<NotificationWithSubscribers>? = null
        /**
         * An optional list of tags to associate with the specified budget. Each tag consists of a key and a value, and each key must be unique for the resource.
         */
        public var resourceTags: List<ResourceTag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.budgets.model.CreateBudgetRequest) : this() {
            this.accountId = x.accountId
            this.budget = x.budget
            this.notificationsWithSubscribers = x.notificationsWithSubscribers
            this.resourceTags = x.resourceTags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.budgets.model.CreateBudgetRequest = CreateBudgetRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.budgets.model.Budget] inside the given [block]
         */
        public fun budget(block: aws.sdk.kotlin.services.budgets.model.Budget.Builder.() -> kotlin.Unit) {
            this.budget = aws.sdk.kotlin.services.budgets.model.Budget.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
