// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.budgets.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * The parameters that determine the budget amount for an auto-adjusting budget.
 */
public class AutoAdjustData private constructor(builder: Builder) {
    /**
     * The string that defines whether your budget auto-adjusts based on historical or forecasted data.
     */
    public val autoAdjustType: aws.sdk.kotlin.services.budgets.model.AutoAdjustType = requireNotNull(builder.autoAdjustType) { "A non-null value must be provided for autoAdjustType" }
    /**
     * The parameters that define or describe the historical data that your auto-adjusting budget is based on.
     */
    public val historicalOptions: aws.sdk.kotlin.services.budgets.model.HistoricalOptions? = builder.historicalOptions
    /**
     * The last time that your budget was auto-adjusted.
     */
    public val lastAutoAdjustTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastAutoAdjustTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.budgets.model.AutoAdjustData = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AutoAdjustData(")
        append("autoAdjustType=$autoAdjustType,")
        append("historicalOptions=$historicalOptions,")
        append("lastAutoAdjustTime=$lastAutoAdjustTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = autoAdjustType.hashCode()
        result = 31 * result + (historicalOptions?.hashCode() ?: 0)
        result = 31 * result + (lastAutoAdjustTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AutoAdjustData

        if (autoAdjustType != other.autoAdjustType) return false
        if (historicalOptions != other.historicalOptions) return false
        if (lastAutoAdjustTime != other.lastAutoAdjustTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.budgets.model.AutoAdjustData = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The string that defines whether your budget auto-adjusts based on historical or forecasted data.
         */
        public var autoAdjustType: aws.sdk.kotlin.services.budgets.model.AutoAdjustType? = null
        /**
         * The parameters that define or describe the historical data that your auto-adjusting budget is based on.
         */
        public var historicalOptions: aws.sdk.kotlin.services.budgets.model.HistoricalOptions? = null
        /**
         * The last time that your budget was auto-adjusted.
         */
        public var lastAutoAdjustTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.budgets.model.AutoAdjustData) : this() {
            this.autoAdjustType = x.autoAdjustType
            this.historicalOptions = x.historicalOptions
            this.lastAutoAdjustTime = x.lastAutoAdjustTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.budgets.model.AutoAdjustData = AutoAdjustData(this)

        /**
         * construct an [aws.sdk.kotlin.services.budgets.model.HistoricalOptions] inside the given [block]
         */
        public fun historicalOptions(block: aws.sdk.kotlin.services.budgets.model.HistoricalOptions.Builder.() -> kotlin.Unit) {
            this.historicalOptions = aws.sdk.kotlin.services.budgets.model.HistoricalOptions.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (autoAdjustType == null) autoAdjustType = AutoAdjustType.SdkUnknown("no value provided")
            return this
        }
    }
}
