// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.budgets.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * The historical records for a budget action.
 */
public class ActionHistory private constructor(builder: Builder) {
    /**
     * The description of the details for the event.
     */
    public val actionHistoryDetails: aws.sdk.kotlin.services.budgets.model.ActionHistoryDetails? = builder.actionHistoryDetails
    /**
     * This distinguishes between whether the events are triggered by the user or are generated by the system.
     */
    public val eventType: aws.sdk.kotlin.services.budgets.model.EventType = requireNotNull(builder.eventType) { "A non-null value must be provided for eventType" }
    /**
     * The status of action at the time of the event.
     */
    public val status: aws.sdk.kotlin.services.budgets.model.ActionStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * A generic time stamp. In Java, it's transformed to a `Date` object.
     */
    public val timestamp: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.timestamp) { "A non-null value must be provided for timestamp" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.budgets.model.ActionHistory = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ActionHistory(")
        append("actionHistoryDetails=$actionHistoryDetails,")
        append("eventType=$eventType,")
        append("status=$status,")
        append("timestamp=$timestamp")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = actionHistoryDetails?.hashCode() ?: 0
        result = 31 * result + (eventType.hashCode())
        result = 31 * result + (status.hashCode())
        result = 31 * result + (timestamp.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ActionHistory

        if (actionHistoryDetails != other.actionHistoryDetails) return false
        if (eventType != other.eventType) return false
        if (status != other.status) return false
        if (timestamp != other.timestamp) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.budgets.model.ActionHistory = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The description of the details for the event.
         */
        public var actionHistoryDetails: aws.sdk.kotlin.services.budgets.model.ActionHistoryDetails? = null
        /**
         * This distinguishes between whether the events are triggered by the user or are generated by the system.
         */
        public var eventType: aws.sdk.kotlin.services.budgets.model.EventType? = null
        /**
         * The status of action at the time of the event.
         */
        public var status: aws.sdk.kotlin.services.budgets.model.ActionStatus? = null
        /**
         * A generic time stamp. In Java, it's transformed to a `Date` object.
         */
        public var timestamp: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.budgets.model.ActionHistory) : this() {
            this.actionHistoryDetails = x.actionHistoryDetails
            this.eventType = x.eventType
            this.status = x.status
            this.timestamp = x.timestamp
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.budgets.model.ActionHistory = ActionHistory(this)

        /**
         * construct an [aws.sdk.kotlin.services.budgets.model.ActionHistoryDetails] inside the given [block]
         */
        public fun actionHistoryDetails(block: aws.sdk.kotlin.services.budgets.model.ActionHistoryDetails.Builder.() -> kotlin.Unit) {
            this.actionHistoryDetails = aws.sdk.kotlin.services.budgets.model.ActionHistoryDetails.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (eventType == null) eventType = EventType.SdkUnknown("no value provided")
            if (status == null) status = ActionStatus.SdkUnknown("no value provided")
            if (timestamp == null) timestamp = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
