// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.budgets.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A budget action resource.
 */
public class Action private constructor(builder: Builder) {
    /**
     * A system-generated universally unique identifier (UUID) for the action.
     */
    public val actionId: kotlin.String = requireNotNull(builder.actionId) { "A non-null value must be provided for actionId" }
    /**
     * The trigger threshold of the action.
     */
    public val actionThreshold: aws.sdk.kotlin.services.budgets.model.ActionThreshold? = builder.actionThreshold
    /**
     * The type of action. This defines the type of tasks that can be carried out by this action. This field also determines the format for definition.
     */
    public val actionType: aws.sdk.kotlin.services.budgets.model.ActionType = requireNotNull(builder.actionType) { "A non-null value must be provided for actionType" }
    /**
     * This specifies if the action needs manual or automatic approval.
     */
    public val approvalModel: aws.sdk.kotlin.services.budgets.model.ApprovalModel = requireNotNull(builder.approvalModel) { "A non-null value must be provided for approvalModel" }
    /**
     * A string that represents the budget name. The ":" and "\" characters, and the "/action/" substring, aren't allowed.
     */
    public val budgetName: kotlin.String = requireNotNull(builder.budgetName) { "A non-null value must be provided for budgetName" }
    /**
     * Where you specify all of the type-specific parameters.
     */
    public val definition: aws.sdk.kotlin.services.budgets.model.Definition? = builder.definition
    /**
     * The role passed for action execution and reversion. Roles and actions must be in the same account.
     */
    public val executionRoleArn: kotlin.String = requireNotNull(builder.executionRoleArn) { "A non-null value must be provided for executionRoleArn" }
    /**
     * The type of a notification. It must be ACTUAL or FORECASTED.
     */
    public val notificationType: aws.sdk.kotlin.services.budgets.model.NotificationType = requireNotNull(builder.notificationType) { "A non-null value must be provided for notificationType" }
    /**
     * The status of the action.
     */
    public val status: aws.sdk.kotlin.services.budgets.model.ActionStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * A list of subscribers.
     */
    public val subscribers: List<Subscriber> = requireNotNull(builder.subscribers) { "A non-null value must be provided for subscribers" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.budgets.model.Action = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Action(")
        append("actionId=$actionId,")
        append("actionThreshold=$actionThreshold,")
        append("actionType=$actionType,")
        append("approvalModel=$approvalModel,")
        append("budgetName=$budgetName,")
        append("definition=$definition,")
        append("executionRoleArn=$executionRoleArn,")
        append("notificationType=$notificationType,")
        append("status=$status,")
        append("subscribers=$subscribers")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = actionId.hashCode()
        result = 31 * result + (actionThreshold?.hashCode() ?: 0)
        result = 31 * result + (actionType.hashCode())
        result = 31 * result + (approvalModel.hashCode())
        result = 31 * result + (budgetName.hashCode())
        result = 31 * result + (definition?.hashCode() ?: 0)
        result = 31 * result + (executionRoleArn.hashCode())
        result = 31 * result + (notificationType.hashCode())
        result = 31 * result + (status.hashCode())
        result = 31 * result + (subscribers.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Action

        if (actionId != other.actionId) return false
        if (actionThreshold != other.actionThreshold) return false
        if (actionType != other.actionType) return false
        if (approvalModel != other.approvalModel) return false
        if (budgetName != other.budgetName) return false
        if (definition != other.definition) return false
        if (executionRoleArn != other.executionRoleArn) return false
        if (notificationType != other.notificationType) return false
        if (status != other.status) return false
        if (subscribers != other.subscribers) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.budgets.model.Action = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A system-generated universally unique identifier (UUID) for the action.
         */
        public var actionId: kotlin.String? = null
        /**
         * The trigger threshold of the action.
         */
        public var actionThreshold: aws.sdk.kotlin.services.budgets.model.ActionThreshold? = null
        /**
         * The type of action. This defines the type of tasks that can be carried out by this action. This field also determines the format for definition.
         */
        public var actionType: aws.sdk.kotlin.services.budgets.model.ActionType? = null
        /**
         * This specifies if the action needs manual or automatic approval.
         */
        public var approvalModel: aws.sdk.kotlin.services.budgets.model.ApprovalModel? = null
        /**
         * A string that represents the budget name. The ":" and "\" characters, and the "/action/" substring, aren't allowed.
         */
        public var budgetName: kotlin.String? = null
        /**
         * Where you specify all of the type-specific parameters.
         */
        public var definition: aws.sdk.kotlin.services.budgets.model.Definition? = null
        /**
         * The role passed for action execution and reversion. Roles and actions must be in the same account.
         */
        public var executionRoleArn: kotlin.String? = null
        /**
         * The type of a notification. It must be ACTUAL or FORECASTED.
         */
        public var notificationType: aws.sdk.kotlin.services.budgets.model.NotificationType? = null
        /**
         * The status of the action.
         */
        public var status: aws.sdk.kotlin.services.budgets.model.ActionStatus? = null
        /**
         * A list of subscribers.
         */
        public var subscribers: List<Subscriber>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.budgets.model.Action) : this() {
            this.actionId = x.actionId
            this.actionThreshold = x.actionThreshold
            this.actionType = x.actionType
            this.approvalModel = x.approvalModel
            this.budgetName = x.budgetName
            this.definition = x.definition
            this.executionRoleArn = x.executionRoleArn
            this.notificationType = x.notificationType
            this.status = x.status
            this.subscribers = x.subscribers
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.budgets.model.Action = Action(this)

        /**
         * construct an [aws.sdk.kotlin.services.budgets.model.ActionThreshold] inside the given [block]
         */
        public fun actionThreshold(block: aws.sdk.kotlin.services.budgets.model.ActionThreshold.Builder.() -> kotlin.Unit) {
            this.actionThreshold = aws.sdk.kotlin.services.budgets.model.ActionThreshold.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.budgets.model.Definition] inside the given [block]
         */
        public fun definition(block: aws.sdk.kotlin.services.budgets.model.Definition.Builder.() -> kotlin.Unit) {
            this.definition = aws.sdk.kotlin.services.budgets.model.Definition.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (actionId == null) actionId = ""
            if (actionType == null) actionType = ActionType.SdkUnknown("no value provided")
            if (approvalModel == null) approvalModel = ApprovalModel.SdkUnknown("no value provided")
            if (budgetName == null) budgetName = ""
            if (executionRoleArn == null) executionRoleArn = ""
            if (notificationType == null) notificationType = NotificationType.SdkUnknown("no value provided")
            if (status == null) status = ActionStatus.SdkUnknown("no value provided")
            if (subscribers == null) subscribers = emptyList()
            return this
        }
    }
}
