// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.budgets.model



/**
 * The subscriber to a budget notification. The subscriber consists of a subscription type and either an Amazon SNS topic or an email address.
 *
 * For example, an email subscriber has the following parameters:
 * + A `subscriptionType` of `EMAIL`
 * + An `address` of `example@example.com`
 */
public class Subscriber private constructor(builder: Builder) {
    /**
     * The address that Amazon Web Services sends budget notifications to, either an SNS topic or an email.
     *
     * When you create a subscriber, the value of `Address` can't contain line breaks.
     */
    public val address: kotlin.String? = builder.address
    /**
     * The type of notification that Amazon Web Services sends to a subscriber.
     */
    public val subscriptionType: aws.sdk.kotlin.services.budgets.model.SubscriptionType? = builder.subscriptionType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.budgets.model.Subscriber = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Subscriber(")
        append("address=*** Sensitive Data Redacted ***,")
        append("subscriptionType=$subscriptionType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = address?.hashCode() ?: 0
        result = 31 * result + (subscriptionType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Subscriber

        if (address != other.address) return false
        if (subscriptionType != other.subscriptionType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.budgets.model.Subscriber = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The address that Amazon Web Services sends budget notifications to, either an SNS topic or an email.
         *
         * When you create a subscriber, the value of `Address` can't contain line breaks.
         */
        public var address: kotlin.String? = null
        /**
         * The type of notification that Amazon Web Services sends to a subscriber.
         */
        public var subscriptionType: aws.sdk.kotlin.services.budgets.model.SubscriptionType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.budgets.model.Subscriber) : this() {
            this.address = x.address
            this.subscriptionType = x.subscriptionType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.budgets.model.Subscriber = Subscriber(this)
    }
}
