// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.budgets.model



/**
 * The types of cost that are included in a `COST` budget, such as tax and subscriptions.
 *
 * `USAGE`, `RI_UTILIZATION`, `RI_COVERAGE`, `SAVINGS_PLANS_UTILIZATION`, and `SAVINGS_PLANS_COVERAGE` budgets don't have `CostTypes`.
 */
public class CostTypes private constructor(builder: Builder) {
    /**
     * Specifies whether a budget includes credits.
     *
     * The default value is `true`.
     */
    public val includeCredit: kotlin.Boolean? = builder.includeCredit
    /**
     * Specifies whether a budget includes discounts.
     *
     * The default value is `true`.
     */
    public val includeDiscount: kotlin.Boolean? = builder.includeDiscount
    /**
     * Specifies whether a budget includes non-RI subscription costs.
     *
     * The default value is `true`.
     */
    public val includeOtherSubscription: kotlin.Boolean? = builder.includeOtherSubscription
    /**
     * Specifies whether a budget includes recurring fees such as monthly RI fees.
     *
     * The default value is `true`.
     */
    public val includeRecurring: kotlin.Boolean? = builder.includeRecurring
    /**
     * Specifies whether a budget includes refunds.
     *
     * The default value is `true`.
     */
    public val includeRefund: kotlin.Boolean? = builder.includeRefund
    /**
     * Specifies whether a budget includes subscriptions.
     *
     * The default value is `true`.
     */
    public val includeSubscription: kotlin.Boolean? = builder.includeSubscription
    /**
     * Specifies whether a budget includes support subscription fees.
     *
     * The default value is `true`.
     */
    public val includeSupport: kotlin.Boolean? = builder.includeSupport
    /**
     * Specifies whether a budget includes taxes.
     *
     * The default value is `true`.
     */
    public val includeTax: kotlin.Boolean? = builder.includeTax
    /**
     * Specifies whether a budget includes upfront RI costs.
     *
     * The default value is `true`.
     */
    public val includeUpfront: kotlin.Boolean? = builder.includeUpfront
    /**
     * Specifies whether a budget uses the amortized rate.
     *
     * The default value is `false`.
     */
    public val useAmortized: kotlin.Boolean? = builder.useAmortized
    /**
     * Specifies whether a budget uses a blended rate.
     *
     * The default value is `false`.
     */
    public val useBlended: kotlin.Boolean? = builder.useBlended

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.budgets.model.CostTypes = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CostTypes(")
        append("includeCredit=$includeCredit,")
        append("includeDiscount=$includeDiscount,")
        append("includeOtherSubscription=$includeOtherSubscription,")
        append("includeRecurring=$includeRecurring,")
        append("includeRefund=$includeRefund,")
        append("includeSubscription=$includeSubscription,")
        append("includeSupport=$includeSupport,")
        append("includeTax=$includeTax,")
        append("includeUpfront=$includeUpfront,")
        append("useAmortized=$useAmortized,")
        append("useBlended=$useBlended)")
    }

    override fun hashCode(): kotlin.Int {
        var result = includeCredit?.hashCode() ?: 0
        result = 31 * result + (includeDiscount?.hashCode() ?: 0)
        result = 31 * result + (includeOtherSubscription?.hashCode() ?: 0)
        result = 31 * result + (includeRecurring?.hashCode() ?: 0)
        result = 31 * result + (includeRefund?.hashCode() ?: 0)
        result = 31 * result + (includeSubscription?.hashCode() ?: 0)
        result = 31 * result + (includeSupport?.hashCode() ?: 0)
        result = 31 * result + (includeTax?.hashCode() ?: 0)
        result = 31 * result + (includeUpfront?.hashCode() ?: 0)
        result = 31 * result + (useAmortized?.hashCode() ?: 0)
        result = 31 * result + (useBlended?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CostTypes

        if (includeCredit != other.includeCredit) return false
        if (includeDiscount != other.includeDiscount) return false
        if (includeOtherSubscription != other.includeOtherSubscription) return false
        if (includeRecurring != other.includeRecurring) return false
        if (includeRefund != other.includeRefund) return false
        if (includeSubscription != other.includeSubscription) return false
        if (includeSupport != other.includeSupport) return false
        if (includeTax != other.includeTax) return false
        if (includeUpfront != other.includeUpfront) return false
        if (useAmortized != other.useAmortized) return false
        if (useBlended != other.useBlended) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.budgets.model.CostTypes = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies whether a budget includes credits.
         *
         * The default value is `true`.
         */
        public var includeCredit: kotlin.Boolean? = null
        /**
         * Specifies whether a budget includes discounts.
         *
         * The default value is `true`.
         */
        public var includeDiscount: kotlin.Boolean? = null
        /**
         * Specifies whether a budget includes non-RI subscription costs.
         *
         * The default value is `true`.
         */
        public var includeOtherSubscription: kotlin.Boolean? = null
        /**
         * Specifies whether a budget includes recurring fees such as monthly RI fees.
         *
         * The default value is `true`.
         */
        public var includeRecurring: kotlin.Boolean? = null
        /**
         * Specifies whether a budget includes refunds.
         *
         * The default value is `true`.
         */
        public var includeRefund: kotlin.Boolean? = null
        /**
         * Specifies whether a budget includes subscriptions.
         *
         * The default value is `true`.
         */
        public var includeSubscription: kotlin.Boolean? = null
        /**
         * Specifies whether a budget includes support subscription fees.
         *
         * The default value is `true`.
         */
        public var includeSupport: kotlin.Boolean? = null
        /**
         * Specifies whether a budget includes taxes.
         *
         * The default value is `true`.
         */
        public var includeTax: kotlin.Boolean? = null
        /**
         * Specifies whether a budget includes upfront RI costs.
         *
         * The default value is `true`.
         */
        public var includeUpfront: kotlin.Boolean? = null
        /**
         * Specifies whether a budget uses the amortized rate.
         *
         * The default value is `false`.
         */
        public var useAmortized: kotlin.Boolean? = null
        /**
         * Specifies whether a budget uses a blended rate.
         *
         * The default value is `false`.
         */
        public var useBlended: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.budgets.model.CostTypes) : this() {
            this.includeCredit = x.includeCredit
            this.includeDiscount = x.includeDiscount
            this.includeOtherSubscription = x.includeOtherSubscription
            this.includeRecurring = x.includeRecurring
            this.includeRefund = x.includeRefund
            this.includeSubscription = x.includeSubscription
            this.includeSupport = x.includeSupport
            this.includeTax = x.includeTax
            this.includeUpfront = x.includeUpfront
            this.useAmortized = x.useAmortized
            this.useBlended = x.useBlended
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.budgets.model.CostTypes = CostTypes(this)
    }
}
